/*
 * Decompiled with CFR 0.152.
 */
package jtermios.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.windows.WinAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private volatile int m_ErrNo = 0;
    private volatile boolean[] m_PortFDs = new boolean[256];
    private volatile Hashtable<Integer, Port> m_OpenPorts = new Hashtable();

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
    }

    @Override
    public int errno() {
        return this.m_ErrNo;
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        termios2.c_iflag &= ~(JTermios.IGNBRK | JTermios.BRKINT | JTermios.PARMRK | JTermios.ISTRIP | JTermios.INLCR | JTermios.IGNCR | JTermios.ICRNL | JTermios.IXON);
        termios2.c_oflag &= ~JTermios.OPOST;
        termios2.c_lflag &= ~(JTermios.ECHO | JTermios.ECHONL | JTermios.ICANON | JTermios.ISIG | JTermios.IEXTEN);
        termios2.c_cflag &= ~(JTermios.CSIZE | JTermios.PARENB);
        termios2.c_cflag |= JTermios.CS8;
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        if (JTermios.F_SETFL != cmd) {
            if (JTermios.F_GETFL == cmd) {
                return port.m_OpenFlags;
            }
            this.m_ErrNo = JTermios.ENOTSUP;
            return -1;
        }
        port.m_OpenFlags = arg;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tcdrain(int fd) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_WrBuffer;
        synchronized (memory) {
            try {
                if (!WinAPI.FlushFileBuffers(port.m_Comm)) {
                    port.fail();
                }
                return 0;
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Fail f) {
                    return -1;
                }
            }
        }
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return termios2.c_ispeed;
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return termios2.c_ospeed;
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        termios2.c_ispeed = speed;
        return 0;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        termios2.c_ospeed = speed;
        return 0;
    }

    @Override
    public int open(String filename, int flags) {
        Port port = new Port();
        try {
            port.open(filename, flags);
            return port.m_FD;
        }
        catch (Fail f) {
            port.close();
            return -1;
        }
    }

    private static void nanoSleep(long nsec) throws Fail {
        try {
            Thread.sleep((int)(nsec / 1000000L), (int)(nsec % 1000000L));
        }
        catch (InterruptedException ie) {
            throw new Fail();
        }
    }

    private int getCharBits(Termios tios) {
        int cs = 8;
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS5) {
            cs = 5;
        }
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS6) {
            cs = 6;
        }
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS7) {
            cs = 7;
        }
        if ((tios.c_cflag & JTermios.CSIZE) == JTermios.CS8) {
            cs = 8;
        }
        if ((tios.c_cflag & JTermios.CSTOPB) != 0) {
            ++cs;
        }
        if ((tios.c_cflag & JTermios.PARENB) != 0) {
            ++cs;
        }
        return cs += 2;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(int fd, byte[] buffer, int length) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_RdBuffer;
        synchronized (memory) {
            try {
                if ((long)length > port.m_RdBuffer.size()) {
                    length = (int)port.m_RdBuffer.size();
                }
                if (length == 0) {
                    return 0;
                }
                if ((port.m_OpenFlags & JTermios.O_NONBLOCK) != 0) {
                    this.clearCommErrors(port);
                    int available = port.m_COMSTAT.cbInQue;
                    if (available == 0) {
                        this.m_ErrNo = JTermios.EAGAIN;
                        return -1;
                    }
                    length = JTermiosImpl.min(length, available);
                } else {
                    this.clearCommErrors(port);
                    int available = port.m_COMSTAT.cbInQue;
                    int vtime = 0xFF & port.m_Termios.c_cc[JTermios.VTIME];
                    int vmin = 0xFF & port.m_Termios.c_cc[JTermios.VMIN];
                    if (vmin == 0 && vtime == 0) {
                        if (available == 0) {
                            return 0;
                        }
                        length = JTermiosImpl.min(length, available);
                    }
                    if (vmin == 0) {
                        // empty if block
                    }
                    if (vmin > 0 && vtime > 0) {
                        length = JTermiosImpl.min(JTermiosImpl.max(vmin, available), length);
                    }
                    if (vmin > 0 && vtime == 0) {
                        length = JTermiosImpl.min(JTermiosImpl.max(vmin, available), length);
                    }
                }
                if (!WinAPI.ResetEvent(port.m_RdOVL.hEvent)) {
                    port.fail();
                }
                if (!WinAPI.ReadFile(port.m_Comm, (Pointer)port.m_RdBuffer, length, port.m_RdN, port.m_RdOVL)) {
                    if (WinAPI.GetLastError() != 997) {
                        port.fail();
                    }
                    port.m_ReadWaitObjects[0] = port.m_RdOVL.hEvent;
                    if (WinAPI.WaitForMultipleObjects(2, port.m_ReadWaitObjects, false, -1) != 0) {
                        port.fail();
                    }
                    if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_RdOVL, port.m_RdN, true)) {
                        port.fail();
                    }
                }
                port.m_RdBuffer.read(0L, buffer, 0, port.m_RdN[0]);
                return port.m_RdN[0];
            }
            catch (Fail ie) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(int fd, byte[] buffer, int length) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        Memory memory = port.m_WrBuffer;
        synchronized (memory) {
            try {
                if (port.m_WritePending > 0) {
                    while (true) {
                        port.m_WriteWaitObjects[0] = port.m_WrOVL.hEvent;
                        int res = WinAPI.WaitForMultipleObjects(2, port.m_WriteWaitObjects, false, -1);
                        if (res != 258) break;
                        this.clearCommErrors(port);
                        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "write pending, cbInQue %d cbOutQue %d\n", port.m_COMSTAT.cbInQue, port.m_COMSTAT.cbOutQue);
                    }
                    if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_WrOVL, port.m_WrN, false)) {
                        port.fail();
                    }
                    if (port.m_WrN[0] != port.m_WritePending) {
                        new RuntimeException("Windows OVERLAPPED WriteFile failed to write all, tried to write " + port.m_WritePending + " but got " + port.m_WrN[0]);
                    }
                    port.m_WritePending = 0;
                }
                if ((port.m_OpenFlags & JTermios.O_NONBLOCK) != 0) {
                    int room;
                    if (!WinAPI.ClearCommError(port.m_Comm, port.m_WrErr, port.m_WrStat)) {
                        port.fail();
                    }
                    if (length > (room = (int)port.m_WrBuffer.size() - port.m_WrStat.cbOutQue)) {
                        length = room;
                    }
                }
                if (!WinAPI.ResetEvent(port.m_WrOVL.hEvent)) {
                    port.fail();
                }
                if ((long)length > port.m_WrBuffer.size()) {
                    length = (int)port.m_WrBuffer.size();
                }
                port.m_WrBuffer.write(0L, buffer, 0, length);
                boolean ok = WinAPI.WriteFile(port.m_Comm, (Pointer)port.m_WrBuffer, length, port.m_WrN, port.m_WrOVL);
                if (!ok) {
                    if (WinAPI.GetLastError() != 997) {
                        port.fail();
                    }
                    port.m_WritePending = length;
                }
                return length;
            }
            catch (Fail f) {
                return -1;
            }
        }
    }

    @Override
    public int close(int fd) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        port.close();
        return 0;
    }

    @Override
    public int tcflush(int fd, int queue) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        try {
            if (queue == JTermios.TCIFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 2)) {
                    port.fail();
                }
            } else if (queue == JTermios.TCOFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 1)) {
                    port.fail();
                }
            } else if (queue == JTermios.TCIOFLUSH) {
                if (!WinAPI.PurgeComm(port.m_Comm, 1)) {
                    port.fail();
                }
                if (!WinAPI.PurgeComm(port.m_Comm, 2)) {
                    port.fail();
                }
            } else {
                this.m_ErrNo = JTermios.ENOTSUP;
                return -1;
            }
            return 0;
        }
        catch (Fail f) {
            return -1;
        }
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        termios2.set(port.m_Termios);
        return 0;
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        Port port = this.getPort(fd);
        if (port == null) {
            return -1;
        }
        try {
            if (!WinAPI.SetCommBreak(port.m_Comm)) {
                port.fail();
            }
            JTermiosImpl.nanoSleep((long)duration * 250000000L);
            if (!WinAPI.ClearCommBreak(port.m_Comm)) {
                port.fail();
            }
            return 0;
        }
        catch (Fail f) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        Port port;
        if (cmd != JTermios.TCSANOW) {
            JTermios.JTermiosLogging.log(0, "tcsetattr only supports TCSANOW\n", new Object[0]);
        }
        if ((port = this.getPort(fd)) == null) {
            return -1;
        }
        Termios termios3 = port.m_Termios;
        synchronized (termios3) {
            try {
                port.m_Termios.set(termios2);
                this.updateFromTermios(port);
                return 0;
            }
            catch (Fail f) {
                return -1;
            }
        }
    }

    public int updateFromTermios(Port port) throws Fail {
        Termios tios = port.m_Termios;
        int c_speed = tios.c_ospeed;
        int c_cflag = tios.c_cflag;
        int c_iflag = tios.c_iflag;
        int c_oflag = tios.c_oflag;
        if (c_speed != port.m_c_speed || c_cflag != port.m_c_cflag || c_iflag != port.m_c_iflag || c_oflag != port.m_c_oflag) {
            WinAPI.DCB dcb = port.m_DCB;
            if (!WinAPI.GetCommState(port.m_Comm, dcb)) {
                port.fail();
            }
            dcb.DCBlength = dcb.size();
            dcb.BaudRate = c_speed;
            if (tios.c_ospeed != tios.c_ispeed) {
                JTermios.JTermiosLogging.log(0, "c_ospeed (%d) != c_ispeed (%d)\n", tios.c_ospeed, tios.c_ispeed);
            }
            int flags = 0;
            flags |= 1;
            if ((c_cflag & JTermios.PARENB) != 0) {
                flags |= 2;
            }
            if ((c_iflag & JTermios.IXON) != 0) {
                flags |= 0x100;
            }
            if ((c_iflag & JTermios.IXOFF) != 0) {
                flags |= 0x200;
            }
            if ((c_iflag & JTermios.IXANY) != 0) {
                flags |= 0x80;
            }
            if ((c_iflag & JTermios.CRTSCTS) != 0) {
                flags |= 0x3000;
                flags |= 4;
            }
            dcb.fFlags = flags;
            int cs = 8;
            int csize = c_cflag & JTermios.CSIZE;
            if (csize == JTermios.CS5) {
                cs = 5;
            }
            if (csize == JTermios.CS6) {
                cs = 6;
            }
            if (csize == JTermios.CS7) {
                cs = 7;
            }
            if (csize == JTermios.CS8) {
                cs = 8;
            }
            dcb.ByteSize = (byte)cs;
            dcb.Parity = (c_cflag & JTermios.PARENB) != 0 ? ((c_cflag & JTermios.PARODD) != 0 && (c_cflag & JTermios.CMSPAR) != 0 ? (byte)3 : ((c_cflag & JTermios.PARODD) != 0 ? (byte)1 : ((c_cflag & JTermios.CMSPAR) != 0 ? (byte)4 : (byte)2))) : (byte)0;
            dcb.StopBits = (c_cflag & JTermios.CSTOPB) != 0 ? (csize == JTermios.CS5 ? 1 : 2) : 0;
            dcb.XonChar = tios.c_cc[JTermios.VSTART];
            dcb.XoffChar = tios.c_cc[JTermios.VSTOP];
            dcb.ErrorChar = 0;
            dcb.EvtChar = (byte)10;
            dcb.EofChar = tios.c_cc[JTermios.VEOF];
            if (!WinAPI.SetCommState(port.m_Comm, dcb)) {
                port.fail();
            }
            port.m_c_speed = c_speed;
            port.m_c_cflag = c_cflag;
            port.m_c_iflag = c_iflag;
            port.m_c_oflag = c_oflag;
        }
        int vmin = port.m_Termios.c_cc[JTermios.VMIN] & 0xFF;
        int vtime = (port.m_Termios.c_cc[JTermios.VTIME] & 0xFF) * 100;
        if (vmin != port.m_VMIN || vtime != port.m_VTIME) {
            WinAPI.COMMTIMEOUTS touts = port.m_Timeouts;
            touts.WriteTotalTimeoutConstant = 0;
            touts.WriteTotalTimeoutMultiplier = 0;
            if (vmin == 0 && vtime == 0) {
                touts.ReadIntervalTimeout = -1;
                touts.ReadTotalTimeoutConstant = 0;
                touts.ReadTotalTimeoutMultiplier = 0;
            }
            if (vmin == 0 && vtime > 0) {
                touts.ReadIntervalTimeout = 0;
                touts.ReadTotalTimeoutConstant = vtime;
                touts.ReadTotalTimeoutMultiplier = 0;
            }
            if (vmin > 0 && vtime > 0) {
                touts.ReadIntervalTimeout = vtime;
                touts.ReadTotalTimeoutConstant = 0;
                touts.ReadTotalTimeoutMultiplier = 0;
            }
            if (vmin > 0 && vtime == 0) {
                touts.ReadIntervalTimeout = 0;
                touts.ReadTotalTimeoutConstant = 0;
                touts.ReadTotalTimeoutMultiplier = 0;
            }
            if (!WinAPI.SetCommTimeouts(port.m_Comm, port.m_Timeouts)) {
                port.fail();
            }
            port.m_VMIN = vmin;
            port.m_VTIME = vtime;
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(2, "vmin %d vtime %d ReadIntervalTimeout %d ReadTotalTimeoutConstant %d ReadTotalTimeoutMultiplier %d\n", vmin, vtime, touts.ReadIntervalTimeout, touts.ReadTotalTimeoutConstant, touts.ReadTotalTimeoutMultiplier);
        }
        return 0;
    }

    private int maskToFDSets(Port port, JTermios.FDSet readfds, JTermios.FDSet writefds, JTermios.FDSet exceptfds, int ready) throws Fail {
        this.clearCommErrors(port);
        int emask = port.m_EventFlags.getValue();
        int fd = port.m_FD;
        if ((emask & 1) != 0 && port.m_COMSTAT.cbInQue > 0) {
            this.FD_SET(fd, readfds);
            ++ready;
        }
        if ((emask & 4) != 0 && port.m_COMSTAT.cbOutQue == 0) {
            this.FD_SET(fd, writefds);
            ++ready;
        }
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCommErrors(Port port) throws Fail {
        WinAPI.COMSTAT cOMSTAT = port.m_COMSTAT;
        synchronized (cOMSTAT) {
            if (!WinAPI.ClearCommError(port.m_Comm, port.m_ClearErr, port.m_COMSTAT)) {
                port.fail();
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int select(int n, JTermios.FDSet readfds, JTermios.FDSet writefds, JTermios.FDSet exceptfds, TimeVal timeout) {
        ready = 0;
        locked = new LinkedList<Port>();
        try {
            waiting = new LinkedList<Port>();
            fd = 0;
            while (true) {
                block40: {
                    block41: {
                        if (fd < n) break block41;
                        if (ready != 0) {
                        }
                        waitn = waiting.size();
                        if (waitn <= 0) break;
                        wobj = new WinAPI.HANDLE[waiting.size() * 2];
                        i = 0;
                        ie = waiting.iterator();
                        if (true) ** GOTO lbl85
                    }
                    rd = this.FD_ISSET(fd, readfds);
                    wr = this.FD_ISSET(fd, writefds);
                    this.FD_CLR(fd, readfds);
                    this.FD_CLR(fd, writefds);
                    if (!rd && !wr) break block40;
                    port = this.getPort(fd);
                    if (port == null) {
                    }
                    try {
                        port.lock();
                        locked.add(port);
                        this.clearCommErrors(port);
                        if (rd && port.m_COMSTAT.cbInQue > 0) {
                            this.FD_SET(fd, readfds);
                            ++ready;
                        }
                        if (wr && port.m_COMSTAT.cbOutQue == 0) {
                            this.FD_SET(fd, writefds);
                            ++ready;
                        }
                        if (port.m_WaitPending) {
                            if (!WinAPI.SetCommMask(port.m_Comm, 0)) {
                                port.fail();
                            }
                            if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_SelOVL, port.m_SelN, false) && WinAPI.GetLastError() != 996) {
                                port.fail();
                            }
                            port.m_WaitPending = false;
                        }
                        if (!WinAPI.ResetEvent(port.m_SelOVL.hEvent)) {
                            port.fail();
                        }
                        flags = 0;
                        if (rd) {
                            flags |= 1;
                        }
                        if (wr) {
                            flags |= 4;
                        }
                        if (!WinAPI.SetCommMask(port.m_Comm, flags)) {
                            port.fail();
                        }
                        if (WinAPI.WaitCommEvent(port.m_Comm, port.m_EventFlags, port.m_SelOVL)) {
                            if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_SelOVL, port.m_SelN, false)) {
                                port.fail();
                            }
                            ready = this.maskToFDSets(port, readfds, writefds, exceptfds, ready);
                        } else {
                            if (WinAPI.GetLastError() != 997 && WinAPI.GetLastError() != 87) {
                                port.fail();
                            }
                            waiting.add(port);
                            port.m_WaitPending = true;
                        }
                    }
                    catch (InterruptedException ie) {
                        this.m_ErrNo = JTermios.EINTR;
                        var19_20 = locked.iterator();
                        if (true) ** GOTO lbl79
                    }
                }
                ++fd;
            }
            if (timeout != null) {
                JTermiosImpl.nanoSleep(timeout.tv_sec * 1000000000L + timeout.tv_usec * 1000L);
            }
            this.m_ErrNo = JTermios.EINVAL;
            return this.m_ErrNo;
        }
        catch (Fail f) {
            f.printStackTrace();
        }
        do {
            port = (Port)var19_20.next();
            port.unlock();
lbl79:
            // 2 sources

        } while (var19_20.hasNext());
        return -1;
        do {
            port = (Port)ie.next();
            wobj[i++] = port.m_SelOVL.hEvent;
            wobj[i++] = port.WaitCommEventCancelObject;
lbl85:
            // 2 sources

        } while (ie.hasNext());
        tout = timeout != null ? (int)(timeout.tv_sec * 1000L + timeout.tv_usec / 1000L) : -1;
        res = WinAPI.WaitForMultipleObjects(waitn * 2, wobj, false, tout);
        if (res == 258) {
            for (Port port : waiting) {
                this.clearCommErrors(port);
                mask = new int[1];
                if (!WinAPI.GetCommMask(port.m_Comm, mask)) {
                    port.fail();
                }
                if (port.m_COMSTAT.cbInQue > 0 && (mask[0] & 1) != 0) {
                    this.FD_SET(port.m_FD, readfds);
                    JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log != false && JTermios.JTermiosLogging.log(1, "missed EV_RXCHAR event\n", new Object[0]) != false;
                    return (int)JTermios.JTermiosLogging.log;
                }
                if (port.m_COMSTAT.cbOutQue != 0 || (mask[0] & 4) == 0) continue;
                this.FD_SET(port.m_FD, writefds);
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log != false && JTermios.JTermiosLogging.log(1, "missed EV_TXEMPTY event\n", new Object[0]) != false;
                return (int)JTermios.JTermiosLogging.log;
            }
        }
        if (res != 258) {
            i = (res - 0) / 2;
            if (i < 0) throw new Fail();
            if (i >= waitn) {
                throw new Fail();
            }
            if ((res - 0 & 1) == 1) {
            }
            port = (Port)waiting.get(i);
            if (!WinAPI.GetOverlappedResult(port.m_Comm, port.m_SelOVL, port.m_SelN, false)) {
                port.fail();
            }
            ready = this.maskToFDSets(port, readfds, writefds, exceptfds, ready);
            port.m_WaitPending = false;
        }
        finally {
            ** for (port : locked)
        }
lbl-1000:
        // 1 sources

        {
            port.unlock();
            continue;
        }
lbl120:
        // 1 sources

        return -1;
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        this.m_ErrNo = JTermios.EINVAL;
        return -1;
    }

    public int poll(int[] fds, int nfds, int timeout) {
        this.m_ErrNo = JTermios.EINVAL;
        return -1;
    }

    @Override
    public boolean canPoll() {
        return false;
    }

    @Override
    public void perror(String msg) {
        if (msg != null && msg.length() > 0) {
            System.out.print(String.valueOf(msg) + ": ");
        }
        System.out.printf("%d\n", this.m_ErrNo);
    }

    private static int baudToDCB(int baud) {
        switch (baud) {
            case 110: {
                return 110;
            }
            case 300: {
                return 300;
            }
            case 600: {
                return 600;
            }
            case 1200: {
                return 1200;
            }
            case 2400: {
                return 2400;
            }
            case 4800: {
                return 4800;
            }
            case 9600: {
                return 9600;
            }
            case 14400: {
                return 14400;
            }
            case 19200: {
                return 19200;
            }
            case 38400: {
                return 38400;
            }
            case 57600: {
                return 57600;
            }
            case 115200: {
                return 115200;
            }
            case 128000: {
                return 128000;
            }
            case 256000: {
                return 256000;
            }
        }
        return baud;
    }

    @Override
    public JTermios.FDSet newFDSet() {
        return new FDSetImpl();
    }

    public void FD_CLR(int fd, JTermios.FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] & ~(1 << fd % 32);
    }

    public boolean FD_ISSET(int fd, JTermios.FDSet set) {
        if (set == null) {
            return false;
        }
        FDSetImpl p = (FDSetImpl)set;
        return (p.bits[fd / 32] & 1 << fd % 32) != 0;
    }

    public void FD_SET(int fd, JTermios.FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] | 1 << fd % 32;
    }

    public void FD_ZERO(JTermios.FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        Arrays.fill(p.bits, 0);
    }

    @Override
    public int ioctl(int fd, int cmd, int[] arg) {
        block11: {
            Port port;
            block10: {
                block9: {
                    port = this.getPort(fd);
                    if (port == null) {
                        return -1;
                    }
                    try {
                        if (cmd != JTermios.FIONREAD) break block9;
                        this.clearCommErrors(port);
                        arg[0] = port.m_COMSTAT.cbInQue;
                        return 0;
                    }
                    catch (Fail f) {
                        return -1;
                    }
                }
                if (cmd != JTermios.TIOCMSET) break block10;
                int a = arg[0];
                port.MSR = (a & JTermios.TIOCM_DTR) != 0 ? (port.MSR |= JTermios.TIOCM_DTR) : (port.MSR &= ~JTermios.TIOCM_DTR);
                if (!WinAPI.EscapeCommFunction(port.m_Comm, (a & JTermios.TIOCM_DTR) != 0 ? 5 : 6)) {
                    port.fail();
                }
                port.MSR = (a & JTermios.TIOCM_RTS) != 0 ? (port.MSR |= JTermios.TIOCM_RTS) : (port.MSR &= ~JTermios.TIOCM_RTS);
                if (!WinAPI.EscapeCommFunction(port.m_Comm, (a & JTermios.TIOCM_RTS) != 0 ? 3 : 4)) {
                    port.fail();
                }
                return 0;
            }
            if (cmd != JTermios.TIOCMGET) break block11;
            int[] stat = new int[1];
            if (!WinAPI.GetCommModemStatus(port.m_Comm, stat)) {
                port.fail();
            }
            int s = stat[0];
            int a = arg[0];
            a = (s & 0x80) != 0 ? (a |= JTermios.TIOCM_CAR) : (a &= ~JTermios.TIOCM_CAR);
            a = (s & 0x40) != 0 ? (a |= JTermios.TIOCM_RNG) : (a &= ~JTermios.TIOCM_RNG);
            a = (s & 0x20) != 0 ? (a |= JTermios.TIOCM_DSR) : (a &= ~JTermios.TIOCM_DSR);
            a = (s & 0x10) != 0 ? (a |= JTermios.TIOCM_CTS) : (a &= ~JTermios.TIOCM_CTS);
            a = (port.MSR & JTermios.TIOCM_DTR) != 0 ? (a |= JTermios.TIOCM_DTR) : (a &= ~JTermios.TIOCM_DTR);
            a = (port.MSR & JTermios.TIOCM_RTS) != 0 ? (a |= JTermios.TIOCM_RTS) : (a &= ~JTermios.TIOCM_RTS);
            arg[0] = a;
            return 0;
        }
        this.m_ErrNo = JTermios.ENOTSUP;
        return -1;
    }

    private void set_errno(int x) {
        this.m_ErrNo = x;
    }

    private void report(String msg) {
        System.err.print(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Port getPort(int fd) {
        JTermiosImpl jTermiosImpl = this;
        synchronized (jTermiosImpl) {
            Port port = this.m_OpenPorts.get(fd);
            if (port == null) {
                this.m_ErrNo = JTermios.EBADF;
            }
            return port;
        }
    }

    private static String getString(byte[] buffer, int offset) {
        byte c;
        StringBuffer s = new StringBuffer();
        while ((c = buffer[offset++]) != 0) {
            s.append((char)c);
        }
        return s.toString();
    }

    @Override
    public String getPortNamePattern() {
        return "^COM.*";
    }

    @Override
    public List<String> getPortList() {
        Pattern p = JTermios.getPortNamePattern(this);
        int size = 0;
        size = 16384;
        while (size < 0x100000) {
            byte[] buffer = new byte[size];
            int res = WinAPI.QueryDosDevice(null, buffer, buffer.length);
            if (res > 0) {
                String port;
                LinkedList<String> list = new LinkedList<String>();
                int offset = 0;
                while ((port = JTermiosImpl.getString(buffer, offset)).length() > 0) {
                    if (p.matcher(port).matches()) {
                        list.add(port);
                    }
                    offset += port.length() + 1;
                }
                return list;
            }
            int err = WinAPI.GetLastError();
            if (err != 122) {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "QueryDosDeviceW() failed with GetLastError() = %d\n", err);
                return null;
            }
            size *= 2;
        }
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "Repeated QueryDosDeviceW() calls failed up to buffer size %d\n", size);
        return null;
    }

    @Override
    public void shutDown() {
        for (Port port : this.m_OpenPorts.values()) {
            try {
                JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "shutDown() closing port %d\n", port.m_FD);
                port.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int br = speed;
        switch (speed) {
            case 50: {
                br = JTermios.B50;
                break;
            }
            case 75: {
                br = JTermios.B75;
                break;
            }
            case 110: {
                br = JTermios.B110;
                break;
            }
            case 134: {
                br = JTermios.B134;
                break;
            }
            case 150: {
                br = JTermios.B150;
                break;
            }
            case 200: {
                br = JTermios.B200;
                break;
            }
            case 300: {
                br = JTermios.B300;
                break;
            }
            case 600: {
                br = JTermios.B600;
                break;
            }
            case 1200: {
                br = JTermios.B1200;
                break;
            }
            case 1800: {
                br = JTermios.B1800;
                break;
            }
            case 2400: {
                br = JTermios.B2400;
                break;
            }
            case 4800: {
                br = JTermios.B4800;
                break;
            }
            case 9600: {
                br = JTermios.B9600;
                break;
            }
            case 19200: {
                br = JTermios.B19200;
                break;
            }
            case 38400: {
                br = JTermios.B38400;
                break;
            }
            case 7200: {
                br = JTermios.B7200;
                break;
            }
            case 14400: {
                br = JTermios.B14400;
                break;
            }
            case 28800: {
                br = JTermios.B28800;
                break;
            }
            case 57600: {
                br = JTermios.B57600;
                break;
            }
            case 76800: {
                br = JTermios.B76800;
                break;
            }
            case 115200: {
                br = JTermios.B115200;
                break;
            }
            case 230400: {
                br = JTermios.B230400;
            }
        }
        int r = this.cfsetispeed(termios2, br);
        if (r != 0) {
            return r;
        }
        r = this.cfsetospeed(termios2, br);
        if (r != 0) {
            return r;
        }
        r = this.tcsetattr(fd, JTermios.TCSANOW, termios2);
        if (r != 0) {
            return r;
        }
        return 0;
    }

    @Override
    public int pipe(int[] fds) {
        this.m_ErrNo = JTermios.EMFILE;
        return -1;
    }

    private static class FDSetImpl
    implements JTermios.FDSet {
        static final int FD_SET_SIZE = 256;
        static final int NFBBITS = 32;
        int[] bits = new int[8];

        private FDSetImpl() {
        }

        public void FD_CLR(int fd) {
            int n = fd / 32;
            this.bits[n] = this.bits[n] & ~(1 << fd % 32);
        }

        public boolean FD_ISSET(int fd) {
            return (this.bits[fd / 32] & 1 << fd % 32) != 0;
        }

        public void FD_SET(int fd) {
            int n = fd / 32;
            this.bits[n] = this.bits[n] | 1 << fd % 32;
        }

        public void FD_ZERO() {
            Arrays.fill(this.bits, 0);
        }
    }

    static class Fail
    extends Exception {
        Fail() {
        }
    }

    private class Port {
        volatile int m_FD = -1;
        volatile boolean m_Locked;
        volatile WinAPI.HANDLE m_Comm;
        volatile int m_OpenFlags;
        volatile WinAPI.DCB m_DCB = new WinAPI.DCB();
        volatile WinAPI.COMMTIMEOUTS m_Timeouts = new WinAPI.COMMTIMEOUTS();
        volatile WinAPI.COMSTAT m_COMSTAT = new WinAPI.COMSTAT();
        volatile int[] m_ClearErr = new int[1];
        volatile Memory m_RdBuffer = new Memory(2048L);
        volatile int[] m_RdErr = new int[1];
        volatile int[] m_RdN = new int[1];
        volatile WinAPI.OVERLAPPED m_RdOVL = new WinAPI.OVERLAPPED();
        volatile WinAPI.HANDLE m_ReadCancelObject;
        volatile WinAPI.HANDLE[] m_ReadWaitObjects = new WinAPI.HANDLE[2];
        volatile Memory m_WrBuffer = new Memory(2048L);
        volatile WinAPI.COMSTAT m_WrStat = new WinAPI.COMSTAT();
        volatile int[] m_WrErr = new int[1];
        volatile int[] m_WrN = new int[1];
        volatile int m_WritePending;
        volatile WinAPI.OVERLAPPED m_WrOVL = new WinAPI.OVERLAPPED();
        volatile WinAPI.HANDLE m_WriteCancelObject;
        volatile WinAPI.HANDLE[] m_WriteWaitObjects = new WinAPI.HANDLE[2];
        volatile boolean m_WaitPending;
        volatile int[] m_SelN = new int[1];
        volatile WinAPI.HANDLE WaitCommEventCancelObject;
        volatile WinAPI.OVERLAPPED m_SelOVL = new WinAPI.OVERLAPPED();
        volatile IntByReference m_EventFlags = new IntByReference();
        volatile Termios m_Termios = new Termios();
        volatile int MSR;
        volatile int m_VTIME = -1;
        volatile int m_VMIN = -1;
        volatile int m_c_speed = -1;
        volatile int m_c_cflag = -1;
        volatile int m_c_iflag = -1;
        volatile int m_c_oflag = -1;

        private Port() {
        }

        public synchronized void fail() throws Fail {
            int err = WinAPI.GetLastError();
            Memory buffer = new Memory(2048L);
            WinAPI.FormatMessageW(4608, null, err, WinAPI.MAKELANGID(0, 1), (Pointer)buffer, (int)buffer.size(), null);
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "fail() %s, Windows GetLastError()= %d, %s\n", JTermios.JTermiosLogging.lineno(1), err, buffer.getWideString(0L));
            Fail f = new Fail();
            throw f;
        }

        public synchronized void lock() throws InterruptedException {
            while (this.m_Locked) {
                this.wait();
            }
            this.m_Locked = true;
        }

        public synchronized void unlock() {
            if (!this.m_Locked) {
                throw new IllegalArgumentException("Port was not locked");
            }
            this.m_Locked = false;
            this.notifyAll();
        }

        public synchronized void waitUnlock() {
            while (this.m_Locked) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void open(String filename, int flags) throws Fail {
            JTermiosImpl jTermiosImpl = JTermiosImpl.this;
            synchronized (jTermiosImpl) {
                this.m_FD = -1;
                int i = 0;
                while (i < JTermiosImpl.this.m_PortFDs.length) {
                    if (!JTermiosImpl.this.m_PortFDs[i]) {
                        this.m_FD = i;
                        ((JTermiosImpl)JTermiosImpl.this).m_PortFDs[i] = true;
                        JTermiosImpl.this.m_OpenPorts.put(this.m_FD, this);
                        this.m_OpenFlags = flags;
                        if (!filename.startsWith("\\\\")) {
                            filename = "\\\\.\\" + filename;
                        }
                        this.m_Comm = WinAPI.CreateFile(filename, -1073741824, 0, null, 3, 0x40000000, null);
                        if (WinAPI.INVALID_HANDLE_VALUE == this.m_Comm) {
                            if (WinAPI.GetLastError() == 2) {
                                JTermiosImpl.this.m_ErrNo = JTermios.ENOENT;
                            } else {
                                JTermiosImpl.this.m_ErrNo = JTermios.EBUSY;
                            }
                            this.fail();
                        }
                        if (!WinAPI.SetupComm(this.m_Comm, (int)this.m_RdBuffer.size(), (int)this.m_WrBuffer.size())) {
                            this.fail();
                        }
                        JTermiosImpl.this.cfmakeraw(this.m_Termios);
                        JTermiosImpl.this.cfsetispeed(this.m_Termios, JTermios.B9600);
                        JTermiosImpl.this.cfsetospeed(this.m_Termios, JTermios.B9600);
                        this.m_Termios.c_cc[JTermios.VTIME] = 0;
                        this.m_Termios.c_cc[JTermios.VMIN] = 0;
                        JTermiosImpl.this.updateFromTermios(this);
                        this.WaitCommEventCancelObject = WinAPI.CreateEvent(null, false, false, null);
                        if (this.WaitCommEventCancelObject == WinAPI.INVALID_HANDLE_VALUE) {
                            this.fail();
                        }
                        this.m_ReadCancelObject = WinAPI.CreateEvent(null, true, false, null);
                        if (this.m_ReadCancelObject == WinAPI.INVALID_HANDLE_VALUE) {
                            this.fail();
                        }
                        this.m_ReadWaitObjects[1] = this.m_ReadCancelObject;
                        this.m_WriteCancelObject = WinAPI.CreateEvent(null, true, false, null);
                        if (this.m_WriteCancelObject == WinAPI.INVALID_HANDLE_VALUE) {
                            this.fail();
                        }
                        this.m_WriteWaitObjects[1] = this.m_WriteCancelObject;
                        this.m_RdOVL.writeField("hEvent", (Object)WinAPI.CreateEvent(null, true, false, null));
                        if (this.m_RdOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                            this.fail();
                        }
                        this.m_WrOVL.writeField("hEvent", (Object)WinAPI.CreateEvent(null, true, false, null));
                        if (this.m_WrOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                            this.fail();
                        }
                        this.m_SelOVL.writeField("hEvent", (Object)WinAPI.CreateEvent(null, true, false, null));
                        if (this.m_SelOVL.hEvent == WinAPI.INVALID_HANDLE_VALUE) {
                            this.fail();
                        }
                        return;
                    }
                    ++i;
                }
                throw new RuntimeException("Too many ports open");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            JTermiosImpl jTermiosImpl = JTermiosImpl.this;
            synchronized (jTermiosImpl) {
                WinAPI.HANDLE h;
                if (this.m_FD >= 0) {
                    JTermiosImpl.this.m_OpenPorts.remove(this.m_FD);
                    ((JTermiosImpl)JTermiosImpl.this).m_PortFDs[this.m_FD] = false;
                    this.m_FD = -1;
                }
                if (this.m_ReadCancelObject != null) {
                    WinAPI.SetEvent(this.m_ReadCancelObject);
                }
                Memory memory = this.m_RdBuffer;
                synchronized (memory) {
                    h = (WinAPI.HANDLE)((Object)this.m_RdOVL.readField("hEvent"));
                    this.m_RdOVL = null;
                    if (h != null && !h.equals((Object)WinAPI.NULL) && !h.equals((Object)WinAPI.INVALID_HANDLE_VALUE)) {
                        WinAPI.CloseHandle(h);
                    }
                    if (this.m_ReadCancelObject != null && this.m_ReadCancelObject != WinAPI.NULL && this.m_ReadCancelObject != WinAPI.INVALID_HANDLE_VALUE) {
                        WinAPI.CloseHandle(this.m_ReadCancelObject);
                    }
                    this.m_ReadCancelObject = null;
                }
                if (this.m_WriteCancelObject != null) {
                    WinAPI.SetEvent(this.m_WriteCancelObject);
                }
                memory = this.m_WrBuffer;
                synchronized (memory) {
                    h = (WinAPI.HANDLE)((Object)this.m_WrOVL.readField("hEvent"));
                    this.m_WrOVL = null;
                    if (h != null && !h.equals((Object)WinAPI.NULL) && !h.equals((Object)WinAPI.INVALID_HANDLE_VALUE)) {
                        WinAPI.CloseHandle(h);
                    }
                    if (this.m_WriteCancelObject != null && this.m_WriteCancelObject != WinAPI.NULL && this.m_WriteCancelObject != WinAPI.INVALID_HANDLE_VALUE) {
                        WinAPI.CloseHandle(this.m_WriteCancelObject);
                    }
                    this.m_ReadCancelObject = null;
                }
                if (this.WaitCommEventCancelObject != null) {
                    WinAPI.SetEvent(this.WaitCommEventCancelObject);
                }
                this.waitUnlock();
                if (this.WaitCommEventCancelObject != null && this.WaitCommEventCancelObject != WinAPI.NULL && this.WaitCommEventCancelObject != WinAPI.INVALID_HANDLE_VALUE) {
                    WinAPI.CloseHandle(this.WaitCommEventCancelObject);
                }
                this.WaitCommEventCancelObject = null;
                h = (WinAPI.HANDLE)((Object)this.m_SelOVL.readField("hEvent"));
                this.m_SelOVL = null;
                if (h != null && !h.equals((Object)WinAPI.NULL) && !h.equals((Object)WinAPI.INVALID_HANDLE_VALUE)) {
                    WinAPI.CloseHandle(h);
                }
                if (this.m_Comm != null && this.m_Comm != WinAPI.NULL && this.m_Comm != WinAPI.INVALID_HANDLE_VALUE) {
                    WinAPI.CloseHandle(this.m_Comm);
                }
                this.m_Comm = null;
            }
        }
    }
}

