/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi;

import com.sun.jna.Platform;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.linux.LinuxBackend;
import purejavahidapi.macosx.MacOsXBackend;
import purejavahidapi.shared.Backend;
import purejavahidapi.windows.WindowsBackend;

public class PureJavaHidApi {
    private static Object m_Mutex = new Object();
    private static final Backend m_Backend;
    private static LinkedList<HidDevice> m_OpenDevices;

    public static String getVersion() {
        return "0.0.13";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HidDeviceInfo> enumerateDevices() {
        Object object = m_Mutex;
        synchronized (object) {
            if (m_Backend == null) {
                throw new IllegalStateException("Unsupported platform");
            }
            return m_Backend.enumerateDevices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HidDevice openDevice(HidDeviceInfo hidDeviceInfo) throws IOException {
        Object object = m_Mutex;
        synchronized (object) {
            if (m_Backend == null) {
                throw new IllegalStateException("Unsupported platform");
            }
            HidDevice hidDevice = m_Backend.openDevice(hidDeviceInfo);
            if (hidDevice != null) {
                m_OpenDevices.add(hidDevice);
            }
            return hidDevice;
        }
    }

    static {
        m_OpenDevices = new LinkedList();
        m_Backend = Platform.isMac() ? new MacOsXBackend() : (Platform.isWindows() ? new WindowsBackend() : (Platform.isLinux() ? new LinuxBackend() : null));
        if (m_Backend != null) {
            m_Backend.init();
        }
    }
}

