/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.examples;

import java.util.List;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.PureJavaHidApi;

public class Example2 {
    static volatile boolean deviceOpen = false;

    public static void main(String[] stringArray) {
        try {
            while (true) {
                HidDeviceInfo hidDeviceInfo = null;
                if (deviceOpen) continue;
                System.out.println("scanning");
                List<HidDeviceInfo> list = PureJavaHidApi.enumerateDevices();
                for (HidDeviceInfo hidDeviceInfo2 : list) {
                    if (hidDeviceInfo2.getVendorId() != 7504 || hidDeviceInfo2.getProductId() != 24608) continue;
                    hidDeviceInfo = hidDeviceInfo2;
                    break;
                }
                if (hidDeviceInfo == null) {
                    System.out.println("device not found");
                    Thread.sleep(1000L);
                    continue;
                }
                System.out.println("device found '" + hidDeviceInfo.getProductString() + "'");
                deviceOpen = true;
                final HidDevice hidDevice = PureJavaHidApi.openDevice(hidDeviceInfo);
                hidDevice.setDeviceRemovalListener(new DeviceRemovalListener(){

                    @Override
                    public void onDeviceRemoval(HidDevice hidDevice) {
                        System.out.println("device removed");
                        deviceOpen = false;
                    }
                });
                hidDevice.setInputReportListener(new InputReportListener(){

                    @Override
                    public void onInputReport(HidDevice hidDevice, byte by, byte[] byArray, int n) {
                        System.out.print(".");
                    }
                });
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(1000L);
                                System.out.println();
                                System.out.println("Sending reset");
                                for (int i = 0; i < 10; ++i) {
                                    byte[] byArray = new byte[64];
                                    byArray[0] = -2;
                                    byArray[1] = -19;
                                    byArray[2] = -64;
                                    byArray[3] = -34;
                                    System.out.println("SEND");
                                    hidDevice.setOutputReport((byte)0, byArray, byArray.length);
                                }
                                Thread.currentThread();
                                Thread.sleep(1000L);
                                deviceOpen = false;
                                hidDevice.close();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                }).start();
                Thread.sleep(2000L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }
}

