/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.hidparser;

import java.util.LinkedList;
import purejavahidapi.hidparser.Collection;
import purejavahidapi.hidparser.Field;
import purejavahidapi.hidparser.HidParserTestData;
import purejavahidapi.hidparser.Report;

public class HidParser {
    public static final boolean TRACE = true;
    private Collection m_RootCollection;
    private Collection m_TopCollection;
    private LinkedList<Global> m_GlobalStack;
    private int m_DelemiterDepth;
    private int m_ParseIndex;
    private byte[] m_Descritor;
    private int m_DescritorLength;
    private Local m_Local;
    private Global m_Global;
    private LinkedList<Report> m_Reports;
    static final int HID_MAX_FIELDS = 256;
    private static final int HID_MAX_IDS = 256;
    private static final int HID_MAX_APPLICATIONS = 16;
    private static final int HID_MAX_USAGES = 12288;
    private static final int HID_INPUT_REPORT = 0;
    private static final int HID_OUTPUT_REPORT = 1;
    private static final int HID_FEATURE_REPORT = 2;
    private static final int HID_COLLECTION_PHYSICAL = 0;
    private static final int HID_COLLECTION_APPLICATION = 1;
    private static final int HID_COLLECTION_LOGICAL = 2;
    private static final int HID_MAIN_ITEM_CONSTANT = 1;
    private static final int HID_MAIN_ITEM_VARIABLE = 2;
    private static final int HID_MAIN_ITEM_RELATIVE = 4;
    private static final int HID_MAIN_ITEM_WRAP = 8;
    private static final int HID_MAIN_ITEM_NONLINEAR = 16;
    private static final int HID_MAIN_ITEM_NO_PREFERRED = 32;
    private static final int HID_MAIN_ITEM_NULL_STATE = 64;
    private static final int HID_MAIN_ITEM_VOLATILE = 128;
    private static final int HID_MAIN_ITEM_BUFFERED_BYTE = 256;
    private static final int HID_LONG_ITEM_PREFIX = 254;

    static void printf(String string, Object ... objectArray) {
        System.out.printf(string, objectArray);
    }

    private Report registerReport(int n, int n2) {
        for (Report report : this.m_Reports) {
            if (report.m_Type != n || report.m_Id != n2) continue;
            return report;
        }
        Report report = new Report(n, n2, this.m_TopCollection);
        this.m_Reports.add(report);
        return report;
    }

    private Field registerField(Report report, int n) {
        if (report.m_MaxField == 256) {
            throw new IllegalStateException("too many fields in report");
        }
        Field field = new Field(this.m_TopCollection);
        report.m_Fields[report.m_MaxField++] = field;
        field.m_Report = report;
        return field;
    }

    private int lookUpCollection(int n) {
        Collection collection = this.m_TopCollection;
        while (collection.m_Parent != null) {
            if (collection.m_Type == n) {
                return collection.m_Usage;
            }
            collection = collection.m_Parent;
        }
        return 0;
    }

    private void addUsage(int n) {
        if (this.m_Local.m_UsageIndex >= this.m_Local.m_Usages.length) {
            throw new IllegalStateException("usage index exceeded");
        }
        this.m_Local.m_Usages[this.m_Local.m_UsageIndex++] = n;
    }

    private void addField(int n, int n2) {
        Report report = null;
        report = this.registerReport(n, this.m_Global.m_ReportId);
        if (null == report) {
            throw new IllegalStateException("failed to register report");
        }
        int n3 = 0;
        for (int i = 0; i < this.m_Global.m_ReportCount; ++i) {
            if (i < this.m_Local.m_UsageIndex) {
                n3 = i;
            }
            int n4 = report.m_Size;
            report.m_Size += this.m_Global.m_ReportSize;
            Field field = this.registerField(report, this.m_Global.m_ReportCount);
            if (null == field) {
                throw new IllegalStateException("failed to register field");
            }
            field.m_Physical = this.lookUpCollection(0);
            field.m_Logical = this.lookUpCollection(2);
            field.m_Application = this.lookUpCollection(1);
            field.m_Usage = this.m_Local.m_Usages[n3];
            field.m_Flags = n2;
            field.m_ReportOffset = n4;
            field.m_ReportType = n;
            field.m_ReportSize = this.m_Global.m_ReportSize;
            field.m_LogicalMinimum = this.m_Global.m_LogicalMinimum;
            field.m_LogicalMaximum = this.m_Global.m_LogicalMaximum;
            field.m_PhysicalMinimum = this.m_Global.m_PhysicalMinimum;
            field.m_PhysicalMaximum = this.m_Global.m_PhysicalMaximum;
            field.m_UnitExponent = this.m_Global.m_UnitExponent;
            field.m_Unit = this.m_Global.m_Unit;
        }
    }

    private void parseGlobalItem(Item item) {
        switch (item.m_GTag) {
            case PUSH: {
                this.m_GlobalStack.push((Global)this.m_Global.clone());
                break;
            }
            case POP: {
                if (this.m_GlobalStack.isEmpty()) {
                    throw new IllegalStateException("global enviroment stack underflow");
                }
                this.m_Global = this.m_GlobalStack.pop();
                break;
            }
            case USAGE_PAGE: {
                this.m_Global.m_UsagePage = item.m_UValue;
                break;
            }
            case LOGICAL_MINIMUM: {
                this.m_Global.m_LogicalMinimum = item.m_SValue;
                break;
            }
            case LOGICAL_MAXIMUM: {
                this.m_Global.m_LogicalMaximum = item.m_SValue;
                break;
            }
            case PHYSICAL_MINIMUM: {
                this.m_Global.m_PhysicalMinimum = item.m_SValue;
                break;
            }
            case PHYSICAL_MAXIMUM: {
                this.m_Global.m_PhysicalMaximum = item.m_SValue;
                System.out.println("m_Global.m_PhysicalMaximum " + this.m_Global.m_PhysicalMaximum);
                break;
            }
            case UNIT_EXPONENT: {
                this.m_Global.m_UnitExponent = item.m_SValue;
                break;
            }
            case UNIT: {
                this.m_Global.m_Unit = item.m_UValue;
                break;
            }
            case REPORT_SIZE: {
                if (item.m_UValue < 0 || item.m_UValue > 32) {
                    throw new IllegalStateException(String.format("invalid report size %d", item.m_UValue));
                }
                this.m_Global.m_ReportSize = item.m_UValue;
                break;
            }
            case REPORT_COUNT: {
                if (item.m_UValue < 0 || item.m_UValue > 12288) {
                    throw new IllegalStateException(String.format("invalid report count %d", item.m_UValue));
                }
                this.m_Global.m_ReportCount = item.m_UValue;
                break;
            }
            case REPORT_ID: {
                if (item.m_UValue == 0) {
                    throw new IllegalStateException("report_id 0 is invalid");
                }
                this.m_Global.m_ReportId = item.m_UValue;
                break;
            }
            default: {
                throw new IllegalStateException("unsupported global tag");
            }
        }
    }

    private void parseMainItem(Item item) {
        switch (item.m_MTag) {
            case COLLECTION: {
                this.m_TopCollection = new Collection(this.m_TopCollection, this.m_Local.m_Usages[0], item.m_UValue & 3);
                break;
            }
            case ENDCOLLECTION: {
                if (this.m_TopCollection.m_Parent == null) {
                    throw new IllegalStateException("collection stack underflow");
                }
                this.m_TopCollection = this.m_TopCollection.m_Parent;
                this.m_Local.reset();
                break;
            }
            case INPUT: {
                this.addField(0, item.m_UValue);
                this.m_Local.reset();
                break;
            }
            case OUTPUT: {
                this.addField(1, item.m_UValue);
                this.m_Local.reset();
                break;
            }
            case FEATURE: {
                this.addField(2, item.m_UValue);
                this.m_Local.reset();
                break;
            }
            default: {
                throw new IllegalStateException("unsupported main tag");
            }
        }
    }

    private void parseLocalItem(Item item) {
        if (item.m_Size == 0) {
            throw new IllegalStateException("item data expected for local item");
        }
        int n = item.m_UValue;
        if (item.m_Size <= 2) {
            n = (this.m_Global.m_UsagePage << 16) + n;
        }
        switch (item.m_LTag) {
            case DELIMITER: {
                if (item.m_UValue > 0) {
                    if (this.m_Local.m_DelimiterDepth != 0) {
                        throw new IllegalStateException("nested delimiters");
                    }
                    ++this.m_Local.m_DelimiterDepth;
                    ++this.m_Local.m_DelimiterBranch;
                    break;
                }
                if (this.m_Local.m_DelimiterDepth < 1) {
                    throw new IllegalStateException("extra delimiters");
                }
                --this.m_Local.m_DelimiterDepth;
                break;
            }
            case USAGE: {
                if (this.m_Local.m_DelimiterBranch > 1) break;
                this.addUsage(n);
                break;
            }
            case USAGE_MINIMUM: {
                if (this.m_Local.m_DelimiterDepth <= 1) break;
                this.m_Local.m_UsageMinimum = n;
                break;
            }
            case USAGE_MAXIMUM: {
                if (this.m_Local.m_DelimiterBranch <= 1) break;
                for (int i = this.m_Local.m_UsageMinimum; i <= item.m_UValue; ++i) {
                    this.addUsage(i);
                }
                break;
            }
            case DESIGNATOR_INDEX: {
                break;
            }
            case DESIGNATOR_MAXIMUM: {
                break;
            }
            case DESIGNATOR_MINIMUM: {
                break;
            }
            case STRING_INDEX: {
                break;
            }
            case STRING_MAXIMUM: {
                break;
            }
            case STRING_MINIMUM: {
                break;
            }
            default: {
                throw new IllegalStateException("unsupported local tag");
            }
        }
    }

    private Item getNextItem() {
        int n;
        int n2;
        if (this.m_ParseIndex >= this.m_DescritorLength) {
            return null;
        }
        Item item = null;
        int n3 = this.m_ParseIndex;
        if ((n2 = this.m_Descritor[this.m_ParseIndex++] & 0xFF) == 254) {
            if (this.m_ParseIndex >= this.m_DescritorLength) {
                throw new IllegalStateException("unexpected end of data white fetching long item size");
            }
            n = this.m_Descritor[this.m_ParseIndex++] & 0xFF;
            if (this.m_ParseIndex >= this.m_DescritorLength) {
                throw new IllegalStateException("unexpected end of data white fetching long item tag");
            }
            int n4 = this.m_Descritor[this.m_ParseIndex++] & 0xFF;
            if (this.m_ParseIndex + n - 1 >= this.m_DescritorLength) {
                throw new IllegalStateException("unexpected end of data white fetching long item");
            }
            this.m_ParseIndex += n;
            item = new Item(n, ItemType.LONG, n4, 0);
        } else {
            n = n2 >> 2 & 3;
            int n5 = n2 >> 4 & 0xF;
            int n6 = n2 & 3;
            int n7 = 0;
            switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.m_ParseIndex >= this.m_DescritorLength) {
                        throw new IllegalStateException("unexpected end of data white fetching item size==1");
                    }
                    n7 = this.m_Descritor[this.m_ParseIndex++] & 0xFF;
                    break;
                }
                case 2: {
                    if (this.m_ParseIndex + 1 >= this.m_DescritorLength) {
                        throw new IllegalStateException("unexpected end of data white fetching item size==1");
                    }
                    n7 = this.m_Descritor[this.m_ParseIndex++] & 0xFF | (this.m_Descritor[this.m_ParseIndex++] & 0xFF) << 8;
                    break;
                }
                case 3: {
                    ++n6;
                    if (this.m_ParseIndex + 1 >= this.m_DescritorLength) {
                        throw new IllegalStateException("unexpected end of data white fetching item size==1");
                    }
                    n7 = this.m_Descritor[this.m_ParseIndex++] & 0xFF | (this.m_Descritor[this.m_ParseIndex++] & 0xFF) << 8 | (this.m_Descritor[this.m_ParseIndex++] & 0xFF) << 16 | this.m_Descritor[this.m_ParseIndex++] << 24;
                }
            }
            if (n < 0 || n >= ItemType.values().length) {
                throw new IllegalStateException(String.format("illegal/unsupported type %d", n));
            }
            item = new Item(n6, ItemType.values()[n], n5, n7);
        }
        String string = "?";
        if (item.m_GTag != null) {
            string = item.m_GTag.toString();
        }
        if (item.m_MTag != null) {
            string = item.m_MTag.toString();
        }
        if (item.m_LTag != null) {
            string = item.m_LTag.toString();
        }
        HidParser.printf("[%3d] = 0x%02X:  size %d  type %-8s  tag %-20s  value 0x%08X (%d)\n", new Object[]{n3, n2, item.m_Size, item.m_Type, string, item.m_SValue, item.m_SValue});
        return item;
    }

    private void resetParser() {
        this.m_TopCollection = this.m_RootCollection = new Collection(null, 0, 0);
        this.m_GlobalStack = new LinkedList();
        this.m_DelemiterDepth = 0;
        this.m_ParseIndex = 0;
        this.m_Descritor = null;
        this.m_DescritorLength = 0;
        this.m_Local = new Local();
        this.m_Global = new Global();
        this.m_Reports = new LinkedList();
    }

    public void dump(String string) {
        for (Report report : this.m_Reports) {
            report.dump(string);
        }
    }

    public void parse(byte[] byArray, int n) {
        Item item;
        this.resetParser();
        this.m_Descritor = byArray;
        this.m_DescritorLength = n;
        block6: while (null != (item = this.getNextItem())) {
            switch (item.m_Type) {
                case MAIN: {
                    this.parseMainItem(item);
                    continue block6;
                }
                case LOCAL: {
                    this.parseLocalItem(item);
                    continue block6;
                }
                case GLOBAL: {
                    this.parseGlobalItem(item);
                    continue block6;
                }
                case LONG: {
                    throw new IllegalStateException("unexpected long global item");
                }
            }
            throw new IllegalStateException("unknown global item type (bug)");
        }
        if (this.m_TopCollection.m_Parent != null) {
            throw new IllegalStateException("unbalanced collection at end of report description");
        }
        if (this.m_DelemiterDepth > 0) {
            throw new IllegalStateException("unbalanced delimiter at end of report description");
        }
        this.m_RootCollection.dump("");
    }

    public static void main(String ... stringArray) {
        try {
            int[] nArray = HidParserTestData.WHB04;
            byte[] byArray = new byte[nArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)nArray[i];
            }
            HidParser hidParser = new HidParser();
            hidParser.parse(byArray, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final class Item {
        int m_Size;
        ItemType m_Type;
        MainTag m_MTag;
        GlobalTag m_GTag;
        LocalTag m_LTag;
        int m_UValue;
        int m_SValue;

        public Item(int n, ItemType itemType, int n2, int n3) {
            this.m_Size = n;
            this.m_Type = itemType;
            if (this.m_Type == ItemType.MAIN) {
                if (n2 < 8 || n2 >= MainTag.values().length) {
                    throw new IllegalStateException(String.format("illegal/unsupported main tag %d", n2));
                }
                this.m_MTag = MainTag.values()[n2];
            }
            if (this.m_Type == ItemType.GLOBAL) {
                if (n2 < 0 || n2 >= GlobalTag.values().length) {
                    throw new IllegalStateException(String.format("illegal/unsupported global tag %d", n2));
                }
                this.m_GTag = GlobalTag.values()[n2];
            }
            if (this.m_Type == ItemType.LOCAL) {
                if (n2 < 0 || n2 >= LocalTag.values().length) {
                    throw new IllegalStateException(String.format("illegal/unsupported local tag %d", n2));
                }
                this.m_LTag = LocalTag.values()[n2];
            }
            this.m_UValue = n3;
            this.m_SValue = n3;
            switch (n) {
                case 1: {
                    if ((n3 & 0xFFFFFF80) == 0) break;
                    this.m_SValue |= 0xFFFFFF00;
                    break;
                }
                case 2: {
                    if ((n3 & Short.MIN_VALUE) == 0) break;
                    this.m_SValue |= 0xFFFF0000;
                    break;
                }
            }
        }
    }

    public static final class Global {
        int m_UsagePage;
        int m_LogicalMinimum;
        int m_LogicalMaximum;
        int m_PhysicalMinimum;
        int m_PhysicalMaximum;
        int m_UnitExponent;
        int m_Unit;
        int m_ReportId;
        int m_ReportSize;
        int m_ReportCount;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return 0;
            }
        }
    }

    private static final class Local {
        public int[] m_Usages = new int[12288];
        public int[] m_CollectionIndex = new int[12288];
        public int m_UsageIndex;
        public int m_UsageMinimum;
        public int m_DelimiterDepth;
        public int m_DelimiterBranch;

        private Local() {
        }

        public void reset() {
            int n;
            this.m_UsageIndex = 0;
            this.m_UsageMinimum = 0;
            this.m_DelimiterDepth = 0;
            this.m_DelimiterBranch = 0;
            for (n = 0; n < this.m_Usages.length; ++n) {
                this.m_Usages[n] = 0;
            }
            for (n = 0; n < this.m_CollectionIndex.length; ++n) {
                this.m_CollectionIndex[n] = 0;
            }
        }
    }

    static enum GlobalTag {
        USAGE_PAGE,
        LOGICAL_MINIMUM,
        LOGICAL_MAXIMUM,
        PHYSICAL_MINIMUM,
        PHYSICAL_MAXIMUM,
        UNIT_EXPONENT,
        UNIT,
        REPORT_SIZE,
        REPORT_ID,
        REPORT_COUNT,
        PUSH,
        POP;

    }

    static enum LocalTag {
        USAGE,
        USAGE_MINIMUM,
        USAGE_MAXIMUM,
        DESIGNATOR_INDEX,
        DESIGNATOR_MINIMUM,
        DESIGNATOR_MAXIMUM,
        STRING_INDEX,
        STRING_MINIMUM,
        STRING_MAXIMUM,
        DELIMITER;

    }

    static enum MainTag {
        PADDING_0,
        PADDING_1,
        PADDING_2,
        PADDING_3,
        PADDING_4,
        PADDING_5,
        PADDING_6,
        PADDING_7,
        INPUT,
        OUTPUT,
        COLLECTION,
        FEATURE,
        ENDCOLLECTION;

    }

    static enum ItemType {
        MAIN,
        GLOBAL,
        LOCAL,
        RESERVED,
        LONG;

    }
}

