/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.linux;

import com.sun.jna.Native;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.linux.CLibrary;
import purejavahidapi.linux.HIDRAW;
import purejavahidapi.linux.LinuxBackend;
import purejavahidapi.linux.UdevLibrary;
import purejavahidapi.shared.SyncPoint;

public class HidDevice
extends purejavahidapi.HidDevice {
    private int m_DeviceHandle;
    private int m_NudgePipeReadHandle;
    private int m_NudgePipeWriteHandle;
    private LinuxBackend m_Backend;
    private boolean m_UsesNumberedReports;
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;
    private byte[] m_InputReportBytes;
    private byte[] m_GetFeatureReportBytes;

    HidDevice(HidDeviceInfo hidDeviceInfo, LinuxBackend linuxBackend) throws IOException {
        this.m_Backend = linuxBackend;
        this.m_HidDeviceInfo = hidDeviceInfo;
        UdevLibrary.udev udev2 = UdevLibrary.udev_new();
        UdevLibrary.udev_device udev_device2 = UdevLibrary.udev_device_new_from_syspath(udev2, this.m_HidDeviceInfo.getPath());
        String string = UdevLibrary.udev_device_get_devnode(udev_device2);
        UdevLibrary.udev_unref(udev2);
        this.m_DeviceHandle = CLibrary.open(string, 2);
        if (this.m_DeviceHandle < 0) {
            int n = Native.getLastError();
            if (n == CLibrary.EACCES) {
                throw new AccessDeniedException(string);
            }
            if (n == CLibrary.ENOENT) {
                throw new FileNotFoundException(string);
            }
            throw new IOException("open() failed, errno " + n);
        }
        int[] nArray = new int[2];
        int n = CLibrary.pipe(nArray);
        if (n != 0) {
            throw new IOException("pipe() failed" + Native.getLastError());
        }
        this.m_NudgePipeReadHandle = nArray[0];
        this.m_NudgePipeWriteHandle = nArray[1];
        int[] nArray2 = new int[]{0};
        UdevLibrary.hidraw_report_descriptor hidraw_report_descriptor2 = new UdevLibrary.hidraw_report_descriptor();
        int n2 = CLibrary.ioctl(this.m_DeviceHandle, UdevLibrary.HIDIOCGRDESCSIZE, nArray2);
        if (n2 < 0) {
            throw new IOException("ioctl(...HIDIOCGRDESCSIZE..) failed");
        }
        hidraw_report_descriptor2.size = nArray2[0];
        n2 = CLibrary.ioctl(this.m_DeviceHandle, UdevLibrary.HIDIOCGRDESC, hidraw_report_descriptor2);
        if (n2 < 0) {
            throw new IOException("ioctl(...HIDIOCGRDESC..) failed");
        }
        this.m_UsesNumberedReports = HidDevice.uses_numbered_reports(hidraw_report_descriptor2.value, hidraw_report_descriptor2.size);
        this.m_InputReportBytes = new byte[4097];
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HidDevice.this.runReadOnBackground();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        this.m_Thread.setDaemon(true);
        this.m_Thread.start();
        this.m_SyncStart.waitAndSync();
    }

    private void runReadOnBackground() throws IOException {
        CLibrary.pollfd[] pollfdArray = (CLibrary.pollfd[])new CLibrary.pollfd().toArray(2);
        pollfdArray[0].fd = this.m_NudgePipeReadHandle;
        pollfdArray[0].events = CLibrary.POLLIN;
        pollfdArray[1].fd = this.m_DeviceHandle;
        pollfdArray[1].events = CLibrary.POLLIN;
        this.m_SyncStart.waitAndSync();
        while (!this.m_StopThread) {
            int n = CLibrary.poll(pollfdArray, 2, -1);
            if (n < 0) {
                throw new IOException("pipe() failed" + Native.getLastError());
            }
            if (n <= 0 || (pollfdArray[1].revents & CLibrary.POLLIN) == 0) continue;
            int n2 = CLibrary.read(this.m_DeviceHandle, this.m_InputReportBytes, this.m_InputReportBytes.length);
            if (this.m_InputReportListener == null) continue;
            byte by = 0;
            if (this.m_UsesNumberedReports) {
                by = this.m_InputReportBytes[0];
                System.arraycopy(this.m_InputReportBytes, 1, this.m_InputReportBytes, 0, --n2);
            }
            this.m_InputReportListener.onInputReport(this, by, this.m_InputReportBytes, n2);
        }
        this.m_SyncShutdown.waitAndSync();
    }

    @Override
    public void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_StopThread = true;
        CLibrary.write(this.m_NudgePipeWriteHandle, new byte[1], 1);
        this.m_Thread.interrupt();
        this.m_SyncShutdown.waitAndSync();
        CLibrary.close(this.m_DeviceHandle);
        CLibrary.close(this.m_NudgePipeWriteHandle);
        CLibrary.close(this.m_NudgePipeReadHandle);
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized int setOutputReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        byte[] byArray2 = new byte[n + 1];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, 1, n);
        int n2 = CLibrary.write(this.m_DeviceHandle, byArray2, n + 1);
        if (n2 < 0) {
            return -1;
        }
        return n2 - 1;
    }

    @Override
    public synchronized int setFeatureReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        byte[] byArray2 = new byte[n + 1];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, 1, n);
        int n2 = CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCSFEATURE(n + 1), byArray2);
        if (n2 < 0) {
            return -1;
        }
        return n2 - 1;
    }

    @Override
    public synchronized int setFeatureReport(byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCSFEATURE(n), byArray);
    }

    @Override
    public synchronized void setInputReportListener(InputReportListener inputReportListener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_InputReportListener = inputReportListener;
    }

    @Override
    public synchronized void setDeviceRemovalListener(DeviceRemovalListener deviceRemovalListener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_DeviceRemovalListener = deviceRemovalListener;
    }

    @Override
    public synchronized int getFeatureReport(byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        int n2 = CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCGFEATURE(n), this.m_GetFeatureReportBytes);
        if (n2 < 0) {
            return -1;
        }
        System.arraycopy(this.m_GetFeatureReportBytes, 1, byArray, 0, n2 - 1);
        return n2 - 1;
    }

    @Override
    public synchronized int getFeatureReport(int n, byte[] byArray, int n2) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return CLibrary.ioctl(this.m_DeviceHandle, HIDRAW.HIDIOCGFEATURE(n2), byArray);
    }

    private static boolean uses_numbered_reports(byte[] byArray, int n) {
        int n2;
        int n3;
        for (int i = 0; i < n; i += n3 + n2) {
            int n4 = byArray[i] & 0xFF;
            if (n4 == 133) {
                return true;
            }
            if ((n4 & 0xF0) == 240) {
                n3 = i + 1 < n ? byArray[i + 1] : 0;
                n2 = 3;
                continue;
            }
            int n5 = n4 & 3;
            switch (n5) {
                case 0: 
                case 1: 
                case 2: {
                    n3 = n5;
                    break;
                }
                case 3: {
                    n3 = 4;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            n2 = 1;
        }
        return false;
    }

    @Override
    public DeviceRemovalListener getDeviceRemovalListener() {
        return this.m_DeviceRemovalListener;
    }
}

