/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.linux;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import purejavahidapi.linux.UdevLibrary;

class HidDeviceInfo
extends purejavahidapi.HidDeviceInfo {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HidDeviceInfo(String string) throws IOException {
        this.m_DevicePath = string;
        UdevLibrary.udev_device udev_device2 = null;
        UdevLibrary.udev udev2 = null;
        UdevLibrary.udev_device udev_device3 = null;
        UdevLibrary.udev_device udev_device4 = null;
        try {
            udev2 = UdevLibrary.udev_new();
            udev_device2 = UdevLibrary.udev_device_new_from_syspath(udev2, string);
            String string2 = UdevLibrary.udev_device_get_devnode(udev_device2);
            udev_device3 = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(udev_device2, "hid", null);
            if (udev_device3 == null) {
                throw new IOException("hid_dev == null");
            }
            if (string2 == null) {
                throw new IOException("dev_path == null");
            }
            udev_device4 = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(udev_device2, "usb", "usb_device");
            String string3 = UdevLibrary.udev_device_get_devnode(udev_device4);
            Properties properties = new Properties();
            properties.load(new StringReader(UdevLibrary.udev_device_get_sysattr_value(udev_device3, "uevent")));
            String[] stringArray = ((String)properties.get("HID_ID")).split(":");
            short s = (short)Long.parseLong(stringArray[0], 16);
            this.m_DeviceId = string3;
            this.m_VendorId = (short)Long.parseLong(stringArray[1], 16);
            this.m_ProductId = (short)Long.parseLong(stringArray[2], 16);
            this.m_ProductString = (String)properties.get("HID_NAME");
            this.m_SerialNumberString = (String)properties.get("HID_UNIQ");
            if (s != 3 && s != 5) {
                throw new IOException("bus != BUS_USB && bus != BUS_BLUETOOTH ");
            }
            switch (s) {
                case 3: {
                    if (udev_device4 == null) {
                        throw new IOException("usb_dev == null");
                    }
                    UdevLibrary.udev_device udev_device5 = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(udev_device2, "usb", "usb_interface");
                    if (udev_device5 == null) return;
                    String string4 = UdevLibrary.udev_device_get_sysattr_value(udev_device5, "bInterfaceNumber");
                    return;
                }
                case 5: {
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            if (udev_device2 != null) {
                UdevLibrary.udev_device_unref(udev_device2);
            }
            if (udev2 != null) {
                UdevLibrary.udev_unref(udev2);
            }
        }
    }
}

