/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.linux;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.linux.CLibrary;
import purejavahidapi.linux.UdevLibrary;
import purejavahidapi.shared.Backend;

public class LinuxBackend
extends Backend {
    @Override
    public void init() {
        try {
            UdevLibrary.udev udev2 = UdevLibrary.udev_new();
            if (udev2 == null) {
                throw new Exception("udev_new returned null");
            }
            final UdevLibrary.udev_monitor udev_monitor2 = UdevLibrary.udev_monitor_new_from_netlink(udev2, "udev");
            if (udev_monitor2 == null) {
                throw new Exception("udev_monitor returned null");
            }
            if (UdevLibrary.udev_monitor_filter_add_match_subsystem_devtype(udev_monitor2, "usb", "usb_device") < 0) {
                throw new Exception("udev_monitor_filter_add_match_subsystem_devtype failed");
            }
            if (UdevLibrary.udev_monitor_enable_receiving(udev_monitor2) < 0) {
                throw new Exception("udev_monitor_enable_receiving failed");
            }
            final int n = UdevLibrary.udev_monitor_get_fd(udev_monitor2);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            UdevLibrary.udev_device udev_device2;
                            String string;
                            CLibrary.pollfd[] pollfdArray = (CLibrary.pollfd[])new CLibrary.pollfd().toArray(1);
                            pollfdArray[0].fd = n;
                            pollfdArray[0].events = CLibrary.POLLIN;
                            int n2 = CLibrary.poll(pollfdArray, 1, -1);
                            if (n2 <= 0 || !"remove".equals(string = UdevLibrary.udev_device_get_action(udev_device2 = UdevLibrary.udev_monitor_receive_device(udev_monitor2)))) continue;
                            LinuxBackend.this.deviceRemoved(UdevLibrary.udev_device_get_devnode(udev_device2));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public List<HidDeviceInfo> enumerateDevices() {
        UdevLibrary.udev_list_entry udev_list_entry2;
        LinkedList<HidDeviceInfo> linkedList = new LinkedList<HidDeviceInfo>();
        UdevLibrary.udev udev2 = UdevLibrary.udev_new();
        UdevLibrary.udev_enumerate udev_enumerate2 = UdevLibrary.udev_enumerate_new(udev2);
        UdevLibrary.udev_enumerate_add_match_subsystem(udev_enumerate2, "hidraw");
        UdevLibrary.udev_enumerate_scan_devices(udev_enumerate2);
        UdevLibrary.udev_list_entry udev_list_entry3 = udev_list_entry2 = UdevLibrary.udev_enumerate_get_list_entry(udev_enumerate2);
        while (udev_list_entry3 != null) {
            block4: {
                String string = UdevLibrary.udev_list_entry_get_name(udev_list_entry3);
                UdevLibrary.udev_device udev_device2 = UdevLibrary.udev_device_new_from_syspath(udev2, string);
                UdevLibrary.udev_device udev_device3 = UdevLibrary.udev_device_get_parent_with_subsystem_devtype(udev_device2, "hid", null);
                if (udev_device3 != null) {
                    try {
                        Properties properties = new Properties();
                        properties.load(new StringReader(UdevLibrary.udev_device_get_sysattr_value(udev_device3, "uevent")));
                        String[] stringArray = ((String)properties.get("HID_ID")).split(":");
                        short s = (short)Long.parseLong(stringArray[0], 16);
                        short s2 = (short)Long.parseLong(stringArray[1], 16);
                        short s3 = (short)Long.parseLong(stringArray[2], 16);
                        if (s != 3 && s != 5) break block4;
                        purejavahidapi.linux.HidDeviceInfo hidDeviceInfo = new purejavahidapi.linux.HidDeviceInfo(string);
                        linkedList.add(hidDeviceInfo);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    UdevLibrary.udev_device_unref(udev_device2);
                }
            }
            udev_list_entry3 = UdevLibrary.udev_list_entry_get_next(udev_list_entry3);
        }
        UdevLibrary.udev_enumerate_unref(udev_enumerate2);
        UdevLibrary.udev_unref(udev2);
        return linkedList;
    }

    @Override
    public HidDevice openDevice(HidDeviceInfo hidDeviceInfo) throws IOException {
        return new purejavahidapi.linux.HidDevice(hidDeviceInfo, this);
    }
}

