/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.macosx;

import com.sun.jna.Callback;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import purejavahidapi.DeviceRemovalListener;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.macosx.CoreFoundationLibrary;
import purejavahidapi.macosx.IOHIDManagerLibrary;
import purejavahidapi.macosx.MacOsXBackend;
import purejavahidapi.shared.SyncPoint;

public class HidDevice
extends purejavahidapi.HidDevice {
    private MacOsXBackend m_Backend;
    private static int m_InternalIdGenerator = 0;
    int m_InternalId = m_InternalIdGenerator++;
    private IOHIDManagerLibrary.IOHIDDeviceRef m_IOHIDDeviceRef;
    private boolean m_Disconnected;
    private CoreFoundationLibrary.CFStringRef m_CFRunLoopMode;
    private CoreFoundationLibrary.CFRunLoopRef m_CFRunLoopRef;
    private CoreFoundationLibrary.CFRunLoopSourceRef m_CFRunLoopSourceRef;
    private Pointer m_InputReportBuffer;
    private byte[] m_InputReportData;
    private int m_MaxInputReportLength;
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;
    private HidReportCallback m_HidReportCallBack;
    private HidDeviceRemovalCallback m_HidDeviceRemovalCallback;
    private PerformSignalCallback m_PerformSignalCallback;
    private static Hashtable<Callback, HidDevice> m_DevFromCallback = new Hashtable();

    Pointer asPointerForPassingToCallback() {
        return new Pointer((long)this.m_InternalId);
    }

    HidDevice(purejavahidapi.macosx.HidDeviceInfo hidDeviceInfo, MacOsXBackend macOsXBackend) {
        this.m_Backend = macOsXBackend;
        this.m_HidDeviceInfo = hidDeviceInfo;
        this.m_IOHIDDeviceRef = this.m_Backend.getIOHIDDeviceRef(hidDeviceInfo.getPath());
        this.m_PerformSignalCallback = new PerformSignalCallback();
        m_DevFromCallback.put(this.m_PerformSignalCallback, this);
        this.m_HidReportCallBack = new HidReportCallback();
        m_DevFromCallback.put(this.m_HidReportCallBack, this);
        this.m_HidDeviceRemovalCallback = new HidDeviceRemovalCallback();
        m_DevFromCallback.put(this.m_HidDeviceRemovalCallback, this);
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_MaxInputReportLength = HidDevice.getIntProperty(this.m_IOHIDDeviceRef, CoreFoundationLibrary.CFSTR("MaxInputReportSize"));
        if (this.m_MaxInputReportLength > 0) {
            this.m_InputReportBuffer = new Memory((long)this.m_MaxInputReportLength);
            this.m_InputReportData = new byte[this.m_MaxInputReportLength];
        }
        String string = String.format("HIDAPI_0x%08x", Pointer.nativeValue((Pointer)this.m_IOHIDDeviceRef.getPointer()));
        this.m_CFRunLoopMode = CoreFoundationLibrary.CFStringCreateWithCString(null, string, 1536);
        if (this.m_MaxInputReportLength > 0) {
            IOHIDManagerLibrary.IOHIDDeviceRegisterInputReportCallback(this.m_IOHIDDeviceRef, this.m_InputReportBuffer, this.m_MaxInputReportLength, this.m_HidReportCallBack, this.asPointerForPassingToCallback());
        }
        IOHIDManagerLibrary.IOHIDManagerRegisterDeviceRemovalCallback(MacOsXBackend.m_HidManager, this.m_HidDeviceRemovalCallback, this.asPointerForPassingToCallback());
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                IOHIDManagerLibrary.IOHIDDeviceScheduleWithRunLoop(HidDevice.this.m_IOHIDDeviceRef, CoreFoundationLibrary.CFRunLoopGetCurrent(), HidDevice.this.m_CFRunLoopMode);
                CoreFoundationLibrary.CFRunLoopSourceContext cFRunLoopSourceContext = new CoreFoundationLibrary.CFRunLoopSourceContext();
                cFRunLoopSourceContext.perform = HidDevice.this.m_PerformSignalCallback;
                HidDevice.this.m_CFRunLoopSourceRef = CoreFoundationLibrary.CFRunLoopSourceCreate(CoreFoundationLibrary.kCFAllocatorDefault, 0L, cFRunLoopSourceContext);
                CoreFoundationLibrary.CFRunLoopAddSource(CoreFoundationLibrary.CFRunLoopGetCurrent(), HidDevice.this.m_CFRunLoopSourceRef, HidDevice.this.m_CFRunLoopMode);
                HidDevice.this.m_CFRunLoopRef = CoreFoundationLibrary.CFRunLoopGetCurrent();
                HidDevice.this.m_SyncStart.waitAndSync();
                while (!HidDevice.this.m_StopThread && !HidDevice.this.m_Disconnected) {
                    int n = CoreFoundationLibrary.CFRunLoopRunInMode(HidDevice.this.m_CFRunLoopMode, 1.0, false);
                    if (n == 1) {
                        HidDevice.this.m_Disconnected = true;
                        break;
                    }
                    if (n == 3 || n == 4) continue;
                    HidDevice.this.m_StopThread = true;
                    break;
                }
                if (!HidDevice.this.m_Disconnected) {
                    HidDevice.this.m_SyncShutdown.waitAndSync();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        this.m_Thread.start();
        this.m_SyncStart.waitAndSync();
    }

    @Override
    public synchronized void setInputReportListener(InputReportListener inputReportListener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_InputReportListener = inputReportListener;
    }

    @Override
    public synchronized void setDeviceRemovalListener(DeviceRemovalListener deviceRemovalListener) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_DeviceRemovalListener = deviceRemovalListener;
    }

    static void processPendingEvents() {
        int n;
        while ((n = CoreFoundationLibrary.CFRunLoopRunInMode(CoreFoundationLibrary.kCFRunLoopDefaultMode, 0.001, false)) != 1 && n != 3) {
        }
    }

    static int getIntProperty(IOHIDManagerLibrary.IOHIDDeviceRef iOHIDDeviceRef, CoreFoundationLibrary.CFStringRef cFStringRef) {
        int[] nArray = new int[]{0};
        CoreFoundationLibrary.CFTypeRef cFTypeRef = IOHIDManagerLibrary.IOHIDDeviceGetProperty(iOHIDDeviceRef, cFStringRef);
        if (cFTypeRef != null && CoreFoundationLibrary.CFGetTypeID(cFTypeRef.getPointer()) == CoreFoundationLibrary.CFNumberGetTypeID()) {
            CoreFoundationLibrary.CFNumberGetValue(new CoreFoundationLibrary.CFNumber(cFTypeRef.getPointer()), 3, nArray);
            return nArray[0];
        }
        return 0;
    }

    static int getIntProperty(IOHIDManagerLibrary.IOHIDElementRef iOHIDElementRef, CoreFoundationLibrary.CFStringRef cFStringRef) {
        int[] nArray = new int[]{0};
        CoreFoundationLibrary.CFTypeRef cFTypeRef = IOHIDManagerLibrary.IOHIDElementGetProperty(iOHIDElementRef, cFStringRef);
        if (cFTypeRef != null && CoreFoundationLibrary.CFGetTypeID(cFTypeRef.getPointer()) == CoreFoundationLibrary.CFNumberGetTypeID()) {
            CoreFoundationLibrary.CFNumberGetValue(new CoreFoundationLibrary.CFNumber(cFTypeRef.getPointer()), 3, nArray);
            return nArray[0];
        }
        return 0;
    }

    static String getStringProperty(IOHIDManagerLibrary.IOHIDDeviceRef iOHIDDeviceRef, CoreFoundationLibrary.CFStringRef cFStringRef) {
        try {
            CoreFoundationLibrary.CFTypeRef cFTypeRef = IOHIDManagerLibrary.IOHIDDeviceGetProperty(iOHIDDeviceRef, cFStringRef);
            CoreFoundationLibrary.CFStringRef cFStringRef2 = null;
            if (cFTypeRef != null) {
                cFStringRef2 = new CoreFoundationLibrary.CFStringRef(cFTypeRef.getPointer());
            }
            if (cFStringRef2 != null) {
                long l = CoreFoundationLibrary.CFStringGetLength(cFStringRef2);
                CoreFoundationLibrary.CFRange cFRange = new CoreFoundationLibrary.CFRange(0L, l);
                long[] lArray = new long[]{0L};
                CoreFoundationLibrary.CFStringGetBytes(cFStringRef2, cFRange, 0x8000100, (byte)63, false, null, 0L, lArray);
                byte[] byArray = new byte[(int)lArray[0]];
                CoreFoundationLibrary.CFStringGetBytes(cFStringRef2, cFRange, 0x8000100, (byte)63, false, byArray, byArray.length, lArray);
                return new String(byArray, "utf-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return null;
    }

    static String createPathForDevide(IOHIDManagerLibrary.IOHIDDeviceRef iOHIDDeviceRef) {
        String string = HidDevice.getStringProperty(iOHIDDeviceRef, CoreFoundationLibrary.CFSTR("Transport"));
        if (string == null) {
            return null;
        }
        short s = (short)HidDevice.getIntProperty(iOHIDDeviceRef, CoreFoundationLibrary.CFSTR("VendorID"));
        short s2 = (short)HidDevice.getIntProperty(iOHIDDeviceRef, CoreFoundationLibrary.CFSTR("ProductID"));
        return String.format("%s_%04x_%04x_0x%08x", string, s, s2, Pointer.nativeValue((Pointer)iOHIDDeviceRef.getPointer()));
    }

    @Override
    public synchronized int getFeatureReport(byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        int[] nArray = new int[]{n};
        int n2 = IOHIDManagerLibrary.IOHIDDeviceGetReport(this.m_IOHIDDeviceRef, 2, 0xFF & byArray[0], ByteBuffer.wrap(byArray), nArray);
        if (n2 == 0) {
            return nArray[0];
        }
        return -1;
    }

    @Override
    public synchronized int getFeatureReport(int n, byte[] byArray, int n2) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        int[] nArray = new int[]{n2};
        byte[] byArray2 = new byte[n2 + 1];
        int n3 = IOHIDManagerLibrary.IOHIDDeviceGetReport(this.m_IOHIDDeviceRef, 2, n, ByteBuffer.wrap(byArray2), nArray);
        int n4 = nArray[0];
        if (n3 == 0) {
            if (n == 0) {
                System.arraycopy(byArray2, 0, byArray, 0, n4);
                return n4;
            }
            System.arraycopy(byArray2, 1, byArray, 0, n4 - 1);
            return n4 - 1;
        }
        return -1;
    }

    private int setReport(int n, byte by, byte[] byArray, int n2) {
        int n3;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n4 = IOHIDManagerLibrary.IOHIDDeviceSetReport(this.m_IOHIDDeviceRef, n, 0xFF & by, byteBuffer, n3 = n2);
        if (n4 == 0) {
            return n2;
        }
        return -1;
    }

    @Override
    public synchronized int setOutputReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        int n2 = by != 0 ? 1 : 0;
        byte[] byArray2 = new byte[n + n2];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, n2, n);
        return this.setReport(1, by, byArray2, n + n2);
    }

    @Override
    public synchronized int setFeatureReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        int n2 = by != 0 ? 1 : 0;
        byte[] byArray2 = new byte[n + n2];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, n2, n);
        return this.setReport(2, by, byArray2, n + n2);
    }

    @Override
    public synchronized int setFeatureReport(byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        return this.setReport(2, (byte)0, byArray, n);
    }

    @Override
    public synchronized void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        IOHIDManagerLibrary.IOHIDDeviceRegisterInputReportCallback(this.m_IOHIDDeviceRef, this.m_InputReportBuffer, this.m_MaxInputReportLength, null, null);
        IOHIDManagerLibrary.IOHIDManagerRegisterDeviceRemovalCallback(MacOsXBackend.m_HidManager, null, null);
        IOHIDManagerLibrary.IOHIDDeviceUnscheduleFromRunLoop(this.m_IOHIDDeviceRef, this.m_CFRunLoopRef, this.m_CFRunLoopMode);
        IOHIDManagerLibrary.IOHIDDeviceScheduleWithRunLoop(this.m_IOHIDDeviceRef, CoreFoundationLibrary.CFRunLoopGetMain(), CoreFoundationLibrary.kCFRunLoopDefaultMode);
        this.m_StopThread = true;
        CoreFoundationLibrary.CFRunLoopSourceSignal(this.m_CFRunLoopSourceRef);
        CoreFoundationLibrary.CFRunLoopWakeUp(this.m_CFRunLoopRef);
        if (Thread.currentThread() != this.m_Thread) {
            this.m_Thread.interrupt();
            this.m_SyncShutdown.waitAndSync();
            try {
                this.m_Thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        IOHIDManagerLibrary.IOHIDDeviceClose(this.m_IOHIDDeviceRef, 1);
        if (this.m_CFRunLoopMode != null) {
            CoreFoundationLibrary.CFRelease(this.m_CFRunLoopMode);
        }
        if (this.m_CFRunLoopSourceRef != null) {
            CoreFoundationLibrary.CFRelease(this.m_CFRunLoopSourceRef);
        }
        CoreFoundationLibrary.CFRelease(this.m_IOHIDDeviceRef);
        m_DevFromCallback.remove(this.m_PerformSignalCallback);
        m_DevFromCallback.remove(this.m_HidReportCallBack);
        m_DevFromCallback.remove(this.m_HidDeviceRemovalCallback);
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized HidDeviceInfo getHidDeviceInfo() {
        return this.m_HidDeviceInfo;
    }

    private static class PerformSignalCallback
    implements CoreFoundationLibrary.CFRunLoopPerformCallBack {
        private PerformSignalCallback() {
        }

        @Override
        public void callback(Pointer pointer) {
            CoreFoundationLibrary.CFRunLoopStop(CoreFoundationLibrary.CFRunLoopGetCurrent());
        }
    }

    static class HidReportCallback
    implements IOHIDManagerLibrary.IOHIDReportCallback {
        HidReportCallback() {
        }

        @Override
        public void callback(Pointer pointer, int n, Pointer pointer2, int n2, int n3, Pointer pointer3, NativeLong nativeLong) {
            HidDevice hidDevice = m_DevFromCallback.get(this);
            if (hidDevice != null) {
                if (hidDevice.m_InputReportListener != null) {
                    int n4 = nativeLong.intValue();
                    if (n3 == 0) {
                        n4 = nativeLong.intValue();
                        pointer3.read(0L, hidDevice.m_InputReportData, 0, n4);
                    } else {
                        n4 = nativeLong.intValue() - 1;
                        pointer3.read(1L, hidDevice.m_InputReportData, 0, n4);
                    }
                    hidDevice.m_InputReportListener.onInputReport(hidDevice, (byte)n3, hidDevice.m_InputReportData, n4);
                }
            } else {
                System.err.println("HidReportCallback could not get the HidDevice object");
            }
        }
    }

    static class HidDeviceRemovalCallback
    implements IOHIDManagerLibrary.IOHIDDeviceCallback {
        HidDeviceRemovalCallback() {
        }

        @Override
        public void hid_device_removal_callback(Pointer pointer, int n, Pointer pointer2, IOHIDManagerLibrary.IOHIDDeviceRef iOHIDDeviceRef) {
            HidDevice hidDevice = m_DevFromCallback.get(this);
            if (hidDevice != null) {
                hidDevice.m_Disconnected = true;
                hidDevice.close();
                if (hidDevice.m_DeviceRemovalListener != null) {
                    hidDevice.m_DeviceRemovalListener.onDeviceRemoval(hidDevice);
                }
            } else {
                System.err.println("HidDeviceRemovalCallback could not get the HidDevice object");
            }
        }
    }
}

