/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.macosx;

import com.sun.jna.Pointer;
import java.util.LinkedList;
import java.util.List;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.macosx.CoreFoundationLibrary;
import purejavahidapi.macosx.HidDevice;
import purejavahidapi.macosx.IOHIDManagerLibrary;
import purejavahidapi.shared.Backend;

public class MacOsXBackend
extends Backend {
    static IOHIDManagerLibrary.IOHIDManagerRef m_HidManager;

    @Override
    public List<HidDeviceInfo> enumerateDevices() {
        LinkedList<HidDeviceInfo> linkedList = new LinkedList<HidDeviceInfo>();
        HidDevice.processPendingEvents();
        IOHIDManagerLibrary.IOHIDManagerSetDeviceMatching(m_HidManager, null);
        CoreFoundationLibrary.CFSetRef cFSetRef = IOHIDManagerLibrary.IOHIDManagerCopyDevices(m_HidManager);
        int n = (int)CoreFoundationLibrary.CFSetGetCount(cFSetRef);
        Pointer[] pointerArray = new Pointer[n];
        CoreFoundationLibrary.CFSetGetValues(cFSetRef, pointerArray);
        for (int i = 0; i < n; ++i) {
            IOHIDManagerLibrary.IOHIDDeviceRef iOHIDDeviceRef = new IOHIDManagerLibrary.IOHIDDeviceRef(pointerArray[i]);
            purejavahidapi.macosx.HidDeviceInfo hidDeviceInfo = new purejavahidapi.macosx.HidDeviceInfo(iOHIDDeviceRef);
            linkedList.add(hidDeviceInfo);
        }
        CoreFoundationLibrary.CFRelease(cFSetRef);
        return linkedList;
    }

    @Override
    public purejavahidapi.HidDevice openDevice(HidDeviceInfo hidDeviceInfo) {
        return new HidDevice((purejavahidapi.macosx.HidDeviceInfo)hidDeviceInfo, this);
    }

    IOHIDManagerLibrary.IOHIDDeviceRef getIOHIDDeviceRef(String string) {
        HidDevice.processPendingEvents();
        CoreFoundationLibrary.CFSetRef cFSetRef = IOHIDManagerLibrary.IOHIDManagerCopyDevices(m_HidManager);
        int n = (int)CoreFoundationLibrary.CFSetGetCount(cFSetRef);
        Pointer[] pointerArray = new Pointer[n];
        CoreFoundationLibrary.CFSetGetValues(cFSetRef, pointerArray);
        for (int i = 0; i < n; ++i) {
            IOHIDManagerLibrary.IOHIDDeviceRef iOHIDDeviceRef = new IOHIDManagerLibrary.IOHIDDeviceRef(pointerArray[i]);
            String string2 = HidDevice.createPathForDevide(iOHIDDeviceRef);
            if (!string.equals(string2)) continue;
            int n2 = IOHIDManagerLibrary.IOHIDDeviceOpen(iOHIDDeviceRef, 0);
            if (n2 == 0) {
                CoreFoundationLibrary.CFRetain(iOHIDDeviceRef);
                CoreFoundationLibrary.CFRelease(cFSetRef);
                return iOHIDDeviceRef;
            }
            System.out.printf("IOHIDDeviceOpen: %d,%d,%d\n", n2 >> 26 & 0x3F, n2 >> 14 & 0xFFF, n2 & 0x3FFF);
        }
        CoreFoundationLibrary.CFRelease(cFSetRef);
        return null;
    }

    @Override
    public void cleanup() {
        if (m_HidManager != null) {
            IOHIDManagerLibrary.IOHIDManagerClose(m_HidManager, 0);
            CoreFoundationLibrary.CFRelease(m_HidManager);
            m_HidManager = null;
        }
    }

    @Override
    public void init() {
        if (m_HidManager == null) {
            m_HidManager = IOHIDManagerLibrary.IOHIDManagerCreate(CoreFoundationLibrary.kCFAllocatorDefault, 0);
            if (m_HidManager == null) {
                throw new RuntimeException("IOHIDManagerCreate call failed");
            }
            IOHIDManagerLibrary.IOHIDManagerSetDeviceMatching(m_HidManager, null);
            IOHIDManagerLibrary.IOHIDManagerScheduleWithRunLoop(m_HidManager, CoreFoundationLibrary.CFRunLoopGetCurrent(), CoreFoundationLibrary.kCFRunLoopDefaultMode);
        }
    }
}

