/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Structure;
import com.sun.jna.platform.win32.DBT;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.platform.win32.Wtsapi32;
import purejavahidapi.shared.SyncPoint;
import purejavahidapi.windows.SetupApiLibrary;
import purejavahidapi.windows.WindowsBackend;

public class DeviceRemovalHandler
implements WinUser.WindowProc {
    private WindowsBackend m_WindowsBackend;
    private SyncPoint m_StartupSync;

    public DeviceRemovalHandler(WindowsBackend windowsBackend) {
        this.m_WindowsBackend = windowsBackend;
        this.m_StartupSync = new SyncPoint(2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WinDef.HWND hWND;
                String string = new String("WindowClass");
                WinDef.HMODULE hMODULE = Kernel32.INSTANCE.GetModuleHandle(null);
                if (hMODULE == null) {
                    WindowsBackend.reportLastError();
                }
                WinUser.WNDCLASSEX wNDCLASSEX = new WinUser.WNDCLASSEX();
                wNDCLASSEX.hInstance = hMODULE;
                wNDCLASSEX.lpfnWndProc = DeviceRemovalHandler.this;
                wNDCLASSEX.lpszClassName = string;
                WinDef.ATOM aTOM = User32.INSTANCE.RegisterClassEx(wNDCLASSEX);
                if (aTOM == null) {
                    WindowsBackend.reportLastError();
                }
                if ((hWND = User32.INSTANCE.CreateWindowEx(8, "WindowClass", "", 0, 0, 0, 0, 0, null, null, (WinDef.HINSTANCE)hMODULE, null)) == null) {
                    WindowsBackend.reportLastError();
                }
                if (!Wtsapi32.INSTANCE.WTSRegisterSessionNotification(hWND, 0)) {
                    WindowsBackend.reportLastError();
                }
                DBT.DEV_BROADCAST_DEVICEINTERFACE dEV_BROADCAST_DEVICEINTERFACE = new DBT.DEV_BROADCAST_DEVICEINTERFACE();
                dEV_BROADCAST_DEVICEINTERFACE.dbcc_size = dEV_BROADCAST_DEVICEINTERFACE.size();
                dEV_BROADCAST_DEVICEINTERFACE.dbcc_devicetype = 5;
                dEV_BROADCAST_DEVICEINTERFACE.dbcc_classguid = DBT.GUID_DEVINTERFACE_USB_DEVICE;
                WinUser.HDEVNOTIFY hDEVNOTIFY = User32.INSTANCE.RegisterDeviceNotification((WinNT.HANDLE)hWND, (Structure)dEV_BROADCAST_DEVICEINTERFACE, 0);
                if (hDEVNOTIFY == null) {
                    WindowsBackend.reportLastError();
                }
                DeviceRemovalHandler.this.m_StartupSync.waitAndSync();
                WinUser.MSG mSG = new WinUser.MSG();
                while (User32.INSTANCE.GetMessage(mSG, hWND, 0, 0) != 0) {
                    User32.INSTANCE.TranslateMessage(mSG);
                    User32.INSTANCE.DispatchMessage(mSG);
                }
                if (!User32.INSTANCE.UnregisterDeviceNotification(hDEVNOTIFY)) {
                    WindowsBackend.reportLastError();
                }
                if (!Wtsapi32.INSTANCE.WTSUnRegisterSessionNotification(hWND)) {
                    WindowsBackend.reportLastError();
                }
                if (!User32.INSTANCE.UnregisterClass(aTOM.toString(), (WinDef.HINSTANCE)hMODULE)) {
                    WindowsBackend.reportLastError();
                }
                if (!User32.INSTANCE.DestroyWindow(hWND)) {
                    WindowsBackend.reportLastError();
                }
            }
        };
        Thread thread = new Thread(runnable, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
        this.m_StartupSync.waitAndSync();
    }

    public WinDef.LRESULT callback(WinDef.HWND hWND, int n, WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
        switch (n) {
            case 2: {
                User32.INSTANCE.PostQuitMessage(0);
                return new WinDef.LRESULT(0L);
            }
            case 537: {
                WinDef.LRESULT lRESULT = this.onDeviceChange(wPARAM, lPARAM);
                return lRESULT != null ? lRESULT : User32.INSTANCE.DefWindowProc(hWND, n, wPARAM, lPARAM);
            }
        }
        return User32.INSTANCE.DefWindowProc(hWND, n, wPARAM, lPARAM);
    }

    protected WinDef.LRESULT onDeviceChange(WinDef.WPARAM wPARAM, WinDef.LPARAM lPARAM) {
        switch (wPARAM.intValue()) {
            case 32772: {
                return this.onDeviceChangeRemoveComplete(lPARAM);
            }
        }
        return null;
    }

    private void handleDeviceRemoval(String string) {
        SetupApiLibrary.HDEVINFO hDEVINFO = SetupApiLibrary.SetupDiCreateDeviceInfoList(null, null);
        if (hDEVINFO != WinBase.INVALID_HANDLE_VALUE) {
            SetupApiLibrary.SP_DEVICE_INTERFACE_DATA sP_DEVICE_INTERFACE_DATA = new SetupApiLibrary.SP_DEVICE_INTERFACE_DATA();
            sP_DEVICE_INTERFACE_DATA.cbSize = sP_DEVICE_INTERFACE_DATA.size();
            if (SetupApiLibrary.SetupDiOpenDeviceInterface(hDEVINFO, string, 0, sP_DEVICE_INTERFACE_DATA)) {
                SetupApiLibrary.SP_DEVINFO_DATA sP_DEVINFO_DATA = new SetupApiLibrary.SP_DEVINFO_DATA();
                sP_DEVINFO_DATA.cbSize = sP_DEVINFO_DATA.size();
                if (SetupApiLibrary.SetupDiEnumDeviceInfo(hDEVINFO, 0, sP_DEVINFO_DATA)) {
                    char[] cArray = new char[255];
                    int[] nArray = new int[]{0};
                    if (SetupApiLibrary.SetupDiGetDeviceInstanceId(hDEVINFO, sP_DEVINFO_DATA, cArray, cArray.length, nArray)) {
                        String string2 = new String(cArray, 0, nArray[0] - 1);
                        this.m_WindowsBackend.deviceRemoved(string2);
                    }
                }
                if (!SetupApiLibrary.SetupDiDeleteDeviceInterfaceData(hDEVINFO, sP_DEVICE_INTERFACE_DATA)) {
                    WindowsBackend.reportLastError();
                }
            }
        }
        if (!SetupApiLibrary.SetupDiDestroyDeviceInfoList(hDEVINFO)) {
            WindowsBackend.reportLastError();
        }
    }

    protected WinDef.LRESULT onDeviceChangeArrivalOrRemoveComplete(WinDef.LPARAM lPARAM, String string) {
        DBT.DEV_BROADCAST_HDR dEV_BROADCAST_HDR = new DBT.DEV_BROADCAST_HDR(lPARAM.longValue());
        switch (dEV_BROADCAST_HDR.dbch_devicetype) {
            case 5: {
                DBT.DEV_BROADCAST_DEVICEINTERFACE dEV_BROADCAST_DEVICEINTERFACE = new DBT.DEV_BROADCAST_DEVICEINTERFACE(dEV_BROADCAST_HDR.getPointer());
                this.handleDeviceRemoval(dEV_BROADCAST_DEVICEINTERFACE.getDbcc_name());
                break;
            }
            default: {
                return null;
            }
        }
        return new WinDef.LRESULT(1L);
    }

    protected WinDef.LRESULT onDeviceChangeRemoveComplete(WinDef.LPARAM lPARAM) {
        return this.onDeviceChangeArrivalOrRemoveComplete(lPARAM, "Remove Complete");
    }
}

