/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.shared.SyncPoint;
import purejavahidapi.windows.HidLibrary;
import purejavahidapi.windows.Kernel32Library;
import purejavahidapi.windows.WindowsBackend;

public class HidDevice
extends purejavahidapi.HidDevice {
    private int INPUT = 0;
    private int OUTPUT = 1;
    private int FEATURE = 2;
    private static final WinNT.HANDLE INVALID_HANDLE_VALUE = null;
    private WindowsBackend m_Backend;
    private WinNT.HANDLE[] m_Handles = new WinNT.HANDLE[3];
    private int[] m_ReportLength = new int[3];
    private Memory[] m_Buffer = new Memory[3];
    private WinBase.OVERLAPPED[] m_Overlapped = new WinBase.OVERLAPPED[3];
    private int[][] m_Transfrd = new int[3][1];
    private byte[] m_InputReportBytes;
    private Thread m_Thread;
    private SyncPoint m_SyncStart;
    private SyncPoint m_SyncShutdown;
    private boolean m_StopThread;

    HidDevice(HidDeviceInfo hidDeviceInfo, WindowsBackend windowsBackend) {
        int n;
        String[] stringArray = hidDeviceInfo.getPath().split(":");
        for (n = 0; n < stringArray.length; ++n) {
            WinNT.HANDLE hANDLE = WindowsBackend.openDeviceHandle(stringArray[n], false);
            if (hANDLE == INVALID_HANDLE_VALUE) {
                return;
            }
            this.m_Backend = windowsBackend;
            HidLibrary.HIDD_ATTRIBUTES hIDD_ATTRIBUTES = new HidLibrary.HIDD_ATTRIBUTES();
            hIDD_ATTRIBUTES.Size = new NativeLong((long)hIDD_ATTRIBUTES.size());
            HidLibrary.HidD_GetAttributes(hANDLE, hIDD_ATTRIBUTES);
            this.m_HidDeviceInfo = (purejavahidapi.windows.HidDeviceInfo)hidDeviceInfo;
            HidLibrary.HIDP_PREPARSED_DATA[] hIDP_PREPARSED_DATAArray = new HidLibrary.HIDP_PREPARSED_DATA[1];
            boolean bl = HidLibrary.HidD_GetPreparsedData(hANDLE, hIDP_PREPARSED_DATAArray);
            if (!bl) {
                Kernel32Library.CloseHandle(hANDLE);
                return;
            }
            HidLibrary.HIDP_CAPS hIDP_CAPS = new HidLibrary.HIDP_CAPS();
            int n2 = HidLibrary.HidP_GetCaps(hIDP_PREPARSED_DATAArray[0], hIDP_CAPS);
            if (n2 != 0x110000) {
                Kernel32Library.CloseHandle(hANDLE);
                return;
            }
            if (hIDP_CAPS.InputReportByteLength > 0) {
                this.m_ReportLength[this.INPUT] = hIDP_CAPS.InputReportByteLength;
                this.m_Buffer[this.INPUT] = new Memory((long)(this.m_ReportLength[this.INPUT] + 1));
                this.m_InputReportBytes = new byte[this.m_ReportLength[this.INPUT] + 1];
                this.m_Handles[this.INPUT] = hANDLE;
            }
            if (hIDP_CAPS.OutputReportByteLength > 0) {
                this.m_ReportLength[this.OUTPUT] = hIDP_CAPS.OutputReportByteLength;
                this.m_Buffer[this.OUTPUT] = new Memory((long)(this.m_ReportLength[this.OUTPUT] + 1));
                this.m_Handles[this.OUTPUT] = hANDLE;
            }
            if (hIDP_CAPS.FeatureReportByteLength > 0) {
                this.m_ReportLength[this.FEATURE] = hIDP_CAPS.FeatureReportByteLength;
                this.m_Buffer[this.FEATURE] = new Memory((long)(this.m_ReportLength[this.FEATURE] + 1));
                this.m_Handles[this.FEATURE] = hANDLE;
            }
            HidLibrary.HidD_FreePreparsedData(hIDP_PREPARSED_DATAArray[0]);
        }
        for (n = 0; n < 3; ++n) {
            this.m_Overlapped[n] = new WinBase.OVERLAPPED();
            this.m_Overlapped[n].setAutoRead(false);
            this.m_Overlapped[n].setAutoWrite(false);
            this.m_Overlapped[n].hEvent = Kernel32Library.CreateEvent(null, false, false, null);
            this.m_Overlapped[n].writeField("hEvent");
        }
        this.m_SyncStart = new SyncPoint(2);
        this.m_SyncShutdown = new SyncPoint(2);
        this.m_Thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HidDevice.this.runReadOnBackground();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }, this.m_HidDeviceInfo.getPath());
        this.m_Backend.addDevice(this.m_HidDeviceInfo.getDeviceId(), this);
        this.m_Open = true;
        if (this.m_ReportLength[this.INPUT] > 0) {
            this.m_Thread.start();
            this.m_SyncStart.waitAndSync();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_StopThread = true;
        if (this.m_ReportLength[this.INPUT] > 0) {
            Kernel32Library.CancelIoEx(this.m_Handles[this.INPUT], null);
            this.m_Thread.interrupt();
            this.m_SyncShutdown.waitAndSync();
        }
        for (int i = 0; i < 3; ++i) {
            Kernel32Library.CloseHandle(this.m_Handles[i]);
        }
        this.m_Backend.removeDevice(this.m_HidDeviceInfo.getDeviceId());
        this.m_Open = false;
    }

    @Override
    public synchronized int setOutputReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (this.m_ReportLength[this.OUTPUT] <= 0) {
            throw new IllegalArgumentException("this device supportst no output reports");
        }
        this.m_Buffer[this.OUTPUT].write(0L, new byte[]{by}, 0, 1);
        this.m_Buffer[this.OUTPUT].write(1L, byArray, 0, n);
        if (!Kernel32Library.WriteFile(this.m_Handles[this.OUTPUT], (Pointer)this.m_Buffer[this.OUTPUT], this.m_ReportLength[this.OUTPUT], this.m_Transfrd[this.OUTPUT], this.m_Overlapped[this.OUTPUT])) {
            if (Kernel32Library.GetLastError() != 997) {
                System.out.println("write WriteFile failed " + Kernel32Library.GetLastError());
                return -1;
            }
            if (!Kernel32Library.GetOverlappedResult(this.m_Handles[this.OUTPUT], this.m_Overlapped[this.OUTPUT], this.m_Transfrd[this.OUTPUT], true)) {
                System.out.println("write GetOverlappedResult failed " + Kernel32Library.GetLastError());
                return 0;
            }
        }
        return this.m_Transfrd[this.OUTPUT][0] - 1;
    }

    @Override
    @Deprecated
    public synchronized int setFeatureReport(byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (!HidLibrary.HidD_SetFeature(this.m_Handles[this.FEATURE], byArray, n)) {
            return -1;
        }
        return n;
    }

    @Override
    @Deprecated
    public synchronized int getFeatureReport(byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        if (!Kernel32Library.DeviceIoControl(this.m_Handles[this.FEATURE], 721298, (Pointer)this.m_Buffer[this.FEATURE], this.m_ReportLength[this.FEATURE], (Pointer)this.m_Buffer[this.FEATURE], this.m_ReportLength[this.FEATURE], this.m_Transfrd[this.FEATURE], this.m_Overlapped[this.FEATURE]) && Kernel32Library.GetLastError() != 997) {
            return -1;
        }
        if (!Kernel32Library.GetOverlappedResult(this.m_Handles[this.FEATURE], this.m_Overlapped[this.FEATURE], this.m_Transfrd[this.FEATURE], true)) {
            return -1;
        }
        this.m_Buffer[this.FEATURE].read(1L, byArray, 0, this.m_Transfrd[this.FEATURE][0]);
        return this.m_Transfrd[this.FEATURE][0];
    }

    @Override
    public synchronized int getFeatureReport(int n, byte[] byArray, int n2) {
        return this.getFeatureReport((byte)n, byArray, n2);
    }

    public synchronized int getFeatureReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_Buffer[this.FEATURE].write(0L, new byte[]{by}, 0, 1);
        if (!Kernel32Library.DeviceIoControl(this.m_Handles[this.FEATURE], 721298, (Pointer)this.m_Buffer[this.FEATURE], this.m_ReportLength[this.FEATURE], (Pointer)this.m_Buffer[this.FEATURE], this.m_ReportLength[this.FEATURE], this.m_Transfrd[this.FEATURE], this.m_Overlapped[this.FEATURE]) && Kernel32Library.GetLastError() != 997) {
            return -1;
        }
        if (!Kernel32Library.GetOverlappedResult(this.m_Handles[this.FEATURE], this.m_Overlapped[this.FEATURE], this.m_Transfrd[this.FEATURE], true)) {
            return -1;
        }
        this.m_Buffer[this.FEATURE].read(1L, byArray, 0, this.m_Transfrd[this.FEATURE][0]);
        return this.m_Transfrd[this.FEATURE][0];
    }

    private void runReadOnBackground() {
        this.m_SyncStart.waitAndSync();
        while (!this.m_StopThread) {
            this.m_Transfrd[this.INPUT][0] = 0;
            if (!Kernel32Library.ReadFile(this.m_Handles[this.INPUT], (Pointer)this.m_Buffer[this.INPUT], this.m_ReportLength[this.INPUT], this.m_Transfrd[this.INPUT], this.m_Overlapped[this.INPUT])) {
                if (Kernel32Library.GetLastError() == 1167) break;
                if (Kernel32Library.GetLastError() != 997) {
                    System.out.println("ReadFile failed with GetLastError()==" + Kernel32Library.GetLastError());
                    Kernel32Library.CancelIo(this.m_Handles[this.INPUT]);
                    break;
                }
                if (!Kernel32Library.GetOverlappedResult(this.m_Handles[this.INPUT], this.m_Overlapped[this.INPUT], this.m_Transfrd[this.INPUT], true)) {
                    if (Kernel32Library.GetLastError() == 1167) break;
                    System.out.println("GetOverlappedResult failed with GetLastError()==" + Kernel32Library.GetLastError());
                }
            }
            if (this.m_Transfrd[this.INPUT][0] <= 0) continue;
            byte by = this.m_Buffer[this.INPUT].getByte(0L);
            int[] nArray = this.m_Transfrd[this.INPUT];
            nArray[0] = nArray[0] - 1;
            this.m_Buffer[this.INPUT].read(1L, this.m_InputReportBytes, 0, this.m_Transfrd[this.INPUT][0]);
            if (this.m_InputReportListener == null) continue;
            this.m_InputReportListener.onInputReport(this, by, this.m_InputReportBytes, this.m_Transfrd[this.INPUT][0]);
        }
        this.m_SyncShutdown.waitAndSync();
    }

    @Override
    public int setFeatureReport(byte by, byte[] byArray, int n) {
        if (!this.m_Open) {
            throw new IllegalStateException("device not open");
        }
        this.m_Buffer[this.FEATURE].write(0L, new byte[]{by}, 0, 1);
        this.m_Buffer[this.FEATURE].write(1L, byArray, 0, n);
        if (!Kernel32Library.DeviceIoControl(this.m_Handles[this.FEATURE], 721297, (Pointer)this.m_Buffer[this.FEATURE], this.m_ReportLength[this.FEATURE], (Pointer)this.m_Buffer[this.FEATURE], this.m_ReportLength[this.FEATURE], this.m_Transfrd[this.FEATURE], this.m_Overlapped[this.FEATURE])) {
            System.out.println(Kernel32Library.GetLastError());
            if (Kernel32Library.GetLastError() != 997) {
                return -1;
            }
        }
        if (!Kernel32Library.GetOverlappedResult(this.m_Handles[this.FEATURE], this.m_Overlapped[this.FEATURE], this.m_Transfrd[this.FEATURE], true)) {
            return -1;
        }
        return this.m_Transfrd[this.FEATURE][0];
    }
}

