/*
 * Decompiled with CFR 0.152.
 */
package purejavahidapi.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.shared.Backend;
import purejavahidapi.windows.DeviceRemovalHandler;
import purejavahidapi.windows.HidLibrary;
import purejavahidapi.windows.SetupApiLibrary;

public class WindowsBackend
extends Backend {
    @Override
    public void init() {
        new DeviceRemovalHandler(this);
    }

    @Override
    public void cleanup() {
    }

    public static void reportLastError() {
        int n = Native.getLastError();
        if (n != 0) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            String string = String.format("GetLastError() == %d at %s:%d\n", n, stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
            throw new RuntimeException(string);
        }
    }

    private boolean isSamePhysicalDevice(String string, String string2) {
        String[] stringArray = string.split("\\\\");
        String[] stringArray2 = string2.split("\\\\");
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length < 3 || stringArray2.length < 3) {
            return false;
        }
        if (!stringArray[0].equals(stringArray2[0])) {
            return false;
        }
        String[] stringArray3 = stringArray[1].split("&");
        String[] stringArray4 = stringArray2[1].split("&");
        if (stringArray3 == null || stringArray4 == null) {
            return false;
        }
        if (stringArray3.length < 3 || stringArray4.length < 3) {
            return false;
        }
        if (!stringArray3[0].equals(stringArray4[0])) {
            return false;
        }
        if (!stringArray3[1].equals(stringArray4[1])) {
            return false;
        }
        String[] stringArray5 = stringArray[2].split("&");
        String[] stringArray6 = stringArray2[2].split("&");
        if (stringArray5 == null || stringArray6 == null) {
            return false;
        }
        if (stringArray5.length < 4 || stringArray6.length < 4) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (stringArray5[i].equals(stringArray6[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HidDeviceInfo> enumerateDevices() {
        try {
            LinkedList<HidDeviceInfo> linkedList = new LinkedList<HidDeviceInfo>();
            SetupApiLibrary.GUID gUID = new SetupApiLibrary.GUID(1293833650, 61807, 4559, 136, 203, 0, 17, 17, 0, 0, 48);
            SetupApiLibrary.SP_DEVINFO_DATA sP_DEVINFO_DATA = new SetupApiLibrary.SP_DEVINFO_DATA();
            SetupApiLibrary.SP_DEVICE_INTERFACE_DATA sP_DEVICE_INTERFACE_DATA = new SetupApiLibrary.SP_DEVICE_INTERFACE_DATA();
            SetupApiLibrary.SP_DEVICE_INTERFACE_DETAIL_DATA_A sP_DEVICE_INTERFACE_DETAIL_DATA_A = null;
            SetupApiLibrary.HDEVINFO hDEVINFO = null;
            sP_DEVINFO_DATA.cbSize = sP_DEVINFO_DATA.size();
            sP_DEVICE_INTERFACE_DATA.cbSize = sP_DEVICE_INTERFACE_DATA.size();
            hDEVINFO = SetupApiLibrary.SetupDiGetClassDevs(gUID, null, null, 18);
            int n = 0;
            while (true) {
                int[] nArray;
                WinNT.HANDLE hANDLE = WinBase.INVALID_HANDLE_VALUE;
                if (!SetupApiLibrary.SetupDiEnumDeviceInterfaces(hDEVINFO, null, gUID, n, sP_DEVICE_INTERFACE_DATA)) {
                    if (Kernel32.INSTANCE.GetLastError() == 259) break;
                    WindowsBackend.reportLastError();
                }
                if (!SetupApiLibrary.SetupDiGetDeviceInterfaceDetail(hDEVINFO, sP_DEVICE_INTERFACE_DATA, null, 0, nArray = new int[]{0}, null) && Kernel32.INSTANCE.GetLastError() != 122) {
                    WindowsBackend.reportLastError();
                }
                int[] nArray2 = new int[]{8, 6, 5};
                for (int i = 0; i < nArray2.length && !SetupApiLibrary.SetupDiGetDeviceInterfaceDetail(hDEVINFO, sP_DEVICE_INTERFACE_DATA, sP_DEVICE_INTERFACE_DETAIL_DATA_A = new SetupApiLibrary.SP_DEVICE_INTERFACE_DETAIL_DATA_A(nArray2[i], nArray[0]), nArray[0], null, null); ++i) {
                    sP_DEVICE_INTERFACE_DETAIL_DATA_A = null;
                    if (Kernel32.INSTANCE.GetLastError() == 1784) continue;
                    WindowsBackend.reportLastError();
                }
                if (sP_DEVICE_INTERFACE_DETAIL_DATA_A != null) {
                    char[] cArray = new char[256];
                    if (!SetupApiLibrary.SetupDiEnumDeviceInfo(hDEVINFO, n, sP_DEVINFO_DATA)) {
                        WindowsBackend.reportLastError();
                    } else if (!SetupApiLibrary.SetupDiGetDeviceRegistryProperty(hDEVINFO, sP_DEVINFO_DATA, 7, null, cArray, cArray.length, null)) {
                        WindowsBackend.reportLastError();
                    } else {
                        int n2 = 0;
                        while (cArray[n2++] != '\u0000') {
                        }
                        String string = new String(cArray, 0, n2 - 1);
                        if ("HIDClass".equals(string)) {
                            if (!SetupApiLibrary.SetupDiGetDeviceRegistryProperty(hDEVINFO, sP_DEVINFO_DATA, 9, null, cArray, cArray.length, null)) {
                                if (Kernel32.INSTANCE.GetLastError() != 13) {
                                    WindowsBackend.reportLastError();
                                }
                            } else {
                                Object object;
                                Object object2;
                                String string2;
                                char[] cArray2 = new char[256];
                                int[] nArray3 = new int[]{0};
                                if (!SetupApiLibrary.SetupDiGetDeviceInstanceId(hDEVINFO, sP_DEVINFO_DATA, cArray2, cArray2.length, nArray3)) {
                                    WindowsBackend.reportLastError();
                                }
                                Object object3 = new String(cArray2);
                                int n3 = sP_DEVINFO_DATA.DevInst;
                                IntByReference intByReference = new IntByReference();
                                while (Cfgmgr32.INSTANCE.CM_Get_Parent(intByReference, n3, 0) == 0) {
                                    int n4;
                                    string2 = new IntByReference(0);
                                    n3 = intByReference.getValue();
                                    if (Cfgmgr32.INSTANCE.CM_Get_Device_ID_Size((IntByReference)string2, n3, 0) != 0) {
                                        WindowsBackend.reportLastError();
                                    }
                                    if (Cfgmgr32.INSTANCE.CM_Get_Device_ID(n3, (Pointer)(object2 = new Memory((long)((n4 = string2.getValue() + 1) * 2))), n4, 0) != 0) {
                                        WindowsBackend.reportLastError();
                                    }
                                    if (!((String)(object = object2.getString(0L))).startsWith("USB\\")) continue;
                                    object3 = object;
                                    break;
                                }
                                if ((hANDLE = WindowsBackend.openDeviceHandle(string2 = new String(sP_DEVICE_INTERFACE_DETAIL_DATA_A.DevicePath), true)) == WinBase.INVALID_HANDLE_VALUE) break;
                                HidLibrary.HIDD_ATTRIBUTES hIDD_ATTRIBUTES = new HidLibrary.HIDD_ATTRIBUTES();
                                hIDD_ATTRIBUTES.Size = new NativeLong((long)hIDD_ATTRIBUTES.size());
                                HidLibrary.HidD_GetAttributes(hANDLE, hIDD_ATTRIBUTES);
                                object2 = null;
                                object = linkedList.iterator();
                                while (object.hasNext()) {
                                    HidDeviceInfo hidDeviceInfo = (HidDeviceInfo)object.next();
                                    if (!this.isSamePhysicalDevice(hidDeviceInfo.getDeviceId(), (String)object3)) continue;
                                    object2 = hidDeviceInfo;
                                }
                                if (object2 == null) {
                                    object2 = new purejavahidapi.windows.HidDeviceInfo(hANDLE, hIDD_ATTRIBUTES);
                                    linkedList.add((HidDeviceInfo)object2);
                                }
                                ((purejavahidapi.windows.HidDeviceInfo)object2).addDevicePath((String)object3, string2);
                                Kernel32.INSTANCE.CloseHandle(hANDLE);
                            }
                        }
                    }
                }
                ++n;
            }
            SetupApiLibrary.SetupDiDestroyDeviceInfoList(hDEVINFO);
            return linkedList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public HidDevice openDevice(HidDeviceInfo hidDeviceInfo) throws IOException {
        return new purejavahidapi.windows.HidDevice(hidDeviceInfo, this);
    }

    static WinNT.HANDLE openDeviceHandle(String string, boolean bl) {
        int n = bl ? 0 : -1073741824;
        int n2 = 3;
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateFile(string, n, n2, null, 3, 0x40000000, null);
        return hANDLE;
    }

    static interface EnumerateCallback {
    }
}

