/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.awt.AWTEDTExecutor;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.OffscreenLayerOption;
import com.jogamp.nativewindow.OffscreenLayerSurface;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AppContextInfo;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.SurfaceUpdatedHelper;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_Rectangle;

public abstract class JAWTWindow
implements NativeWindow,
OffscreenLayerSurface,
OffscreenLayerOption,
ScalableSurface {
    protected static final boolean DEBUG = JAWTUtil.DEBUG;
    protected boolean shallUseOffscreenLayer = false;
    protected final Component component;
    private final AppContextInfo appContextInfo;
    private final SurfaceUpdatedHelper surfaceUpdatedHelper = new SurfaceUpdatedHelper();
    private final RecursiveLock surfaceLock = LockFactory.createRecursiveLock();
    private final JAWTComponentListener jawtComponentListener;
    private volatile AWTGraphicsConfiguration awtConfig;
    private JAWT jawt;
    private boolean isOffscreenLayerSurface;
    protected long drawable;
    protected Rectangle jawt_surface_bounds;
    protected Insets insets;
    private volatile long offscreenSurfaceLayer;
    private final float[] minPixelScale = new float[]{1.0f, 1.0f};
    private final float[] maxPixelScale = new float[]{1.0f, 1.0f};
    private final float[] hasPixelScale = new float[]{1.0f, 1.0f};
    private final float[] reqPixelScale = new float[]{0.0f, 0.0f};
    private volatile boolean hasPixelScaleChanged = false;
    private long drawable_old;
    private final Runnable repaintTask = new Runnable(){

        @Override
        public void run() {
            Component component = JAWTWindow.this.component;
            if (DEBUG) {
                System.err.println("Bug 1004: RepaintTask on " + Thread.currentThread() + ": Has Comp " + (null != component));
            }
            if (null != component) {
                component.repaint();
            }
        }
    };

    protected JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (abstractGraphicsConfiguration == null) {
            throw new IllegalArgumentException("Error: AbstractGraphicsConfiguration is null");
        }
        if (!(abstractGraphicsConfiguration instanceof AWTGraphicsConfiguration)) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is not an AWTGraphicsConfiguration: " + abstractGraphicsConfiguration);
        }
        this.appContextInfo = JAWTUtil.isOffscreenLayerSupported() ? new AppContextInfo("<init>") : null;
        this.component = (Component)object;
        this.jawtComponentListener = new JAWTComponentListener();
        this.offscreenSurfaceLayer = 0L;
        this.invalidate();
        this.awtConfig = (AWTGraphicsConfiguration)abstractGraphicsConfiguration;
        if (DEBUG) {
            System.err.println(this.jawtStr2("ctor"));
        }
    }

    private static String id(Object object) {
        return null != object ? JAWTWindow.toHexString(object.hashCode()) : "nil";
    }

    private String jawtStr1() {
        return "JAWTWindow[" + JAWTWindow.id(this) + "]";
    }

    private String jawtStr2(String string) {
        return this.jawtStr1() + "." + string + " @ Thread " + JAWTWindow.getThreadName();
    }

    private static String getThreadName() {
        return Thread.currentThread().getName();
    }

    protected synchronized void invalidate() {
        if (DEBUG) {
            System.err.println(this.jawtStr2("invalidate") + " - " + this.jawtComponentListener.toString());
            if (this.isSurfaceLayerAttached()) {
                System.err.println("OffscreenSurfaceLayer still attached: 0x" + Long.toHexString(this.offscreenSurfaceLayer));
            }
        }
        long l = this.offscreenSurfaceLayer;
        this.offscreenSurfaceLayer = 0L;
        this.invalidateNative(l);
        this.jawt = null;
        this.awtConfig = null;
        this.offscreenSurfaceLayer = 0L;
        this.isOffscreenLayerSurface = false;
        this.drawable = 0L;
        this.drawable_old = 0L;
        this.jawt_surface_bounds = new Rectangle();
        this.insets = new Insets();
        this.hasPixelScale[0] = 1.0f;
        this.hasPixelScale[1] = 1.0f;
        this.minPixelScale[0] = 1.0f;
        this.minPixelScale[1] = 1.0f;
        this.maxPixelScale[0] = 1.0f;
        this.maxPixelScale[1] = 1.0f;
        this.hasPixelScaleChanged = false;
    }

    protected abstract void invalidateNative(long var1);

    public final void setAWTGraphicsConfiguration(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        if (DEBUG) {
            System.err.println(this.jawtStr2("setAWTGraphicsConfiguration") + ": " + this.awtConfig + " -> " + aWTGraphicsConfiguration);
        }
        if (null == this.awtConfig) {
            throw new IllegalArgumentException(this.jawtStr2("") + ": null config");
        }
        this.awtConfig = aWTGraphicsConfiguration;
    }

    public final AWTGraphicsConfiguration getAWTGraphicsConfiguration() {
        return this.awtConfig;
    }

    @Override
    public boolean setSurfaceScale(float[] fArray) {
        System.arraycopy(fArray, 0, this.reqPixelScale, 0, 2);
        return false;
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        System.arraycopy(this.reqPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMinimumSurfaceScale(float[] fArray) {
        System.arraycopy(this.minPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getMaximumSurfaceScale(float[] fArray) {
        System.arraycopy(this.maxPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    protected final boolean updateLockedData(JAWT_Rectangle jAWT_Rectangle, GraphicsConfiguration graphicsConfiguration) {
        boolean bl;
        Rectangle rectangle = new Rectangle(jAWT_Rectangle.getX(), jAWT_Rectangle.getY(), jAWT_Rectangle.getWidth(), jAWT_Rectangle.getHeight());
        boolean bl2 = bl = !this.jawt_surface_bounds.equals(rectangle);
        if (bl) {
            if (DEBUG) {
                System.err.println("JAWTWindow.updateBounds: " + this.jawt_surface_bounds + " -> " + rectangle);
            }
            this.jawt_surface_bounds.set(jAWT_Rectangle.getX(), jAWT_Rectangle.getY(), jAWT_Rectangle.getWidth(), jAWT_Rectangle.getHeight());
            if (this.component instanceof Container) {
                java.awt.Insets insets = ((Container)this.component).getInsets();
                this.insets.set(insets.left, insets.right, insets.top, insets.bottom);
            }
        }
        this.updatePixelScale(graphicsConfiguration, false);
        return this.hasPixelScaleChanged || bl;
    }

    public final boolean updatePixelScale(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        if (JAWTUtil.getPixelScale(graphicsConfiguration, this.minPixelScale, this.maxPixelScale)) {
            this.hasPixelScaleChanged = true;
            if (DEBUG) {
                System.err.println("JAWTWindow.updatePixelScale: updated req[" + this.reqPixelScale[0] + ", " + this.reqPixelScale[1] + "], min[" + this.minPixelScale[0] + ", " + this.minPixelScale[1] + "], max[" + this.maxPixelScale[0] + ", " + this.maxPixelScale[1] + "], has[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "]");
            }
        }
        if (bl) {
            boolean bl2 = this.hasPixelScaleChanged;
            this.hasPixelScaleChanged = false;
            return bl2;
        }
        return this.hasPixelScaleChanged;
    }

    public final boolean hasPixelScaleChanged() {
        boolean bl = this.hasPixelScaleChanged;
        this.hasPixelScaleChanged = false;
        return bl;
    }

    protected final boolean setReqPixelScale() {
        this.updatePixelScale(this.awtConfig.getAWTGraphicsConfiguration(), true);
        return SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, this.reqPixelScale, this.minPixelScale, this.maxPixelScale, DEBUG ? this.getClass().getSimpleName() : null);
    }

    public final RectangleImmutable getJAWTSurfaceBounds() {
        return this.jawt_surface_bounds;
    }

    protected final float getPixelScaleX() {
        return this.hasPixelScale[0];
    }

    protected final float getPixelScaleY() {
        return this.hasPixelScale[1];
    }

    @Override
    public final InsetsImmutable getInsets() {
        return this.insets;
    }

    public final Component getAWTComponent() {
        return this.component;
    }

    public final boolean isApplet() {
        return false;
    }

    public final JAWT getJAWT() {
        return this.jawt;
    }

    @Override
    public void setShallUseOffscreenLayer(boolean bl) {
        this.shallUseOffscreenLayer = bl;
    }

    @Override
    public final boolean getShallUseOffscreenLayer() {
        return this.shallUseOffscreenLayer;
    }

    @Override
    public final boolean isOffscreenLayerSurfaceEnabled() {
        return this.isOffscreenLayerSurface;
    }

    @Override
    public final void attachSurfaceLayer(long l) throws NativeWindowException {
        if (null == this.appContextInfo) {
            throw new NativeWindowException("Offscreen layer not supported");
        }
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new NativeWindowException("Not an offscreen layer surface");
        }
        this.attachSurfaceLayerImpl(l);
        this.offscreenSurfaceLayer = l;
        this.appContextInfo.invokeOnAppContextThread(false, this.repaintTask, "Repaint");
    }

    protected void attachSurfaceLayerImpl(long l) {
        throw new UnsupportedOperationException("offscreen layer not supported");
    }

    protected void layoutSurfaceLayerImpl(boolean bl) {
    }

    private final void layoutSurfaceLayerIfEnabled(boolean bl) throws NativeWindowException {
        if (this.isOffscreenLayerSurfaceEnabled() && 0L != this.offscreenSurfaceLayer) {
            this.layoutSurfaceLayerImpl(bl);
        }
    }

    @Override
    public final void detachSurfaceLayer() throws NativeWindowException {
        if (0L == this.offscreenSurfaceLayer) {
            throw new NativeWindowException("No offscreen layer attached: " + this);
        }
        if (DEBUG) {
            System.err.println("JAWTWindow.detachSurfaceHandle(): osh " + JAWTWindow.toHexString(this.offscreenSurfaceLayer) + " - " + Thread.currentThread().getName());
        }
        long l = this.offscreenSurfaceLayer;
        this.offscreenSurfaceLayer = 0L;
        this.detachSurfaceLayerImpl(l);
    }

    protected void detachSurfaceLayerImpl(long l) {
        throw new UnsupportedOperationException("offscreen layer not supported");
    }

    @Override
    public final long getAttachedSurfaceLayer() {
        return this.offscreenSurfaceLayer;
    }

    @Override
    public final boolean isSurfaceLayerAttached() {
        return 0L != this.offscreenSurfaceLayer;
    }

    @Override
    public final void setChosenCapabilities(CapabilitiesImmutable capabilitiesImmutable) {
        ((MutableGraphicsConfiguration)this.getGraphicsConfiguration()).setChosenCapabilities(capabilitiesImmutable);
        this.awtConfig.setChosenCapabilities(capabilitiesImmutable);
    }

    @Override
    public final RecursiveLock getLock() {
        return this.surfaceLock;
    }

    @Override
    public final boolean setCursor(final PixelRectangle pixelRectangle, final PointImmutable pointImmutable) {
        AWTEDTExecutor.singleton.invoke(false, new Runnable(){

            @Override
            public void run() {
                Cursor cursor = null;
                if (null == pixelRectangle || null == pointImmutable) {
                    cursor = Cursor.getDefaultCursor();
                } else {
                    java.awt.Point point = new java.awt.Point(pointImmutable.getX(), pointImmutable.getY());
                    try {
                        cursor = AWTMisc.getCursor(pixelRectangle, point);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (null != cursor) {
                    JAWTWindow.this.component.setCursor(cursor);
                }
            }
        });
        return true;
    }

    @Override
    public final boolean hideCursor() {
        AWTEDTExecutor.singleton.invoke(false, new Runnable(){

            @Override
            public void run() {
                Cursor cursor = AWTMisc.getNullCursor();
                if (null != cursor) {
                    JAWTWindow.this.component.setCursor(cursor);
                }
            }
        });
        return true;
    }

    protected abstract JAWT fetchJAWTImpl() throws NativeWindowException;

    protected abstract int lockSurfaceImpl(GraphicsConfiguration var1) throws NativeWindowException;

    protected void dumpJAWTInfo() {
        System.err.println(this.jawt2String(null).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException, RuntimeException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getHoldCount() == 1 ? 1 : 3;
        if (1 == n) {
            if (!this.component.isDisplayable()) {
                this.surfaceLock.unlock();
                if (DEBUG) {
                    System.err.println("JAWTWindow: Can't lock surface, component peer n/a. Component displayable " + this.component.isDisplayable() + ", " + this.component);
                    ExceptionUtils.dumpStack(System.err);
                }
            } else {
                GraphicsConfiguration graphicsConfiguration = EventQueue.isDispatchThread() || Thread.holdsLock(this.component.getTreeLock()) ? this.component.getGraphicsConfiguration() : this.awtConfig.getAWTGraphicsConfiguration();
                try {
                    AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
                    abstractGraphicsDevice.lock();
                    try {
                        if (null == this.jawt) {
                            this.jawt = this.fetchJAWTImpl();
                            this.isOffscreenLayerSurface = JAWTUtil.isJAWTUsingOffscreenLayer(this.jawt);
                        }
                        if (3 == (n = this.lockSurfaceImpl(graphicsConfiguration)) && this.drawable_old != this.drawable) {
                            n = 2;
                            if (DEBUG) {
                                System.err.println("JAWTWindow: surface change " + JAWTWindow.toHexString(this.drawable_old) + " -> " + JAWTWindow.toHexString(this.drawable));
                            }
                        }
                    }
                    finally {
                        if (1 >= n) {
                            abstractGraphicsDevice.unlock();
                        }
                    }
                }
                finally {
                    if (1 >= n) {
                        this.surfaceLock.unlock();
                    }
                }
            }
        }
        return n;
    }

    protected abstract void unlockSurfaceImpl() throws NativeWindowException;

    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        this.drawable_old = this.drawable;
        if (this.surfaceLock.getHoldCount() == 1) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.getGraphicsConfiguration().getScreen().getDevice();
            try {
                if (null != this.jawt) {
                    this.unlockSurfaceImpl();
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        this.surfaceUpdatedHelper.addSurfaceUpdatedListener(n, surfaceUpdatedListener);
    }

    @Override
    public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        this.surfaceUpdatedHelper.removeSurfaceUpdatedListener(surfaceUpdatedListener);
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        this.surfaceUpdatedHelper.surfaceUpdated(object, nativeSurface, l);
    }

    @Override
    public long getSurfaceHandle() {
        return this.drawable;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        if (null == this.awtConfig) {
            throw new NativeWindowException(this.jawtStr2("") + ": null awtConfig, invalidated");
        }
        return this.awtConfig.getNativeGraphicsConfiguration();
    }

    @Override
    public final long getDisplayHandle() {
        return this.getGraphicsConfiguration().getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.getGraphicsConfiguration().getScreen().getIndex();
    }

    @Override
    public final int getSurfaceWidth() {
        return SurfaceScaleUtils.scale(this.getWidth(), this.getPixelScaleX());
    }

    @Override
    public final int getSurfaceHeight() {
        return SurfaceScaleUtils.scale(this.getHeight(), this.getPixelScaleY());
    }

    @Override
    public final int[] convertToWindowUnits(int[] nArray) {
        return SurfaceScaleUtils.scaleInv(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final int[] convertToPixelUnits(int[] nArray) {
        return SurfaceScaleUtils.scale(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final NativeSurface getNativeSurface() {
        return this;
    }

    @Override
    public final int getX() {
        return this.component.getX();
    }

    @Override
    public final int getY() {
        return this.component.getY();
    }

    @Override
    public final int getWidth() {
        return this.component.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.component.getHeight();
    }

    @Override
    public final Rectangle getBounds() {
        return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public final Rectangle getSurfaceBounds() {
        return new Rectangle(SurfaceScaleUtils.scale(this.getX(), this.getPixelScaleX()), SurfaceScaleUtils.scale(this.getY(), this.getPixelScaleY()), this.getSurfaceWidth(), this.getSurfaceHeight());
    }

    @Override
    public void destroy() {
        this.surfaceLock.lock();
        try {
            if (DEBUG) {
                System.err.println(this.jawtStr2("destroy"));
            }
            this.jawtComponentListener.detach();
            this.invalidate();
        }
        finally {
            this.surfaceLock.unlock();
        }
    }

    @Override
    public final NativeWindow getParent() {
        return null;
    }

    @Override
    public long getWindowHandle() {
        return this.drawable;
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        Point point2 = this.getLocationOnScreenNative(point);
        if (null == point2) {
            point2 = AWTMisc.getLocationOnScreenSafe(point, this.component, DEBUG);
        }
        return point2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point getLocationOnScreenNative(Point point) {
        int n = this.lockSurface();
        if (1 == n) {
            if (DEBUG) {
                System.err.println("Warning: JAWT Lock couldn't be acquired: " + this);
                ExceptionUtils.dumpStack(System.err);
            }
            return null;
        }
        try {
            Point point2 = this.getLocationOnScreenNativeImpl(0, 0);
            if (null != point2 && null != point) {
                point.translate(point2.getX(), point2.getY());
                Point point3 = point;
                return point3;
            }
            Point point4 = point2;
            return point4;
        }
        finally {
            this.unlockSurface();
        }
    }

    protected abstract Point getLocationOnScreenNativeImpl(int var1, int var2);

    @Override
    public boolean hasFocus() {
        return this.component.hasFocus();
    }

    protected StringBuilder jawt2String(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("JVM version: ").append(PlatformPropsImpl.JAVA_VERSION).append(" (").append(PlatformPropsImpl.JAVA_VERSION_NUMBER).append(" update ").append(PlatformPropsImpl.JAVA_VERSION_UPDATE).append(")").append(Platform.getNewline());
        if (null != this.jawt) {
            stringBuilder.append("JAWT version: ").append(JAWTWindow.toHexString(this.jawt.getCachedVersion())).append(", CA_LAYER: ").append(JAWTUtil.isJAWTUsingOffscreenLayer(this.jawt)).append(", isLayeredSurface ").append(this.isOffscreenLayerSurfaceEnabled()).append(", bounds ").append(this.jawt_surface_bounds).append(", insets ").append(this.insets).append(", pixelScale ").append(this.getPixelScaleX()).append("x").append(this.getPixelScaleY());
        } else {
            stringBuilder.append("JAWT n/a, bounds ").append(this.jawt_surface_bounds).append(", insets ").append(this.insets);
        }
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.jawtStr1() + "[");
        this.jawt2String(stringBuilder);
        stringBuilder.append(", shallUseOffscreenLayer " + this.shallUseOffscreenLayer + ", isOffscreenLayerSurface " + this.isOffscreenLayerSurface + ", attachedSurfaceLayer " + JAWTWindow.toHexString(this.getAttachedSurfaceLayer()) + ", windowHandle " + JAWTWindow.toHexString(this.getWindowHandle()) + ", surfaceHandle " + JAWTWindow.toHexString(this.getSurfaceHandle()) + ", bounds " + this.jawt_surface_bounds + ", insets " + this.insets);
        stringBuilder.append(", window [" + this.getX() + "/" + this.getY() + " " + this.getWidth() + "x" + this.getHeight() + "], pixels[scale " + this.getPixelScaleX() + ", " + this.getPixelScaleY() + " -> " + this.getSurfaceWidth() + "x" + this.getSurfaceHeight() + "], visible " + this.component.isVisible());
        stringBuilder.append(", lockedExt " + this.isSurfaceLockedByOtherThread() + ",\n\tconfig " + this.awtConfig + ",\n\tawtComponent " + this.getAWTComponent() + ",\n\tsurfaceLock " + this.surfaceLock + "]");
        return stringBuilder.toString();
    }

    protected static final String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    protected static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    private class JAWTComponentListener
    implements ComponentListener,
    HierarchyListener {
        private volatile boolean isShowing;

        private String str(Object object) {
            if (null == object) {
                return "0xnil: null";
            }
            if (object instanceof Component) {
                Component component = (Component)object;
                return JAWTWindow.id(object) + ": " + component.getClass().getSimpleName() + "[visible " + component.isVisible() + ", showing " + component.isShowing() + ", valid " + component.isValid() + ", displayable " + component.isDisplayable() + ", " + component.getX() + "/" + component.getY() + " " + component.getWidth() + "x" + component.getHeight() + "]";
            }
            return JAWTWindow.id(object) + ": " + object.getClass().getSimpleName() + "[..]";
        }

        private String s(ComponentEvent componentEvent) {
            return "visible[isShowing " + this.isShowing + "]," + Platform.getNewline() + "    ** COMP " + this.str(componentEvent.getComponent()) + Platform.getNewline() + "    ** SOURCE " + this.str(componentEvent.getSource()) + Platform.getNewline() + "    ** THIS " + this.str(JAWTWindow.this.component) + Platform.getNewline() + "    ** THREAD " + JAWTWindow.getThreadName();
        }

        private String s(HierarchyEvent hierarchyEvent) {
            return "visible[isShowing " + this.isShowing + "], changeBits 0x" + Long.toHexString(hierarchyEvent.getChangeFlags()) + Platform.getNewline() + "    ** COMP " + this.str(hierarchyEvent.getComponent()) + Platform.getNewline() + "    ** SOURCE " + this.str(hierarchyEvent.getSource()) + Platform.getNewline() + "    ** CHANGED " + this.str(hierarchyEvent.getChanged()) + Platform.getNewline() + "    ** CHANGEDPARENT " + this.str(hierarchyEvent.getChangedParent()) + Platform.getNewline() + "    ** THIS " + this.str(JAWTWindow.this.component) + Platform.getNewline() + "    ** THREAD " + JAWTWindow.getThreadName();
        }

        public final String toString() {
            return "visible[isShowing " + this.isShowing + "]," + Platform.getNewline() + "    ** THIS " + this.str(JAWTWindow.this.component) + Platform.getNewline() + "    ** THREAD " + JAWTWindow.getThreadName();
        }

        private JAWTComponentListener() {
            this.isShowing = JAWTWindow.this.component.isShowing();
            AWTEDTExecutor.singleton.invoke(false, new Runnable(){

                @Override
                public void run() {
                    JAWTComponentListener.this.isShowing = JAWTWindow.this.component.isShowing();
                    if (DEBUG) {
                        System.err.println(JAWTWindow.this.jawtStr2("attach") + ": " + JAWTComponentListener.this.toString());
                    }
                    JAWTWindow.this.component.addComponentListener(JAWTComponentListener.this);
                    JAWTWindow.this.component.addHierarchyListener(JAWTComponentListener.this);
                }
            });
        }

        private final void detach() {
            AWTEDTExecutor.singleton.invoke(false, new Runnable(){

                @Override
                public void run() {
                    if (DEBUG) {
                        System.err.println(JAWTWindow.this.jawtStr2("detach") + ": " + JAWTComponentListener.this.toString());
                    }
                    JAWTWindow.this.component.removeComponentListener(JAWTComponentListener.this);
                    JAWTWindow.this.component.removeHierarchyListener(JAWTComponentListener.this);
                }
            });
        }

        @Override
        public final void componentResized(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr2("componentResized") + ": " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void componentMoved(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr2("componentMoved") + ": " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void componentShown(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr2("componentShown") + ": " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void componentHidden(ComponentEvent componentEvent) {
            if (DEBUG) {
                System.err.println(JAWTWindow.this.jawtStr2("componentHidden") + ": " + this.s(componentEvent));
            }
            JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
        }

        @Override
        public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            boolean bl = this.isShowing;
            this.isShowing = JAWTWindow.this.component.isShowing();
            int n = 0;
            if (0L != (4L & hierarchyEvent.getChangeFlags()) && hierarchyEvent.getChanged() != JAWTWindow.this.component && bl != this.isShowing) {
                JAWTWindow.this.layoutSurfaceLayerIfEnabled(this.isShowing);
                n = 1;
            }
            if (DEBUG) {
                Component component = hierarchyEvent.getChanged();
                boolean bl2 = component.isDisplayable();
                boolean bl3 = component.isShowing();
                System.err.println(JAWTWindow.this.jawtStr2("hierarchyChanged") + ": action " + n + ", displayable " + bl2 + ", showing [changed " + bl3 + ", comp " + bl + " -> " + this.isShowing + "], " + this.s(hierarchyEvent));
            }
        }
    }
}

