/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.common.util.locks.LockFactory;
import com.jogamp.common.util.locks.RecursiveThreadGroupLock;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.NativeWindowVersion;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.JoglVersion;
import java.lang.reflect.Constructor;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDynamicLookupHelper;

public class GLProfile {
    public static final boolean DEBUG;
    public static final boolean disableOpenGLCore;
    public static final boolean disableOpenGLARBContext;
    public static final boolean disableOpenGLES;
    public static final boolean disableOpenGLDesktop;
    public static final boolean disabledEGL;
    public static final boolean disableSurfacelessContext;
    public static final boolean enableANGLE;
    public static final String GL4bc = "GL4bc";
    public static final String GL4 = "GL4";
    public static final String GL3bc = "GL3bc";
    public static final String GL3 = "GL3";
    public static final String GL2 = "GL2";
    public static final String GLES1 = "GLES1";
    public static final String GLES2 = "GLES2";
    public static final String GLES3 = "GLES3";
    public static final String GL2ES1 = "GL2ES1";
    public static final String GL2ES2 = "GL2ES2";
    public static final String GL2GL3 = "GL2GL3";
    public static final String GL4ES3 = "GL4ES3";
    private static final String GL_DEFAULT = "GL_DEFAULT";
    private static final String GL_GL = "GL";
    public static final String[] GL_PROFILE_LIST_ALL;
    public static final String[] GL_PROFILE_LIST_MAX;
    public static final String[] GL_PROFILE_LIST_MIN;
    public static final String[] GL_PROFILE_LIST_MIN_DESKTOP;
    public static final String[] GL_PROFILE_LIST_MAX_MOBILE;
    public static final String[] GL_PROFILE_LIST_MAX_FIXEDFUNC;
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER;
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER_CORE;
    private static boolean isAWTAvailable;
    private static boolean hasDesktopGLFactory;
    private static boolean hasGL234Impl;
    private static boolean hasMobileFactory;
    private static boolean hasGLES3Impl;
    private static boolean hasGLES1Impl;
    private static boolean hasGL234OnMobileImpl;
    private static Constructor<?> ctorGL234Impl;
    private static Constructor<?> ctorGLES3Impl;
    private static Constructor<?> ctorGLES1Impl;
    private static Constructor<?> ctorGL234ProcAddr;
    private static Constructor<?> ctorGLES3ProcAddr;
    private static Constructor<?> ctorGLES1ProcAddr;
    private static GLDrawableFactoryImpl mobileFactory;
    private static GLDrawableFactoryImpl desktopFactory;
    private static AbstractGraphicsDevice defaultDevice;
    private static boolean initialized;
    private static final RecursiveThreadGroupLock initLock;
    private static final Class<?>[] ctorGLArgs;
    private static final Class<?>[] ctorProcArgs;
    private static final String GL4bcImplClassName = "jogamp.opengl.gl4.GL4bcImpl";
    private static final String GL4bcProcClassName = "jogamp.opengl.gl4.GL4bcProcAddressTable";
    private static final String GLES1ImplClassName = "jogamp.opengl.es1.GLES1Impl";
    private static final String GLES1ProcClassName = "jogamp.opengl.es1.GLES1ProcAddressTable";
    private static final String GLES3ImplClassName = "jogamp.opengl.es3.GLES3Impl";
    private static final String GLES3ProcClassName = "jogamp.opengl.es3.GLES3ProcAddressTable";
    private static HashMap<String, HashMap<String, GLProfile>> deviceConn2ProfileMap;
    private final GLProfile profileImpl;
    private final String profile;
    private final boolean isHardwareRasterizer;
    private final boolean isCustom;

    public static boolean isInitialized() {
        initLock.lock();
        try {
            boolean bl = initialized;
            return bl;
        }
        finally {
            initLock.unlock();
        }
    }

    public static void initSingleton() {
        boolean bl;
        initLock.lock();
        try {
            if (!initialized) {
                initialized = true;
                bl = true;
                if (DEBUG) {
                    System.err.println("GLProfile.initSingleton() - thread " + Thread.currentThread().getName());
                    ExceptionUtils.dumpStack(System.err);
                }
                if (ReflectionUtil.DEBUG_STATS_FORNAME) {
                    ReflectionUtil.resetForNameCount();
                }
                SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Platform.initSingleton();
                        if (TempJarCache.isInitialized(true)) {
                            ClassLoader classLoader = GLProfile.class.getClassLoader();
                            Class[] classArray = new Class[]{jogamp.nativewindow.Debug.class, Debug.class, null};
                            if (ReflectionUtil.isClassAvailable("jogamp.newt.Debug", classLoader)) {
                                classArray[2] = ReflectionUtil.getClass("jogamp.newt.Debug", false, classLoader);
                            }
                            JNILibLoaderBase.addNativeJarLibsJoglCfg(classArray);
                        }
                        GLProfile.initProfilesForDefaultDevices();
                        return null;
                    }
                });
                if (ReflectionUtil.DEBUG_STATS_FORNAME && bl) {
                    System.err.println(ReflectionUtil.getForNameStats(null).toString());
                }
            } else {
                bl = false;
            }
        }
        finally {
            initLock.unlock();
        }
        if (DEBUG && bl && (hasGL234Impl || hasGL234OnMobileImpl || hasGLES1Impl || hasGLES3Impl)) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(defaultDevice, null, true));
        }
    }

    public static void initProfiles(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        GLProfile.getProfileMap(abstractGraphicsDevice, true);
    }

    public static void shutdown() {
        initLock.lock();
        try {
            if (initialized) {
                initialized = false;
                if (DEBUG) {
                    System.err.println("GLProfile.shutdown() - thread " + Thread.currentThread().getName());
                    ExceptionUtils.dumpStack(System.err);
                }
                GLDrawableFactory.shutdown();
            }
        }
        finally {
            initLock.unlock();
        }
    }

    public static boolean isAvailable(AbstractGraphicsDevice abstractGraphicsDevice, String string) {
        GLProfile.initSingleton();
        return GLProfile.isAvailableImpl(GLProfile.getProfileMap(abstractGraphicsDevice, false), string);
    }

    private static boolean isAvailableImpl(HashMap<String, GLProfile> hashMap, String string) {
        return null != hashMap && null != hashMap.get(string);
    }

    public static boolean isAvailable(String string) {
        return GLProfile.isAvailable(null, string);
    }

    public static boolean isAnyAvailable() {
        return GLProfile.isAvailable(null, null);
    }

    public static String glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice) {
        return GLProfile.glAvailabilityToString(abstractGraphicsDevice, null).toString();
    }

    public static StringBuilder glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder) {
        return GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder, null, 0);
    }

    private static StringBuilder doIndent(StringBuilder stringBuilder, String string, int n) {
        while (n > 0) {
            stringBuilder.append(string);
            --n;
        }
        return stringBuilder;
    }

    public static StringBuilder glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder, String string, int n) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = null != string;
        GLProfile.initSingleton();
        int n2 = 0;
        int n3 = 0;
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        HashMap<String, GLProfile> hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, false);
        if (bl) {
            GLProfile.doIndent(stringBuilder, string, n).append("Natives");
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, ++n).append("GL4bc ").append(string);
        } else {
            stringBuilder.append("Natives[GL4bc ");
        }
        boolean bl2 = GLProfile.isAvailableImpl(hashMap, GL4bc);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 4, 2);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL4 ").append(string);
        } else {
            stringBuilder.append(", GL4 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL4);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 4, 4);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GLES3 ").append(string);
        } else {
            stringBuilder.append(", GLES3 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GLES3);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 3, 8);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL3bc ").append(string);
        } else {
            stringBuilder.append(", GL3bc ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL3bc);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 3, 2);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL3 ").append(string);
        } else {
            stringBuilder.append(", GL3 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL3);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 3, 4);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL2 ").append(string);
        } else {
            stringBuilder.append(", GL2 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GL2);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 2, 2);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GLES2 ").append(string);
        } else {
            stringBuilder.append(", GLES2 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GLES2);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 2, 8);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GLES1 ").append(string);
        } else {
            stringBuilder.append(", GLES1 ");
        }
        bl2 = GLProfile.isAvailableImpl(hashMap, GLES1);
        stringBuilder.append(bl2);
        if (bl2) {
            ++n3;
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder.append(" "), 1, 8);
        }
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("Count\t" + n3 + " / " + n2);
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, --n).append("Common");
            ++n;
        } else {
            stringBuilder.append(", count " + n3 + " / " + n2 + "], Common[");
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL4ES3 ").append(string);
        } else {
            stringBuilder.append(", GL4ES3 ");
        }
        stringBuilder.append(GLProfile.isAvailableImpl(hashMap, GL4ES3));
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL2GL3 ").append(string);
        } else {
            stringBuilder.append(", GL2GL3 ");
        }
        stringBuilder.append(GLProfile.isAvailableImpl(hashMap, GL2GL3));
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL2ES2 ").append(string);
        } else {
            stringBuilder.append(", GL2ES2 ");
        }
        stringBuilder.append(GLProfile.isAvailableImpl(hashMap, GL2ES2));
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("GL2ES1 ").append(string);
        } else {
            stringBuilder.append(", GL2ES1 ");
        }
        stringBuilder.append(GLProfile.isAvailableImpl(hashMap, GL2ES1));
        ++n2;
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, --n).append("Mappings");
            ++n;
        } else {
            stringBuilder.append("], Mappings[");
        }
        int n4 = 0;
        if (null != hashMap) {
            for (Map.Entry<String, GLProfile> entry : hashMap.entrySet()) {
                if (GL_DEFAULT == entry.getKey()) continue;
                if (bl) {
                    GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n);
                }
                stringBuilder.append(entry.getKey() + (bl ? " \t" : " ") + entry.getValue());
                if (!bl) {
                    stringBuilder.append(", ");
                }
                ++n4;
            }
            if (bl) {
                GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("default ");
            } else {
                stringBuilder.append(", default ");
            }
            try {
                stringBuilder.append(GLProfile.getDefault(abstractGraphicsDevice));
            }
            catch (GLException gLException) {
                stringBuilder.append("n/a");
            }
        }
        if (bl) {
            GLProfile.doIndent(stringBuilder.append(Platform.getNewline()), string, n).append("Count\t" + n4 + " / " + n2);
            stringBuilder.append(Platform.getNewline());
        } else {
            stringBuilder.append(", count " + n4 + " / " + n2 + "]");
        }
        return stringBuilder;
    }

    public static String glAvailabilityToString() {
        return GLProfile.glAvailabilityToString(null);
    }

    public static GLProfile getDefault(AbstractGraphicsDevice abstractGraphicsDevice) {
        GLProfile gLProfile = GLProfile.get(abstractGraphicsDevice, GL_DEFAULT);
        return gLProfile;
    }

    public static GLProfile getDefault() {
        return GLProfile.getDefault(defaultDevice);
    }

    public static GLProfile getMaximum(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX, bl);
    }

    public static GLProfile getMaximum(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX, bl);
    }

    public static GLProfile getMinimum(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MIN, bl);
    }

    public static GLProfile getMinimum(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MIN, bl);
    }

    public static GLProfile getMaxFixedFunc(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_FIXEDFUNC, bl);
    }

    public static GLProfile getMaxFixedFunc(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_FIXEDFUNC, bl);
    }

    public static GLProfile getMaxProgrammable(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_PROGSHADER, bl);
    }

    public static GLProfile getMaxProgrammable(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_PROGSHADER, bl);
    }

    public static GLProfile getMaxProgrammableCore(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL_PROFILE_LIST_MAX_PROGSHADER_CORE, bl);
    }

    public static GLProfile getMaxProgrammableCore(boolean bl) throws GLException {
        return GLProfile.get(GL_PROFILE_LIST_MAX_PROGSHADER_CORE, bl);
    }

    public static GLProfile getGL2ES1(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2ES1).getImpl();
    }

    public static GLProfile getGL2ES1() throws GLException {
        return GLProfile.get(defaultDevice, GL2ES1).getImpl();
    }

    public static GLProfile getGL2ES2(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2ES2).getImpl();
    }

    public static GLProfile getGL2ES2() throws GLException {
        return GLProfile.get(defaultDevice, GL2ES2).getImpl();
    }

    public static GLProfile getGL4ES3(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL4ES3).getImpl();
    }

    public static GLProfile getGL4ES3() throws GLException {
        return GLProfile.get(defaultDevice, GL4ES3).getImpl();
    }

    public static GLProfile getGL2GL3(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        return GLProfile.get(abstractGraphicsDevice, GL2GL3).getImpl();
    }

    public static GLProfile getGL2GL3() throws GLException {
        return GLProfile.get(defaultDevice, GL2GL3).getImpl();
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String string) throws GLException {
        HashMap<String, GLProfile> hashMap;
        GLProfile gLProfile;
        if (null == string || string == GL_GL) {
            string = GL_DEFAULT;
        }
        if (null == (gLProfile = (hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, true)).get(string))) {
            throw new GLException("Profile " + string + " is not available on " + abstractGraphicsDevice + ", but: " + hashMap.values());
        }
        return gLProfile;
    }

    public static GLProfile get(String string) throws GLException {
        return GLProfile.get(defaultDevice, string);
    }

    public static GLProfile get(AbstractGraphicsDevice abstractGraphicsDevice, String[] stringArray, boolean bl) throws GLException {
        GLProfile gLProfile = null;
        HashMap<String, GLProfile> hashMap = GLProfile.getProfileMap(abstractGraphicsDevice, true);
        for (int i = 0; i < stringArray.length; ++i) {
            GLProfile gLProfile2 = hashMap.get(stringArray[i]);
            if (null == gLProfile2) continue;
            if (!bl) {
                return gLProfile2;
            }
            if (gLProfile2.isHardwareRasterizer()) {
                return gLProfile2;
            }
            if (null != gLProfile) continue;
            gLProfile = gLProfile2;
        }
        if (null != gLProfile) {
            return gLProfile;
        }
        throw new GLException("Profiles " + GLProfile.array2String(stringArray) + " not available on device " + abstractGraphicsDevice);
    }

    public static GLProfile get(String[] stringArray, boolean bl) throws GLException {
        return GLProfile.get(defaultDevice, stringArray, bl);
    }

    public static boolean usesNativeGLES1(String string) {
        return GLES1 == string;
    }

    public static boolean usesNativeGLES2(String string) {
        return GLES3 == string || GLES2 == string;
    }

    public static boolean usesNativeGLES3(String string) {
        return GLES3 == string;
    }

    public static boolean usesNativeGLES(String string) {
        return GLProfile.usesNativeGLES2(string) || GLProfile.usesNativeGLES1(string);
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getGLTypeName(int n) {
        switch (n) {
            case 5121: {
                return "GL_UNSIGNED_BYTE";
            }
            case 5120: {
                return "GL_BYTE";
            }
            case 5123: {
                return "GL_UNSIGNED_SHORT";
            }
            case 5122: {
                return "GL_SHORT";
            }
            case 5126: {
                return "GL_FLOAT";
            }
            case 5132: {
                return "GL_FIXED";
            }
            case 5124: {
                return "GL_INT";
            }
            case 5125: {
                return "GL_UNSIGNED_INT";
            }
            case 5130: {
                return "GL_DOUBLE";
            }
            case 5127: {
                return "GL_2_BYTES";
            }
            case 5128: {
                return "GL_3_BYTES";
            }
            case 5129: {
                return "GL_4_BYTES";
            }
        }
        return null;
    }

    public static String getGLArrayName(int n) {
        switch (n) {
            case 32884: {
                return "GL_VERTEX_ARRAY";
            }
            case 32885: {
                return "GL_NORMAL_ARRAY";
            }
            case 32886: {
                return "GL_COLOR_ARRAY";
            }
            case 32888: {
                return "GL_TEXTURE_COORD_ARRAY";
            }
        }
        return null;
    }

    public final String getGLImplBaseClassName() {
        return GLProfile.getGLImplBaseClassName(this.getImplName());
    }

    private static final String getGLImplBaseClassName(String string) {
        if (GLES2 == string || GLES3 == string) {
            return "jogamp.opengl.es3.GLES3";
        }
        if (GLES1 == string) {
            return "jogamp.opengl.es1.GLES1";
        }
        if (GL4bc == string || GL4 == string || GL3bc == string || GL3 == string || GL2 == string) {
            return "jogamp.opengl.gl4.GL4bc";
        }
        throw new GLException("unsupported profile \"" + string + "\"");
    }

    public final Constructor<?> getGLCtor(boolean bl) {
        return GLProfile.getGLCtor(this.getImplName(), bl);
    }

    private static final Constructor<?> getGLCtor(String string, boolean bl) {
        if (GLES2 == string || GLES3 == string) {
            return bl ? ctorGLES3Impl : ctorGLES3ProcAddr;
        }
        if (GLES1 == string) {
            return bl ? ctorGLES1Impl : ctorGLES1ProcAddr;
        }
        if (GL4bc == string || GL4 == string || GL3bc == string || GL3 == string || GL2 == string) {
            return bl ? ctorGL234Impl : ctorGL234ProcAddr;
        }
        throw new GLException("unsupported profile \"" + string + "\"");
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GLProfile) {
            GLProfile gLProfile = (GLProfile)object;
            return this.getName() == gLProfile.getName() && this.getImplName() == gLProfile.getImplName();
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 97 * n + this.getImplName().hashCode();
        n = 97 * n + this.getName().hashCode();
        return n;
    }

    public final void verifyEquality(GLProfile gLProfile) throws GLException {
        if (!this.equals(gLProfile)) {
            throw new GLException("GLProfiles are not equal: " + this + " != " + gLProfile);
        }
    }

    public final String getName() {
        return this.profile;
    }

    public final GLProfile getImpl() {
        return null != this.profileImpl ? this.profileImpl : this;
    }

    public final boolean isHardwareRasterizer() {
        return this.isHardwareRasterizer;
    }

    public final String getImplName() {
        return null != this.profileImpl ? this.profileImpl.getName() : this.getName();
    }

    public final boolean isGL4bc() {
        return GL4bc == this.profile;
    }

    public final boolean isGL4() {
        return this.isGL4bc() || GL4 == this.profile;
    }

    public final boolean isGL3bc() {
        return this.isGL4bc() || GL3bc == this.profile;
    }

    public final boolean isGL3() {
        return this.isGL4() || this.isGL3bc() || GL3 == this.profile;
    }

    public final boolean isGL2() {
        return this.isGL3bc() || GL2 == this.profile;
    }

    public final boolean isGLES1() {
        return GLES1 == this.profile;
    }

    public final boolean isGLES2() {
        return this.isGLES3() || GLES2 == this.profile;
    }

    public final boolean isGLES3() {
        return GLES3 == this.profile;
    }

    public final boolean isGLES() {
        return GLES3 == this.profile || GLES2 == this.profile || GLES1 == this.profile;
    }

    public final boolean isGL2ES1() {
        return GL2ES1 == this.profile || this.isGLES1() || this.isGL2();
    }

    public final boolean isGL2GL3() {
        return GL2GL3 == this.profile || this.isGL3() || this.isGL2();
    }

    public final boolean isGL2ES2() {
        return GL2ES2 == this.profile || this.isGLES2() || this.isGL2GL3();
    }

    public final boolean isGL2ES3() {
        return this.isGL3ES3() || this.isGL2GL3();
    }

    public final boolean isGL3ES3() {
        return this.isGL4ES3() || this.isGL3();
    }

    public final boolean isGL4ES3() {
        return GL4ES3 == this.profile || this.isGLES3() || this.isGL4();
    }

    public final boolean hasGLSL() {
        return this.isGL2ES2();
    }

    public final boolean usesNativeGLES1() {
        return GLES1 == this.getImplName();
    }

    public final boolean usesNativeGLES2() {
        return GLES2 == this.getImplName();
    }

    public final boolean usesNativeGLES3() {
        return GLES3 == this.getImplName();
    }

    public final boolean usesNativeGLES() {
        return this.usesNativeGLES3() || this.usesNativeGLES2() || this.usesNativeGLES1();
    }

    public boolean isValidDataType(int n, boolean bl) {
        switch (n) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5126: 
            case 5132: {
                return true;
            }
            case 5124: 
            case 5125: {
                if (this.isGL2ES2()) {
                    return true;
                }
            }
            case 5130: {
                if (this.isGL3()) {
                    return true;
                }
            }
            case 5127: 
            case 5128: 
            case 5129: {
                if (!this.isGL2()) break;
                return true;
            }
        }
        if (bl) {
            throw new GLException("Illegal data type on profile " + this + ": " + n);
        }
        return false;
    }

    public boolean isValidArrayDataType(int n, int n2, int n3, boolean bl, boolean bl2) {
        block82: {
            String string;
            block84: {
                block83: {
                    block81: {
                        string = GLProfile.getGLArrayName(n);
                        if (!this.isGLES1()) break block81;
                        if (bl) {
                            if (bl2) {
                                throw new GLException("Illegal array type for " + string + " on profile GLES1: VertexAttribPointer");
                            }
                            return false;
                        }
                        block0 : switch (n) {
                            case 32884: 
                            case 32888: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32885: {
                                switch (n3) {
                                    case 5120: 
                                    case 5122: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 3: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                            case 32886: {
                                switch (n3) {
                                    case 5121: 
                                    case 5126: 
                                    case 5132: {
                                        break;
                                    }
                                    default: {
                                        if (bl2) {
                                            throw new GLException("Illegal data type for " + string + " on profile GLES1: " + n3);
                                        }
                                        return false;
                                    }
                                }
                                switch (n2) {
                                    case 0: 
                                    case 4: {
                                        break block0;
                                    }
                                }
                                if (bl2) {
                                    throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                                }
                                return false;
                            }
                        }
                        break block82;
                    }
                    if (!this.isGLES2()) break block83;
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5126: 
                        case 5132: {
                            break block82;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GLES2: " + n3);
                            }
                            return false;
                        }
                    }
                }
                if (!this.isGL2ES2()) break block82;
                if (!bl) break block84;
                switch (n3) {
                    case 5120: 
                    case 5121: 
                    case 5122: 
                    case 5123: 
                    case 5124: 
                    case 5125: 
                    case 5126: 
                    case 5130: {
                        break;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                        }
                        return false;
                    }
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break block82;
                    }
                    default: {
                        if (bl2) {
                            throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                        }
                        return false;
                    }
                }
            }
            block32 : switch (n) {
                case 32884: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32885: {
                    switch (n3) {
                        case 5120: 
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GLES1: " + n2);
                    }
                    return false;
                }
                case 32886: {
                    switch (n3) {
                        case 5120: 
                        case 5121: 
                        case 5122: 
                        case 5123: 
                        case 5124: 
                        case 5125: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
                case 32888: {
                    switch (n3) {
                        case 5122: 
                        case 5124: 
                        case 5126: 
                        case 5130: {
                            break;
                        }
                        default: {
                            if (bl2) {
                                throw new GLException("Illegal data type for " + string + " on profile GL2: " + n3);
                            }
                            return false;
                        }
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break block32;
                        }
                    }
                    if (bl2) {
                        throw new GLException("Illegal component number for " + string + " on profile GL2: " + n2);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "GLProfile[" + this.getName() + "/" + this.getImplName() + "." + (this.isHardwareRasterizer ? "hw" : "sw") + (this.isCustom ? ".custom" : "") + "]";
    }

    private static final Constructor<?> getCtor(String string, boolean bl, ClassLoader classLoader) {
        try {
            return ReflectionUtil.getConstructor(string, bl ? ctorGLArgs : ctorProcArgs, false, classLoader);
        }
        catch (Throwable throwable) {
            if (DEBUG) {
                System.err.println("Caught: " + throwable.getMessage());
                throwable.printStackTrace();
            }
            return null;
        }
    }

    private static final void initGLCtorImpl() {
        Constructor<?> constructor;
        ClassLoader classLoader = GLProfile.class.getClassLoader();
        Constructor<?> constructor2 = GLProfile.getCtor(GL4bcImplClassName, true, classLoader);
        Constructor<?> constructor3 = constructor = null != constructor2 ? GLProfile.getCtor(GL4bcProcClassName, false, classLoader) : null;
        if (null != constructor) {
            hasGL234Impl = true;
            ctorGL234Impl = constructor2;
            ctorGL234ProcAddr = constructor;
        } else {
            hasGL234Impl = false;
            ctorGL234Impl = null;
            ctorGL234ProcAddr = null;
        }
        hasGL234OnMobileImpl = hasGL234Impl;
        constructor2 = GLProfile.getCtor(GLES1ImplClassName, true, classLoader);
        Constructor<?> constructor4 = constructor = null != constructor2 ? GLProfile.getCtor(GLES1ProcClassName, false, classLoader) : null;
        if (null != constructor) {
            hasGLES1Impl = true;
            ctorGLES1Impl = constructor2;
            ctorGLES1ProcAddr = constructor;
        } else {
            hasGLES1Impl = false;
            ctorGLES1Impl = null;
            ctorGLES1ProcAddr = null;
        }
        constructor2 = GLProfile.getCtor(GLES3ImplClassName, true, classLoader);
        Constructor<?> constructor5 = constructor = null != constructor2 ? GLProfile.getCtor(GLES3ProcClassName, false, classLoader) : null;
        if (null != constructor) {
            hasGLES3Impl = true;
            ctorGLES3Impl = constructor2;
            ctorGLES3ProcAddr = constructor;
        } else {
            hasGLES3Impl = false;
            ctorGLES3Impl = null;
            ctorGLES3ProcAddr = null;
        }
    }

    private static void initProfilesForDefaultDevices() {
        boolean bl;
        Object object;
        Object object2;
        NativeWindowFactory.initSingleton();
        if (DEBUG) {
            System.err.println("GLProfile.init - thread: " + Thread.currentThread().getName());
            System.err.println(VersionUtil.getPlatformInfo());
            System.err.println(GlueGenVersion.getInstance());
            System.err.println(NativeWindowVersion.getInstance());
            System.err.println(JoglVersion.getInstance());
        }
        ClassLoader classLoader = GLProfile.class.getClassLoader();
        isAWTAvailable = NativeWindowFactory.isAWTAvailable() && ReflectionUtil.isClassAvailable("com.jogamp.opengl.awt.GLCanvas", classLoader);
        GLProfile.initGLCtorImpl();
        GLDrawableFactory.initSingleton();
        Throwable throwable = null;
        try {
            desktopFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GL2);
            if (null != desktopFactory) {
                object2 = desktopFactory.getGLDynamicLookupHelper(2, 2);
                hasDesktopGLFactory = hasGL234Impl = null != object2 && ((DynamicLibraryBundle)object2).isLibComplete() && hasGL234Impl;
            }
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (DEBUG && null != throwable) {
            throwable.printStackTrace();
        }
        if (null == desktopFactory) {
            hasDesktopGLFactory = false;
            hasGL234Impl = false;
            object2 = null;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Desktop GLDrawable factory not available");
            }
        } else {
            object2 = desktopFactory.getDefaultDevice();
        }
        throwable = null;
        try {
            mobileFactory = (GLDrawableFactoryImpl)GLDrawableFactory.getFactoryImpl(GLES2);
            if (null != mobileFactory) {
                object = mobileFactory.getGLDynamicLookupHelper(2, 8);
                GLDynamicLookupHelper gLDynamicLookupHelper = mobileFactory.getGLDynamicLookupHelper(1, 8);
                GLDynamicLookupHelper gLDynamicLookupHelper2 = mobileFactory.getGLDynamicLookupHelper(3, 4);
                hasGLES3Impl = null != object && ((DynamicLibraryBundle)object).isLibComplete() && hasGLES3Impl;
                hasGLES1Impl = null != gLDynamicLookupHelper && gLDynamicLookupHelper.isLibComplete() && hasGLES1Impl;
                hasGL234OnMobileImpl = null != gLDynamicLookupHelper2 && gLDynamicLookupHelper2.isLibComplete() && hasGL234OnMobileImpl;
                hasMobileFactory = hasGLES3Impl || hasGLES1Impl || hasGL234OnMobileImpl;
            }
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        catch (NullPointerException nullPointerException) {
            throwable = nullPointerException;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        if (DEBUG && null != throwable) {
            throwable.printStackTrace();
        }
        if (null == mobileFactory) {
            hasMobileFactory = false;
            hasGL234OnMobileImpl = false;
            hasGLES3Impl = false;
            hasGLES1Impl = false;
            object = null;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Mobile GLDrawable factory not available");
            }
        } else {
            object = mobileFactory.getDefaultDevice();
        }
        if (null != object2) {
            defaultDevice = object2;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Default device is desktop derived: " + defaultDevice);
            }
        } else if (null != object) {
            defaultDevice = object;
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Default device is mobile derived: " + defaultDevice);
            }
        } else {
            if (DEBUG) {
                System.err.println("Info: GLProfile.init - Default device not available");
            }
            defaultDevice = null;
        }
        boolean bl2 = null != object ? GLProfile.initProfilesForDevice((AbstractGraphicsDevice)object) : false;
        boolean bl3 = null != object2 ? GLProfile.initProfilesForDevice((AbstractGraphicsDevice)object2) : false;
        boolean bl4 = bl = bl2 || bl3;
        if (DEBUG) {
            System.err.println("GLProfile.init addedAnyProfile       " + bl + " (desktop: " + bl3 + ", mobile " + bl2 + ")");
            System.err.println("GLProfile.init isAWTAvailable        " + isAWTAvailable);
            System.err.println("GLProfile.init hasDesktopGLFactory   " + hasDesktopGLFactory);
            System.err.println("GLProfile.init hasGL234Impl          " + hasGL234Impl);
            System.err.println("GLProfile.init hasMobileFactory      " + hasMobileFactory);
            System.err.println("GLProfile.init hasGLES1Impl          " + hasGLES1Impl);
            System.err.println("GLProfile.init hasGLES3Impl          " + hasGLES3Impl);
            System.err.println("GLProfile.init hasGL234OnEGLImpl     " + hasGL234OnMobileImpl);
            System.err.println("GLProfile.init defaultDevice         " + defaultDevice);
            System.err.println("GLProfile.init defaultDevice Desktop " + object2);
            System.err.println("GLProfile.init defaultDevice Mobile  " + object);
            System.err.println("GLProfile.init profile order         " + GLProfile.array2String(GL_PROFILE_LIST_ALL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initProfilesForDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            return false;
        }
        initLock.lock();
        try {
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(abstractGraphicsDevice);
            if (null != gLDrawableFactory) {
                gLDrawableFactory.enterThreadCriticalZone();
                try {
                    boolean bl = GLProfile.initProfilesForDeviceCritical(abstractGraphicsDevice);
                    gLDrawableFactory.leaveThreadCriticalZone();
                    return bl;
                }
                catch (Throwable throwable) {
                    gLDrawableFactory.leaveThreadCriticalZone();
                    throw throwable;
                }
            }
        }
        finally {
            initLock.unlock();
        }
        return false;
    }

    private static boolean initProfilesForDeviceCritical(AbstractGraphicsDevice abstractGraphicsDevice) {
        boolean bl;
        boolean bl2;
        block22: {
            block23: {
                HashMap hashMap;
                boolean bl3;
                boolean bl4;
                boolean bl5 = GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    System.err.println("Info: GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + " (" + abstractGraphicsDevice.getClass().getName() + "), isSet " + bl5 + ", hasDesktopGLFactory " + hasDesktopGLFactory + ", hasEGLFactory " + hasMobileFactory);
                }
                if (bl5) {
                    String string = abstractGraphicsDevice.getUniqueID();
                    HashMap<String, GLProfile> hashMap2 = deviceConn2ProfileMap.get(string);
                    if (null == hashMap2) {
                        throw new InternalError("GLContext Avail. GLVersion is set - but no profile map for device: " + abstractGraphicsDevice);
                    }
                    return null != hashMap2.get(GL_DEFAULT);
                }
                HashMap<Object, Object> hashMap3 = null;
                bl2 = false;
                HashMap<Object, Object> hashMap4 = null;
                bl = false;
                boolean bl6 = bl4 = hasDesktopGLFactory && desktopFactory.getIsDeviceCompatible(abstractGraphicsDevice);
                if (bl4) {
                    GLProfile.computeProfileMap(abstractGraphicsDevice, true, true);
                    Thread thread = desktopFactory.getSharedResourceThread();
                    if (null != thread) {
                        initLock.addOwner(thread);
                    }
                    boolean bl7 = desktopFactory.createSharedResource(abstractGraphicsDevice);
                    if (null != thread) {
                        initLock.removeOwner(thread);
                    }
                    if (bl7) {
                        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                            throw new InternalError("Available GLVersions not set for " + abstractGraphicsDevice);
                        }
                        hashMap3 = GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
                        boolean bl8 = bl2 = hashMap3.size() > 0;
                        if (DEBUG) {
                            System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ": desktop Shared Ctx " + bl7 + ", profiles: " + (bl2 ? hashMap3.size() : 0));
                        }
                    }
                }
                boolean bl9 = bl3 = hasMobileFactory && mobileFactory.getIsDeviceCompatible(abstractGraphicsDevice);
                if (bl3) {
                    GLProfile.computeProfileMap(abstractGraphicsDevice, true, true);
                    Thread thread = mobileFactory.getSharedResourceThread();
                    if (null != thread) {
                        initLock.addOwner(thread);
                    }
                    boolean bl10 = mobileFactory.createSharedResource(abstractGraphicsDevice);
                    if (null != thread) {
                        initLock.removeOwner(thread);
                    }
                    if (bl10) {
                        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
                            throw new InternalError("Available GLVersions not set for " + abstractGraphicsDevice);
                        }
                        hashMap4 = GLProfile.computeProfileMap(abstractGraphicsDevice, false, false);
                        boolean bl11 = bl = hashMap4.size() > 0;
                    }
                    if (DEBUG) {
                        System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice + ": mobile Shared Ctx " + bl10 + ", profiles: " + (bl ? hashMap4.size() : 0));
                    }
                }
                if (bl) {
                    hashMap = hashMap4;
                } else if (bl2) {
                    hashMap = hashMap3;
                } else {
                    hashMap = new HashMap();
                    if (DEBUG) {
                        System.err.println("GLProfile: device could not be initialized: " + abstractGraphicsDevice);
                        System.err.println("GLProfile: compatible w/ desktop: " + bl4 + ", mobile " + bl3);
                        System.err.println("GLProfile: desktoplFactory      " + desktopFactory);
                        System.err.println("GLProfile: mobileFactory        " + mobileFactory);
                        System.err.println("GLProfile: hasGLES1Impl         " + hasGLES1Impl);
                        System.err.println("GLProfile: hasGLES3Impl         " + hasGLES3Impl);
                    }
                }
                GLProfile.setProfileMap(abstractGraphicsDevice, hashMap);
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice, true);
                if (!DEBUG) break block22;
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getUniqueID() + ": added profile(s): desktop " + bl2 + ", mobile " + bl);
                System.err.println("GLProfile.initProfilesForDevice: " + abstractGraphicsDevice.getUniqueID() + ": " + GLProfile.glAvailabilityToString(abstractGraphicsDevice));
                if (!bl2) break block23;
                GLProfile.dumpGLInfo(desktopFactory, abstractGraphicsDevice);
                List<GLCapabilitiesImmutable> list = desktopFactory.getAvailableCapabilities(abstractGraphicsDevice);
                for (int i = 0; i < list.size(); ++i) {
                    System.err.println(list.get(i));
                }
                break block22;
            }
            if (!bl) break block22;
            GLProfile.dumpGLInfo(mobileFactory, abstractGraphicsDevice);
            List<GLCapabilitiesImmutable> list = mobileFactory.getAvailableCapabilities(abstractGraphicsDevice);
            for (int i = 0; i < list.size(); ++i) {
                System.err.println(list.get(i));
            }
        }
        return bl2 || bl;
    }

    private static void dumpGLInfo(GLDrawableFactoryImpl gLDrawableFactoryImpl, AbstractGraphicsDevice abstractGraphicsDevice) {
        GLContext gLContext = gLDrawableFactoryImpl.getOrCreateSharedContext(abstractGraphicsDevice);
        if (null != gLContext) {
            System.err.println("GLProfile.dumpGLInfo: " + gLContext);
            if (0 != gLContext.makeCurrent()) {
                try {
                    System.err.println(JoglVersion.getGLInfo(gLContext.getGL(), null));
                }
                finally {
                    gLContext.release();
                }
            } else {
                System.err.println("GLProfile.dumpGLInfo: Couldn't make context current");
            }
        } else {
            System.err.println("GLProfile.dumpGLInfo: shared context n/a");
            System.err.println(abstractGraphicsDevice.getClass().getSimpleName() + "[type " + abstractGraphicsDevice.getType() + ", connection " + abstractGraphicsDevice.getConnection() + "]:");
            System.err.println(GLProfile.glAvailabilityToString(abstractGraphicsDevice, null, "\t", 1).toString());
        }
    }

    public static AbstractGraphicsDevice getDefaultDevice() {
        GLProfile.initSingleton();
        return defaultDevice;
    }

    private static String array2String(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static void glAvailabilityToString(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder, int n, int n2) {
        String string = GLContext.getAvailableGLVersionAsString(abstractGraphicsDevice, n, n2);
        if (null == string) {
            throw new GLException("Internal Error");
        }
        stringBuilder.append("[");
        stringBuilder.append(string);
        stringBuilder.append("]");
    }

    private static HashMap<String, GLProfile> computeProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl, boolean bl2) {
        if (DEBUG) {
            System.err.println("GLProfile.init map " + abstractGraphicsDevice.getUniqueID() + ", desktopCtxUndef " + bl + ", esCtxUndef " + bl2);
        }
        boolean[] blArray = new boolean[1];
        GLProfile gLProfile = null;
        GLProfile gLProfile2 = null;
        HashMap<String, GLProfile> hashMap = new HashMap<String, GLProfile>(GL_PROFILE_LIST_ALL.length + 1);
        for (int i = 0; i < GL_PROFILE_LIST_ALL.length; ++i) {
            String string = GL_PROFILE_LIST_ALL[i];
            String string2 = GLProfile.computeProfileImpl(abstractGraphicsDevice, string, bl, bl2, blArray);
            if (null != string2) {
                GLProfile gLProfile3;
                if (string.equals(string2)) {
                    gLProfile3 = new GLProfile(string, null, blArray[0], false);
                } else {
                    GLProfile gLProfile4 = hashMap.get(string2);
                    if (null == gLProfile4) {
                        throw new InternalError("XXX0 profile[" + i + "]: " + string + " -> profileImpl " + string2 + " !!! not mapped ");
                    }
                    gLProfile3 = new GLProfile(string, gLProfile4, blArray[0], false);
                }
                hashMap.put(string, gLProfile3);
                if (DEBUG) {
                    System.err.println("GLProfile.init map " + gLProfile3 + " on device " + abstractGraphicsDevice.getUniqueID());
                }
                if (null == gLProfile2 && blArray[0]) {
                    gLProfile2 = gLProfile3;
                    if (!DEBUG) continue;
                    System.err.println("GLProfile.init map defaultHW " + gLProfile3 + " on device " + abstractGraphicsDevice.getUniqueID());
                    continue;
                }
                if (null != gLProfile) continue;
                gLProfile = gLProfile3;
                if (!DEBUG) continue;
                System.err.println("GLProfile.init map defaultAny " + gLProfile3 + " on device " + abstractGraphicsDevice.getUniqueID());
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("GLProfile.init map *** no mapping for " + string + " on device " + abstractGraphicsDevice.getUniqueID());
        }
        if (null != gLProfile2) {
            hashMap.put(GL_DEFAULT, gLProfile2);
        } else if (null != gLProfile) {
            hashMap.put(GL_DEFAULT, gLProfile);
        }
        GLProfile.setProfileMap(abstractGraphicsDevice, hashMap);
        return hashMap;
    }

    private static String computeProfileImpl(AbstractGraphicsDevice abstractGraphicsDevice, String string, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3 = hasGL234Impl || hasGL234OnMobileImpl;
        boolean[] blArray2 = new boolean[1];
        if (GL2ES1 == string) {
            boolean bl4;
            boolean bl5;
            if (hasGLES1Impl) {
                bl5 = bl2 || GLContext.isGLES1Available(abstractGraphicsDevice, blArray2);
                bl4 = bl5 && blArray2[0];
            } else {
                bl5 = false;
                bl4 = false;
            }
            if (bl3) {
                boolean bl6;
                boolean bl7 = GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray2);
                boolean bl8 = bl7 && blArray2[0];
                boolean bl9 = GLContext.isGL2Available(abstractGraphicsDevice, blArray2);
                boolean bl10 = bl9 && blArray2[0];
                boolean bl11 = bl6 = bl8 || bl10 || bl4;
                if (GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray) && (blArray[0] || !bl6)) {
                    return GL4bc;
                }
                if (bl7 && (bl8 || !bl6)) {
                    blArray[0] = bl8;
                    return GL3bc;
                }
                if ((bl || bl9) && (bl10 || !bl6)) {
                    blArray[0] = bl10;
                    return GL2;
                }
            }
            if (bl5) {
                blArray[0] = bl4;
                return GLES1;
            }
        } else if (GL2ES2 == string) {
            boolean bl12;
            boolean bl13;
            boolean bl14;
            boolean bl15;
            if (hasGLES3Impl) {
                bl15 = bl2 || GLContext.isGLES2Available(abstractGraphicsDevice, blArray2);
                bl14 = bl15 && blArray2[0];
                bl13 = bl2 || GLContext.isGLES3Available(abstractGraphicsDevice, blArray2);
                bl12 = bl13 && blArray2[0];
            } else {
                bl15 = false;
                bl14 = false;
                bl13 = false;
                bl12 = false;
            }
            if (bl3) {
                boolean bl16;
                boolean bl17 = GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray2);
                boolean bl18 = bl17 && blArray2[0];
                boolean bl19 = GLContext.isGL3Available(abstractGraphicsDevice, blArray2);
                boolean bl20 = bl19 && blArray2[0];
                boolean bl21 = GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray2);
                boolean bl22 = bl21 && blArray2[0];
                boolean bl23 = GLContext.isGL2Available(abstractGraphicsDevice, blArray2);
                boolean bl24 = bl23 && blArray2[0];
                boolean bl25 = bl16 = bl18 || bl20 || bl22 || bl24 || bl12 || bl14;
                if (GLContext.isGL4Available(abstractGraphicsDevice, blArray) && (blArray[0] || !bl16)) {
                    return GL4;
                }
                if (bl17 && (bl18 || !bl16)) {
                    blArray[0] = bl18;
                    return GL4bc;
                }
                if (bl19 && (bl20 || !bl16)) {
                    blArray[0] = bl20;
                    return GL3;
                }
                if (bl21 && (bl22 || !bl16)) {
                    blArray[0] = bl22;
                    return GL3bc;
                }
                if ((bl || bl23) && (bl24 || !bl16)) {
                    blArray[0] = bl24;
                    return GL2;
                }
            }
            if (bl13 && (bl12 || !bl14)) {
                blArray[0] = bl12;
                return GLES3;
            }
            if (bl15) {
                blArray[0] = bl14;
                return GLES2;
            }
        } else if (GL4ES3 == string) {
            boolean bl26 = GLContext.isGLES3CompatibleAvailable(abstractGraphicsDevice);
            if (bl || bl2 || bl26) {
                boolean bl27;
                boolean[] blArray3 = new boolean[1];
                boolean bl28 = hasGLES3Impl && (bl2 || GLContext.isGLES3Available(abstractGraphicsDevice, blArray3));
                boolean bl29 = bl27 = bl28 && blArray3[0];
                if (bl3) {
                    boolean bl30;
                    boolean bl31 = GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray2);
                    boolean bl32 = bl31 && blArray2[0];
                    boolean bl33 = bl30 = bl32 || bl27;
                    if (GLContext.isGL4Available(abstractGraphicsDevice, blArray) && (blArray[0] || !bl30)) {
                        return GL4;
                    }
                    if ((bl || bl31) && (bl32 || !bl30)) {
                        blArray[0] = bl32;
                        return GL4bc;
                    }
                }
                if (bl28) {
                    blArray[0] = blArray3[0];
                    return GLES3;
                }
            }
        } else if (GL2GL3 == string) {
            if (bl3) {
                boolean bl34;
                boolean bl35 = GLContext.isGL4Available(abstractGraphicsDevice, blArray2);
                boolean bl36 = bl35 && blArray2[0];
                boolean bl37 = GLContext.isGL3Available(abstractGraphicsDevice, blArray2);
                boolean bl38 = bl37 && blArray2[0];
                boolean bl39 = GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray2);
                boolean bl40 = bl39 && blArray2[0];
                boolean bl41 = GLContext.isGL2Available(abstractGraphicsDevice, blArray2);
                boolean bl42 = bl41 && blArray2[0];
                boolean bl43 = bl34 = bl36 || bl38 || bl40 || bl42;
                if (GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray) && (blArray[0] || !bl34)) {
                    return GL4bc;
                }
                if (bl35 && (bl36 || !bl34)) {
                    blArray[0] = bl36;
                    return GL4;
                }
                if (bl39 && (bl40 || !bl34)) {
                    blArray[0] = bl40;
                    return GL3bc;
                }
                if (bl37 && (bl38 || !bl34)) {
                    blArray[0] = bl38;
                    return GL3;
                }
                if (bl || bl41) {
                    blArray[0] = bl42;
                    return GL2;
                }
            }
        } else {
            if (GL4bc == string && bl3 && (bl || GLContext.isGL4bcAvailable(abstractGraphicsDevice, blArray))) {
                return bl ? GL4bc : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 4, 2);
            }
            if (GL4 == string && bl3 && (bl || GLContext.isGL4Available(abstractGraphicsDevice, blArray))) {
                return bl ? GL4 : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 4, 4);
            }
            if (GL3bc == string && bl3 && (bl || GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray))) {
                return bl ? GL3bc : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 3, 2);
            }
            if (GL3 == string && bl3 && (bl || GLContext.isGL3Available(abstractGraphicsDevice, blArray))) {
                return bl ? GL3 : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 3, 4);
            }
            if (GL2 == string && bl3 && (bl || GLContext.isGL2Available(abstractGraphicsDevice, blArray))) {
                if (bl) {
                    return GL2;
                }
                String string2 = GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 2, 2);
                if (GL3bc == string2 && !GLContext.isGL3bcAvailable(abstractGraphicsDevice, blArray)) {
                    return GL2;
                }
                return string2;
            }
            if (GLES3 == string && hasGLES3Impl && (bl2 || GLContext.isGLES3Available(abstractGraphicsDevice, blArray))) {
                return bl2 ? GLES3 : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 3, 8);
            }
            if (GLES2 == string && hasGLES3Impl && (bl2 || GLContext.isGLES2Available(abstractGraphicsDevice, blArray))) {
                return bl2 ? GLES2 : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 2, 8);
            }
            if (GLES1 == string && hasGLES1Impl && (bl2 || GLContext.isGLES1Available(abstractGraphicsDevice, blArray))) {
                return bl2 ? GLES1 : GLContext.getAvailableGLProfileName(abstractGraphicsDevice, 1, 8);
            }
        }
        return null;
    }

    private static HashMap<String, GLProfile> getProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, boolean bl) throws GLException {
        String string;
        HashMap<String, GLProfile> hashMap;
        GLProfile.initSingleton();
        if (null == defaultDevice) {
            throw new GLException("No default device available");
        }
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = defaultDevice;
        }
        if (null != (hashMap = deviceConn2ProfileMap.get(string = abstractGraphicsDevice.getUniqueID()))) {
            return hashMap;
        }
        if (!GLProfile.initProfilesForDevice(abstractGraphicsDevice)) {
            if (bl) {
                throw new GLException("No Profile available for " + abstractGraphicsDevice);
            }
            return null;
        }
        hashMap = deviceConn2ProfileMap.get(string);
        if (null == hashMap && bl) {
            throw new InternalError("initProfilesForDevice(..) didn't setProfileMap(..) for " + abstractGraphicsDevice);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setProfileMap(AbstractGraphicsDevice abstractGraphicsDevice, HashMap<String, GLProfile> hashMap) {
        HashMap<String, HashMap<String, GLProfile>> hashMap2 = deviceConn2ProfileMap;
        synchronized (hashMap2) {
            deviceConn2ProfileMap.put(abstractGraphicsDevice.getUniqueID(), hashMap);
        }
    }

    private GLProfile(String string, GLProfile gLProfile, boolean bl, boolean bl2) {
        this.profile = string;
        this.profileImpl = gLProfile;
        this.isHardwareRasterizer = bl;
        this.isCustom = bl2;
    }

    public static GLProfile createCustomGLProfile(String string, GLProfile gLProfile) {
        return new GLProfile(string, gLProfile, gLProfile.isHardwareRasterizer, true);
    }

    static {
        Platform.initSingleton();
        boolean bl = Platform.OSType.IOS == Platform.getOSType();
        boolean bl2 = Platform.OSType.MACOS == Platform.getOSType() || bl;
        DEBUG = Debug.debug("GLProfile");
        disabledEGL = bl;
        disableOpenGLCore = PropertyAccess.isPropertyDefined("jogl.disable.openglcore", true) && !bl2;
        disableOpenGLARBContext = PropertyAccess.isPropertyDefined("jogl.disable.openglarbcontext", true) && !bl2;
        disableOpenGLES = disableOpenGLARBContext || PropertyAccess.isPropertyDefined("jogl.disable.opengles", true);
        disableOpenGLDesktop = PropertyAccess.isPropertyDefined("jogl.disable.opengldesktop", true);
        disableSurfacelessContext = PropertyAccess.isPropertyDefined("jogl.disable.surfacelesscontext", true);
        enableANGLE = PropertyAccess.isPropertyDefined("jogl.enable.ANGLE", true);
        GL_PROFILE_LIST_ALL = new String[]{GL4bc, GL3bc, GL2, GL4, GL3, GLES3, GL4ES3, GL2GL3, GLES2, GL2ES2, GLES1, GL2ES1};
        GL_PROFILE_LIST_MAX = new String[]{GL4bc, GL4, GL3bc, GL3, GLES3, GL2, GLES2, GLES1};
        GL_PROFILE_LIST_MIN = new String[]{GLES1, GLES2, GL2, GLES3, GL3, GL3bc, GL4, GL4bc};
        GL_PROFILE_LIST_MIN_DESKTOP = new String[]{GL2, GL3bc, GL4bc, GL3, GL4};
        GL_PROFILE_LIST_MAX_MOBILE = new String[]{GLES3, GLES2, GLES1};
        GL_PROFILE_LIST_MAX_FIXEDFUNC = new String[]{GL4bc, GL3bc, GL2, GLES1};
        GL_PROFILE_LIST_MAX_PROGSHADER = new String[]{GL4bc, GL4, GL3bc, GL3, GLES3, GL2, GLES2};
        GL_PROFILE_LIST_MAX_PROGSHADER_CORE = new String[]{GL4, GL3, GLES3, GLES2};
        mobileFactory = null;
        desktopFactory = null;
        defaultDevice = null;
        initialized = false;
        initLock = LockFactory.createRecursiveThreadGroupLock();
        ctorGLArgs = new Class[]{GLProfile.class, GLContextImpl.class};
        ctorProcArgs = new Class[]{FunctionAddressResolver.class};
        deviceConn2ProfileMap = new HashMap();
    }
}

