/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.javafx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.InterruptedRuntimeException;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.common.util.TaskBase;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.javafx.JFXAccessor;
import com.jogamp.newt.Display;
import com.jogamp.newt.util.EDTUtil;
import javafx.application.Platform;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;

public class JFXEDTUtil
implements EDTUtil {
    public static final boolean DEBUG = Debug.debug("EDT");
    private final Object edtLock = new Object();
    private final ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
    private final String name;
    private final Runnable dispatchMessages;
    private NEDT nedt = null;
    private int start_iter = 0;
    private static long pollPeriod = 10L;
    private static Runnable nullTask = new Runnable(){

        @Override
        public void run() {
        }
    };

    public JFXEDTUtil(final Display display) {
        this.name = Thread.currentThread().getName() + "-JFXDisplay-" + display.getFQName() + "-EDT-";
        this.dispatchMessages = new Runnable(){

            @Override
            public void run() {
                ((DisplayImpl)display).dispatchMessages();
            }
        };
        this.nedt = new NEDT(this.threadGroup, this.name);
        this.nedt.setDaemon(true);
    }

    @Override
    public long getPollPeriod() {
        return pollPeriod;
    }

    @Override
    public void setPollPeriod(long l) {
        pollPeriod = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() throws IllegalStateException {
        Object object = this.edtLock;
        synchronized (object) {
            if (this.nedt.isRunning()) {
                Thread thread = Thread.currentThread();
                boolean bl = JFXAccessor.isJFXThread();
                throw new IllegalStateException("EDT still running and not subject to stop. Curr " + thread.getName() + ", NEDT " + this.nedt.getName() + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", JFX-EDT " + JFXAccessor.getJFXThreadName() + ", on JFX-EDT " + bl);
            }
            if (DEBUG) {
                System.err.println(Thread.currentThread() + ": JFX-EDT reset - edt: " + this.nedt);
            }
            if (!JFXAccessor.hasJFXThreadStopped()) {
                if (this.nedt.getState() != Thread.State.NEW) {
                    this.nedt = new NEDT(this.threadGroup, this.name);
                    this.nedt.setDaemon(true);
                }
                this.startImpl();
            }
        }
        if (!JFXAccessor.hasJFXThreadStopped() && !this.nedt.isRunning()) {
            throw new RuntimeException("EDT could not be started: " + this.nedt);
        }
    }

    private final void startImpl() {
        if (this.nedt.isAlive()) {
            throw new RuntimeException("JFX-EDT Thread.isAlive(): true, isRunning: " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop + ", edt: " + this.nedt);
        }
        ++this.start_iter;
        this.nedt.setName(this.name + this.start_iter);
        if (DEBUG) {
            System.err.println(Thread.currentThread() + ": JFX-EDT START - edt: " + this.nedt + ", jfxThread " + JFXAccessor.getJFXThreadName());
        }
        this.nedt.start();
    }

    @Override
    public boolean isCurrentThreadEDT() {
        return JFXAccessor.isJFXThread();
    }

    @Override
    public final boolean isCurrentThreadNEDT() {
        return this.nedt == Thread.currentThread();
    }

    @Override
    public final boolean isCurrentThreadEDTorNEDT() {
        return JFXAccessor.isJFXThread() || Thread.currentThread() == this.nedt;
    }

    @Override
    public boolean isRunning() {
        return this.nedt.isRunning();
    }

    @Override
    public final boolean invokeStop(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, true);
    }

    @Override
    public final boolean invoke(boolean bl, Runnable runnable) {
        return this.invokeImpl(bl, runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean invokeImpl(boolean bl, Runnable runnable, boolean bl2) {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            TaskBase taskBase;
            Object object3 = this.edtLock;
            synchronized (object3) {
                if (this.nedt.shouldStop) {
                    if (DEBUG) {
                        System.err.println(Thread.currentThread() + ": Warning: JFX-EDT about (1) to stop, won't enqueue new task: " + this.nedt + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
                        ExceptionUtils.dumpStack(System.err);
                    }
                    return false;
                }
                boolean bl3 = JFXAccessor.hasJFXThreadStopped();
                if (bl3) {
                    bl2 = true;
                }
                if (this.isCurrentThreadEDT()) {
                    if (null != runnable) {
                        runnable.run();
                    }
                    bl = false;
                    taskBase = null;
                    if (bl2) {
                        this.nedt.shouldStop = true;
                    }
                } else {
                    if (!this.nedt.isRunning && !bl3) {
                        if (null != runnable) {
                            if (bl2) {
                                System.err.println(Thread.currentThread() + ": Warning: JFX-EDT is about (3) to stop and stopped already, dropping task. NEDT " + this.nedt);
                            } else {
                                System.err.println(Thread.currentThread() + ": Warning: JFX-EDT is not running, dropping task. NEDT " + this.nedt);
                            }
                            if (DEBUG) {
                                ExceptionUtils.dumpStack(System.err);
                            }
                        }
                        return false;
                    }
                    if (bl2) {
                        if (this.nedt.isRunning) {
                            if (DEBUG) {
                                System.err.println(Thread.currentThread() + ": JFX-EDT signal STOP (on edt: " + this.isCurrentThreadEDT() + ") - " + this.nedt + ", isRunning " + this.nedt.isRunning + ", shouldStop " + this.nedt.shouldStop);
                            }
                            Object object4 = this.nedt.sync;
                            synchronized (object4) {
                                this.nedt.shouldStop = true;
                                this.nedt.sync.notifyAll();
                            }
                        }
                        if (JFXAccessor.hasJFXThreadStopped()) {
                            System.err.println(Thread.currentThread() + ": Warning: JFX-EDT is about (3) to stop and stopped already, dropping task. " + this.nedt);
                            if (DEBUG) {
                                ExceptionUtils.dumpStack(System.err);
                            }
                            return false;
                        }
                    }
                    if (null != runnable) {
                        taskBase = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
                        Platform.runLater((Runnable)taskBase);
                    } else {
                        bl = false;
                        taskBase = null;
                    }
                }
            }
            if (bl) {
                try {
                    while (taskBase.isInQueue()) {
                        object.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                object3 = taskBase.getThrowable();
                if (null != object3) {
                    if (object3 instanceof NativeWindowException) {
                        throw (NativeWindowException)object3;
                    }
                    throw new RuntimeException((Throwable)object3);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilIdle() {
        NEDT nEDT;
        Object object = this.edtLock;
        synchronized (object) {
            nEDT = this.nedt;
        }
        if (!nEDT.isRunning || Thread.currentThread() == nEDT || JFXAccessor.hasJFXThreadStopped() || JFXAccessor.isJFXThread()) {
            return false;
        }
        JFXAccessor.runOnJFXThread(true, nullTask);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean waitUntilStopped() {
        Object object = this.edtLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            boolean bl = JFXAccessor.isJFXThread();
            if (this.nedt.isRunning && this.nedt != thread && !bl) {
                try {
                    while (this.nedt.isRunning) {
                        this.edtLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedRuntimeException(interruptedException);
                }
                return true;
            }
            return false;
        }
    }

    class NEDT
    extends InterruptSource.Thread {
        volatile boolean shouldStop;
        volatile boolean isRunning;
        Object sync;

        public NEDT(ThreadGroup threadGroup, String string) {
            super(threadGroup, null, string);
            this.shouldStop = false;
            this.isRunning = false;
            this.sync = new Object();
        }

        public final boolean isRunning() {
            return this.isRunning && !this.shouldStop;
        }

        @Override
        public final void start() throws IllegalThreadStateException {
            this.isRunning = true;
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            if (DEBUG) {
                System.err.println(this.getName() + ": JFX-EDT run() START " + this.getName());
            }
            RuntimeException runtimeException = null;
            try {
                do {
                    if (!this.shouldStop) {
                        JFXAccessor.runOnJFXThread(true, JFXEDTUtil.this.dispatchMessages);
                    }
                    object = this.sync;
                    synchronized (object) {
                        if (!this.shouldStop) {
                            try {
                                this.sync.wait(pollPeriod);
                            }
                            catch (InterruptedException interruptedException) {
                                throw new InterruptedRuntimeException(interruptedException);
                            }
                        }
                    }
                } while (!this.shouldStop);
            }
            catch (Throwable throwable) {
                this.shouldStop = true;
                if (throwable instanceof RuntimeException) {
                    runtimeException = (RuntimeException)throwable;
                }
                runtimeException = new RuntimeException("Within JFX-EDT", throwable);
            }
            finally {
                if (DEBUG) {
                    System.err.println(this.getName() + ": JFX-EDT run() END " + this.getName() + ", " + runtimeException);
                }
                object = JFXEDTUtil.this.edtLock;
                synchronized (object) {
                    this.isRunning = false;
                    JFXEDTUtil.this.edtLock.notifyAll();
                }
                if (DEBUG) {
                    System.err.println(this.getName() + ": JFX-EDT run() EXIT " + this.getName() + ", exception: " + runtimeException);
                }
                if (null != runtimeException) {
                    throw runtimeException;
                }
            }
        }
    }
}

