/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.oculusvr.OVR;
import com.jogamp.oculusvr.OVRException;
import com.jogamp.oculusvr.ovrDistortionMesh;
import com.jogamp.oculusvr.ovrDistortionVertex;
import com.jogamp.oculusvr.ovrEyeRenderDesc;
import com.jogamp.oculusvr.ovrFovPort;
import com.jogamp.oculusvr.ovrFrameTiming;
import com.jogamp.oculusvr.ovrHmdDesc;
import com.jogamp.oculusvr.ovrMatrix4f;
import com.jogamp.oculusvr.ovrPosef;
import com.jogamp.oculusvr.ovrRecti;
import com.jogamp.oculusvr.ovrSizei;
import com.jogamp.oculusvr.ovrTrackingState;
import com.jogamp.oculusvr.ovrVector2f;
import com.jogamp.oculusvr.ovrVector3f;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoUtil;
import com.jogamp.opengl.util.stereo.ViewerPose;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.opengl.oculusvr.OVRStereoDevice;
import jogamp.opengl.oculusvr.OVRUtil;

public class OVRStereoDeviceRenderer
implements StereoDeviceRenderer {
    private static final String shaderPrefix01 = "dist01";
    private static final String shaderTimewarpSuffix = "_timewarp";
    private static final String shaderChromaSuffix = "_chroma";
    private static final String shaderPlainSuffix = "_plain";
    private final OVRStereoDevice context;
    private final OVREye[] eyes;
    private final ovrPosef[] ovrEyePoses;
    private final ovrVector3f[] hmdToEyeViewOffset;
    private final ViewerPose viewerPose;
    private final ovrTrackingState trackingState;
    private final int distortionBits;
    private final int textureCount;
    private final DimensionImmutable[] eyeTextureSizes;
    private final DimensionImmutable totalTextureSize;
    private final GLUniformData texUnit0;
    private final float[] mat4Tmp1 = new float[16];
    private final float[] mat4Tmp2 = new float[16];
    private ShaderProgram sp;
    private ovrFrameTiming frameTiming;
    private int frameCount;

    public String toString() {
        return "OVRDist[distortion[" + StereoUtil.distortionBitsToString(this.distortionBits) + "], eyeTexSize " + Arrays.toString(this.eyeTextureSizes) + ", sbsSize " + this.totalTextureSize + ", texCount " + this.textureCount + ", texUnit " + this.getTextureUnit() + ", " + PlatformPropsImpl.NEWLINE + "  " + this.eyes[0] + ", " + PlatformPropsImpl.NEWLINE + "  " + this.eyes[1] + "]";
    }

    private static int distBits2OVRDistCaps(int n) {
        int n2 = 0;
        if (StereoUtil.usesTimewarpDistortion(n)) {
            n2 |= 2;
        }
        if (StereoUtil.usesChromaticDistortion(n)) {
            n2 |= 1;
        }
        if (StereoUtil.usesVignetteDistortion(n)) {
            n2 |= 8;
        }
        return n2;
    }

    OVRStereoDeviceRenderer(OVRStereoDevice oVRStereoDevice, int n, int n2, float[] fArray, ovrEyeRenderDesc[] ovrEyeRenderDescArray, DimensionImmutable[] dimensionImmutableArray, DimensionImmutable dimensionImmutable, RectangleImmutable[] rectangleImmutableArray, int n3) {
        ovrSizei ovrSizei2;
        ovrSizei ovrSizei3;
        if (1 > n2 || 2 < n2) {
            throw new IllegalArgumentException("textureCount can only be 1 or 2, has " + n2);
        }
        this.context = oVRStereoDevice;
        this.eyes = new OVREye[2];
        this.distortionBits = (n | oVRStereoDevice.getMinimumDistortionBits()) & oVRStereoDevice.getSupportedDistortionBits();
        this.textureCount = n2;
        this.eyeTextureSizes = dimensionImmutableArray;
        this.totalTextureSize = dimensionImmutable;
        this.texUnit0 = new GLUniformData("ovr_Texture0", n3);
        if (1 == n2) {
            ovrSizei2 = ovrSizei3 = OVRUtil.createOVRSizei(dimensionImmutable);
        } else {
            ovrSizei3 = OVRUtil.createOVRSizei(dimensionImmutableArray[0]);
            ovrSizei2 = OVRUtil.createOVRSizei(dimensionImmutableArray[1]);
        }
        this.eyes[0] = new OVREye(oVRStereoDevice.hmdDesc, this.distortionBits, fArray, ovrEyeRenderDescArray[0], ovrSizei3, rectangleImmutableArray[0]);
        this.eyes[1] = new OVREye(oVRStereoDevice.hmdDesc, this.distortionBits, fArray, ovrEyeRenderDescArray[1], ovrSizei2, rectangleImmutableArray[1]);
        this.ovrEyePoses = new ovrPosef[2];
        this.ovrEyePoses[0] = ovrPosef.create();
        this.ovrEyePoses[1] = ovrPosef.create();
        this.hmdToEyeViewOffset = new ovrVector3f[2];
        this.hmdToEyeViewOffset[0] = this.eyes[0].ovrEyeDesc.getHmdToEyeViewOffset();
        this.hmdToEyeViewOffset[1] = this.eyes[1].ovrEyeDesc.getHmdToEyeViewOffset();
        this.viewerPose = new ViewerPose();
        this.trackingState = ovrTrackingState.create();
        this.sp = null;
        this.frameTiming = null;
        this.frameCount = 0;
    }

    @Override
    public StereoDevice getDevice() {
        return this.context;
    }

    @Override
    public final int getDistortionBits() {
        return this.distortionBits;
    }

    @Override
    public final boolean usesSideBySideStereo() {
        return true;
    }

    @Override
    public final DimensionImmutable[] getEyeSurfaceSize() {
        return this.eyeTextureSizes;
    }

    @Override
    public final DimensionImmutable getTotalSurfaceSize() {
        return this.totalTextureSize;
    }

    @Override
    public final int getTextureCount() {
        return this.textureCount;
    }

    @Override
    public final int getTextureUnit() {
        return this.texUnit0.intValue();
    }

    @Override
    public final boolean ppAvailable() {
        return 0 != this.distortionBits;
    }

    @Override
    public final void init(GL gL) {
        if (StereoDevice.DEBUG) {
            System.err.println(JoglVersion.getGLInfo(gL, null).toString());
        }
        if (null != this.sp) {
            throw new IllegalStateException("Already initialized");
        }
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        boolean bl = StereoUtil.usesTimewarpDistortion(this.distortionBits);
        boolean bl2 = StereoUtil.usesChromaticDistortion(this.distortionBits);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(shaderPrefix01);
        if (!bl2 && !bl) {
            stringBuilder.append(shaderPlainSuffix);
        } else if (bl2 && !bl) {
            stringBuilder.append(shaderChromaSuffix);
        } else if (bl) {
            stringBuilder.append(shaderTimewarpSuffix);
            if (bl2) {
                stringBuilder.append(shaderChromaSuffix);
            }
        }
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append(shaderPrefix01);
        if (bl2) {
            stringBuilder.append(shaderChromaSuffix);
        } else {
            stringBuilder.append(shaderPlainSuffix);
        }
        String string2 = stringBuilder.toString();
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, OVRStereoDeviceRenderer.class, "shader", "shader/bin", string, true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, OVRStereoDeviceRenderer.class, "shader", "shader/bin", string2, true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        this.sp = new ShaderProgram();
        this.sp.add(gL2ES2, shaderCode, System.err);
        this.sp.add(gL2ES2, shaderCode2, System.err);
        if (!this.sp.link(gL2ES2, System.err)) {
            throw new GLException("could not link program: " + this.sp);
        }
        this.sp.useProgram(gL2ES2, true);
        if (0 > this.texUnit0.setLocation(gL2ES2, this.sp.program())) {
            throw new OVRException("Couldn't locate " + this.texUnit0);
        }
        this.eyes[0].linkData(gL2ES2, this.sp);
        this.eyes[1].linkData(gL2ES2, this.sp);
        this.sp.useProgram(gL2ES2, false);
    }

    @Override
    public final void dispose(GL gL) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        this.sp.useProgram(gL2ES2, false);
        this.eyes[0].dispose(gL2ES2);
        this.eyes[1].dispose(gL2ES2);
        this.sp.destroy(gL2ES2);
        this.frameTiming = null;
    }

    @Override
    public final StereoDeviceRenderer.Eye getEye(int n) {
        return this.eyes[n];
    }

    @Override
    public final ViewerPose updateViewerPose() {
        ovrTrackingState ovrTrackingState2 = this.trackingState;
        OVR.ovrHmd_GetEyePoses(this.context.hmdDesc, this.frameCount, this.hmdToEyeViewOffset, this.ovrEyePoses, ovrTrackingState2);
        this.context.updateUsedSensorBits(ovrTrackingState2);
        ovrPosef ovrPosef2 = ovrTrackingState2.getHeadPose().getThePose();
        ovrVector3f ovrVector3f2 = ovrPosef2.getPosition();
        this.viewerPose.setPosition(ovrVector3f2.getX(), ovrVector3f2.getY(), ovrVector3f2.getZ());
        OVRUtil.copyToQuaternion(ovrPosef2.getOrientation(), this.viewerPose.orientation);
        return this.viewerPose;
    }

    @Override
    public final ViewerPose getLastViewerPose() {
        return this.viewerPose;
    }

    @Override
    public final void beginFrame(GL gL) {
        this.frameTiming = OVR.ovrHmd_BeginFrameTiming(this.context.hmdDesc, this.frameCount);
    }

    @Override
    public final void endFrame(GL gL) {
        if (null == this.frameTiming) {
            throw new IllegalStateException("beginFrame not called");
        }
        OVR.ovrHmd_EndFrameTiming(this.context.hmdDesc);
        this.frameTiming = null;
        ++this.frameCount;
    }

    @Override
    public final void ppBegin(GL gL) {
        if (null == this.sp) {
            throw new IllegalStateException("Not initialized");
        }
        if (null == this.frameTiming) {
            throw new IllegalStateException("beginFrame not called");
        }
        if (StereoUtil.usesTimewarpDistortion(this.distortionBits)) {
            OVR.ovr_WaitTillTime(this.frameTiming.getTimewarpPointSeconds());
        }
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL.glClear(16384);
        gL.glActiveTexture(33984 + this.getTextureUnit());
        gL2ES2.glDisable(2884);
        gL2ES2.glDisable(2929);
        gL2ES2.glDisable(3042);
        if (!gL2ES2.isGLcore()) {
            gL2ES2.glEnable(3553);
        }
        this.sp.useProgram(gL2ES2, true);
        gL2ES2.glUniform(this.texUnit0);
    }

    @Override
    public final void ppOneEye(GL gL, int n) {
        OVREye oVREye = this.eyes[n];
        if (StereoUtil.usesTimewarpDistortion(this.distortionBits)) {
            oVREye.updateTimewarp(this.context.hmdDesc, this.ovrEyePoses[n], this.mat4Tmp1, this.mat4Tmp2);
        }
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        oVREye.updateUniform(gL2ES2, this.sp);
        oVREye.enableVBO(gL2ES2, true);
        gL2ES2.glDrawElements(4, oVREye.indexCount, 5123, 0L);
        this.eyes[n].enableVBO(gL2ES2, false);
    }

    @Override
    public final void ppEnd(GL gL) {
        this.sp.useProgram(gL.getGL2ES2(), false);
    }

    public static class OVREye
    implements StereoDeviceRenderer.Eye {
        private final int eyeName;
        private final int distortionBits;
        private final int vertexCount;
        private final int indexCount;
        private final RectangleImmutable viewport;
        private final GLUniformData eyeToSourceUVScale;
        private final GLUniformData eyeToSourceUVOffset;
        private final GLUniformData eyeRotationStart;
        private final GLUniformData eyeRotationEnd;
        private final GLArrayDataServer iVBO;
        private final GLArrayData vboPos;
        private final GLArrayData vboParams;
        private final GLArrayData vboTexCoordsR;
        private final GLArrayData vboTexCoordsG;
        private final GLArrayData vboTexCoordsB;
        private final GLArrayDataServer indices;
        final ovrEyeRenderDesc ovrEyeDesc;
        private final ovrFovPort ovrEyeFov;
        private final EyeParameter eyeParameter;
        private final ovrMatrix4f[] timeWarpMatrices;

        @Override
        public final RectangleImmutable getViewport() {
            return this.viewport;
        }

        @Override
        public final EyeParameter getEyeParameter() {
            return this.eyeParameter;
        }

        OVREye(ovrHmdDesc ovrHmdDesc2, int n, float[] fArray, ovrEyeRenderDesc ovrEyeRenderDesc2, ovrSizei ovrSizei2, RectangleImmutable rectangleImmutable) {
            this.eyeName = ovrEyeRenderDesc2.getEye();
            this.distortionBits = n;
            this.viewport = rectangleImmutable;
            boolean bl = StereoUtil.usesTimewarpDistortion(n);
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(4 + (bl ? 32 : 0));
            this.eyeToSourceUVScale = new GLUniformData("ovr_EyeToSourceUVScale", 2, Buffers.slice2Float(floatBuffer, 0, 2));
            this.eyeToSourceUVOffset = new GLUniformData("ovr_EyeToSourceUVOffset", 2, Buffers.slice2Float(floatBuffer, 2, 2));
            if (bl) {
                this.eyeRotationStart = new GLUniformData("ovr_EyeRotationStart", 4, 4, Buffers.slice2Float(floatBuffer, 4, 16));
                this.eyeRotationEnd = new GLUniformData("ovr_EyeRotationEnd", 4, 4, Buffers.slice2Float(floatBuffer, 20, 16));
                this.timeWarpMatrices = new ovrMatrix4f[2];
                this.timeWarpMatrices[0] = ovrMatrix4f.create();
                this.timeWarpMatrices[1] = ovrMatrix4f.create();
            } else {
                this.eyeRotationStart = null;
                this.eyeRotationEnd = null;
                this.timeWarpMatrices = null;
            }
            this.ovrEyeDesc = ovrEyeRenderDesc2;
            this.ovrEyeFov = ovrEyeRenderDesc2.getFov();
            ovrVector3f ovrVector3f2 = ovrEyeRenderDesc2.getHmdToEyeViewOffset();
            this.eyeParameter = new EyeParameter(this.eyeName, fArray, OVRUtil.getFovHV(this.ovrEyeFov), ovrVector3f2.getX(), ovrVector3f2.getY(), ovrVector3f2.getZ());
            Object object = new ovrVector2f[]{ovrVector2f.create(), ovrVector2f.create()};
            ovrRecti ovrRecti2 = OVRUtil.createOVRRecti(rectangleImmutable);
            OVR.ovrHmd_GetRenderScaleAndOffset(this.ovrEyeFov, ovrSizei2, ovrRecti2, (ovrVector2f[])object);
            if (StereoDevice.DEBUG) {
                System.err.println("XXX." + this.eyeName + ": eyeParam      " + this.eyeParameter);
                System.err.println("XXX." + this.eyeName + ": uvScale       " + OVRUtil.toString(object[0]));
                System.err.println("XXX." + this.eyeName + ": uvOffset      " + OVRUtil.toString(object[1]));
                System.err.println("XXX." + this.eyeName + ": textureSize   " + OVRUtil.toString(ovrSizei2));
                System.err.println("XXX." + this.eyeName + ": viewport      " + OVRUtil.toString(ovrRecti2));
            }
            FloatBuffer floatBuffer2 = this.eyeToSourceUVScale.floatBufferValue();
            floatBuffer2.put(0, object[0].getX());
            floatBuffer2.put(1, object[0].getY());
            FloatBuffer floatBuffer3 = this.eyeToSourceUVOffset.floatBufferValue();
            floatBuffer3.put(0, object[1].getX());
            floatBuffer3.put(1, object[1].getY());
            object = ovrDistortionMesh.create();
            int n2 = OVRStereoDeviceRenderer.distBits2OVRDistCaps(n);
            if (!OVR.ovrHmd_CreateDistortionMesh(ovrHmdDesc2, this.eyeName, this.ovrEyeFov, n2, (ovrDistortionMesh)object)) {
                throw new OVRException("Failed to create meshData for eye " + this.eyeName + ", " + OVRUtil.toString(this.ovrEyeFov) + " and " + StereoUtil.distortionBitsToString(n));
            }
            this.vertexCount = ((ovrDistortionMesh)object).getVertexCount();
            this.indexCount = ((ovrDistortionMesh)object).getIndexCount();
            boolean bl2 = StereoUtil.usesChromaticDistortion(n);
            boolean bl3 = StereoUtil.usesVignetteDistortion(n);
            int n3 = 6 + (bl2 ? 4 : 0);
            this.iVBO = GLArrayDataServer.createGLSLInterleaved(n3, 5126, false, this.vertexCount, 35044);
            this.vboPos = this.iVBO.addGLSLSubArray("ovr_Position", 2, 34962);
            this.vboParams = this.iVBO.addGLSLSubArray("ovr_Params", 2, 34962);
            this.vboTexCoordsR = this.iVBO.addGLSLSubArray("ovr_TexCoordR", 2, 34962);
            if (bl2) {
                this.vboTexCoordsG = this.iVBO.addGLSLSubArray("ovr_TexCoordG", 2, 34962);
                this.vboTexCoordsB = this.iVBO.addGLSLSubArray("ovr_TexCoordB", 2, 34962);
            } else {
                this.vboTexCoordsG = null;
                this.vboTexCoordsB = null;
            }
            this.indices = GLArrayDataServer.createData(1, 5122, this.indexCount, 35044, 34963);
            FloatBuffer floatBuffer4 = (FloatBuffer)this.iVBO.getBuffer();
            ovrDistortionVertex[] ovrDistortionVertexArray = new ovrDistortionVertex[]{ovrDistortionVertex.create()};
            for (int i = 0; i < this.vertexCount; ++i) {
                ovrDistortionVertex ovrDistortionVertex2 = ((ovrDistortionMesh)object).getPVertexData(i, ovrDistortionVertexArray)[0];
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": START VERTEX " + i + " / " + this.vertexCount);
                }
                ovrVector2f ovrVector2f2 = ovrDistortionVertex2.getScreenPosNDC();
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": pos " + OVRUtil.toString(ovrVector2f2));
                }
                floatBuffer4.put(ovrVector2f2.getX());
                floatBuffer4.put(ovrVector2f2.getY());
                if (bl3) {
                    if (StereoDevice.DUMP_DATA) {
                        System.err.println("XXX." + this.eyeName + ": vignette " + ovrDistortionVertex2.getVignetteFactor());
                    }
                    floatBuffer4.put(ovrDistortionVertex2.getVignetteFactor());
                } else {
                    floatBuffer4.put(1.0f);
                }
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": timewarp " + ovrDistortionVertex2.getTimeWarpFactor());
                }
                floatBuffer4.put(ovrDistortionVertex2.getTimeWarpFactor());
                ovrVector2f2 = ovrDistortionVertex2.getTanEyeAnglesR();
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": texR " + OVRUtil.toString(ovrVector2f2));
                }
                floatBuffer4.put(ovrVector2f2.getX());
                floatBuffer4.put(ovrVector2f2.getY());
                if (!bl2) continue;
                ovrVector2f2 = ovrDistortionVertex2.getTanEyeAnglesG();
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": texG " + OVRUtil.toString(ovrVector2f2));
                }
                floatBuffer4.put(ovrVector2f2.getX());
                floatBuffer4.put(ovrVector2f2.getY());
                ovrVector2f2 = ovrDistortionVertex2.getTanEyeAnglesB();
                if (StereoDevice.DUMP_DATA) {
                    System.err.println("XXX." + this.eyeName + ": texB " + OVRUtil.toString(ovrVector2f2));
                }
                floatBuffer4.put(ovrVector2f2.getX());
                floatBuffer4.put(ovrVector2f2.getY());
            }
            if (StereoDevice.DUMP_DATA) {
                System.err.println("XXX." + this.eyeName + ": iVBO " + this.iVBO);
            }
            ShortBuffer shortBuffer = ((ovrDistortionMesh)object).getPIndexData();
            if (StereoDevice.DUMP_DATA) {
                System.err.println("XXX." + this.eyeName + ": idx " + this.indices + ", count " + this.indexCount);
                for (int i = 0; i < this.indexCount; ++i) {
                    if (0 == i % 16) {
                        System.err.printf("%n%5d: ", i);
                    }
                    System.err.printf("%5d, ", shortBuffer.get(i));
                }
                System.err.println();
            }
            ShortBuffer shortBuffer2 = (ShortBuffer)this.indices.getBuffer();
            shortBuffer2.put(shortBuffer);
            if (StereoDevice.DEBUG) {
                System.err.println("XXX." + this.eyeName + ": " + this);
            }
            OVR.ovrHmd_DestroyDistortionMesh((ovrDistortionMesh)object);
        }

        void linkData(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
            if (0 > this.vboPos.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.vboPos);
            }
            if (0 > this.vboParams.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.vboParams);
            }
            if (0 > this.vboTexCoordsR.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.vboTexCoordsR);
            }
            if (StereoUtil.usesChromaticDistortion(this.distortionBits)) {
                if (0 > this.vboTexCoordsG.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.vboTexCoordsG);
                }
                if (0 > this.vboTexCoordsB.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.vboTexCoordsB);
                }
            }
            if (0 > this.eyeToSourceUVScale.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.eyeToSourceUVScale);
            }
            if (0 > this.eyeToSourceUVOffset.setLocation(gL2ES2, shaderProgram.program())) {
                throw new GLException("Couldn't locate " + this.eyeToSourceUVOffset);
            }
            if (StereoUtil.usesTimewarpDistortion(this.distortionBits)) {
                if (0 > this.eyeRotationStart.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.eyeRotationStart);
                }
                if (0 > this.eyeRotationEnd.setLocation(gL2ES2, shaderProgram.program())) {
                    throw new GLException("Couldn't locate " + this.eyeRotationEnd);
                }
            }
            this.iVBO.seal(gL2ES2, true);
            this.iVBO.enableBuffer(gL2ES2, false);
            this.indices.seal(gL2ES2, true);
            this.indices.enableBuffer(gL2ES2, false);
        }

        void dispose(GL2ES2 gL2ES2) {
            this.iVBO.destroy(gL2ES2);
            this.indices.destroy(gL2ES2);
        }

        void enableVBO(GL2ES2 gL2ES2, boolean bl) {
            this.iVBO.enableBuffer(gL2ES2, bl);
            this.indices.bindBuffer(gL2ES2, bl);
        }

        void updateUniform(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
            gL2ES2.glUniform(this.eyeToSourceUVScale);
            gL2ES2.glUniform(this.eyeToSourceUVOffset);
            if (StereoUtil.usesTimewarpDistortion(this.distortionBits)) {
                gL2ES2.glUniform(this.eyeRotationStart);
                gL2ES2.glUniform(this.eyeRotationEnd);
            }
        }

        void updateTimewarp(ovrHmdDesc ovrHmdDesc2, ovrPosef ovrPosef2, float[] fArray, float[] fArray2) {
            OVR.ovrHmd_GetEyeTimewarpMatrices(ovrHmdDesc2, this.eyeName, ovrPosef2, this.timeWarpMatrices);
            float[] fArray3 = FloatUtil.transposeMatrix(this.timeWarpMatrices[0].getM(0, fArray), fArray2);
            FloatBuffer floatBuffer = this.eyeRotationStart.floatBufferValue();
            floatBuffer.put(fArray3);
            floatBuffer.rewind();
            float[] fArray4 = FloatUtil.transposeMatrix(this.timeWarpMatrices[1].getM(0, fArray), fArray2);
            FloatBuffer floatBuffer2 = this.eyeRotationEnd.floatBufferValue();
            floatBuffer2.put(fArray4);
            floatBuffer2.rewind();
        }

        public String toString() {
            return "Eye[" + this.eyeName + ", viewport " + this.viewport + ", " + this.eyeParameter + ", vertices " + this.vertexCount + ", indices " + this.indexCount + ", uvScale[" + this.eyeToSourceUVScale.floatBufferValue().get(0) + ", " + this.eyeToSourceUVScale.floatBufferValue().get(1) + "], uvOffset[" + this.eyeToSourceUVOffset.floatBufferValue().get(0) + ", " + this.eyeToSourceUVOffset.floatBufferValue().get(1) + "], desc" + OVRUtil.toString(this.ovrEyeDesc) + "]";
        }
    }
}

