/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr.stereo.lense;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceConfig;
import jogamp.opengl.oculusvr.stereo.lense.DistortionSpec;
import jogamp.opengl.util.stereo.DistortionMesh;
import jogamp.opengl.util.stereo.ScaleAndOffset2D;

public class DistortionMeshProducer
implements DistortionMesh.Producer {
    private DistortionSpec[] distortionSpecs = null;
    private GenericStereoDeviceConfig deviceConfig = null;
    private final float[] eyeReliefInMeters = new float[]{0.0f, 0.0f};
    private static final int DMA_GridSizeLog2 = 6;
    private static final int DMA_GridSize = 64;
    private static final int DMA_NumVertsPerEye = 4225;
    private static final int DMA_NumTrisPerEye = 8192;

    @Override
    public void init(GenericStereoDeviceConfig genericStereoDeviceConfig, float[] fArray) throws IllegalStateException {
        if (null != this.deviceConfig) {
            throw new IllegalStateException("Already initialized");
        }
        System.arraycopy(fArray, 0, this.eyeReliefInMeters, 0, 2);
        this.distortionSpecs = DistortionSpec.CalculateDistortionSpec(genericStereoDeviceConfig, fArray);
        this.deviceConfig = genericStereoDeviceConfig;
    }

    private static float[] TransformTanFovSpaceToScreenNDC(DistortionSpec distortionSpec, float[] fArray, boolean bl) {
        float f = VectorUtil.normVec2(fArray);
        float f2 = distortionSpec.lens.DistortionFnInverseApprox(f);
        if (!bl) {
            f2 = distortionSpec.lens.DistortionFnInverse(f);
        }
        float[] fArray2 = new float[2];
        float[] fArray3 = f > 0.0f ? VectorUtil.scaleVec2(fArray2, fArray, f2 / f) : fArray;
        float[] fArray4 = VectorUtil.addVec2(fArray2, VectorUtil.divVec2(fArray2, fArray3, distortionSpec.tanEyeAngleScale), distortionSpec.lensCenter);
        return fArray4;
    }

    private static void TransformScreenNDCToTanFovSpaceChroma(float[] fArray, float[] fArray2, float[] fArray3, DistortionSpec distortionSpec, float[] fArray4) {
        float[] fArray5 = new float[2];
        float[] fArray6 = VectorUtil.scaleVec2(fArray5, VectorUtil.subVec2(fArray5, fArray4, distortionSpec.lensCenter), distortionSpec.tanEyeAngleScale);
        float f = fArray6[0] * fArray6[0] + fArray6[1] * fArray6[1];
        float[] fArray7 = distortionSpec.lens.DistortionFnScaleRadiusSquaredChroma(f);
        VectorUtil.scaleVec2(fArray, fArray6, fArray7[0]);
        VectorUtil.scaleVec2(fArray2, fArray6, fArray7[1]);
        VectorUtil.scaleVec2(fArray3, fArray6, fArray7[2]);
    }

    @Override
    public final DistortionMesh create(EyeParameter eyeParameter, int n) {
        int n2;
        int n3;
        ScaleAndOffset2D scaleAndOffset2D = new ScaleAndOffset2D(eyeParameter.fovhv);
        boolean bl = 1 == eyeParameter.number;
        float f = 0.0f;
        float f2 = 0.0f;
        if (bl) {
            f = 1.0f;
            f2 = 0.5f;
        }
        DistortionMesh.DistortionVertex[] distortionVertexArray = new DistortionMesh.DistortionVertex[4225];
        int n4 = 0;
        float[] fArray = new float[2];
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        for (int i = 0; i <= 64; ++i) {
            for (n3 = 0; n3 <= 64; ++n3) {
                float f3;
                float[] fArray4 = new float[10];
                n2 = 0;
                float[] fArray5 = new float[]{2.0f * ((float)n3 / 64.0f) - 1.0f, 2.0f * ((float)i / 64.0f) - 1.0f};
                float[] fArray6 = scaleAndOffset2D.convertToTanFovSpace(fArray5);
                float[] fArray7 = DistortionMeshProducer.TransformTanFovSpaceToScreenNDC(this.distortionSpecs[eyeParameter.number], fArray6, false);
                float f4 = 13.333333f * (1.0f - Math.max(FloatUtil.abs(fArray5[0]), FloatUtil.abs(fArray5[0])));
                float f5 = 26.666666f * (1.0f - Math.max(FloatUtil.abs(fArray7[0]), FloatUtil.abs(fArray7[1])));
                f4 = Math.min(f5, f4);
                switch (this.deviceConfig.shutterType) {
                    case Global: {
                        f3 = 0.0f;
                        break;
                    }
                    case RollingLeftToRight: {
                        f3 = fArray7[0] * 0.25f + 0.25f;
                        if (!bl) break;
                        f3 += 0.5f;
                        break;
                    }
                    case RollingRightToLeft: {
                        f3 = 0.75f - fArray7[0] * 0.25f;
                        if (!bl) break;
                        f3 -= 0.5f;
                        break;
                    }
                    case RollingTopToBottom: {
                        f3 = fArray7[1] * 0.5f + 0.5f;
                        break;
                    }
                    default: {
                        f3 = 0.0f;
                    }
                }
                DistortionMeshProducer.TransformScreenNDCToTanFovSpaceChroma(fArray, fArray2, fArray3, this.distortionSpecs[eyeParameter.number], fArray7);
                fArray7[0] = Math.max(-1.0f, Math.min(fArray7[0], 1.0f));
                fArray7[1] = Math.max(-1.0f, Math.min(fArray7[1], 1.0f));
                fArray4[n2++] = 0.5f * fArray7[0] - 0.5f + f;
                fArray4[n2++] = -fArray7[1];
                fArray4[n2++] = Math.max(0.0f, Math.min(f4, 1.0f));
                fArray4[n2++] = f3;
                fArray4[n2++] = fArray[0];
                fArray4[n2++] = fArray[1];
                fArray4[n2++] = fArray2[0];
                fArray4[n2++] = fArray2[1];
                fArray4[n2++] = fArray3[0];
                fArray4[n2++] = fArray3[1];
                distortionVertexArray[n4++] = new DistortionMesh.DistortionVertex(fArray4, 2, 1, 1, 2, 2, 2);
            }
        }
        short[] sArray = new short[24576];
        n3 = 0;
        for (int i = 0; i < 4096; ++i) {
            n2 = (i & 1) >> 0 | (i & 4) >> 1 | (i & 0x10) >> 2 | (i & 0x40) >> 3 | (i & 0x100) >> 4 | (i & 0x400) >> 5 | (i & 0x1000) >> 6 | (i & 0x4000) >> 7;
            int n5 = (i & 2) >> 1 | (i & 8) >> 2 | (i & 0x20) >> 3 | (i & 0x80) >> 4 | (i & 0x200) >> 5 | (i & 0x800) >> 6 | (i & 0x2000) >> 7 | (i & 0x8000) >> 8;
            int n6 = n2 * 65 + n5;
            if (n2 < 32 != n5 < 32) {
                sArray[n3++] = (short)n6;
                sArray[n3++] = (short)(n6 + 1);
                sArray[n3++] = (short)(n6 + 65 + 1);
                sArray[n3++] = (short)(n6 + 65 + 1);
                sArray[n3++] = (short)(n6 + 65);
                sArray[n3++] = (short)n6;
                continue;
            }
            sArray[n3++] = (short)n6;
            sArray[n3++] = (short)(n6 + 1);
            sArray[n3++] = (short)(n6 + 65);
            sArray[n3++] = (short)(n6 + 1);
            sArray[n3++] = (short)(n6 + 65 + 1);
            sArray[n3++] = (short)(n6 + 65);
        }
        return new DistortionMesh(distortionVertexArray, distortionVertexArray.length, sArray, sArray.length);
    }
}

