/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr.stereo.lense;

public class LensConfig {
    public static final int NumCoefficients = 11;
    private DistortionEquation eqn;
    float MetersPerTanAngleAtCenter;
    private final float[] K;
    private final float[] InvK;
    private float MaxR;
    private float MaxInvR;
    private final float[] ChromaticAberration = new float[4];

    public LensConfig() {
        this.K = new float[11];
        this.InvK = new float[11];
        this.SetToIdentity();
    }

    public LensConfig(DistortionEquation distortionEquation, float f, float[] fArray) {
        this.K = new float[11];
        this.InvK = new float[11];
        this.SetToIdentity();
        this.eqn = distortionEquation;
        this.MetersPerTanAngleAtCenter = f;
        System.arraycopy(fArray, 0, this.K, 0, fArray.length);
        this.ChromaticAberration[0] = -0.006f;
        this.ChromaticAberration[1] = 0.0f;
        this.ChromaticAberration[2] = 0.014f;
        this.ChromaticAberration[3] = 0.0f;
    }

    private void SetUpInverseApprox() {
        switch (this.eqn) {
            case RecipPoly4: {
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                float[] fArray3 = new float[4];
                float[] fArray4 = new float[4];
                float f = this.MaxInvR;
                fArray[0] = 0.0f;
                fArray[1] = f * 0.4f;
                fArray[2] = f * 0.8f;
                fArray[3] = f * 1.5f;
                for (int i = 0; i < 4; ++i) {
                    fArray2[i] = fArray[i] * fArray[i];
                    fArray3[i] = this.DistortionFnInverse(fArray[i]);
                    fArray4[i] = fArray[i] / fArray3[i];
                }
                fArray4[0] = 1.0f;
                LensConfig.FitCubicPolynomial(this.InvK, fArray2, fArray4);
                break;
            }
            case CatmullRom10: {
                for (int i = 1; i < 11; ++i) {
                    float f = i;
                    float f2 = f * this.MaxInvR * this.MaxInvR / 10.0f;
                    float f3 = (float)Math.sqrt(f2);
                    float f4 = this.DistortionFnInverse(f3);
                    this.InvK[i] = f4 / f3;
                    this.InvK[0] = 1.0f;
                }
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)this.eqn));
            }
        }
    }

    private void SetToIdentity() {
        for (int i = 0; i < 11; ++i) {
            this.K[i] = 0.0f;
            this.InvK[i] = 0.0f;
        }
        this.eqn = DistortionEquation.RecipPoly4;
        this.K[0] = 1.0f;
        this.InvK[0] = 1.0f;
        this.MaxR = 1.0f;
        this.MaxInvR = 1.0f;
        this.ChromaticAberration[0] = 0.0f;
        this.ChromaticAberration[1] = 0.0f;
        this.ChromaticAberration[2] = 0.0f;
        this.ChromaticAberration[3] = 0.0f;
        this.MetersPerTanAngleAtCenter = 0.05f;
    }

    public float DistortionFn(float f) {
        return f * this.DistortionFnScaleRadiusSquared(f * f);
    }

    public float DistortionFnInverseApprox(float f) {
        float f2;
        float f3 = f * f;
        switch (this.eqn) {
            case RecipPoly4: {
                f2 = 1.0f / (this.InvK[0] + f3 * (this.InvK[1] + f3 * (this.InvK[2] + f3 * this.InvK[3])));
                break;
            }
            case CatmullRom10: {
                float f4 = 10.0f * f3 / (this.MaxInvR * this.MaxInvR);
                f2 = LensConfig.EvalCatmullRom10Spline(this.InvK, f4);
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)this.eqn));
            }
        }
        return f * f2;
    }

    public float DistortionFnInverse(float f) {
        float f2 = f * 0.25f;
        float f3 = f * 0.25f;
        float f4 = Math.abs(f - this.DistortionFn(f3));
        for (int i = 0; i < 20; ++i) {
            float f5 = f3 + f2;
            float f6 = f3 - f2;
            float f7 = Math.abs(f - this.DistortionFn(f5));
            float f8 = Math.abs(f - this.DistortionFn(f6));
            if (f7 < f4) {
                f3 = f5;
                f4 = f7;
                continue;
            }
            if (f8 < f4) {
                f3 = f6;
                f4 = f8;
                continue;
            }
            f2 *= 0.5f;
        }
        return f3;
    }

    public float DistortionFnScaleRadiusSquared(float f) {
        float f2;
        switch (this.eqn) {
            case RecipPoly4: {
                f2 = 1.0f / (this.K[0] + f * (this.K[1] + f * (this.K[2] + f * this.K[3])));
                break;
            }
            case CatmullRom10: {
                float f3 = 10.0f * f / (this.MaxR * this.MaxR);
                f2 = LensConfig.EvalCatmullRom10Spline(this.K, f3);
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)this.eqn));
            }
        }
        return f2;
    }

    public float[] DistortionFnScaleRadiusSquaredChroma(float f) {
        float f2 = this.DistortionFnScaleRadiusSquared(f);
        float[] fArray = new float[]{f2 * (1.0f + this.ChromaticAberration[0] + f * this.ChromaticAberration[1]), f2, f2 * (1.0f + this.ChromaticAberration[2] + f * this.ChromaticAberration[3])};
        return fArray;
    }

    private static boolean FitCubicPolynomial(float[] fArray, float[] fArray2, float[] fArray3) {
        float f = (fArray2[0] - fArray2[1]) * (fArray2[0] - fArray2[2]) * (fArray2[0] - fArray2[3]);
        float f2 = (fArray2[1] - fArray2[2]) * (fArray2[1] - fArray2[3]) * (fArray2[1] - fArray2[0]);
        float f3 = (fArray2[2] - fArray2[3]) * (fArray2[2] - fArray2[0]) * (fArray2[2] - fArray2[1]);
        float f4 = (fArray2[3] - fArray2[0]) * (fArray2[3] - fArray2[1]) * (fArray2[3] - fArray2[2]);
        if (f == 0.0f || f2 == 0.0f || f3 == 0.0f || f4 == 0.0f) {
            return false;
        }
        float f5 = fArray3[0] / f;
        float f6 = fArray3[1] / f2;
        float f7 = fArray3[2] / f3;
        float f8 = fArray3[3] / f4;
        fArray[0] = -(f5 * fArray2[1] * fArray2[2] * fArray2[3] + f6 * fArray2[0] * fArray2[2] * fArray2[3] + f7 * fArray2[0] * fArray2[1] * fArray2[3] + f8 * fArray2[0] * fArray2[1] * fArray2[2]);
        fArray[1] = f5 * (fArray2[1] * fArray2[2] + fArray2[2] * fArray2[3] + fArray2[3] * fArray2[1]) + f6 * (fArray2[0] * fArray2[2] + fArray2[2] * fArray2[3] + fArray2[3] * fArray2[0]) + f7 * (fArray2[0] * fArray2[1] + fArray2[1] * fArray2[3] + fArray2[3] * fArray2[0]) + f8 * (fArray2[0] * fArray2[1] + fArray2[1] * fArray2[2] + fArray2[2] * fArray2[0]);
        fArray[2] = -(f5 * (fArray2[1] + fArray2[2] + fArray2[3]) + f6 * (fArray2[0] + fArray2[2] + fArray2[3]) + f7 * (fArray2[0] + fArray2[1] + fArray2[3]) + f8 * (fArray2[0] + fArray2[1] + fArray2[2]));
        fArray[3] = f5 + f6 + f7 + f8;
        return true;
    }

    private static float EvalCatmullRom10Spline(float[] fArray, float f) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = (float)Math.floor(f);
        f6 = Math.max(0.0f, Math.min(10.0f, f6));
        float f7 = f - f6;
        int n = (int)f6;
        switch (n) {
            case 0: {
                f5 = 1.0f;
                f4 = fArray[1] - fArray[0];
                f3 = fArray[1];
                f2 = 0.5f * (fArray[2] - fArray[0]);
                break;
            }
            default: {
                f5 = fArray[n];
                f4 = 0.5f * (fArray[n + 1] - fArray[n - 1]);
                f3 = fArray[n + 1];
                f2 = 0.5f * (fArray[n + 2] - fArray[n]);
                break;
            }
            case 9: {
                f5 = fArray[9];
                f4 = 0.5f * (fArray[10] - fArray[9]);
                f3 = fArray[10];
                f2 = fArray[10] - fArray[9];
                break;
            }
            case 10: {
                f5 = fArray[10];
                f4 = fArray[10] - fArray[9];
                f3 = f5 + f4;
                f2 = f4;
            }
        }
        float f8 = 1.0f - f7;
        float f9 = (f5 * (1.0f + 2.0f * f7) + f4 * f7) * f8 * f8 + (f3 * (1.0f + 2.0f * f8) - f2 * f8) * f7 * f7;
        return f9;
    }

    public static LensConfig[] GenerateLensConfigFromEyeRelief(float[] fArray, DistortionEquation distortionEquation) {
        LensConfig[] lensConfigArray = new LensConfig[2];
        DistortionDescriptor[] distortionDescriptorArray = LensConfig.CreateDistortionDescriptorsforOVRDK1_CupsABC();
        lensConfigArray[0] = LensConfig.GenerateLensConfigFromEyeRelief(fArray[0], distortionDescriptorArray, distortionEquation);
        lensConfigArray[1] = LensConfig.GenerateLensConfigFromEyeRelief(fArray[1], distortionDescriptorArray, distortionEquation);
        return lensConfigArray;
    }

    private static LensConfig GenerateLensConfigFromEyeRelief(float f, DistortionDescriptor[] distortionDescriptorArray, DistortionEquation distortionEquation) {
        float f2;
        int n = distortionDescriptorArray.length;
        DistortionDescriptor distortionDescriptor = null;
        DistortionDescriptor distortionDescriptor2 = null;
        float f3 = 0.0f;
        if (f == 0.0f) {
            distortionDescriptor2 = distortionDescriptorArray[0];
            distortionDescriptor = distortionDescriptorArray[0];
            f3 = 0.0f;
        } else {
            for (int i = 0; i < n - 1; ++i) {
                assert (distortionDescriptorArray[i].eyeRelief < distortionDescriptorArray[i + 1].eyeRelief);
                if (!(distortionDescriptorArray[i].eyeRelief <= f) || !(distortionDescriptorArray[i + 1].eyeRelief > f)) continue;
                distortionDescriptor2 = distortionDescriptorArray[i];
                distortionDescriptor = distortionDescriptorArray[i + 1];
                f3 = (f - distortionDescriptor2.eyeRelief) / (distortionDescriptor.eyeRelief - distortionDescriptor2.eyeRelief);
            }
        }
        if (distortionDescriptor == null) {
            if (distortionDescriptorArray[0].eyeRelief > f) {
                distortionDescriptor2 = distortionDescriptorArray[0];
                distortionDescriptor = distortionDescriptorArray[0];
            } else {
                assert (distortionDescriptorArray[n - 1].eyeRelief <= f);
                distortionDescriptor2 = distortionDescriptorArray[n - 1];
                distortionDescriptor = distortionDescriptorArray[n - 1];
            }
            f3 = 0.0f;
        }
        float f4 = 1.0f - f3;
        distortionDescriptor2.config.MaxR = distortionDescriptor2.maxRadius;
        distortionDescriptor.config.MaxR = distortionDescriptor.maxRadius;
        LensConfig lensConfig = new LensConfig();
        lensConfig.MaxR = f2 = f4 * distortionDescriptor2.maxRadius + f3 * distortionDescriptor.maxRadius;
        switch (distortionEquation) {
            case RecipPoly4: {
                float f5;
                int n2;
                float[] fArray = new float[4];
                float[] fArray2 = new float[4];
                fArray[0] = 0.0f;
                fArray2[0] = 1.0f;
                for (n2 = 1; n2 < 4; ++n2) {
                    f5 = f4 * distortionDescriptor2.sampleRadius[n2 - 1] + f3 * distortionDescriptor.sampleRadius[n2 - 1];
                    float f6 = f5 * f5;
                    float f7 = distortionDescriptor2.config.DistortionFnScaleRadiusSquared(f6);
                    float f8 = distortionDescriptor.config.DistortionFnScaleRadiusSquared(f6);
                    fArray[n2] = f6;
                    fArray2[n2] = 1.0f / (f4 * f7 + f3 * f8);
                }
                lensConfig.eqn = DistortionEquation.RecipPoly4;
                n2 = LensConfig.FitCubicPolynomial(lensConfig.K, fArray, fArray2) ? 1 : 0;
                assert (n2 != 0);
                lensConfig.MaxInvR = f5 = lensConfig.DistortionFn(f2);
                lensConfig.SetUpInverseApprox();
                break;
            }
            case CatmullRom10: {
                float f9;
                float f10;
                float f11;
                int n3;
                lensConfig.MaxR = f2;
                lensConfig.K[0] = f4 * distortionDescriptor2.config.K[0] + f3 * distortionDescriptor.config.K[0];
                for (n3 = 1; n3 < 11; ++n3) {
                    float f12;
                    f11 = (float)n3 / 10.0f * f2 * f2;
                    f10 = distortionDescriptor2.config.DistortionFnScaleRadiusSquared(f11);
                    float f13 = distortionDescriptor.config.DistortionFnScaleRadiusSquared(f11);
                    lensConfig.K[n3] = f12 = f4 * f10 + f3 * f13;
                }
                lensConfig.eqn = DistortionEquation.CatmullRom10;
                for (n3 = 1; n3 < 11; ++n3) {
                    f11 = (float)n3 / 10.0f * f2 * f2;
                    f10 = lensConfig.DistortionFnScaleRadiusSquared(f11);
                    assert (Math.abs(f10 - lensConfig.K[n3]) < 1.0E-4f);
                }
                lensConfig.MaxInvR = f9 = lensConfig.DistortionFn(f2);
                lensConfig.SetUpInverseApprox();
                break;
            }
            default: {
                throw new InternalError("unsupported EQ " + (Object)((Object)distortionEquation));
            }
        }
        lensConfig.ChromaticAberration[0] = f4 * distortionDescriptor2.config.ChromaticAberration[0] + f3 * distortionDescriptor.config.ChromaticAberration[0];
        lensConfig.ChromaticAberration[1] = f4 * distortionDescriptor2.config.ChromaticAberration[1] + f3 * distortionDescriptor.config.ChromaticAberration[1];
        lensConfig.ChromaticAberration[2] = f4 * distortionDescriptor2.config.ChromaticAberration[2] + f3 * distortionDescriptor.config.ChromaticAberration[2];
        lensConfig.ChromaticAberration[3] = f4 * distortionDescriptor2.config.ChromaticAberration[3] + f3 * distortionDescriptor.config.ChromaticAberration[3];
        lensConfig.MetersPerTanAngleAtCenter = distortionDescriptor2.config.MetersPerTanAngleAtCenter * f4 + distortionDescriptor.config.MetersPerTanAngleAtCenter * f3;
        return lensConfig;
    }

    public static DistortionDescriptor[] CreateDistortionDescriptorsforOVRDK1_CupsABC() {
        return new DistortionDescriptor[]{new DistortionDescriptor(new LensConfig(DistortionEquation.CatmullRom10, 0.0425f, new float[]{1.0f, 1.06505f, 1.14725f, 1.2705f, 1.48f, 1.87f, 2.534f, 3.6f, 5.1f, 7.4f, 11.0f}), 0.007760465f, new float[]{0.22271715f, 0.51224947f, 0.7126949f}, (float)Math.sqrt(1.8f)), new DistortionDescriptor(new LensConfig(DistortionEquation.CatmullRom10, 0.0425f, new float[]{1.0f, 1.0324073f, 1.0716046f, 1.1199839f, 1.1808606f, 1.2590494f, 1.361915f, 1.5014338f, 1.6986004f, 1.9940577f, 2.4783146f}), 0.012760465f, new float[]{0.22271715f, 0.51224947f, 0.7126949f}, 1.0f), new DistortionDescriptor(new LensConfig(DistortionEquation.CatmullRom10, 0.0425f, new float[]{1.0102f, 1.0371f, 1.0831f, 1.1353f, 1.2f, 1.2851f, 1.3979f, 1.56f, 1.8f, 2.25f, 3.0f}), 0.017760465f, new float[]{0.22271715f, 0.51224947f, 0.7126949f}, 1.0f)};
    }

    public static enum DistortionEquation {
        RecipPoly4,
        CatmullRom10;

    }

    public static class DistortionDescriptor {
        final LensConfig config;
        final float eyeRelief;
        final float[] sampleRadius;
        final float maxRadius;

        public DistortionDescriptor(LensConfig lensConfig, float f, float[] fArray, float f2) {
            this.config = lensConfig;
            this.eyeRelief = f;
            this.sampleRadius = fArray;
            this.maxRadius = f2;
        }
    }
}

