/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.opengl.windows.wgl.RECT;

public class PGPU_DEVICE {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] PGPU_DEVICE_size = new int[]{184, 184, 184, 184, 184, 184, 184, 184, 184, 184};
    private static final int[] cb_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] DeviceName_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] DeviceName_size = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final int[] DeviceString_offset = new int[]{36, 36, 36, 36, 36, 36, 36, 36, 36, 36};
    private static final int[] DeviceString_size = new int[]{128, 128, 128, 128, 128, 128, 128, 128, 128, 128};
    private static final int[] Flags_offset = new int[]{164, 164, 164, 164, 164, 164, 164, 164, 164, 164};
    private static final int[] rcVirtualScreen_offset = new int[]{168, 168, 168, 168, 168, 168, 168, 168, 168, 168};
    private static final int[] rcVirtualScreen_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};

    public static int size() {
        return PGPU_DEVICE_size[mdIdx];
    }

    public static PGPU_DEVICE create() {
        return PGPU_DEVICE.create(Buffers.newDirectByteBuffer(PGPU_DEVICE.size()));
    }

    public static PGPU_DEVICE create(ByteBuffer byteBuffer) {
        return new PGPU_DEVICE(byteBuffer);
    }

    PGPU_DEVICE(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[PGPU_DEVICE.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public PGPU_DEVICE setCb(int n) {
        this.accessor.setIntAt(cb_offset[mdIdx], n);
        return this;
    }

    public int getCb() {
        return this.accessor.getIntAt(cb_offset[mdIdx]);
    }

    public static final int getDeviceNameArrayLength() {
        return 32;
    }

    public PGPU_DEVICE setDeviceName(int n, byte[] byArray) {
        if (n + byArray.length > 32) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + byArray.length + " > array-length " + 32);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (32 > DeviceName_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 32 > size " + DeviceName_size[mdIdx] + ", elemSize " + 1 + " * " + 32);
        }
        int n2 = DeviceName_offset[mdIdx];
        int n3 = n2 + 32;
        if (n3 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n3 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n2 + ", elemSize " + 1 + " * " + 32);
        }
        this.accessor.setBytesAt(n2 += 1 * n, byArray);
        return this;
    }

    public ByteBuffer getDeviceName() {
        return this.accessor.slice(DeviceName_offset[mdIdx], 32);
    }

    public byte[] getDeviceName(int n, byte[] byArray) {
        if (n + byArray.length > 32) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + byArray.length + " > array-length " + 32);
        }
        return this.accessor.getBytesAt(DeviceName_offset[mdIdx] + 1 * n, byArray);
    }

    public static final int getDeviceStringArrayLength() {
        return 128;
    }

    public PGPU_DEVICE setDeviceString(int n, byte[] byArray) {
        if (n + byArray.length > 128) {
            throw new IndexOutOfBoundsException("offset " + n + " + val.length " + byArray.length + " > array-length " + 128);
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (128 > DeviceString_size[mdIdx]) {
            throw new IndexOutOfBoundsException("bTotal 128 > size " + DeviceString_size[mdIdx] + ", elemSize " + 1 + " * " + 128);
        }
        int n2 = DeviceString_offset[mdIdx];
        int n3 = n2 + 128;
        if (n3 > byteBuffer.limit()) {
            throw new IndexOutOfBoundsException("bLimes " + n3 + " > buffer.limit " + byteBuffer.limit() + ", elemOff " + n2 + ", elemSize " + 1 + " * " + 128);
        }
        this.accessor.setBytesAt(n2 += 1 * n, byArray);
        return this;
    }

    public ByteBuffer getDeviceString() {
        return this.accessor.slice(DeviceString_offset[mdIdx], 128);
    }

    public byte[] getDeviceString(int n, byte[] byArray) {
        if (n + byArray.length > 128) {
            throw new IndexOutOfBoundsException("offset " + n + " + result.length " + byArray.length + " > array-length " + 128);
        }
        return this.accessor.getBytesAt(DeviceString_offset[mdIdx] + 1 * n, byArray);
    }

    public PGPU_DEVICE setFlags(int n) {
        this.accessor.setIntAt(Flags_offset[mdIdx], n);
        return this;
    }

    public int getFlags() {
        return this.accessor.getIntAt(Flags_offset[mdIdx]);
    }

    public RECT getRcVirtualScreen() {
        return RECT.create(this.accessor.slice(rcVirtualScreen_offset[mdIdx], rcVirtualScreen_size[mdIdx]));
    }
}

