/*
 * Decompiled with CFR 0.152.
 */
package com.eazycnc.uwk;

import com.eazycnc.uwk.InvalidValueException;
import com.eazycnc.uwk.SimpleVariable;

public class NumericVariable
extends SimpleVariable {
    private boolean m_IsInteger = true;
    private Number m_MinValue;
    private Number m_MaxValue;

    public NumericVariable(Number number) {
        super(number);
        if (number == null) {
            throw new InvalidValueException("null is not a number");
        }
        if (number instanceof Byte) {
            this.m_MinValue = (byte)-128;
            this.m_MaxValue = (byte)127;
        } else if (number instanceof Short) {
            this.m_MinValue = (short)Short.MIN_VALUE;
            this.m_MaxValue = (short)Short.MAX_VALUE;
        } else if (number instanceof Integer) {
            this.m_MinValue = Integer.MIN_VALUE;
            this.m_MaxValue = Integer.MAX_VALUE;
        } else if (number instanceof Float) {
            this.m_MinValue = Float.valueOf(-3.4028235E38f);
            this.m_MaxValue = Float.valueOf(Float.MAX_VALUE);
            this.m_IsInteger = false;
        } else if (number instanceof Double) {
            this.m_MinValue = -1.7976931348623157E308;
            this.m_MaxValue = Double.MAX_VALUE;
            this.m_IsInteger = false;
        } else {
            throw new InvalidValueException("Value of type" + number.getClass().getSimpleName() + " is not supported ");
        }
    }

    public NumericVariable(Number number, Number number2, Number number3) {
        this(number);
        this.m_MinValue = number2;
        this.m_MaxValue = number3;
    }

    public Number getMinValue() {
        return this.m_MinValue;
    }

    public Number getMaxValue() {
        return this.m_MaxValue;
    }

    @Override
    public void validate(Object object) {
        double d;
        super.validate(object);
        if (!(object instanceof Number)) {
            throw new InvalidValueException("Value " + object + " is not number");
        }
        if (this.m_IsInteger) {
            try {
                d = ((Number)object).intValue();
            }
            catch (Exception exception) {
                throw new InvalidValueException("Value " + object + " is not integer ");
            }
        } else {
            d = ((Number)object).doubleValue();
        }
        if (this.getMinValue() != null && d < this.getMinValue().doubleValue()) {
            throw new InvalidValueException("Value " + object + " is too small, minimum allowed is " + this.getMinValue());
        }
        if (this.getMaxValue() != null && d > this.getMaxValue().doubleValue()) {
            throw new InvalidValueException("Value " + object + " is too large, maximum allowed is " + this.getMaxValue());
        }
    }

    public byte byteValue() {
        return ((Number)this.getValue()).byteValue();
    }

    public short shortValue() {
        return ((Number)this.getValue()).shortValue();
    }

    public int intValue() {
        return ((Number)this.getValue()).intValue();
    }

    public long longValue() {
        return ((Number)this.getValue()).longValue();
    }

    public float floatValue() {
        return ((Number)this.getValue()).floatValue();
    }

    public double doubleValue() {
        return ((Number)this.getValue()).doubleValue();
    }
}

