/*
 * Decompiled with CFR 0.152.
 */
package com.eazycnc.uwk;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.ErrorHandler;
import com.eazycnc.uwk.InvalidValueException;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.ResourceLoader;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.TextFieldCallback;
import com.eazycnc.uwk.Translator;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.Canvas;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.CheckBox;
import com.eazycnc.uwk.widgets.ColorPicker;
import com.eazycnc.uwk.widgets.ComboBox;
import com.eazycnc.uwk.widgets.EditListener;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import com.eazycnc.uwk.widgets.FocusListener;
import com.eazycnc.uwk.widgets.Image;
import com.eazycnc.uwk.widgets.Label;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.OpenGLCanvas;
import com.eazycnc.uwk.widgets.Picture;
import com.eazycnc.uwk.widgets.RadioButton;
import com.eazycnc.uwk.widgets.SourceCodeEditor;
import com.eazycnc.uwk.widgets.SplitLayout;
import com.eazycnc.uwk.widgets.TabbedLayout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.ToggleButton;
import com.eazycnc.uwk.widgets.Widget;
import com.eazycnc.uwk.widgets.WidgetFactory;
import java.io.File;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.LinkedList;

public class UWKit {
    private static Translator m_Translator;
    private static ResourceLoader m_ResourceLoader;
    private static Format m_DefaultFloatFormat;
    private static Format m_DefaultIntegerFormat;
    private static Format m_DefaultFormat;
    public static WidgetFactory m_Factory;
    private static LinkedList<LinkedList<VariableValue>> m_UndoStack;
    private static LinkedList<VariableValue> m_UndoList;
    private static ErrorHandler m_ErrorHandler;
    private static final Object NO_UNSET;

    public static String translate(String string) {
        if (m_Translator != null) {
            return m_Translator.translate(string);
        }
        return string;
    }

    public static void setTranslator(Translator translator) {
        m_Translator = translator;
    }

    public static void setResourceLoader(ResourceLoader resourceLoader) {
        m_ResourceLoader = resourceLoader;
    }

    public static void setResourceClass(Class clazz) {
        m_ResourceLoader.setResourceClass(clazz);
    }

    public static void setDefaultFloatFormat(Format format) {
        m_DefaultFloatFormat = format;
    }

    public static void setDefaultIntegerFormat(Format format) {
        m_DefaultIntegerFormat = format;
    }

    public static void setDefaultFormat(Format format) {
        m_DefaultFormat = format;
    }

    public static Image loadImage(String string) {
        return m_Factory.createImage(m_ResourceLoader, string);
    }

    private static boolean isEqual(Object object, Object object2) {
        if (object != null && object2 != null && object.getClass() != object2.getClass()) {
            throw new IllegalArgumentException("Uncompareble object types " + object.getClass().getSimpleName() + "(" + object + ")," + object2.getClass().getSimpleName() + "(" + object2 + ")");
        }
        return object != null && object.equals(object2) || object == object2;
    }

    public static void setErrorHandler(ErrorHandler errorHandler) {
        m_ErrorHandler = errorHandler;
    }

    public static ErrorHandler getErrorHandler() {
        return m_ErrorHandler;
    }

    private static void setVariableValue(Variable variable, Object object) {
        if (m_UndoList != null) {
            m_UndoList.addFirst(new VariableValue(variable, object));
        }
        variable.setValue(object);
    }

    public static Label newLabel(String string) {
        return UWKit.newLabel(new SimpleVariable(UWKit.translate(string)));
    }

    public static ColorPicker newColorPicker(Variable variable) {
        ColorPicker colorPicker = m_Factory.createColorPicker();
        UWKit.connect(colorPicker, variable);
        return colorPicker;
    }

    private static void connect(final ColorPicker colorPicker, final Variable variable) {
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable2) {
                colorPicker.setColor(variable.getValue().toString());
            }
        });
        colorPicker.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                String string = colorPicker.getColor();
                variable.validate(string);
                UWKit.setVariableValue(variable, string);
            }
        });
    }

    public static Label newLabel(Variable variable) {
        Label label = m_Factory.createLabel(variable.getValue().toString());
        UWKit.connect(label, variable);
        return label;
    }

    private static void connect(final Label label, final Variable variable) {
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable2) {
                label.setText(variable.getValue().toString());
            }
        });
    }

    public static ComboBox newComboBox(Variable variable, Object ... objectArray) {
        int n = objectArray.length / 2;
        if (objectArray.length != n * 2) {
            throw new IllegalArgumentException("Uneven number of items and values");
        }
        Object[] objectArray2 = new Object[n];
        Object[] objectArray3 = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = objectArray[i * 2 + 0];
            objectArray3[i] = objectArray[i * 2 + 1];
        }
        return UWKit.newComboBox(variable, objectArray2, objectArray3);
    }

    public static ComboBox newComboBox(Variable variable, Object[] objectArray, Object[] objectArray2) {
        ComboBox comboBox = m_Factory.craeteComboBox(objectArray);
        UWKit.connect(comboBox, variable, objectArray, objectArray2);
        return comboBox;
    }

    private static void connect(final ComboBox comboBox, final Variable variable, final Object[] objectArray, Object[] objectArray2) {
        final Object[] objectArray3 = objectArray2 == null ? objectArray : objectArray2;
        final int[] nArray = new int[]{0};
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable2) {
                Object object = variable.getValue();
                int n = -1;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!UWKit.isEqual(object, objectArray3[i])) continue;
                    n = i;
                    break;
                }
                nArray[0] = n;
                comboBox.setSelectedIndex(n);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                block3: {
                    int n = comboBox.getSelectedIndex();
                    if (n >= 0 && n < objectArray3.length) {
                        Object object = objectArray3[n];
                        try {
                            variable.validate(object);
                            UWKit.setVariableValue(variable, object);
                        }
                        catch (InvalidValueException invalidValueException) {
                            comboBox.setSelectedIndex(nArray[0]);
                            if (m_ErrorHandler == null) break block3;
                            m_ErrorHandler.handleException(invalidValueException, variable, object);
                        }
                    }
                }
            }
        });
    }

    public static CheckBox newCheckBox(Variable variable, String string) {
        return UWKit.newCheckBox(variable, UWKit.translate(string), (Object)true, (Object)false);
    }

    public static CheckBox newCheckBox(Variable variable, Variable variable2) {
        return UWKit.newCheckBox(variable, variable2, (Object)true, (Object)false);
    }

    public static CheckBox newCheckBox(Variable variable, String string, Object object, Object object2) {
        return UWKit.newCheckBox(variable, new SimpleVariable(UWKit.translate(string)), object, object2);
    }

    public static CheckBox newCheckBox(Variable variable, Variable variable2, Object object, Object object2) {
        CheckBox checkBox = m_Factory.createCheckBox("");
        UWKit.connect(checkBox, variable, variable2, object, object2);
        return checkBox;
    }

    private static void connect(final CheckBox checkBox, final Variable variable, final Variable variable2, final Object object, final Object object2) {
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                Object object3 = UWKit.isEqual(variable.getValue(), object) ? object2 : object;
                variable.validate(object3);
                UWKit.setVariableValue(variable, object3);
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable2) {
                checkBox.setSelected(UWKit.isEqual(variable.getValue(), object));
            }
        });
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                checkBox.setText(variable2.getValue().toString());
            }
        });
    }

    public static RadioButton newRadioButton(Variable variable, String string, Object object) {
        return UWKit.newRadioButton(variable, new SimpleVariable(UWKit.translate(string)), object);
    }

    public static RadioButton newRadioButton(Variable variable, Variable variable2, Object object) {
        RadioButton radioButton = m_Factory.createRadioButton(variable2.getValue().toString());
        UWKit.connect(radioButton, variable, variable2, object);
        return radioButton;
    }

    private static void connect(final RadioButton radioButton, final Variable variable, final Variable variable2, final Object object) {
        radioButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                UWKit.setVariableValue(variable, object);
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable2) {
                radioButton.setSelected(UWKit.isEqual(variable.getValue(), object));
            }
        });
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                radioButton.setText(variable2.getValue().toString());
            }
        });
    }

    public static ToggleButton newToggleButton(Variable variable, String string, Object object) {
        return UWKit.newToggleButton(variable, string, object, NO_UNSET);
    }

    public static ToggleButton newToggleButton(Variable variable, String string, Object object, Object object2) {
        return UWKit.newToggleButton(variable, (Variable)new SimpleVariable(UWKit.translate(string)), object, object2);
    }

    public static ToggleButton newToggleButton(Variable variable, Variable variable2, Object object) {
        return UWKit.newToggleButton(null, variable, variable2, object, NO_UNSET);
    }

    public static ToggleButton newToggleButton(Variable variable, Variable variable2, Object object, Object object2) {
        return UWKit.newToggleButton(null, variable, variable2, object, object2);
    }

    public static ToggleButton newToggleButton(String string, Variable variable, String string2, Object object) {
        return UWKit.newToggleButton(string, variable, new SimpleVariable(UWKit.translate(string2)), object, NO_UNSET);
    }

    public static ToggleButton newToggleButton(String string, Variable variable, String string2, Object object, Object object2) {
        return UWKit.newToggleButton(string, variable, new SimpleVariable(UWKit.translate(string2)), object, object2);
    }

    public static ToggleButton newToggleButton(String string, Variable variable, Variable variable2, Object object, Object object2) {
        ToggleButton toggleButton = m_Factory.createToggleButton(m_ResourceLoader, string, variable2.getValue().toString());
        UWKit.connect(toggleButton, variable, variable2, object, object2);
        return toggleButton;
    }

    private static void connect(final ToggleButton toggleButton, final Variable variable, final Variable variable2, final Object object, final Object object2) {
        toggleButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                block6: {
                    try {
                        if (!UWKit.isEqual(variable.getValue(), object)) {
                            UWKit.setVariableValue(variable, object);
                        } else if (object2 != NO_UNSET) {
                            UWKit.setVariableValue(variable, object2);
                        } else {
                            variable.fireChangeEvent();
                        }
                    }
                    catch (InvalidValueException invalidValueException) {
                        toggleButton.setSelected(UWKit.isEqual(variable.getValue(), object));
                        if (m_ErrorHandler == null) break block6;
                        m_ErrorHandler.handleException(invalidValueException, variable, object);
                    }
                }
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable2) {
                toggleButton.setSelected(UWKit.isEqual(variable.getValue(), object));
            }
        });
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                toggleButton.setText(variable2.getValue().toString());
            }
        });
    }

    public static TextField newTextField(Variable variable, double d, int n) {
        Object object = variable.getValue();
        return UWKit.newTextField(variable, d, n, UWKit.getFormatter(object), UWKit.getFormatter(object));
    }

    public static TextField newTextField(Variable variable, double d, int n, Format format, Format format2) {
        return UWKit.newTextField(variable, d, n, new SimpleVariable(format), format2);
    }

    public static TextField newTextField(Variable variable, double d, int n, Variable variable2, Format format) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n; n2 += 1) {
            stringBuffer.append("0");
        }
        n2 = 0;
        if (variable != null && variable.getValue() instanceof Number) {
            n2 = 1;
        }
        TextField textField = m_Factory.createTextField(stringBuffer.toString(), d, n, n2 != 0);
        if (variable != null) {
            try {
                textField.setFieldText(variable.getValue().toString());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            UWKit.connect(textField, variable, variable2, format);
        }
        return textField;
    }

    private static void connect(final TextField textField, final Variable variable, final Variable variable2, final Format format) {
        new Object(){
            String prevValue;
            Format format;
            {
                variable2.addObserver(new VariableObserver(){

                    @Override
                    public void valueChanged(Variable variable) {
                        Object object = variable2.getValue();
                        format = object instanceof String ? new DecimalFormat(object.toString()) : (Format)object;
                        this.updateField(false);
                    }
                });
                textField.setEditListener(new EditListener(){

                    @Override
                    public void onEndEdit(boolean bl) {
                        if (bl) {
                            this.updateValue();
                        } else {
                            this.updateField(true);
                        }
                    }
                });
                variable.addObserver(new VariableObserver(){

                    @Override
                    public void valueChanged(Variable variable) {
                        this.updateField(false);
                    }
                });
                variable.addObserver(new VariableObserver(){

                    @Override
                    public void valueChanged(Variable variable) {
                        this.updateField(false);
                    }
                });
                textField.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(Widget widget) {
                        this.updateValue();
                    }

                    @Override
                    public void focusGained(Widget widget) {
                        textField.selectAll();
                    }
                });
            }

            void updateField(boolean bl) {
                Object object = variable.getValue();
                if (object != null) {
                    this.prevValue = this.format.format(object);
                    if (bl || !textField.hasFocus()) {
                        textField.setFieldText(this.prevValue);
                    }
                }
            }

            void updateValue() {
                block5: {
                    String string = textField.getFieldText();
                    if (!string.equals(this.prevValue)) {
                        try {
                            Object object = null;
                            Format format2 = format != null ? format : this.format;
                            try {
                                object = format2.parseObject(string);
                            }
                            catch (ParseException parseException) {
                                throw new InvalidValueException("Bad value entered");
                            }
                            object = UWKit.castToType(variable.getValue(), object);
                            variable.validate(object);
                            UWKit.setVariableValue(variable, object);
                            textField.selectAll();
                        }
                        catch (Exception exception) {
                            this.updateField(false);
                            textField.selectAll();
                            if (m_ErrorHandler == null) break block5;
                            m_ErrorHandler.handleException(exception, variable, string);
                        }
                    }
                }
            }
        };
    }

    private static Format getFormatter(Object object) {
        if (object instanceof Number) {
            if (object instanceof Double || object instanceof Float) {
                if (m_DefaultFloatFormat != null) {
                    return m_DefaultFloatFormat;
                }
                return NumberFormat.getNumberInstance();
            }
            if (m_DefaultIntegerFormat != null) {
                return m_DefaultIntegerFormat;
            }
            return NumberFormat.getIntegerInstance();
        }
        if (m_DefaultFormat != null) {
            return m_DefaultFormat;
        }
        return new Format(){

            @Override
            public Object parseObject(String string) throws ParseException {
                return string;
            }

            @Override
            public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                stringBuffer.append(object.toString());
                return stringBuffer;
            }

            @Override
            public Object parseObject(String string, ParsePosition parsePosition) {
                return string;
            }
        };
    }

    private static Object castToType(Object object, Object object2) {
        if (object instanceof Number) {
            Number number;
            Number number2 = (Number)object2;
            if (object instanceof Double) {
                number = number2.doubleValue();
            } else if (object instanceof Integer) {
                number = number2.intValue();
            } else if (object instanceof Float) {
                number = Float.valueOf(number2.floatValue());
            } else if (object instanceof Byte) {
                number = number2.byteValue();
            } else if (object instanceof Short) {
                number = number2.shortValue();
            } else if (object instanceof Long) {
                number = number2.longValue();
            } else {
                throw new IllegalArgumentException("Unsupported Number type: " + object.getClass().getSimpleName());
            }
            if (number2.doubleValue() != number.doubleValue()) {
                throw new IllegalArgumentException("Value entered " + object2 + " cannot be represented as " + object.getClass().getSimpleName());
            }
            return number;
        }
        return object2;
    }

    public static Variable concat(Object ... objectArray) {
        if (objectArray == null || objectArray.length < 1) {
            throw new IllegalArgumentException("at least two arguments required");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            objectArray[i] = new SimpleVariable(objectArray[i]);
        }
        return UWKit.concat(0, objectArray);
    }

    private static Variable concat(int n, Object ... objectArray) {
        if (objectArray.length - n < 1) {
            throw new IllegalArgumentException("at least one arguments required");
        }
        if (objectArray.length - n == 1) {
            return (SimpleVariable)objectArray[n];
        }
        return UWKit.concat((SimpleVariable)objectArray[n], UWKit.concat(n + 1, objectArray));
    }

    public static Variable concat(final Variable variable, final Variable variable2) {
        final SimpleVariable simpleVariable = new SimpleVariable((Object)""){

            @Override
            public Object getValue() {
                return variable.getValue().toString() + variable2.getValue().toString();
            }

            @Override
            public void setValue(Object object) {
                throw new IllegalArgumentException("should never be called");
            }

            @Override
            public void validate(Object object) {
            }
        };
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                simpleVariable.fireChangeEvent();
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                simpleVariable.fireChangeEvent();
            }
        });
        return simpleVariable;
    }

    public static NumericVariable divide(Variable variable, double d) {
        return UWKit.divide(variable, new NumericVariable(d));
    }

    public static NumericVariable divide(final Variable variable, final Variable variable2) {
        final NumericVariable numericVariable = new NumericVariable((Number)((Number)variable.getValue()).doubleValue()){

            @Override
            public Object getValue() {
                return ((Number)variable.getValue()).doubleValue() / ((Number)variable2.getValue()).doubleValue();
            }

            @Override
            public void setValue(Object object) {
                variable.setValue(((Number)object).doubleValue() * ((Number)variable2.getValue()).doubleValue());
            }

            @Override
            public void validate(Object object) {
                variable.validate(((Number)object).doubleValue() * ((Number)variable2.getValue()).doubleValue());
            }
        };
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        return numericVariable;
    }

    public static NumericVariable multiply(Variable variable, double d) {
        return UWKit.multiply(variable, new NumericVariable(d));
    }

    public static NumericVariable multiply(final Variable variable, final Variable variable2) {
        final NumericVariable numericVariable = new NumericVariable((Number)0.0){

            @Override
            public Object getValue() {
                return ((Number)variable.getValue()).doubleValue() * ((Number)variable2.getValue()).doubleValue();
            }

            @Override
            public void setValue(Object object) {
                variable.setValue(((Number)object).doubleValue() / ((Number)variable2.getValue()).doubleValue());
            }

            @Override
            public void validate(Object object) {
                variable.validate(((Number)object).doubleValue() / ((Number)variable2.getValue()).doubleValue());
            }
        };
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        return numericVariable;
    }

    public static NumericVariable add(Variable variable, double d) {
        return UWKit.add(variable, new NumericVariable(d));
    }

    public static NumericVariable add(final Variable variable, final Variable variable2) {
        final NumericVariable numericVariable = new NumericVariable((Number)0.0){

            @Override
            public Object getValue() {
                return ((Number)variable.getValue()).doubleValue() + ((Number)variable2.getValue()).doubleValue();
            }

            @Override
            public void setValue(Object object) {
                variable.setValue(((Number)object).doubleValue() - ((Number)variable2.getValue()).doubleValue());
            }

            @Override
            public void validate(Object object) {
                variable.validate(((Number)object).doubleValue() - ((Number)variable2.getValue()).doubleValue());
            }
        };
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        return numericVariable;
    }

    public static NumericVariable subtract(Variable variable, double d) {
        return UWKit.subtract(variable, new NumericVariable(d));
    }

    public static NumericVariable subtract(final Variable variable, final Variable variable2) {
        final NumericVariable numericVariable = new NumericVariable((Number)0.0){

            @Override
            public Object getValue() {
                return ((Number)variable.getValue()).doubleValue() - ((Number)variable2.getValue()).doubleValue();
            }

            @Override
            public void setValue(Object object) {
                variable.setValue(((Number)object).doubleValue() + ((Number)variable2.getValue()).doubleValue());
            }

            @Override
            public void validate(Object object) {
                variable.validate(((Number)object).doubleValue() + ((Number)variable2.getValue()).doubleValue());
            }
        };
        variable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        variable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                numericVariable.fireChangeEvent();
            }
        });
        return numericVariable;
    }

    public static SplitLayout newSplitLayout(Widget widget, Widget widget2) {
        return m_Factory.createSplitLayout(widget, widget2);
    }

    public static Layout newLayout() {
        return UWKit.newLayout(false, null, "");
    }

    public static Layout newTitledLayout(String string) {
        return UWKit.newLayout(true, string, "");
    }

    public static Layout newScrollLayout() {
        return m_Factory.createScrollLayout();
    }

    public static Layout newLayout(String string) {
        return UWKit.newLayout(false, null, string);
    }

    public static Layout newLayout(boolean bl) {
        return UWKit.newLayout(bl, null, "");
    }

    public static Layout newTitledLayout(String string, String string2) {
        return UWKit.newLayout(true, string, string2);
    }

    public static Layout newLayout(boolean bl, String string) {
        return UWKit.newLayout(bl, null, string);
    }

    public static TabbedLayout newTabbedLayout() {
        return m_Factory.createTabbedLayout();
    }

    public static CardLayout newCardLayout() {
        return m_Factory.createCardLayout();
    }

    public static Layout newLayout(boolean bl, String string, String object) {
        if (object == null) {
            object = "";
        }
        String string2 = "insets 0,novisualpadding";
        object = ((String)object).length() > 0 ? string2 + "," + (String)object : string2;
        return m_Factory.createLayout(bl, UWKit.translate(string), (String)object);
    }

    public static SourceCodeEditor newSourceCodeEditor(boolean bl, File file) {
        return m_Factory.createSourceCodeEditor(bl, file);
    }

    public static Button newButton(String string) {
        Button button = m_Factory.createButton(m_ResourceLoader, null, UWKit.translate(string));
        return button;
    }

    public static Button newButton(String string, String string2) {
        Button button = m_Factory.createButton(m_ResourceLoader, string, UWKit.translate(string2));
        return button;
    }

    public static Picture newPicture(String string) {
        return m_Factory.createPicture(m_ResourceLoader, string);
    }

    public static OpenGLCanvas newOpenGLView() {
        return m_Factory.createOpenGLView();
    }

    public static Canvas newCanvas(Canvas.OnPaintCallback onPaintCallback) {
        return m_Factory.createCanvas(onPaintCallback);
    }

    public static void scheduleInEDT(int n, int n2, Runnable runnable) {
        m_Factory.scheduleInEDT(n, n2, runnable);
    }

    public static void scheduleInEDT(Runnable runnable) {
        m_Factory.scheduleInEDT(runnable);
    }

    public static void beep() {
        m_Factory.beep();
    }

    public static void blip() {
        m_Factory.click();
    }

    public static void showFileDialog(String string, boolean bl, FileDialogCallback fileDialogCallback) {
        m_Factory.showFileDialog(string, bl, fileDialogCallback);
    }

    public static void showConfirmDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        m_Factory.showConfirmDialog(UWKit.translate(string), UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), UWKit.translate(string5), dialogCallback);
    }

    public static void showConfirmDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        m_Factory.showConfirmDialog(UWKit.translate(string), variable, UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), dialogCallback);
    }

    public static void showErrorDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        m_Factory.showErrorDialog(UWKit.translate(string), UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), UWKit.translate(string5), dialogCallback);
    }

    public static void showErrorDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        m_Factory.showErrorDialog(UWKit.translate(string), variable, UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), dialogCallback);
    }

    public static void showInformationDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        m_Factory.showInformationDialog(UWKit.translate(string), UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), UWKit.translate(string5), dialogCallback);
    }

    public static void showInformationDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        m_Factory.showInformationDialog(UWKit.translate(string), variable, UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), dialogCallback);
    }

    public static void showWarningDialog(String string, String string2, String string3, String string4, String string5, DialogCallback dialogCallback) {
        m_Factory.showWarningDialog(UWKit.translate(string), UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), UWKit.translate(string5), dialogCallback);
    }

    public static void showWarningDialog(String string, Variable variable, String string2, String string3, String string4, DialogCallback dialogCallback) {
        m_Factory.showWarningDialog(UWKit.translate(string), variable, UWKit.translate(string2), UWKit.translate(string3), UWKit.translate(string4), dialogCallback);
    }

    public static void closeDialog() {
        m_Factory.closeDialog();
    }

    public static void setTextFieldCallback(TextFieldCallback textFieldCallback) {
        m_Factory.setTextFieldCallback(textFieldCallback);
    }

    static {
        m_UndoStack = new LinkedList();
        NO_UNSET = new Object();
    }

    private static class VariableValue {
        Variable m_Variable;
        Object m_Value;

        VariableValue(Variable variable, Object object) {
            this.m_Variable = variable;
            this.m_Value = object;
        }
    }
}

