/*
 * Decompiled with CFR 0.152.
 */
package concurrentconditionals;

import java.util.LinkedList;
import java.util.List;

public abstract class Condition {
    String m_Name;
    List<Condition> m_Waiting = new LinkedList<Condition>();

    public abstract boolean getCondition();

    Condition(String string) {
        this.m_Name = string;
    }

    String getName() {
        return this.m_Name;
    }

    public synchronized void addWaiting(Condition condition) {
        this.m_Waiting.add(condition);
    }

    public synchronized void removeWaiting(Condition condition) {
        this.m_Waiting.add(condition);
    }

    public synchronized void notifyOfChange() {
        this.notifyAll();
        for (Condition condition : this.m_Waiting) {
            condition.notifyOfChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntil(boolean bl) throws InterruptedException {
        while (bl != this.getCondition()) {
            Condition condition = this;
            synchronized (condition) {
                this.wait(50L);
            }
        }
    }

    public static class Wait
    extends Condition {
        private static String formName(Condition[] conditionArray) {
            Object object = "WAIT(";
            for (Condition condition : conditionArray) {
                object = (String)object + condition.getName() + ",";
            }
            if (((String)object).endsWith(",")) {
                // empty if block
            }
            object = ((String)object).substring(0, ((String)object).length() - 1);
            return (String)object + ")";
        }

        public Wait(Condition ... conditionArray) {
            super(Wait.formName(conditionArray));
            for (Condition condition : conditionArray) {
                condition.addWaiting(this);
            }
        }

        @Override
        public boolean getCondition() {
            return false;
        }
    }

    public static class Or
    extends BinaryCondition {
        public Or(Condition condition, Condition condition2) {
            super(condition.getName() + " OR " + condition2.getName(), condition, condition2);
        }

        @Override
        public boolean getCondition() {
            return this.m_A.getCondition() || this.m_B.getCondition();
        }
    }

    public static class And
    extends BinaryCondition {
        public And(Condition condition, Condition condition2) {
            super(condition.getName() + " AND " + condition2.getName(), condition, condition2);
        }

        @Override
        public boolean getCondition() {
            return this.m_A.getCondition() && this.m_B.getCondition();
        }
    }

    static abstract class BinaryCondition
    extends Condition {
        Condition m_A;
        Condition m_B;

        @Override
        String getName() {
            return "(" + super.getName() + ")";
        }

        BinaryCondition(String string, Condition condition, Condition condition2) {
            super(string);
            this.m_A = condition;
            this.m_B = condition2;
            condition.addWaiting(this);
            condition2.addWaiting(this);
        }
    }
}

