/*
 * Decompiled with CFR 0.152.
 */
package diolanupdater;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class MemoryImage {
    private static final int GROWSIZE = 65536;
    private byte[] m_Image = new byte[0];
    private boolean[] m_Empty = new boolean[0];
    private byte m_Fill;
    private int m_StartAddress = -1;
    private int m_LastAddress = 0;
    private int m_FirstAddress = Integer.MAX_VALUE;

    public byte[] getBytes() {
        return this.getBytes(this.getFirstAddress(), this.getSize());
    }

    public byte[] getBytes(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("address out of range");
        }
        if (n + n2 >= this.m_Image.length) {
            throw new IllegalArgumentException("address+length out of range");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_Image, n, byArray, 0, n2);
        return byArray;
    }

    public void markEmpty(int n, int n2, boolean bl, byte by) {
        this.m_Fill = by;
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            while (n3 > this.m_Image.length) {
                this.growImage();
            }
            this.m_Image[n3] = by;
            this.m_Empty[n3] = bl;
        }
    }

    public boolean isEmpty(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            if (n3 < 0 || n3 >= this.m_Image.length || this.m_Empty[n3]) continue;
            return false;
        }
        return true;
    }

    public void setByte(int n, byte by) {
        while (n >= this.m_Image.length) {
            this.growImage();
        }
        if (n < this.m_FirstAddress) {
            this.m_FirstAddress = n;
        }
        if (n > this.m_LastAddress) {
            this.m_LastAddress = n;
        }
        this.m_Image[n] = by;
        this.m_Empty[n] = false;
    }

    public void setBytes(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = n + i;
            this.setByte(n4, byArray[i + n2]);
        }
    }

    public int getStartAddress() {
        return this.m_StartAddress;
    }

    public int getFirstAddress() {
        return this.m_FirstAddress;
    }

    public int getSize() {
        return this.m_LastAddress - this.m_FirstAddress + 1;
    }

    private void growImage() {
        byte[] byArray = new byte[this.m_Image.length + 65536];
        System.arraycopy(this.m_Image, 0, byArray, 0, this.m_Image.length);
        for (int i = 0; i < 65536; ++i) {
            byArray[this.m_Image.length + i] = this.m_Fill;
        }
        this.m_Image = byArray;
        boolean[] blArray = new boolean[this.m_Empty.length + 65536];
        System.arraycopy(this.m_Empty, 0, blArray, 0, this.m_Empty.length);
        this.m_Empty = blArray;
    }

    public void writeIntelHexEof(PrintStream printStream) throws Exception {
        this.writeIntelHexRecord(printStream, new byte[]{0, 0, 0, 1});
    }

    public void writeIntelHexExtendedLinearAddress(PrintStream printStream, int n) throws Exception {
        this.writeIntelHexRecord(printStream, new byte[]{2, 0, 0, 4, (byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF)});
    }

    public void writeIntelHex(PrintStream printStream, int n, int n2, int n3) throws Exception {
        int n4;
        for (int i = 0; i < n2; i += n4) {
            n4 = n2 - i;
            if (n4 > n3) {
                n4 = n3;
            }
            int n5 = n + i;
            byte[] byArray = new byte[4 + n4];
            byArray[0] = (byte)n4;
            byArray[1] = (byte)(n5 >> 8 & 0xFF);
            byArray[2] = (byte)(n5 & 0xFF);
            byArray[3] = 0;
            byte[] byArray2 = this.getBytes(n5, n4);
            for (int j = 0; j < n4; ++j) {
                byArray[4 + j] = byArray2[j];
            }
            this.writeIntelHexRecord(printStream, byArray);
        }
    }

    private void writeIntelHexRecord(PrintStream printStream, byte[] byArray) throws Exception {
        printStream.printf(":", new Object[0]);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            printStream.printf("%02X", byArray[i] & 0xFF);
            n = (byte)(n + byArray[i]);
        }
        n = (byte)(-n);
        printStream.printf("%02X\n", n & 0xFF);
    }

    public void readIntelHex(InputStream inputStream, byte by, boolean bl) throws Exception {
        String string;
        this.m_Fill = by;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n = 0;
        int n2 = 0;
        block10: while ((string = bufferedReader.readLine()) != null) {
            ++n;
            try {
                int n3;
                if (!string.startsWith(":")) {
                    throw new IllegalArgumentException(String.format("missing ':' marker on line %d", n));
                }
                int n4 = Integer.parseInt(string.substring(1, 3), 16);
                int n5 = Integer.parseInt(string.substring(3, 7), 16);
                int n6 = Integer.parseInt(string.substring(7, 9), 16);
                int n7 = Integer.parseInt(string.substring(n4 * 2 + 9, n4 * 2 + 9 + 2), 16);
                int n8 = 0;
                for (n3 = 0; n3 < 4 + n4; ++n3) {
                    n8 += Integer.parseInt(string.substring(1 + n3 * 2, 1 + n3 * 2 + 2), 16);
                }
                if ((n8 = (n8 & 0xFF ^ 0xFF) + 1 & 0xFF) != n7 && !bl) {
                    throw new IllegalArgumentException(String.format("checksum error on line %d", n));
                }
                switch (n6) {
                    case 0: {
                        for (n3 = 0; n3 < n4; ++n3) {
                            byte by2 = (byte)Integer.parseInt(string.substring(9 + n3 * 2, 9 + n3 * 2 + 2), 16);
                            int n9 = n2 + n5 + n3;
                            if (n9 <= 0) {
                                throw new IllegalArgumentException(String.format("address out of range on line %d", n));
                            }
                            this.setByte(n9, by2);
                        }
                        continue block10;
                    }
                    case 1: {
                        break block10;
                    }
                    case 2: {
                        n2 = Integer.parseInt(string.substring(9, 13), 16) << 4;
                        break;
                    }
                    case 3: 
                    case 5: {
                        this.m_StartAddress = Integer.parseInt(string.substring(9, 27), 16);
                        break;
                    }
                    case 4: {
                        n2 = Integer.parseInt(string.substring(9, 13), 16) << 16;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("unsupported record type %02X on line %d", n6, n));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(String.format("bad format on line %d", n));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                throw new IllegalArgumentException(String.format("too short line %d", n));
            }
        }
    }

    public static void main(String ... stringArray) {
        try {
            MemoryImage memoryImage = new MemoryImage();
            byte[] byArray = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)i;
            }
            memoryImage.setBytes(0x300000, byArray, 0, 256);
            PrintStream printStream = System.out;
            memoryImage.writeIntelHexExtendedLinearAddress(printStream, 0x300000);
            memoryImage.writeIntelHexExtendedLinearAddress(printStream, -65536);
            memoryImage.writeIntelHex(printStream, 0x300000, 16, 16);
            memoryImage.writeIntelHexEof(printStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

