/*
 * Decompiled with CFR 0.152.
 */
package diolanupdater;

import diolanupdater.MemoryImage;
import diolanupdater.Uploader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class UpdateFirmware {
    public boolean updateFirmware(short s, short s2, MemoryImage memoryImage, int n, int n2, Callback callback) throws Exception {
        int n3;
        int n4;
        int n5;
        byte[] byArray = memoryImage.getBytes();
        int n6 = memoryImage.getFirstAddress();
        Uploader uploader = new Uploader(s, s2);
        callback.progress(String.format("Device found (VID=%04X PID=%04X)", s & 0xFFFF, s2 & 0xFFFF), 0);
        Thread.sleep(500L);
        int n7 = 0;
        boolean bl = false;
        while (!bl) {
            byte[] byArray2 = new byte[64];
            byArray2[0] = -2;
            byArray2[1] = 1;
            byte[] byArray3 = uploader.executeCommand(byArray2, false);
            bl = true;
            for (n5 = 2; n5 < 64; ++n5) {
                bl = bl && byArray3[n5] == 0;
            }
            if (bl = bl && byArray3[0] == -1 && byArray3[1] == 1) continue;
            callback.progress(String.format("Not in bootloader mode, reseting the device", new Object[0]), 0);
            Thread.sleep(2000L);
            if (n7 >= 10) {
                callback.progress(String.format("Failed to re-open device, giving up after %d retries", n7), 0);
                return false;
            }
            ++n7;
            uploader.resetToBootloader();
            Thread.sleep(1000L);
            try {
                uploader.close();
            }
            catch (Exception exception) {
                System.out.println("closing device failed, which was kind of expected cause the device was reset...");
            }
            uploader = null;
            callback.progress(String.format("Trying again", new Object[0]), 0);
            while (uploader == null) {
                try {
                    Thread.sleep(1000L);
                    uploader = new Uploader(s, s2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    callback.progress(String.format("Failed to re-open device", new Object[0]), 0);
                }
            }
        }
        System.out.printf("hiAddress 0x%04X\n", n2);
        for (n3 = n; n3 < n2; n3 += n4 * 64) {
            n4 = (n2 - n3) / 64;
            if (n4 > 256) {
                n4 = 256;
            }
            callback.progress(String.format("Erasing 0x%04X", n3), 0);
            uploader.eraseFlash(n3, n4);
        }
        for (n3 = n; n3 < n2; n3 += 32) {
            boolean bl2 = true;
            for (n5 = 0; n5 < 32; ++n5) {
                if (byArray[n3 + n5 - n6] == -1) continue;
                bl2 = false;
                break;
            }
            if (bl2) continue;
            callback.progress(String.format("Programming 0x%04X", n3), 0);
            uploader.writeFlash(n3, byArray, n3 - n6, 32);
        }
        for (n3 = n; n3 < n2; n3 += 32) {
            boolean bl3 = true;
            for (int i = 0; i < 32; ++i) {
                if (byArray[n3 + i - n6] == -1) continue;
                bl3 = false;
                break;
            }
            if (bl3) continue;
            byte[] byArray4 = new byte[32];
            callback.progress(String.format("Verifying 0x%04X", n3), 0);
            uploader.readFlash(n3, byArray4, 0, 32);
            for (int i = 0; i < 32; ++i) {
                if (byArray4[i] == byArray[n3 + i - n6]) continue;
                callback.progress(String.format("Failed at %04X, read %02X != prog %02X\n", n3 + i, byArray4[i] & 0xFF, byArray[n3 + i - n6] & 0xFF), 0);
                return false;
            }
        }
        callback.progress(String.format("Resetting device", new Object[0]), 0);
        uploader.resetTarget();
        try {
            uploader.close();
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("closing device failed.");
        }
        Thread.sleep(500L);
        callback.progress(String.format("Firmware updated succesfully", new Object[0]), 0);
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            MemoryImage memoryImage = new MemoryImage();
            memoryImage.readIntelHex(new FileInputStream(stringArray[0]), (byte)-1, true);
            UpdateFirmware updateFirmware = new UpdateFirmware();
            String[] stringArray2 = new String[]{"x"};
            updateFirmware.updateFirmware((short)7504, (short)24608, memoryImage, 2048, 32704, (string, n) -> {
                stringArray[0] = string.substring(0, 5);
                System.out.println(string);
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static interface Callback {
        public void progress(String var1, int var2);
    }
}

