/*
 * Decompiled with CFR 0.152.
 */
package diolanupdater;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import purejavahidapi.HidDevice;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.PureJavaHidApi;

public class Uploader {
    private static final boolean DEBUG = false;
    private static final int EEPROM_PAGE_LENGTH = 8;
    private static final int FLASH_PAGE_LENGTH = 32;
    private static final int ID_PAGE_LENGTH = 8;
    private HidDevice m_Device;
    private boolean m_Closing = false;
    private byte m_EchoId = (byte)55;
    private String m_ProductString;
    private SynchronousQueue<byte[]> m_InputReport = new SynchronousQueue();

    public HidDevice openDevice(short s, short s2) throws IOException {
        HidDeviceInfo hidDeviceInfo = null;
        List list = PureJavaHidApi.enumerateDevices();
        for (HidDeviceInfo hidDeviceInfo2 : list) {
            if (hidDeviceInfo2.getVendorId() != s || hidDeviceInfo2.getProductId() != s2) continue;
            hidDeviceInfo = hidDeviceInfo2;
            return PureJavaHidApi.openDevice((HidDeviceInfo)hidDeviceInfo);
        }
        return null;
    }

    public Uploader(short s, short s2) throws IOException {
        this.m_Device = this.openDevice(s, s2);
        if (this.m_Device == null) {
            throw new FileNotFoundException();
        }
        this.m_Device.setInputReportListener(new InputReportListener(){

            public void onInputReport(HidDevice hidDevice, byte by, byte[] byArray, int n) {
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                try {
                    if (!Uploader.this.m_Closing && !Uploader.this.m_InputReport.offer(byArray2, 1000L, TimeUnit.MILLISECONDS)) {
                        System.out.println("m_InputReport.offer timed out!");
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }

    public byte[] newCommand(byte by) {
        byte[] byArray = new byte[64];
        byArray[0] = by;
        byArray[1] = this.m_EchoId = (byte)(this.m_EchoId + 1);
        return byArray;
    }

    public void resetToBootloader() throws Exception {
        byte[] byArray = this.newCommand((byte)0);
        byArray[0] = -2;
        byArray[1] = -19;
        byArray[2] = -64;
        byArray[3] = -34;
        this.m_Device.setOutputReport((byte)0, byArray, byArray.length);
    }

    public byte[] executeCommand(byte[] byArray) throws Exception {
        return this.executeCommand(byArray, true);
    }

    public byte[] executeCommand(byte[] byArray, boolean bl) throws Exception {
        byte[] byArray2 = null;
        while (byArray2 == null || bl && byArray2[1] != byArray[1]) {
            this.m_Device.setOutputReport((byte)0, byArray, byArray.length);
            try {
                byArray2 = this.m_InputReport.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Thread.sleep(2L);
        return byArray2;
    }

    public void readFlash(int n, byte[] byArray, int n2, int n3) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 65535);
        this.ensure(n % 2 == 0);
        this.ensure(n3 >= 0);
        this.ensure(n3 % 8 == 0);
        this.ensure(n3 <= 32);
        this.ensure(n2 >= 0);
        this.ensure(n2 + n3 <= byArray.length);
        byte[] byArray2 = this.newCommand((byte)1);
        byArray2[2] = (byte)n;
        byArray2[3] = (byte)(n >> 8);
        byArray2[5] = (byte)n3;
        byte[] byArray3 = this.executeCommand(byArray2);
        for (int i = 0; i < n3; ++i) {
            byArray[n2 + i] = byArray3[i + 6];
        }
    }

    public void writeFlash(int n, byte[] byArray, int n2, int n3) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 65535);
        this.ensure(n % 2 == 0);
        this.ensure(n3 >= 0);
        this.ensure(n3 % 8 == 0);
        this.ensure(n3 <= 32);
        this.ensure(n2 >= 0);
        this.ensure(n2 + n3 <= byArray.length);
        byte[] byArray2 = this.newCommand((byte)2);
        byArray2[2] = (byte)n;
        byArray2[3] = (byte)(n >> 8);
        byArray2[5] = (byte)n3;
        for (int i = 0; i < n3; ++i) {
            byArray2[i + 6] = byArray[n2 + i];
        }
        this.executeCommand(byArray2);
    }

    public void eraseFlash(int n, int n2) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 65535);
        this.ensure(n % 64 == 0);
        this.ensure(n2 > 0);
        this.ensure(n2 <= 256);
        byte[] byArray = this.newCommand((byte)3);
        byArray[2] = (byte)n;
        byArray[3] = (byte)(n >> 8);
        byArray[5] = (byte)n2;
        this.executeCommand(byArray);
    }

    public int getFwVersion() throws Exception {
        byte[] byArray = this.newCommand((byte)4);
        byte[] byArray2 = this.executeCommand(byArray);
        return ((byArray2[2] & 0xFF) << 16) + ((byArray2[3] & 0xFF) << 8) + (byArray2[4] & 0xFF);
    }

    public void resetTarget() throws Exception {
        byte[] byArray = this.newCommand((byte)5);
        this.m_Device.setOutputReport((byte)0, byArray, byArray.length);
    }

    public void readId(byte[] byArray, int n) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 8);
        this.ensure(n <= byArray.length);
        byte[] byArray2 = this.newCommand((byte)6);
        byArray2[5] = (byte)n;
        byte[] byArray3 = this.executeCommand(byArray2);
        for (int i = 0; i < n; ++i) {
            byArray[i] = byArray3[i + 6];
        }
    }

    public void writeId(byte[] byArray, int n) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 8);
        this.ensure(n <= byArray.length);
        byte[] byArray2 = this.newCommand((byte)7);
        byArray2[5] = (byte)n;
        for (int i = 0; i < n; ++i) {
            byArray2[i + 6] = byArray[i];
        }
        this.executeCommand(byArray2);
    }

    public void readEEPROM(int n, byte[] byArray, int n2) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 255);
        this.ensure(n2 >= 0);
        this.ensure(n2 <= 8);
        this.ensure(n2 <= byArray.length);
        byte[] byArray2 = this.newCommand((byte)8);
        byArray2[2] = (byte)n;
        byArray2[5] = (byte)n2;
        byte[] byArray3 = this.executeCommand(byArray2);
        for (int i = 0; i < n2; ++i) {
            byArray[i] = byArray3[i + 6];
        }
    }

    public void writeEEPROM(int n, byte[] byArray, int n2) throws Exception {
        this.ensure(n >= 0);
        this.ensure(n <= 255);
        this.ensure(n2 >= 0);
        this.ensure(n2 <= 8);
        this.ensure(n2 <= byArray.length);
        byte[] byArray2 = this.newCommand((byte)9);
        byArray2[2] = (byte)n;
        byArray2[5] = (byte)n2;
        for (int i = 0; i < n2; ++i) {
            byArray2[i + 6] = byArray[i];
        }
        this.executeCommand(byArray2);
    }

    public void close() {
        this.m_Closing = true;
        this.m_Device.close();
    }

    private void ensure(boolean bl) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException("value out of range");
        }
    }
}

