/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.InvalidValueException;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Validator;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.Canvas;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.Image;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.ToggleButton;
import com.eazycnc.uwk.widgets.Widget;
import eazycnc.AnimationScheduler;
import eazycnc.Main;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import motorcontrol.MachController;

public class AxisSetupPanel {
    public static Layout newAxisSetupPenel(Main main) {
        Layout layout = UWKit.newLayout("flowx");
        layout.add(UWKit.newLabel("Selected Setup:"), new String[0]);
        final CardLayout cardLayout = UWKit.newCardLayout();
        SimpleVariable simpleVariable = new SimpleVariable("");
        ToggleButton toggleButton = null;
        int n = 6;
        Main.m_ScreenCap.push(simpleVariable);
        for (int i = 0; i < n; ++i) {
            String string = Interpreter.getAxisLetter(i);
            String string2 = "axis-" + string;
            if (i == 0) {
                simpleVariable.setValue(string2);
            }
            cardLayout.addCard(string2, AxisSetupPanel.newOneAxisSetup(main, i));
            toggleButton = UWKit.newToggleButton((Variable)simpleVariable, string + "-Axis", (Object)string2, (Object)"growx");
            layout.add(toggleButton, new String[0]);
            Main.m_ScreenCap.addValue(string2);
        }
        Main.m_ScreenCap.pop();
        simpleVariable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                String string = variable.getValue().toString();
                cardLayout.selectCard(string);
            }
        });
        Layout layout2 = UWKit.newTitledLayout("Axis Setup", "flowy");
        layout2.add(layout, new String[0]);
        layout2.add(cardLayout, "growx,growy");
        return layout2;
    }

    private static Widget newIndicatorLed(MachController machController, int n, int n2) {
        Canvas[] canvasArray = new Canvas[]{null};
        Image[] imageArray = new Image[]{UWKit.loadImage("led-gray.png"), UWKit.loadImage("led-green.png")};
        canvasArray[0] = UWKit.newCanvas((graphics, n3, n4) -> {
            int n5 = machController.m_MachState.getParamInt(n, n2);
            int n6 = machController.m_MachState.getParamInt(-2147483644, n2);
            if (n5 >= 0 && n6 != -1 && machController.getMotorController().getHomeInput(n5)) {
                graphics.drawImage(imageArray[1], 0, 0, 16, 16);
            } else {
                graphics.drawImage(imageArray[0], 0, 0, 16, 16);
            }
            AnimationScheduler.scheduleRepaint(canvasArray[0]);
        });
        return canvasArray[0];
    }

    private static Widget newOneAxisSetup(final Main main, int n) {
        Object object2;
        final MachState machState = main.m_MachController.getMachState();
        Variable variable = n < 3 ? machState.getLengthUnit() : new SimpleVariable("deg");
        Layout layout = UWKit.newTitledLayout("Motor Config");
        Layout layout2 = UWKit.newTitledLayout("Axis Limits");
        layout.add(UWKit.newCheckBox((Variable)machState.getVariable(-2147483645, n), "Axis ON", (Object)true, (Object)false), "wrap");
        Layout layout3 = null;
        if (n == 2) {
            layout3 = UWKit.newTitledLayout("Safe Z");
            layout3.add(UWKit.newLabel("Safe Z"), "sgy,align right");
            layout3.add(UWKit.newTextField((Variable)machState.getScaledVariable(15192), 16.0, 7, machState.getDroFormatVariable(), null), "");
            layout3.add(UWKit.newLabel(variable), "align left");
            object2 = UWKit.newButton("Set");
            layout3.add((Widget)object2, "wrap 0");
            object2.addActionListener(new ActionListener(){

                @Override
                public void onAction() {
                    if (main.checkConnected()) {
                        double[] dArray = main.m_MachController.axisPositionFromMotorPosition(main.m_MachController.getMotorPosition());
                        machState.getVariable(15192).setValue(dArray[2]);
                    }
                }
            });
        }
        layout.add(UWKit.newLabel(UWKit.concat(UWKit.concat("Steps/", variable), ":")), "sgy,align right");
        if (n < 3) {
            layout.add(UWKit.newTextField((Variable)UWKit.multiply((Variable)machState.getNumericVariable(-2147483646, n), machState.getNumericVariable(15141)), 16.0, 7, machState.getDroFormatVariable(), null), "wrap");
        } else {
            layout.add(UWKit.newTextField((Variable)UWKit.multiply((Variable)machState.getNumericVariable(-2147483646, n), machState.getNumericVariable(15141)), 16.0, 7, machState.getDroFormatVariable(), null), "wrap");
        }
        layout.add(UWKit.newLabel("Scaler:"), "sgy,align right,");
        layout.add(UWKit.newTextField((Variable)machState.getNumericVariable(-2147483633, n), 16.0, 7, machState.getDroFormatVariable(), null), "split 2,wrap");
        layout.add(UWKit.newLabel("Current:"), "sgy,align right,");
        layout.add(UWKit.newComboBox((Variable)machState.getVariable(Integer.MIN_VALUE, n), "Low", 0, "High", 1, "Auto Hold", 2, "Auto Off", 3), "wrap");
        layout.add(UWKit.newLabel("Forward:"), "sgy,align right,");
        layout.add(UWKit.newComboBox((Variable)machState.getVariable(-2147483643, n), "Output=1", 1, "Output=0", 0), "wrap");
        layout.add(UWKit.newLabel("Home polarity:"), "sgy,align right,");
        layout.add(UWKit.newComboBox((Variable)machState.getVariable(-2147483644, n), "Input=1", 1, "Input=0", 0, "None", -1), "wrap");
        layout.add(UWKit.newCheckBox((Variable)machState.getVariable(-2147483632, n), "Invert Enable"), "skip,wrap");
        object2 = UWKit.divide((Variable)((NumericVariable)machState.getVariable(-2147483647, n)), machState.getNumericVariable(15141));
        layout.add(UWKit.newLabel(UWKit.concat("Home offset:")), "align right,");
        layout.add(UWKit.newTextField((Variable)object2, 16.0, 7, machState.getDroFormatVariable(), null), "sgx g1,split 2");
        layout.add(UWKit.newLabel(variable), "align left,wrap");
        Object[] objectArray = new Object[]{"Motor 0", 0, "Motor 1", 1, "Motor 2", 2, "Motor 3", 3, "Motor 4", 4, "Motor 5", 5, "None", -1};
        layout.add(UWKit.newLabel("Master Motor:"), "sgy,align right,");
        layout.add(UWKit.newComboBox((Variable)machState.getVariable(-2147483638, n), objectArray), "wrap");
        layout.add(UWKit.newLabel(""), "sgy,align right,");
        layout.add(AxisSetupPanel.newIndicatorLed(main.m_MachController, -2147483638, n), "w 16:16:16,h 16:16:16, split 2");
        layout.add(UWKit.newLabel("Home switch"), "sgy,align left,wrap,skip");
        layout.add(UWKit.newLabel("Slave Motor:"), "sgy,align right,");
        layout.add(UWKit.newComboBox((Variable)machState.getVariable(-2147483637, n), objectArray), "wrap");
        layout.add(UWKit.newLabel(""), "sgy,align right,");
        layout.add(AxisSetupPanel.newIndicatorLed(main.m_MachController, -2147483637, n), "w 16:16:16,h 16:16:16,split 2");
        layout.add(UWKit.newLabel("Home switch"), "sgy,align left,wrap");
        Validator validator = object -> {
            int n2 = (Integer)object;
            if (n2 < 0) {
                return;
            }
            for (int i = 0; i < 6; ++i) {
                String string = "Motor " + n2 + " is used by axis " + Interpreter.getAxisLetter(i);
                if (i != n && machState.getParamInt(-2147483638, i) == n2) {
                    throw new InvalidValueException(string);
                }
                if (machState.getParamInt(-2147483637, i) != n2) continue;
                throw new InvalidValueException(string);
            }
        };
        Validator validator2 = object -> {
            int n2 = (Integer)object;
            if (n2 < 0) {
                return;
            }
            for (int i = 0; i < 6; ++i) {
                String string = "Motor " + n2 + " is used by axis " + Interpreter.getAxisLetter(i);
                if (machState.getParamInt(-2147483638, i) == n2) {
                    throw new InvalidValueException(string);
                }
                if (i == n || machState.getParamInt(-2147483637, i) != n2) continue;
                throw new InvalidValueException(string);
            }
        };
        machState.getVariable(-2147483638, n).setValidator(validator);
        machState.getVariable(-2147483637, n).setValidator(validator2);
        layout2.add(UWKit.newLabel(""), "sgy");
        layout2.add(UWKit.newCheckBox((Variable)machState.getVariable(-2147483640, n), "Limits enabled", (Object)true, (Object)false), "wrap,span 3");
        layout2.add(UWKit.newLabel(UWKit.concat("Min:")), "sgy,align right");
        NumericVariable numericVariable = UWKit.divide((Variable)((NumericVariable)machState.getVariable(-2147483642, n)), machState.getNumericVariable(15141));
        layout2.add(UWKit.newTextField((Variable)numericVariable, 16.0, 7, machState.getDroFormatVariable(), null), "sgx g1");
        layout2.add(UWKit.newLabel(variable), "align left");
        Button button = UWKit.newButton("Touch");
        layout2.add(button, "wrap 0");
        final int n2 = n;
        button.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                main.checkConnected();
                double[] dArray = main.m_MachController.axisPositionFromMotorPosition(main.m_MachController.getMotorPosition());
                machState.getVariable(-2147483642, n2).setValue(dArray[n2]);
            }
        });
        layout2.add(UWKit.newLabel(UWKit.concat("Max:")), "align right");
        NumericVariable numericVariable2 = UWKit.divide((Variable)((NumericVariable)machState.getVariable(-2147483641, n)), machState.getNumericVariable(15141));
        layout2.add(UWKit.newTextField((Variable)numericVariable2, 16.0, 7, machState.getDroFormatVariable(), null), "sgx g1");
        layout2.add(UWKit.newLabel(variable), "align left");
        Button button2 = UWKit.newButton("Touch");
        layout2.add(button2, "wrap 0");
        button2.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                main.checkConnected();
                double[] dArray = main.m_MachController.axisPositionFromMotorPosition(main.m_MachController.getMotorPosition());
                machState.getVariable(-2147483641, n2).setValue(dArray[n2]);
            }
        });
        Variable variable2 = UWKit.concat(variable, "/s");
        Variable variable3 = UWKit.concat(variable, "/s^2");
        Variable variable4 = UWKit.concat(variable, "/s^3");
        Variable variable5 = variable;
        Layout layout4 = UWKit.newTitledLayout("Motion Limits");
        layout4.add(UWKit.newLabel("Velocity:"), "align right");
        layout4.add(UWKit.newTextField((Variable)machState.getScaledVariable(15149), 16.0, 7, machState.getDroFormatVariable(), null), new String[0]);
        layout4.add(UWKit.newLabel(variable2), "wrap");
        layout4.add(UWKit.newLabel("Acceleration:"), "align right");
        layout4.add(UWKit.newTextField((Variable)machState.getScaledVariable(15148), 16.0, 7, machState.getDroFormatVariable(), null), new String[0]);
        layout4.add(UWKit.newLabel(variable3), "wrap");
        int n3 = Main.compactUI() ? 6 : 7;
        Layout layout5 = UWKit.newTitledLayout("Jogging");
        layout5.add(UWKit.newLabel("Crawl velc.:"), "align right");
        layout5.add(UWKit.newTextField((Variable)machState.getScaledVariable(0x20000000, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout5.add(UWKit.newLabel(variable2), "align left,wrap");
        layout5.add(UWKit.newLabel("Crawl len.:"), "align right");
        layout5.add(UWKit.newTextField((Variable)machState.getScaledVariable(0x20000003, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout5.add(UWKit.newLabel(variable), "align left,wrap");
        layout5.add(UWKit.newLabel("Min. crawl:"), "align right");
        layout5.add(UWKit.newTextField((Variable)machState.getScaledVariable(0x20000004, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout5.add(UWKit.newLabel(variable), "align left,wrap");
        layout5.add(UWKit.newLabel("Accel.:"), "align right");
        layout5.add(UWKit.newTextField((Variable)machState.getScaledVariable(0x20000002, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout5.add(UWKit.newLabel(variable3), "align left,wrap");
        layout5.add(UWKit.newLabel("Jog velc.:"), "align right");
        layout5.add(UWKit.newTextField((Variable)machState.getScaledVariable(0x20000001, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout5.add(UWKit.newLabel(variable2), "align left,wrap");
        Layout layout6 = UWKit.newTitledLayout("Homing");
        layout6.add(UWKit.newLabel("Crawl velc.:"), "align right");
        layout6.add(UWKit.newTextField((Variable)machState.getScaledVariable(-2147483636, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout6.add(UWKit.newLabel(variable2), "align left,wrap");
        layout6.add(UWKit.newLabel("Home velo.:"), "align right");
        layout6.add(UWKit.newTextField((Variable)machState.getScaledVariable(-2147483635, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout6.add(UWKit.newLabel(variable2), "align left,wrap");
        layout6.add(UWKit.newLabel("Accel.:"), "align right");
        layout6.add(UWKit.newTextField((Variable)machState.getScaledVariable(-2147483634, n), 16.0, n3, machState.getDroFormatVariable(), null), new String[0]);
        layout6.add(UWKit.newLabel(variable3), "align left,wrap");
        Layout layout7 = layout;
        Layout layout8 = UWKit.newLayout("flowy");
        layout8.add(layout5, "growx");
        Layout layout9 = UWKit.newLayout("flowy");
        layout9.add(layout6, "growx");
        layout9.add(layout2, "growx");
        Layout layout10 = UWKit.newLayout("flowx,filly");
        layout10.add(layout7, "grow");
        layout10.add(layout8, "grow");
        layout10.add(layout9, "grow");
        if (layout3 != null) {
            layout9.add(layout3, "growx");
        }
        return layout10;
    }
}

