/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import eazycnc.GCodeEditorPanel;
import eazycnc.Main;
import eazycnc.Worker;
import eazycnc.gcode.FileReader;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import eazycnc.gcode.Parser;
import eazycnc.gcode.RadiusCompensator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BackgroundCompiler {
    private Main m_Main;
    private MachState m_CompileMachState;
    private LinkedList<File> m_AccessedFiles = new LinkedList();
    private Worker m_Worker;
    private volatile boolean m_CompileInProgress;

    public void setPriority(int n) {
        this.m_Worker.setPriority(n);
    }

    public BackgroundCompiler(Main main) {
        this.m_Main = main;
        this.m_Worker = new Worker();
    }

    public boolean compile(final File file, final Map<String, byte[]> map, final CompileCompleted compileCompleted) {
        if (this.m_CompileInProgress) {
            return false;
        }
        this.m_CompileInProgress = true;
        this.m_AccessedFiles.clear();
        final FileReader.FileAccessor fileAccessor = new FileReader.FileAccessor(){

            @Override
            public byte[] readFile(String string) throws IOException {
                byte[] byArray;
                File file2 = GCodeEditorPanel.resolve(file, string);
                byte[] byArray2 = byArray = map != null ? (byte[])map.get(file2.getCanonicalPath()) : null;
                if (byArray == null) {
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    int n = 0;
                    int n2 = (int)file2.length();
                    byArray = new byte[n2];
                    while ((n += fileInputStream.read(byArray, n, n2 - n)) < n2) {
                    }
                    BackgroundCompiler.this.m_AccessedFiles.add(file2);
                    fileInputStream.close();
                }
                return byArray;
            }
        };
        this.m_Main.m_MachController.syncMachStateWithMotorPositions();
        MachState machState = this.m_Main.m_MachController.getMachState();
        this.m_CompileMachState = new MachState("COMPILER", false);
        this.m_CompileMachState.restoreStateFrom(machState);
        Worker.Task task = new Worker.Task(){

            @Override
            public Object doInBackground() {
                long l = System.nanoTime();
                try {
                    String string = file != null ? file.getName() : "anonymous";
                    Machcode machcode = BackgroundCompiler.this.m_Main.m_Parser.parseFile(BackgroundCompiler.this.m_CompileMachState, fileAccessor, string);
                    double d = BackgroundCompiler.this.m_CompileMachState.getParamDouble(15171) / 100.0;
                    if (!BackgroundCompiler.this.m_CompileMachState.getParamBoolean(15170)) {
                        d = 0.0;
                    }
                    double d2 = BackgroundCompiler.this.m_CompileMachState.getParamDouble(15173) / 100.0;
                    RadiusCompensator.process(machcode, d, d2);
                }
                catch (Parser.ParseException parseException) {
                    return parseException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return exception;
                }
                long l2 = System.nanoTime();
                return BackgroundCompiler.this.m_Main.m_Parser.getMachCode();
            }

            @Override
            public void onBackroundTaskCompleted(Object object) {
                try {
                    if (object instanceof Parser.ParseException) {
                        compileCompleted.compileError(BackgroundCompiler.this.m_AccessedFiles, (Parser.ParseException)object);
                    } else if (object instanceof Machcode) {
                        compileCompleted.compileCompleted(BackgroundCompiler.this.m_AccessedFiles, (Machcode)object);
                    } else if (object instanceof Exception) {
                        ((Exception)object).printStackTrace();
                    }
                }
                finally {
                    BackgroundCompiler.this.m_CompileInProgress = false;
                    BackgroundCompiler.this.m_AccessedFiles.clear();
                    BackgroundCompiler.this.m_CompileMachState = null;
                }
            }
        };
        this.m_Worker.execute(task);
        return true;
    }

    public boolean isCompiling() {
        return this.m_CompileInProgress;
    }

    public static interface CompileCompleted {
        public void compileError(List<File> var1, Parser.ParseException var2);

        public void compileCompleted(List<File> var1, Machcode var2);
    }
}

