/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import eazycnc.Main;
import eazycnc.gcode.MachState;
import java.io.FileNotFoundException;

public class ConfigSaveOnAndroid {
    static FileDialogCallback m_FileSelectedCallback;

    public static void testx(Main main) {
        ConfigSaveOnAndroid.loadConfigFromFileSystem(main);
        ConfigSaveOnAndroid.saveConfigToFileSystem(main);
    }

    public static void loadConfigFromFileSystem(final Main main) {
        final MachState machState = main.m_MachController.getMachState();
        UWKit.showConfirmDialog("Load configuration from the file system", "No configuration found -- do you want to browse the file system for it?", "Yes", null, "No", new DialogCallback(){

            @Override
            public void onClose(DialogCallback.DialogOptions dialogOptions) {
                if (dialogOptions == DialogCallback.DialogOptions.YES) {
                    final String string = machState.getParamString(15301);
                    m_FileSelectedCallback = new FileDialogCallback(){

                        @Override
                        public void onFileSelected(String string2) {
                            if (string2 != null) {
                                boolean bl = false;
                                try {
                                    machState.loadState(string2);
                                    bl = true;
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    Main.m_MainWindow.setButtonErrorAndBeep("Reading config file '" + string2 + "' failed because it could not be found ");
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    Main.m_MainWindow.setButtonErrorAndBeep("Reading config file failed, " + illegalArgumentException.getMessage());
                                }
                                catch (Exception exception) {
                                    Main.m_MainWindow.setButtonErrorAndBeep("Reading config file failed with exception " + exception);
                                }
                                if (!bl) {
                                    UWKit.showFileDialog(string, false, m_FileSelectedCallback);
                                }
                            }
                        }
                    };
                    UWKit.showFileDialog(string, false, m_FileSelectedCallback);
                }
            }
        });
    }

    public static void saveConfigToFileSystem(final Main main) {
        final MachState machState = main.m_MachController.getMachState();
        UWKit.showConfirmDialog("Save configuration to file system", "Your configuration has been saved. <br> <br>Do you also want to save a copy of the configuration to the file system?", "Yes", null, "No", new DialogCallback(){

            @Override
            public void onClose(DialogCallback.DialogOptions dialogOptions) {
                if (dialogOptions == DialogCallback.DialogOptions.YES) {
                    String string = machState.getParamString(15301);
                    UWKit.showFileDialog(string, true, new FileDialogCallback(){

                        @Override
                        public void onFileSelected(String string) {
                            try {
                                machState.saveState(string);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                Main.m_MainWindow.setButtonErrorAndBeep("Saving config file '" + string + "' failed because it could written");
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                Main.m_MainWindow.setButtonErrorAndBeep("Saving config file failed because it was " + illegalArgumentException.getMessage());
                            }
                            catch (Exception exception) {
                                Main.m_MainWindow.setButtonErrorAndBeep("Saving config file failed with exception " + exception);
                            }
                        }
                    });
                }
            }
        });
    }
}

