/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class EditMenuHandler {
    private int m_EditCount;
    private JTextArea m_TextComponent;
    private UndoManager m_UndoManager;
    private JMenuItem m_UndoAction;
    private JMenuItem m_RedoAction;
    private JMenuItem m_CopyAction;
    private JMenuItem m_CutAction;
    private JMenuItem m_PasteAction;
    private int m_UpdateMenu;
    private boolean m_CanUndo;
    private boolean m_CanRedo;
    private boolean m_CanCutCopy;
    private boolean m_CanPaste;
    private boolean m_IsDirty;
    private ActionListener m_MenuActionListener;

    void clearDirty() {
        this.m_EditCount = 0;
        this.m_UndoManager.discardAllEdits();
        this.updateEditMenu();
    }

    public int editCount() {
        return this.m_EditCount;
    }

    public boolean isDirty() {
        return this.m_EditCount > 0;
    }

    public void undo() {
        this.m_UndoManager.undo();
    }

    public void redo() {
        this.m_UndoManager.redo();
    }

    public boolean canUndo() {
        return this.m_CanUndo;
    }

    public boolean canRedo() {
        return this.m_CanRedo;
    }

    public boolean canCut() {
        return this.m_CanCutCopy;
    }

    public boolean canCopy() {
        return this.m_CanCutCopy;
    }

    public boolean canPaste() {
        return this.m_CanPaste;
    }

    private boolean update(boolean bl, boolean bl2) {
        if (bl != bl2) {
            ++this.m_UpdateMenu;
            return bl2;
        }
        return bl;
    }

    private void updateEditMenu() {
        int n = this.m_TextComponent.getSelectionStart();
        int n2 = this.m_TextComponent.getSelectionEnd();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        boolean bl = false;
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                bl = !transferable.getTransferData(DataFlavor.stringFlavor).toString().equals("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.m_CanUndo = this.update(this.m_CanUndo, this.m_UndoManager.canUndo());
        this.m_CanRedo = this.update(this.m_CanRedo, this.m_UndoManager.canRedo());
        this.m_CanCutCopy = this.update(this.m_CanCutCopy, n != n2);
        this.m_CanPaste = this.update(this.m_CanPaste, bl);
        this.m_IsDirty = this.update(this.m_IsDirty, this.isDirty());
        if (this.m_UpdateMenu > 0) {
            if (this.m_UndoAction != null) {
                this.m_UndoAction.setEnabled(this.m_CanUndo);
            }
            if (this.m_RedoAction != null) {
                this.m_RedoAction.setEnabled(this.m_CanRedo);
            }
            if (this.m_CutAction != null) {
                this.m_CutAction.setEnabled(this.m_CanCutCopy);
            }
            if (this.m_CopyAction != null) {
                this.m_CopyAction.setEnabled(this.m_CanCutCopy);
            }
            if (this.m_PasteAction != null) {
                this.m_PasteAction.setEnabled(this.m_CanPaste);
            }
        }
        this.m_UpdateMenu = 0;
    }

    public EditMenuHandler(JTextArea jTextArea, JMenuItem jMenuItem, JMenuItem jMenuItem2, JMenuItem jMenuItem3, JMenuItem jMenuItem4, JMenuItem jMenuItem5) {
        this.m_TextComponent = jTextArea;
        this.m_UndoManager = new UndoManager(){

            @Override
            public synchronized boolean addEdit(UndoableEdit undoableEdit) {
                ++EditMenuHandler.this.m_EditCount;
                EditMenuHandler.this.updateEditMenu();
                return super.addEdit(undoableEdit);
            }

            @Override
            public synchronized void undo() throws CannotUndoException {
                super.undo();
                --EditMenuHandler.this.m_EditCount;
                EditMenuHandler.this.updateEditMenu();
            }

            @Override
            public synchronized void redo() throws CannotUndoException {
                ++EditMenuHandler.this.m_EditCount;
                EditMenuHandler.this.updateEditMenu();
                super.redo();
            }
        };
        this.m_UndoAction = jMenuItem;
        this.m_RedoAction = jMenuItem2;
        this.m_CutAction = jMenuItem3;
        this.m_CopyAction = jMenuItem4;
        this.m_PasteAction = jMenuItem5;
        this.m_TextComponent.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditMenuHandler.this.updateEditMenu();
                    }
                });
            }
        });
        this.m_TextComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                EditMenuHandler.this.m_MenuActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() == EditMenuHandler.this.m_UndoAction) {
                            EditMenuHandler.this.undo();
                        }
                        if (actionEvent.getSource() == EditMenuHandler.this.m_RedoAction) {
                            EditMenuHandler.this.redo();
                        }
                        if (actionEvent.getSource() == EditMenuHandler.this.m_CutAction) {
                            EditMenuHandler.this.m_TextComponent.cut();
                        }
                        if (actionEvent.getSource() == EditMenuHandler.this.m_CopyAction) {
                            EditMenuHandler.this.m_TextComponent.copy();
                        }
                        if (actionEvent.getSource() == EditMenuHandler.this.m_PasteAction) {
                            EditMenuHandler.this.m_TextComponent.paste();
                        }
                    }
                };
                if (EditMenuHandler.this.m_UndoAction != null) {
                    EditMenuHandler.this.m_UndoAction.addActionListener(EditMenuHandler.this.m_MenuActionListener);
                }
                if (EditMenuHandler.this.m_RedoAction != null) {
                    EditMenuHandler.this.m_RedoAction.addActionListener(EditMenuHandler.this.m_MenuActionListener);
                }
                if (EditMenuHandler.this.m_CutAction != null) {
                    EditMenuHandler.this.m_CutAction.addActionListener(EditMenuHandler.this.m_MenuActionListener);
                }
                if (EditMenuHandler.this.m_CopyAction != null) {
                    EditMenuHandler.this.m_CopyAction.addActionListener(EditMenuHandler.this.m_MenuActionListener);
                }
                if (EditMenuHandler.this.m_PasteAction != null) {
                    EditMenuHandler.this.m_PasteAction.addActionListener(EditMenuHandler.this.m_MenuActionListener);
                }
                EditMenuHandler.this.m_UpdateMenu = 1;
                EditMenuHandler.this.updateEditMenu();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (EditMenuHandler.this.m_MenuActionListener != null) {
                    if (EditMenuHandler.this.m_UndoAction != null) {
                        EditMenuHandler.this.m_UndoAction.removeActionListener(EditMenuHandler.this.m_MenuActionListener);
                    }
                    if (EditMenuHandler.this.m_RedoAction != null) {
                        EditMenuHandler.this.m_RedoAction.removeActionListener(EditMenuHandler.this.m_MenuActionListener);
                    }
                    if (EditMenuHandler.this.m_CutAction != null) {
                        EditMenuHandler.this.m_CutAction.removeActionListener(EditMenuHandler.this.m_MenuActionListener);
                    }
                    if (EditMenuHandler.this.m_CopyAction != null) {
                        EditMenuHandler.this.m_CopyAction.removeActionListener(EditMenuHandler.this.m_MenuActionListener);
                    }
                    if (EditMenuHandler.this.m_PasteAction != null) {
                        EditMenuHandler.this.m_PasteAction.removeActionListener(EditMenuHandler.this.m_MenuActionListener);
                    }
                    EditMenuHandler.this.m_MenuActionListener = null;
                }
                EditMenuHandler.this.m_UpdateMenu = 1;
                EditMenuHandler.this.updateEditMenu();
            }
        });
        this.m_TextComponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                EditMenuHandler.this.m_UndoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
    }
}

