/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.SourceCodeEditor;
import com.eazycnc.uwk.widgets.TabbedLayout;
import com.eazycnc.uwk.widgets.Widget;
import eazycnc.BackgroundCompiler;
import eazycnc.Main;
import eazycnc.gcode.FilePos;
import eazycnc.gcode.FileReader;
import eazycnc.gcode.Machcode;
import eazycnc.gcode.Parser;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import motorcontrol.MachiningState;

public class GCodeEditorPanel {
    private Main m_Main;
    private Button m_SaveButton;
    private Button m_CloseButton;
    private Button m_ReloadButton;
    private Button m_NewButton;
    private Button m_GotoButton;
    private Button m_DesktopButton;
    private Button m_LoadButton;
    private Parser.ParseException m_Error;
    private File m_ErrorFile;
    private FilePos m_CurrentMachCodeFilePos;
    private int m_RetrigTimer;
    private File m_MainProgram;
    private SimpleVariable m_ErrorText = new SimpleVariable("");
    private Layout m_Layout;
    private boolean m_ZoomOutPending = true;
    private boolean m_ZoomToGrid = true;
    private TabbedLayout m_TabLayout;
    private Hashtable<String, FileInfo> m_OpenFiles = new Hashtable();

    public void closeAllSourceCodeEditors(Runnable runnable) {
        LinkedList<SourceCodeEditor> linkedList = new LinkedList<SourceCodeEditor>();
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            linkedList.add(sourceCodeEditor);
        }
        this.closeSourceCodeEditors(linkedList, runnable).run();
    }

    private Runnable closeSourceCodeEditors(LinkedList<SourceCodeEditor> linkedList, Runnable runnable) {
        if (linkedList.isEmpty()) {
            return runnable;
        }
        SourceCodeEditor sourceCodeEditor = linkedList.removeFirst();
        Runnable runnable2 = this.closeSourceCodeEditors(linkedList, runnable);
        return () -> this.closeFile(sourceCodeEditor, runnable2);
    }

    private void closeFile(final SourceCodeEditor sourceCodeEditor, final Runnable runnable) {
        sourceCodeEditor.closeFile(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = sourceCodeEditor.getFile().getCanonicalPath();
                    GCodeEditorPanel.this.m_OpenFiles.remove(string);
                    if (GCodeEditorPanel.this.m_MainProgram != null && GCodeEditorPanel.this.m_MainProgram.getCanonicalPath().equals(string)) {
                        GCodeEditorPanel.this.m_MainProgram = null;
                        GCodeEditorPanel.this.m_Main.m_ToolpathDisplayPanel.clearAllToolpaths();
                    }
                    GCodeEditorPanel.this.m_TabLayout.removeTab(sourceCodeEditor);
                    GCodeEditorPanel.this.m_CloseButton.setEnabled(false);
                    if (runnable != null) {
                        runnable.run();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public static JButton newToolbarButton(String string) {
        JButton jButton = new JButton(string);
        jButton.putClientProperty("JButton.buttonType", "textured");
        return jButton;
    }

    public Layout getLayout() {
        return this.m_Layout;
    }

    public void tryToLoadFile(String string) {
        try {
            String string2 = new File(string).getParentFile().getPath();
            this.m_Main.m_MachController.getMachState().setParam(15301, string2);
            this.loadFile(false, new File(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.m_MainWindow.setButtonErrorAndBeep("Opening file '" + string + "' failed because it could not be found ");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            Main.m_MainWindow.setButtonErrorAndBeep("Opening file failed,  " + illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Main.m_MainWindow.setButtonErrorAndBeep("Opening file failed with exception " + exception);
        }
    }

    public void enableButtons() {
        boolean bl = MachiningState.PAUSED == this.m_Main.m_MachController.getMachiningState();
        boolean bl2 = MachiningState.STOPPED == this.m_Main.m_MachController.getMachiningState();
        SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getSelectedTab();
        this.m_SaveButton.setEnabled(bl2 && sourceCodeEditor != null && sourceCodeEditor.isDirty());
        this.m_CloseButton.setEnabled(bl2 && sourceCodeEditor != null);
        this.m_NewButton.setEnabled(bl2);
        this.m_LoadButton.setEnabled(bl2);
        this.m_GotoButton.setEnabled(bl2 || bl);
    }

    public GCodeEditorPanel(Main main, Layout layout) {
        this.m_Layout = main.isAndroid() ? UWKit.newTitledLayout("G-code", "flowy,fill, width 180:200:") : UWKit.newTitledLayout("G-code", "flowy,fill, width 180:300:");
        this.m_Main = main;
        Layout layout2 = UWKit.newLayout("flowy,fillx");
        this.m_DesktopButton = UWKit.newButton("Desktop");
        layout2.add(this.m_DesktopButton, "growx,gapbottom 8");
        this.m_NewButton = UWKit.newButton("New");
        layout2.add(this.m_NewButton, "growx");
        this.m_LoadButton = UWKit.newButton("Load");
        layout2.add(this.m_LoadButton, "growx");
        this.m_SaveButton = UWKit.newButton("Save");
        layout2.add(this.m_SaveButton, "growx");
        this.m_CloseButton = UWKit.newButton("Close");
        layout2.add(this.m_CloseButton, "growx,gapbottom 8");
        this.m_NewButton.setEnabled(true);
        this.m_GotoButton = UWKit.newButton("Goto");
        layout2.add(this.m_GotoButton, "growx");
        this.m_DesktopButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                Main.m_Window.setState(1);
            }
        });
        this.m_NewButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                GCodeEditorPanel.this.closeAllSourceCodeEditors(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GCodeEditorPanel.this.m_Main.m_ToolpathDisplayPanel.clearAllToolpaths();
                            GCodeEditorPanel.this.scheduleZoomOut(true);
                            GCodeEditorPanel.this.loadFile(true, new File("Untitled.txt"));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        });
        this.m_CloseButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)GCodeEditorPanel.this.m_TabLayout.getSelectedTab();
                if (sourceCodeEditor != null) {
                    GCodeEditorPanel.this.closeFile(sourceCodeEditor, null);
                }
            }
        });
        this.m_LoadButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                GCodeEditorPanel.this.closeAllSourceCodeEditors(new Runnable(){

                    @Override
                    public void run() {
                        GCodeEditorPanel.this.m_Main.m_MachController.ensurePausedOrStopped(null);
                        GCodeEditorPanel.this.m_Main.m_MachController.stopCycle();
                        String string = GCodeEditorPanel.this.m_Main.m_MachController.getMachState().getParamString(15301);
                        UWKit.showFileDialog(string, false, new FileDialogCallback(){

                            @Override
                            public void onFileSelected(String string) {
                                if (string != null) {
                                    GCodeEditorPanel.this.m_Main.m_ToolpathDisplayPanel.clearAllToolpaths();
                                    GCodeEditorPanel.this.scheduleZoomOut(false);
                                    GCodeEditorPanel.this.tryToLoadFile(string);
                                }
                            }
                        });
                    }
                });
            }
        });
        this.m_GotoButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                try {
                    MachiningState machiningState = GCodeEditorPanel.this.m_Main.m_MachController.getMachiningState();
                    if (machiningState == MachiningState.PAUSED || machiningState == MachiningState.STOPPED) {
                        SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)GCodeEditorPanel.this.m_TabLayout.getSelectedTab();
                        GCodeEditorPanel.this.gotoLine(sourceCodeEditor, sourceCodeEditor.getSelectionStart());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.m_SaveButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                SourceCodeEditor sourceCodeEditor = GCodeEditorPanel.this.getCurrentFile();
                if (sourceCodeEditor != null) {
                    try {
                        String string = GCodeEditorPanel.this.m_MainProgram.getCanonicalPath();
                        String string2 = sourceCodeEditor.getFile().getCanonicalPath();
                        sourceCodeEditor.saveFile();
                        String string3 = sourceCodeEditor.getFile().getCanonicalPath();
                        if (string.equals(string2) && !string2.equals(string3)) {
                            GCodeEditorPanel.this.m_MainProgram = sourceCodeEditor.getFile();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.m_CloseButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                SourceCodeEditor sourceCodeEditor = GCodeEditorPanel.this.getCurrentFile();
                if (sourceCodeEditor != null) {
                    GCodeEditorPanel.this.closeFile(sourceCodeEditor, null);
                }
            }
        });
        this.m_TabLayout = UWKit.newTabbedLayout();
        this.m_TabLayout.addTabListener(new TabbedLayout.TabListener(){
            PropertyChangeListener listener = null;

            @Override
            public void tabChanged(TabbedLayout tabbedLayout) {
                GCodeEditorPanel.this.enableButtons();
            }
        });
        this.m_Layout.add(this.m_TabLayout, "grow,push");
        this.m_Layout.add(layout2, "east,gapleft 4,gapright 2,gaptop 20,growx");
        UWKit.scheduleInEDT(100, 100, new Runnable(){

            @Override
            public void run() {
                try {
                    if (GCodeEditorPanel.this.m_RetrigTimer > 0) {
                        --GCodeEditorPanel.this.m_RetrigTimer;
                        if (GCodeEditorPanel.this.m_RetrigTimer == 0) {
                            GCodeEditorPanel.this.recompile();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.enableButtons();
    }

    public void loadFile(boolean bl, File file) throws Exception {
        this.openFile(bl, file);
        this.m_MainProgram = file;
        this.retrigCompile();
    }

    void scheduleZoomOut(boolean bl) {
        this.m_ZoomOutPending = true;
        this.m_ZoomToGrid = bl;
    }

    private SourceCodeEditor getCurrentFile() {
        return (SourceCodeEditor)this.m_TabLayout.getSelectedTab();
    }

    private void clearError() {
        if (this.m_Main != null) {
            if (Main.m_MainWindow != null) {
                Main.m_MainWindow.setParseErrorText(null);
            }
        }
        this.m_Error = null;
        this.m_ErrorFile = null;
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            sourceCodeEditor.setErrorLine(-1);
        }
    }

    public void setError(FilePos filePos) {
        File file = GCodeEditorPanel.resolve(this.m_MainProgram, filePos.getFileName());
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            File file2 = sourceCodeEditor.getFile();
            if (!file2.equals(file)) continue;
            this.m_ErrorFile = file2;
            sourceCodeEditor.setErrorLine(filePos.getLineNo());
            break;
        }
    }

    private void setError(Parser.ParseException parseException) {
        this.m_Error = parseException;
        FilePos filePos = parseException.getFilePos();
        String string = this.m_TabLayout.getTabCount() > 1 ? " file '" + filePos.getFileName() + "'" : "";
        String string2 = parseException.getError() + ".   (line " + filePos.getLineNo() + string + ")";
        Main.m_MainWindow.setParseErrorText(string2);
        File file = GCodeEditorPanel.resolve(this.m_MainProgram, parseException.getFilePos().getFileName());
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            File file2 = sourceCodeEditor.getFile();
            if (!file2.equals(file)) continue;
            this.m_ErrorFile = file2;
            sourceCodeEditor.setErrorLine(filePos.getLineNo());
            break;
        }
    }

    public void retrigCompile() {
        if (this.m_RetrigTimer == 0) {
            this.clearError();
            this.m_RetrigTimer = 5;
        }
    }

    public void setEnabled(MachiningState machiningState) {
        boolean bl = machiningState == MachiningState.STOPPED || machiningState == MachiningState.LOADING || machiningState == MachiningState.START_LOADING;
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            sourceCodeEditor.setEnabled(bl);
        }
        this.m_GotoButton.setEnabled(machiningState == MachiningState.PAUSED || machiningState == MachiningState.STOPPED);
    }

    public void setCurrentMachCode(FilePos filePos) {
        if (filePos != this.m_CurrentMachCodeFilePos) {
            this.m_CurrentMachCodeFilePos = filePos;
            String string = "";
            if (filePos != null) {
                string = filePos.getFileName();
            }
            Widget widget = this.m_TabLayout.getSelectedTab();
            for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
                SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
                if (filePos != null && sourceCodeEditor.getFile().getName().equals(string)) {
                    this.m_TabLayout.setSelectedTab(sourceCodeEditor);
                    sourceCodeEditor.setCurrentLine(filePos.getLineNo());
                    continue;
                }
                sourceCodeEditor.setCurrentLine(-1);
            }
        }
    }

    private void gotoLine(SourceCodeEditor sourceCodeEditor, int n) {
        byte[] byArray = sourceCodeEditor.getBytes();
        int n2 = 1;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 10) {
                ++n2;
            }
            if (i >= n) break;
        }
        this.m_Main.m_MachController.gotoLine(sourceCodeEditor.getFile().getName(), n2);
    }

    private void openFile(boolean bl, File file) {
        try {
            if (this.m_OpenFiles.containsKey(file.getCanonicalPath())) {
                return;
            }
            final SourceCodeEditor sourceCodeEditor = UWKit.newSourceCodeEditor(bl, file);
            final FileInfo fileInfo = new FileInfo();
            this.m_OpenFiles.put(file.getCanonicalPath(), fileInfo);
            this.m_CloseButton.setEnabled(true);
            this.m_TabLayout.addTab(sourceCodeEditor.getFile().getName(), sourceCodeEditor);
            sourceCodeEditor.setSelectionListener(new SourceCodeEditor.SelectionListener(){

                @Override
                public void selectionChanged(int n, int n2) {
                    GCodeEditorPanel.this.retrigCompile();
                }
            });
            sourceCodeEditor.setEditListener(new SourceCodeEditor.EditListener(){
                boolean wasDirty = false;
                int lineNo = 0;

                @Override
                public void contentsChanged(SourceCodeEditor sourceCodeEditor2) {
                    if (sourceCodeEditor.isDirty() != this.wasDirty) {
                        this.wasDirty = !this.wasDirty;
                        GCodeEditorPanel.this.updateDirty();
                    }
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void updateDirty() {
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            this.m_TabLayout.setTitleAt(i, sourceCodeEditor.getFile().getName() + (sourceCodeEditor.isDirty() ? "*" : ""));
            if (sourceCodeEditor != this.m_TabLayout.getSelectedTab()) continue;
            this.m_SaveButton.setEnabled(sourceCodeEditor.isDirty());
        }
    }

    public static File resolve(File file, String string) {
        Object object = "";
        if (file != null && file.getParent() != null) {
            object = file.getParent() + File.separator;
        }
        return new File((String)object + string);
    }

    public File getMainProgramFile() {
        return this.m_MainProgram;
    }

    public FileReader.FileAccessor getFileAccessorForMainFile() {
        final LinkedHashMap<String, byte[]> linkedHashMap = new LinkedHashMap<String, byte[]>();
        for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
            SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
            byte[] byArray = sourceCodeEditor.getBytes();
            try {
                linkedHashMap.put(sourceCodeEditor.getFile().getCanonicalPath(), byArray);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return new FileReader.FileAccessor(){

            @Override
            public byte[] readFile(String string) throws IOException {
                File file = GCodeEditorPanel.resolve(GCodeEditorPanel.this.m_MainProgram, string);
                byte[] byArray = (byte[])linkedHashMap.get(file.getCanonicalPath());
                if (byArray == null) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n = 0;
                    int n2 = (int)file.length();
                    byArray = new byte[n2];
                    while ((n += fileInputStream.read(byArray, n, n2 - n)) < n2) {
                    }
                    fileInputStream.close();
                }
                return byArray;
            }
        };
    }

    private void openFiles(List<File> list) {
        for (File file : list) {
            this.openFile(false, file);
        }
    }

    private void recompile() throws Exception {
        if (this.m_MainProgram != null) {
            MachiningState machiningState = this.m_Main.m_MachController.getMachiningState();
            if (machiningState != MachiningState.STOPPED && machiningState != MachiningState.PAUSED) {
                this.m_Main.m_MachController.getMachState().retrigCompile();
                return;
            }
            System.out.println("RECOMPILE STARTED");
            this.m_Main.m_MachController.setCompiling(true);
            LinkedHashMap<String, byte[]> linkedHashMap = new LinkedHashMap<String, byte[]>();
            for (int i = 0; i < this.m_TabLayout.getTabCount(); ++i) {
                SourceCodeEditor sourceCodeEditor = (SourceCodeEditor)this.m_TabLayout.getTab(i);
                byte[] byArray = sourceCodeEditor.getBytes();
                linkedHashMap.put(sourceCodeEditor.getFile().getCanonicalPath(), byArray);
            }
            this.m_Main.m_Compiler.compile(this.m_MainProgram, linkedHashMap, new BackgroundCompiler.CompileCompleted(){

                @Override
                public void compileError(List<File> list, Parser.ParseException parseException) {
                    GCodeEditorPanel.this.openFiles(list);
                    GCodeEditorPanel.this.setError(parseException);
                    GCodeEditorPanel.this.m_Main.m_MachController.setCompiling(false);
                }

                @Override
                public void compileCompleted(List<File> list, Machcode machcode) {
                    System.out.println("RECOMPILE COMPLETED");
                    GCodeEditorPanel.this.m_Main.m_MachController.setCompiling(false);
                    GCodeEditorPanel.this.openFiles(list);
                    MachiningState machiningState = GCodeEditorPanel.this.m_Main.m_MachController.getMachiningState();
                    if (machiningState == MachiningState.STOPPED || machiningState == MachiningState.PAUSED) {
                        GCodeEditorPanel.this.m_Main.m_MachController.load(machcode, machiningState == MachiningState.PAUSED);
                        if (GCodeEditorPanel.this.m_ZoomOutPending) {
                            GCodeEditorPanel.this.m_ZoomOutPending = false;
                            GCodeEditorPanel.this.m_Main.m_ToolpathDisplayPanel.resetZoom(GCodeEditorPanel.this.m_ZoomToGrid);
                        }
                        if (Main.m_Simulator != null) {
                            Main.m_Simulator.resimulate();
                        }
                    }
                }
            });
        }
    }

    private static class FileInfo {
        int m_LineNo;
        boolean m_Recompile;

        private FileInfo() {
        }
    }
}

