/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.Button;
import eazycnc.Main;
import eazycnc.gcode.Interpreter;
import java.util.Hashtable;
import java.util.Map;
import motorcontrol.MachiningState;

public class HomeButtonLogic {
    static Map<Button, Integer> m_HomeButtonState;

    public static void doHomeAction(final Button button, final int ... nArray) {
        block16: {
            Integer n;
            int n2;
            block15: {
                if (!Main.m_Main.m_MachController.isConnected()) {
                    Main.m_MainWindow.setButtonErrorAndBeep("Motor controller not connected");
                    return;
                }
                MachiningState machiningState = Main.m_Main.m_MachController.m_MachState.getMachiningState();
                if (machiningState != MachiningState.PAUSED && machiningState != MachiningState.STOPPED) {
                    Main.m_MainWindow.setButtonErrorAndBeep("Homing available only when the system is ins PAUSE or STOP state");
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    n2 = nArray[i];
                    if (Main.m_Main.m_MachController.m_MachState.isAxisEnabled(n2)) continue;
                    String string = Interpreter.getAxisLetter(n2);
                    Main.m_MainWindow.setButtonErrorAndBeep("Axis '" + string + "' is not configured for use");
                    return;
                }
                if (m_HomeButtonState == null) {
                    m_HomeButtonState = new Hashtable<Button, Integer>();
                }
                if ((n = m_HomeButtonState.get(button)) != null && n != 0) break block15;
                final String string = button != null ? button.getText() : null;
                m_HomeButtonState.put(button, 1);
                for (int i = 0; i < nArray.length; ++i) {
                    try {
                        int n3 = nArray[i];
                        int n4 = (int)Math.round(Main.m_Main.m_MachController.m_MachState.getParamDouble(-2147483647, n3) * Main.m_Main.m_MachController.m_MachState.getParamDouble(-2147483646, n3));
                        if (Main.m_Main.m_MachController.getMachState().getParamInt(-2147483644, n3) < 0) {
                            Main.m_Main.m_MachController.resetPosition(n3, n4);
                        } else {
                            Main.m_Main.m_MachController.startHoming(n3, n4);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Main.m_MainWindow.setButtonErrorAndBeep(illegalArgumentException.getMessage());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Main.m_MainWindow.setButtonErrorAndBeep("EXCEPTION " + exception.getClass().getSimpleName() + " press F12 for console");
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = false;
                            for (int i = 0; i < nArray.length; ++i) {
                                int n = nArray[i];
                                int n2 = Main.m_Main.m_MachController.motorFromAxis(n);
                                if (Main.m_Main.m_MachController.getMotorController().getMotorState(n2) != MotorController.MotorState.HOMING) continue;
                                bl = true;
                            }
                            if (bl) {
                                UWKit.scheduleInEDT(100, 0, this);
                            } else {
                                if (button != null) {
                                    button.setText(string);
                                }
                                m_HomeButtonState.put(button, 0);
                            }
                        }
                    };
                    if (button != null) {
                        button.setText("STOP");
                    }
                    runnable.run();
                }
                break block16;
            }
            if (n != 1) break block16;
            m_HomeButtonState.put(button, 2);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n5 = nArray[n2];
                try {
                    if (!Main.m_Main.m_MachController.isHoming(n5)) continue;
                    Main.m_Main.m_MachController.stopHoming(n5);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.m_MainWindow.setButtonErrorAndBeep(illegalArgumentException.getMessage());
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Main.m_MainWindow.setButtonErrorAndBeep("EXCEPTION " + exception.getClass().getSimpleName() + " press F12 for console");
                }
            }
        }
    }
}

