/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import eazycnc.DebugMenu;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class JavaConsole {
    private static String m_LogBaseDir;
    private static boolean m_ConsoleMinimized;
    private static JFrame m_ConsoleWindow;
    private static JTextPane m_ConsoleTextPane;
    private static StyledDocument m_StyledDoc;
    private static PrintStream m_OldOut;
    private static PrintStream m_OldErr;
    private static int m_OutputBufferLimit;
    private static OutputStream m_ConsoleLogStream;
    private static File m_ConsoleOutputFile;

    public static void setLogDir(String string) {
        m_LogBaseDir = string;
    }

    public static void cleanupLogDir() {
        if (m_LogBaseDir == null) {
            return;
        }
        String[] stringArray = new File(m_LogBaseDir).list();
        if (stringArray == null) {
            return;
        }
        long l = System.currentTimeMillis();
        for (String string : stringArray) {
            long l2;
            File file = new File(m_LogBaseDir + string);
            if (!file.isFile() || (l2 = l - file.lastModified()) <= 604800000L) continue;
            System.out.println("Deleting old log file '" + file.getAbsolutePath() + "' from date " + new Date(file.lastModified()));
            if (file.delete()) continue;
            System.err.println("Failed to delete log file '" + file.getAbsolutePath() + "'");
        }
    }

    public static void enableJavaConsoleLogToFile(boolean bl) {
        if (m_LogBaseDir == null) {
            return;
        }
        if (bl && m_ConsoleLogStream == null) {
            try {
                try {
                    new File(m_LogBaseDir).mkdirs();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string = new SimpleDateFormat("'java-console-'yyyy'.'MM'.'dd'-'HH'.'mm'.'ss'.txt'").format(new Date(System.currentTimeMillis()));
                m_ConsoleOutputFile = new File(m_LogBaseDir + string);
                m_ConsoleLogStream = new FileOutputStream(m_ConsoleOutputFile);
                System.out.println("Start logging Java console output to file '" + m_ConsoleOutputFile.getAbsolutePath() + "'");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        if (!bl && m_ConsoleLogStream != null) {
            System.out.println("Stop logging Java console output to file '" + m_ConsoleOutputFile.getAbsolutePath() + "'");
            try {
                m_ConsoleLogStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_ConsoleLogStream = null;
            return;
        }
    }

    static PrintStream createOutStream(PrintStream printStream) {
        m_OldOut = printStream;
        return new PrintStream(new RedirectingStream(m_OldOut, false));
    }

    static PrintStream createErrStream(PrintStream printStream) {
        m_OldErr = printStream;
        return new PrintStream(new RedirectingStream(m_OldErr, true));
    }

    public static void openConsole(boolean bl) {
        JavaConsole.openConsole(bl, false, false);
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        Dimension dimension2 = window.getSize();
        int n = (rectangle.width - dimension2.width) / 2 + rectangle.x;
        int n2 = (rectangle.height - dimension2.height) / 3 + rectangle.y;
        window.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    static void redirectStdOutputStreamsToConsole() {
        System.setOut(JavaConsole.createOutStream(System.out));
        System.setErr(JavaConsole.createErrStream(System.err));
    }

    public static void openConsole(boolean bl, boolean bl2, boolean bl3) {
        if (m_ConsoleWindow == null) {
            Action[] actionArray;
            m_ConsoleWindow = new JFrame("Java Console");
            m_ConsoleWindow.setJMenuBar(new DebugMenu().createDebugMenuBar());
            m_ConsoleWindow.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent windowEvent) {
                    m_ConsoleMinimized = windowEvent.getNewState() == 1;
                }
            });
            m_ConsoleWindow.setDefaultCloseOperation(1);
            m_ConsoleTextPane = new JTextPane(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(Color.BLACK);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    super.paintComponent(graphics);
                }
            };
            m_ConsoleTextPane.setOpaque(false);
            m_ConsoleTextPane.setBackground(new Color(0, 0, 0, 0));
            for (Action action : actionArray = new JTextPane().getActions()) {
                KeyStroke keyStroke;
                String string;
                if (action.getValue("Name").equals("select-all")) {
                    string = "meta A";
                    keyStroke = KeyStroke.getKeyStroke(string);
                    m_ConsoleTextPane.getInputMap().put(keyStroke, string);
                    m_ConsoleTextPane.getActionMap().put(string, action);
                }
                if (!action.getValue("Name").equals("copy-to-clipboard")) continue;
                string = "meta C";
                keyStroke = KeyStroke.getKeyStroke(string);
                m_ConsoleTextPane.getInputMap().put(keyStroke, string);
                m_ConsoleTextPane.getActionMap().put(string, action);
            }
            m_ConsoleTextPane.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            m_StyledDoc = m_ConsoleTextPane.getStyledDocument();
            m_ConsoleTextPane.setPreferredSize(new Dimension(644, 488));
            m_ConsoleWindow.add(new JScrollPane(m_ConsoleTextPane));
            m_ConsoleWindow.pack();
            JavaConsole.centerWindow(m_ConsoleWindow);
        }
        if (bl && !m_ConsoleWindow.isVisible()) {
            m_ConsoleWindow.setVisible(true);
        } else if (bl3) {
            m_ConsoleWindow.setVisible(m_ConsoleMinimized || !m_ConsoleWindow.isVisible());
        }
        if (bl2) {
            m_ConsoleWindow.toFront();
        }
    }

    static {
        m_OutputBufferLimit = 100000;
    }

    private static class RedirectingStream
    extends OutputStream {
        private DateTimeFormatter m_TimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS ");
        private Style m_Style;
        private boolean m_IsErrStream;
        private OutputStream m_OldOutStream;
        private boolean m_StartWithTime = true;
        private byte[] m_Buffer = new byte[0];
        private int m_BufferedLen = 0;

        RedirectingStream(OutputStream outputStream, boolean bl) {
            this.m_IsErrStream = bl;
            this.m_OldOutStream = outputStream;
        }

        private void createStyle() {
            if (this.m_Style == null) {
                this.m_Style = m_StyledDoc.addStyle("StyleName", null);
                StyleConstants.setFontFamily(this.m_Style, "Monospaced");
                StyleConstants.setFontSize(this.m_Style, 14);
                StyleConstants.setBackground(this.m_Style, Color.black);
                StyleConstants.setForeground(this.m_Style, this.m_IsErrStream ? Color.red : Color.green);
            }
        }

        private void buffer(byte[] byArray, int n, int n2) {
            if (this.m_BufferedLen + n2 > this.m_Buffer.length) {
                byte[] byArray2 = new byte[this.m_BufferedLen + n2 + 100];
                System.arraycopy(this.m_Buffer, 0, byArray2, 0, this.m_Buffer.length);
                this.m_Buffer = byArray2;
            }
            System.arraycopy(byArray, n, this.m_Buffer, this.m_BufferedLen, n2);
            this.m_BufferedLen += n2;
        }

        private void outputbuffer() throws IOException {
            ZonedDateTime zonedDateTime = ZonedDateTime.now();
            String string = zonedDateTime.format(this.m_TimeFormatter);
            if (this.m_IsErrStream) {
                this.plain_write("#".getBytes(), 0, 1);
            } else {
                this.plain_write(" ".getBytes(), 0, 1);
            }
            this.plain_write(string.getBytes(), 0, string.length());
            this.plain_write(this.m_Buffer, 0, this.m_BufferedLen);
            if (this.m_Buffer.length > 1024) {
                this.m_Buffer = new byte[1024];
            }
            this.m_BufferedLen = 0;
        }

        @Override
        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n});
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                if (byArray[n + i] != 10) continue;
                this.buffer(byArray, n, i + 1);
                this.outputbuffer();
                this.write(byArray, n + i + 1, n2 - i - 1);
                return;
            }
            this.buffer(byArray, n, n2);
        }

        private void plain_write(byte[] byArray, int n, int n2) throws IOException {
            if (m_ConsoleLogStream != null) {
                m_ConsoleLogStream.write(byArray, n, n2);
            }
            this.m_OldOutStream.write(byArray, n, n2);
            try {
                JavaConsole.openConsole(false);
                this.createStyle();
                m_StyledDoc.insertString(m_StyledDoc.getLength(), new String(byArray, n, n2), this.m_Style);
                if (m_StyledDoc.getLength() > m_OutputBufferLimit) {
                    m_StyledDoc.remove(0, m_OutputBufferLimit / 10);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace(m_OldErr);
            }
        }
    }
}

