/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import eazycnc.gcode.MachState;

public class LimitChecker {
    int n = 3;
    double[] m_LimitMin;
    double[] m_LimitMax;
    double[] m_ToolpathMin;
    double[] m_ToolpathMax;
    MachState m_State;

    public double[] getToolpathMin() {
        return this.m_ToolpathMin;
    }

    public double[] getToolpathMax() {
        return this.m_ToolpathMax;
    }

    public LimitChecker(MachState machState) {
        this.m_State = machState;
        this.m_LimitMin = new double[this.n];
        this.m_LimitMax = new double[this.n];
        this.m_ToolpathMin = new double[this.n];
        this.m_ToolpathMax = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            boolean bl = machState.getParamBoolean(-2147483640, i);
            this.m_LimitMin[i] = bl ? machState.getParamDouble(-2147483642, i) : -1.7976931348623157E308;
            this.m_LimitMax[i] = bl ? machState.getParamDouble(-2147483641, i) : Double.MAX_VALUE;
            this.m_ToolpathMin[i] = Double.MAX_VALUE;
            this.m_ToolpathMax[i] = -1.7976931348623157E308;
        }
    }

    public int checkLimits(double[] dArray) {
        int n = this.m_State.getParamInt(15147) - 1;
        double d = n >= 0 ? this.m_State.getParamDouble(0x40000001, n) : 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.m_ToolpathMin[i] = Math.min(this.m_ToolpathMin[i], dArray[i]);
            this.m_ToolpathMax[i] = Math.max(this.m_ToolpathMax[i], dArray[i]);
            double d2 = dArray[i];
            double d3 = i == 2 ? d : 0.0;
            if (!(d2 - d3 < this.m_LimitMin[i]) && !(dArray[i] > this.m_LimitMax[i])) continue;
            return i;
        }
        return -1;
    }
}

