/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.ComboBox;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import com.eazycnc.uwk.widgets.Label;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.TabbedLayout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.ToggleButton;
import diolanupdater.MemoryImage;
import diolanupdater.UpdateFirmware;
import eazycnc.IndicatorLed;
import eazycnc.Main;
import eazycnc.TOAD5TestPanel;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import purejavacomm.CommPortIdentifier;
import swing.SwingWidgetFactory;
import toad4plus.firmwares.Firmwares;

public class MachineSetupPanel {
    private static void autoDetectPort(final MachState machState) {
        final String[] stringArray = new String[]{null};
        UWKit.m_Factory.scheduleInEDT(new Runnable(){
            LinkedList<String> m_PreviousPorts = null;

            @Override
            public void run() {
                Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
                LinkedList<Object> linkedList = new LinkedList<Object>();
                while (enumeration.hasMoreElements()) {
                    String string = ((CommPortIdentifier)enumeration.nextElement()).getName();
                    if (string.startsWith("cu.")) continue;
                    linkedList.add(string);
                }
                if (this.m_PreviousPorts != null) {
                    for (String string : linkedList) {
                        if (this.m_PreviousPorts.contains(string)) continue;
                        stringArray[0] = string;
                        UWKit.closeDialog();
                        return;
                    }
                }
                this.m_PreviousPorts = linkedList;
                UWKit.m_Factory.scheduleInEDT(this);
            }
        });
        UWKit.showInformationDialog("Auto Detect Port", "<b>Un-plug and re-plug the motor controller USB cable now.</b>", null, null, "Cancel", null);
        if (stringArray[0] == null) {
            UWKit.showConfirmDialog("Port Not Detected", "<b>No motor controller found!</b>", "OK", null, null, null);
        } else {
            UWKit.showConfirmDialog("Port Detected", "<b>Found motor controller port '" + stringArray[0] + "', do you want to use it?</b>", "Yes", null, "Cancel", new DialogCallback(){

                @Override
                public void onClose(DialogCallback.DialogOptions dialogOptions) {
                    if (dialogOptions == DialogCallback.DialogOptions.YES) {
                        machState.setParam(15302, stringArray[0]);
                    }
                }
            });
        }
    }

    private static void updateFirmwareFromFile() {
        UWKit.showFileDialog("", false, new FileDialogCallback(){

            @Override
            public void onFileSelected(String string) {
                try {
                    if (string != null) {
                        MachineSetupPanel.updateFirmwareFromStream(new FileInputStream(string));
                    }
                }
                catch (Exception exception) {
                    Main.m_MainWindow.setButtonErrorAndBeep("Could not read the firmware (" + exception.getClass().getSimpleName() + ").");
                }
            }
        });
    }

    private static void updateFirmwareFromStream(InputStream inputStream) {
        try {
            MemoryImage memoryImage = new MemoryImage();
            memoryImage.readIntelHex(inputStream, (byte)-1, true);
            SimpleVariable simpleVariable = new SimpleVariable("TOAD4 firmware update initiated");
            try {
                new Thread(() -> {
                    try {
                        UpdateFirmware updateFirmware = new UpdateFirmware();
                        try {
                            updateFirmware.updateFirmware((short)7504, (short)24608, memoryImage, 2048, 32704, (string, n) -> {
                                System.out.println("Progress:" + string);
                                UWKit.m_Factory.scheduleInEDT(() -> simpleVariable.setValue(string));
                            });
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            String string2 = "Could not find the TOAD4+ device.";
                            simpleVariable.setValue(string2);
                            Main.m_MainWindow.setButtonErrorAndBeep(string2);
                        }
                        catch (Exception exception) {
                            Main.m_MainWindow.setButtonErrorAndBeep("Update failed with (" + exception.getClass().getSimpleName() + ").");
                        }
                        Thread.sleep(2000L);
                        UWKit.m_Factory.scheduleInEDT(() -> UWKit.closeDialog());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            simpleVariable.setValue("Preparing to update TOAD4+ firmware");
            UWKit.showInformationDialog("Firmware update", simpleVariable, null, null, null, null);
        }
        catch (Exception exception) {
            Main.m_MainWindow.setButtonErrorAndBeep("Could not read the firmware (" + exception.getClass().getSimpleName() + ").");
        }
    }

    private static final boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public static Object[] getLanguages(Main main, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        linkedList2.add("English");
        linkedList2.add("Dutch");
        linkedList2.add("Russian");
        String[] stringArray = new File(Main.m_HomeDir + "locales" + File.separator).list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!MachineSetupPanel.isValidJavaIdentifier(stringArray[i])) continue;
                File file = new File(Main.m_HomeDir + "locales" + File.separator + stringArray[i] + File.separator + "strings.properties");
                if (!file.exists()) continue;
                Object object = stringArray[i];
                if (linkedList2.contains(object)) {
                    linkedList2.remove(object);
                }
                if (bl) {
                    object = "<html><i>" + (String)object + "</i></html>";
                }
                linkedList.add((String)object);
            }
        }
        linkedList2.addAll(linkedList);
        return linkedList2.toArray(new String[0]);
    }

    private static void addOnOffButtons(Layout layout, SimpleVariable simpleVariable, SimpleVariable simpleVariable2) {
        ToggleButton toggleButton = UWKit.newToggleButton("onoff", (Variable)simpleVariable2, "On", (Object)true);
        ToggleButton toggleButton2 = UWKit.newToggleButton("onoff", (Variable)simpleVariable2, "Off", (Object)false);
        layout.add(toggleButton, "split");
        layout.add(toggleButton2, "wrap");
        simpleVariable.addObserver(observable -> {
            boolean bl = (Boolean)simpleVariable.getValue();
            toggleButton.setEnabled(bl);
            toggleButton2.setEnabled(bl);
        });
    }

    private static Layout createIOSetupPanel(Main main, MachState machState) {
        final SimpleVariable simpleVariable = main.m_MachController.getOutputOverrideOn();
        simpleVariable.addObserver(observable -> {
            if (simpleVariable.getValue().equals(true)) {
                UWKit.showConfirmDialog("Confirm Manual Override", "<b>Are you sure you want to Enable Manul Override ?</b><br><br>Manual override may be <u>hazardous to equipment and personel</u>! <br>", "Yes", null, "Cancel", new DialogCallback(){

                    @Override
                    public void onClose(DialogCallback.DialogOptions dialogOptions) {
                        if (dialogOptions != DialogCallback.DialogOptions.YES) {
                            simpleVariable.setValue(false);
                        }
                    }
                });
            }
        });
        SimpleVariable simpleVariable2 = main.m_MachController.getSpindleForwardOverride();
        SimpleVariable simpleVariable3 = main.m_MachController.getSpindleReverseOverride();
        SimpleVariable simpleVariable4 = main.m_MachController.getCoolantOverride();
        SimpleVariable simpleVariable5 = main.m_MachController.getSpindleSpeedOverride();
        Layout layout = UWKit.newTitledLayout("Spindle Speed Calibration", "");
        Layout layout2 = UWKit.newTitledLayout("Spindle Speed Limits", "");
        layout.add(UWKit.newLabel("Low:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getNumericVariable(15359), 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout.add(UWKit.newLabel("rpm"), "align left");
        layout.add(UWKit.newLabel("@DAC:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getNumericVariable(15357), 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout.add(UWKit.newLabel("%"), "align left,wrap");
        layout.add(UWKit.newLabel("High:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getNumericVariable(15360), 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout.add(UWKit.newLabel("rpm"), "align left");
        layout.add(UWKit.newLabel("@DAC:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getNumericVariable(15358), 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout.add(UWKit.newLabel("%"), "align left,wrap");
        layout2.add(UWKit.newLabel("Min:"), "align right");
        layout2.add(UWKit.newTextField((Variable)machState.getNumericVariable(15156), 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout2.add(UWKit.newLabel("rpm"), "align left, wrap");
        layout2.add(UWKit.newLabel("Max:"), "align right");
        layout2.add(UWKit.newTextField((Variable)machState.getNumericVariable(15157), 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout2.add(UWKit.newLabel("rpm"), "align left, wrap");
        Layout layout3 = UWKit.newTitledLayout("Probe Input", "filly");
        layout3.add(UWKit.newLabel("Polarity:"), "align right");
        layout3.add(UWKit.newComboBox((Variable)machState.getVariable(15176), "Active = 0 ", false, "Active = 1 ", true), "wrap");
        layout3.add(UWKit.newLabel(""), "align right");
        Label label = UWKit.newLabel("Probe");
        IndicatorLed indicatorLed = new IndicatorLed(IndicatorLed.Color.GREEN, () -> {
            boolean bl = main.m_MachController.getMotorController().getProbeInputAsserted();
            return bl;
        });
        layout3.add(indicatorLed.getWidget(), "split,w 16:16:16,h 16:16:16");
        layout3.add(label, "wrap");
        layout3.add(UWKit.newLabel(""), "pushy,skip 2,span 10,bottom");
        Layout layout4 = UWKit.newLayout("flowx,filly");
        Layout layout5 = UWKit.newLayout("flowy");
        Layout layout6 = UWKit.newLayout("flowy");
        layout5.add(layout, "grow");
        layout5.add(layout2, "grow");
        layout6.add(layout3, "grow");
        layout4.add(layout5, "growy");
        layout4.add(layout6, "growy");
        return layout4;
    }

    private static Layout newOptionsPanel(MachState machState) {
        Layout layout = UWKit.newTitledLayout("G-code options");
        layout.add(UWKit.newCheckBox((Variable)machState.getVariable(15134), "Incremental IJK", (Object)true, (Object)false), "wrap");
        layout.add(UWKit.newCheckBox((Variable)machState.getVariable(15133), "Incremental XYZ", (Object)true, (Object)false), "wrap");
        layout.add(UWKit.newCheckBox((Variable)machState.getVariable(15159), "G4 P word in msec", (Object)true, (Object)false), "wrap");
        Layout layout2 = UWKit.newTitledLayout("G41/G42 code options");
        layout2.add(UWKit.newRadioButton((Variable)machState.getVariable(15170), "Miter join,", (Object)true), "");
        layout2.add(UWKit.newLabel("limit"), "");
        Layout layout3 = UWKit.newTitledLayout("Auto functions", "flowx");
        layout3.add(UWKit.newCheckBox((Variable)machState.getVariable(15174), "Auto SPINDLE OFF", (Object)true, (Object)false), "growx,wrap");
        layout3.add(UWKit.newCheckBox((Variable)machState.getVariable(15175), "Auto COOLANT OFF", (Object)true, (Object)false), "growx,wrap");
        TextField textField = UWKit.newTextField((Variable)machState.getVariable(15171), 16.0, 5, new SimpleVariable("0.0"), null);
        layout2.add(textField, "");
        layout2.add(UWKit.newLabel("% of tool diameter"), "wrap");
        layout2.add(UWKit.newRadioButton((Variable)machState.getVariable(15170), "Round join", (Object)false), "top");
        CardLayout cardLayout = UWKit.newCardLayout();
        cardLayout.addCard("true", UWKit.newPicture("miter-join.png"));
        cardLayout.addCard("false", UWKit.newPicture("round-join.png"));
        machState.getVariable(15170).addObserver(observable -> {
            Boolean bl = (Boolean)((Variable)((Object)observable)).getValue();
            textField.setEnabled(bl);
            cardLayout.selectCard(bl.toString());
        });
        Layout layout4 = UWKit.newTitledLayout("ZERO DRO on RUN", "flowy");
        for (int i = 0; i < 6; ++i) {
            layout4.add(UWKit.newCheckBox((Variable)machState.getVariable(-2147483639, i), Interpreter.getAxisLetter(i) + "-axis auto zero", (Object)true, (Object)false), "growx");
        }
        layout2.add(cardLayout, "span 3, center");
        Layout layout5 = UWKit.newLayout("flowx,filly");
        Layout layout6 = UWKit.newTitledLayout("Export (Import) settings");
        layout5.add(layout6, "growy");
        layout6.add(UWKit.newLabel("File format:"), "align right");
        layout6.add(UWKit.newComboBox((Variable)machState.getVariable(15350), "CSV", ".csv", "TEXT", ".txt"), "wrap");
        layout6.add(UWKit.newLabel("Number format:"), "align right");
        layout6.add(UWKit.newTextField(machState.getVariable(15351), 16.0, 7), "wrap");
        layout6.add(UWKit.newLabel("Item Separator:"), "align right");
        layout6.add(UWKit.newComboBox((Variable)machState.getVariable(15352), ",", ",", ";", ";"), "wrap");
        Layout layout7 = UWKit.newTitledLayout("Screen");
        layout7.add(UWKit.newLabel("Window:"), "align right");
        layout7.add(UWKit.newComboBox((Variable)machState.getVariable(15220), "Standard", 0, "No Title Bar", 1, "Fullscreen", 2), "wrap,width 120!");
        layout7.add(UWKit.newLabel("Layout:"), "align right");
        layout7.add(UWKit.newComboBox((Variable)machState.getVariable(15298), "Standard", 0, "Compact", 1, "Minimal", 2), "wrap,width 120!");
        Layout layout8 = UWKit.newTitledLayout("Shutdown");
        layout8.add(UWKit.newCheckBox((Variable)machState.getVariable(15221), "Shutdown on Quit"), "");
        Layout layout9 = UWKit.newTitledLayout("On-Screen Keyboard");
        layout9.add(UWKit.newCheckBox((Variable)machState.getVariable(15222), "Enable Keyboard"), "wrap");
        layout9.add(UWKit.newCheckBox((Variable)machState.getVariable(15356), "Sound on Click"), "");
        machState.getVariable(15356).addObserver(observable -> {
            SwingWidgetFactory.m_EnableClickSound = ((SimpleVariable)observable).getValue() == Boolean.TRUE;
        });
        Layout layout10 = UWKit.newLayout("flowx,filly");
        Layout layout11 = UWKit.newLayout("flowy");
        Layout layout12 = UWKit.newLayout("flowy");
        Layout layout13 = UWKit.newLayout("flowy");
        layout11.add(layout, "grow");
        layout11.add(layout3, "grow");
        layout11.add(layout4, "grow,wrap");
        layout12.add(layout7, "grow");
        layout12.add(layout8, "grow");
        layout12.add(layout9, "grow");
        layout12.add(layout5, "grow");
        layout13.add(layout2, "grow");
        layout10.add(layout11, "growy");
        layout10.add(layout12, "growy");
        layout10.add(layout13, "growy");
        return layout10;
    }

    private static Layout newMotionPanel(MachState machState) {
        Variable variable = machState.getSpeedUnit();
        Variable variable2 = machState.getAccelUnit();
        Variable variable3 = machState.getJerkUnit();
        Variable variable4 = machState.getLengthUnit();
        Layout layout = UWKit.newTitledLayout("Motion Limits");
        Layout layout2 = UWKit.newTitledLayout("Motor Update");
        Layout layout3 = UWKit.newTitledLayout("Arc Interpolation");
        layout.add(UWKit.newLabel("Max Velocity:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15149), 16.0, 7, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable), "wrap");
        layout.add(UWKit.newLabel("Max Acceleration:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15148), 16.0, 7, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable2), "wrap");
        layout.add(UWKit.newLabel("Max Jerk:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15169), 16.0, 7, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable3), "wrap");
        layout.add(UWKit.newLabel("Path tolerance:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15144), 16.0, 7, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable4), "");
        layout3.add(UWKit.newLabel("Arc accuracy:"), "align right");
        layout3.add(UWKit.newTextField((Variable)machState.getScaledVariable(15172), 16.0, 7, new SimpleVariable("0.000"), null), "");
        layout3.add(UWKit.newLabel(variable4), "wrap");
        layout3.add(UWKit.newLabel("Small arc limit:"), "align right");
        layout3.add(UWKit.newTextField((Variable)machState.getVariable(15173), 16.0, 7, new SimpleVariable("0.0"), null), "");
        layout3.add(UWKit.newLabel("% of tool diameter"), "wrap");
        layout3.add(UWKit.newCheckBox((Variable)machState.getVariable(15288), "Experimental Interpolation"), "skip,span 2,wrap");
        layout2.add(UWKit.newLabel("Update Period:"), "align right");
        layout2.add(UWKit.newTextField((Variable)UWKit.multiply((Variable)machState.getNumericVariable(15150), 1000.0), 16.0, 7, new SimpleVariable("0.0"), null), new String[0]);
        layout2.add(UWKit.newLabel("msec"), "");
        Layout layout4 = UWKit.newLayout("flowx,filly");
        Layout layout5 = UWKit.newLayout("flowy");
        Layout layout6 = UWKit.newLayout("flowy");
        layout4.add(layout5, "growy");
        layout4.add(layout6, "growy");
        layout5.add(layout, "grow");
        layout5.add(layout2, "grow");
        layout6.add(layout3, "grow");
        return layout4;
    }

    private static String[] splitPath(String object, int n, int n2, int n3) {
        String[] stringArray = new String[n];
        int n4 = 0;
        while (!((String)object).isEmpty()) {
            int n5 = Math.min(((String)object).length(), n3);
            String string = ((String)object).substring(0, n5);
            object = ((String)object).substring(n5);
            int n6 = string.lastIndexOf(File.separator);
            if (n6 >= n2) {
                object = string.substring(n6) + (String)object;
                string = string.substring(0, n6);
            }
            if (n4 >= n) {
                for (int i = 1; i < n; ++i) {
                    stringArray[i - 1] = stringArray[i];
                }
                stringArray[0] = "\u2026\u2026" + stringArray[0];
            }
            int n7 = --n4;
            ++n4;
            stringArray[n7] = string;
        }
        String[] stringArray2 = new String[n4];
        System.arraycopy(stringArray, 0, stringArray2, 0, n4);
        return stringArray2;
    }

    private static void addPath(Layout layout, String string) {
        String[] stringArray = MachineSetupPanel.splitPath(string, 4, 12, 40);
        for (int i = 0; i < stringArray.length; ++i) {
            layout.add(UWKit.newLabel("!" + stringArray[i] + (i < stringArray.length - 1 ? "..." : "")), "left,wrap" + (i > 0 ? ",skip" : ""));
        }
    }

    private static Layout newInfoPanel(Main main) {
        Layout layout = UWKit.newTitledLayout("System Info");
        layout.add(UWKit.newLabel("EazyCNC version:"), "right");
        layout.add(UWKit.newLabel("!" + Main.m_VersionString), "wrap");
        layout.add(UWKit.newLabel("EazyCNC parameters:"), "right");
        MachineSetupPanel.addPath(layout, Main.m_ConfigFile);
        layout.add(UWKit.newLabel("User name:"), "right");
        layout.add(UWKit.newLabel("!" + System.getProperty("user.name")), "wrap");
        layout.add(UWKit.newLabel("User home dir:"), "right");
        layout.add(UWKit.newLabel("!" + System.getProperty("user.home")), "wrap");
        layout.add(UWKit.newLabel("Java version:"), "right");
        layout.add(UWKit.newLabel("!" + System.getProperty("java.version")), "wrap");
        layout.add(UWKit.newLabel("Java home:"), "right");
        MachineSetupPanel.addPath(layout, System.getProperty("java.home"));
        layout.add(UWKit.newLabel("Operating System:"), "right");
        layout.add(UWKit.newLabel("!" + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")), "wrap");
        layout.add(UWKit.newLabel("GL Vendor:"), "right");
        layout.add(UWKit.newLabel(Main.m_MainWindow.m_GlVendor), "wrap");
        layout.add(UWKit.newLabel("GL Renderer:"), "right");
        layout.add(UWKit.newLabel(Main.m_MainWindow.m_GlRenderer), "wrap");
        layout.add(UWKit.newLabel("GL Version:"), "right");
        layout.add(UWKit.newLabel(Main.m_MainWindow.m_GlVersion), "wrap");
        Layout layout2 = UWKit.newTitledLayout("Copyright", "flowy");
        layout2.add(UWKit.newLabel("Copyright (c) 2013-2021 Kustaa Nyholm"), new String[0]);
        layout2.add(UWKit.newLabel("Usage is Subject to"), new String[0]);
        layout2.add(UWKit.newLabel("License Agreement Version 1.0"), new String[0]);
        layout2.add(UWKit.newLabel("for the EazyCNC Software"), new String[0]);
        Layout layout3 = UWKit.newLayout("");
        layout3.add(layout, "top,sgy");
        layout3.add(layout2, "top,sgy");
        return layout3;
    }

    public static Layout newMachineSetupPanel(Main main) {
        MachState machState = main.m_MachController.getMachState();
        Variable variable = machState.getSpeedUnit();
        Variable variable2 = machState.getAccelUnit();
        Variable variable3 = machState.getJerkUnit();
        Variable variable4 = machState.getLengthUnit();
        Layout layout = UWKit.newLayout("flowy,insets 2,fill");
        Layout layout2 = UWKit.newLayout("flowx,filly");
        layout2.add(MachineSetupPanel.createIOSetupPanel(main, machState), "grow");
        Layout layout3 = UWKit.newTitledLayout("Comm port name");
        layout3.add(UWKit.newLabel("Port:"), new String[0]);
        layout3.add(UWKit.newTextField(machState.getVariable(15302), 16.0, 16), new String[0]);
        Button button = UWKit.newButton("Detect Port");
        button.addActionListener(() -> MachineSetupPanel.autoDetectPort(machState));
        layout3.add(button, new String[0]);
        Layout layout4 = UWKit.newTitledLayout("Available firmwares");
        String string = "nothing";
        SimpleVariable simpleVariable = new SimpleVariable(string);
        Button button2 = UWKit.newButton("UPDATE");
        button2.addActionListener(() -> {
            if (main.m_MachController.getConnectionState() != ConnectionState.SHUTDOWN) {
                Main.m_MainWindow.setButtonErrorAndBeep("Cannot update firmware in MACH or SIMU mode");
                return;
            }
            String string = (String)simpleVariable.getValue();
            if (string == null) {
                MachineSetupPanel.updateFirmwareFromFile();
            } else {
                MachineSetupPanel.updateFirmwareFromStream(Firmwares.class.getResourceAsStream(string));
            }
        });
        simpleVariable.addObserver(observable -> button2.setEnabled(simpleVariable.getValue() != string));
        ComboBox comboBox = UWKit.newComboBox((Variable)simpleVariable, Firmwares.getFirmwares());
        layout4.add(UWKit.newLabel("Firmware:"), new String[0]);
        layout4.add(comboBox, new String[0]);
        layout4.add(button2, new String[0]);
        Layout layout5 = UWKit.newTitledLayout("Logging");
        layout5.add(UWKit.newCheckBox((Variable)machState.getVariable(15295), "Enable TOAD4 communication logging"), "wrap");
        layout5.add(UWKit.newCheckBox((Variable)machState.getVariable(15296), "Enable Java console to file logging"), new String[0]);
        Layout layout6 = UWKit.newLayout("flowx");
        if (2 == machState.getParamInt(15355)) {
            layout6.add(layout4, "wrap,growx");
        }
        layout6.add(layout5, "growx");
        Layout layout7 = UWKit.newTitledLayout("Joystick config");
        Layout layout8 = UWKit.newTitledLayout("User Interface");
        layout8.add(UWKit.newLabel("Language:"), "align right");
        layout8.add(UWKit.newComboBox((Variable)machState.getVariable(15299), MachineSetupPanel.getLanguages(main, true), MachineSetupPanel.getLanguages(main, false)), "span 2,wrap");
        layout8.add(UWKit.newLabel("Refresh:"), "align right");
        layout8.add(UWKit.newTextField((Variable)machState.getVariable(15297), 16.0, 7, new DecimalFormat("0"), null), "");
        layout8.add(UWKit.newLabel("fps"), "align left,wrap");
        layout8.add(UWKit.newLabel("Units:"), "align right");
        layout8.add(UWKit.newComboBox((Variable)machState.getVariable(15141), "mm", 1.0, "inch", 25.4), "wrap");
        layout8.add(UWKit.newLabel("DRO-frmt:"), "align right");
        layout8.add(UWKit.newTextField(machState.getVariable(15300), 16.0, 7), new String[0]);
        Variable variable5 = machState.getDroFormatVariable();
        Layout layout9 = UWKit.newTitledLayout("Axis Grid Display");
        Layout layout10 = UWKit.newTitledLayout("Axis Grid Style");
        Layout layout11 = UWKit.newTitledLayout("Axis Grid Size");
        layout10.add(UWKit.newLabel("Grid:"), "align right");
        layout10.add(UWKit.newComboBox((Variable)machState.getVariable(16500), "Manual", 0, "Automatic", 1), "span 2,wrap");
        layout10.add(UWKit.newLabel("Spacing:"), "align right");
        layout10.add(UWKit.newTextField((Variable)machState.getScaledVariable(16502), 16.0, 7, variable5, null), "");
        layout10.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout10.add(UWKit.newLabel("  Width:"), "align right");
        layout10.add(UWKit.newTextField((Variable)machState.getScaledVariable(16501), 16.0, 7, variable5, null), "");
        layout10.add(UWKit.newLabel("pixels "), "wrap");
        layout11.add(UWKit.newLabel(""), new String[0]);
        layout11.add(UWKit.newLabel("Min"), new String[0]);
        layout11.add(UWKit.newLabel("Max"), "skip,wrap");
        layout11.add(UWKit.newLabel("X"), "align right,sgx ags");
        layout11.add(UWKit.newTextField((Variable)machState.getScaledVariable(16503), 16.0, 7, variable5, null), "");
        layout11.add(UWKit.newLabel(machState.getLengthUnit()), "");
        layout11.add(UWKit.newTextField((Variable)machState.getScaledVariable(16507), 16.0, 7, variable5, null), new String[0]);
        layout11.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout11.add(UWKit.newLabel("Y"), "align right,sgx ags");
        layout11.add(UWKit.newTextField((Variable)machState.getScaledVariable(16504), 16.0, 7, variable5, null), "");
        layout11.add(UWKit.newLabel(machState.getLengthUnit()), "");
        layout11.add(UWKit.newTextField((Variable)machState.getScaledVariable(16508), 16.0, 7, variable5, null), new String[0]);
        layout11.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout11.add(UWKit.newLabel("Z"), "align right,sgx ags");
        layout11.add(UWKit.newTextField((Variable)machState.getScaledVariable(16506), 16.0, 7, variable5, null), "");
        layout11.add(UWKit.newLabel(machState.getLengthUnit()), "");
        layout11.add(UWKit.newTextField((Variable)machState.getScaledVariable(16509), 16.0, 7, variable5, null), new String[0]);
        layout11.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout9.add(UWKit.newLabel(""), new String[0]);
        layout9.add(UWKit.newLabel("Position"), "");
        layout9.add(UWKit.newLabel("Color"), "skip,wrap");
        layout9.add(UWKit.newLabel("XY"), "align right,sgx ags");
        layout9.add(UWKit.newTextField((Variable)machState.getScaledVariable(16510), 16.0, 7, variable5, null), new String[0]);
        layout9.add(UWKit.newLabel(machState.getLengthUnit()), "");
        layout9.add(UWKit.newColorPicker(machState.getVariable(15320)), "wrap");
        layout9.add(UWKit.newLabel("YZ"), "align right,sgx ags");
        layout9.add(UWKit.newTextField((Variable)machState.getScaledVariable(16511), 16.0, 7, variable5, null), new String[0]);
        layout9.add(UWKit.newLabel(machState.getLengthUnit()), "");
        layout9.add(UWKit.newColorPicker(machState.getVariable(15321)), "wrap");
        layout9.add(UWKit.newLabel("ZX"), "align right,sgx ags");
        layout9.add(UWKit.newTextField((Variable)machState.getScaledVariable(16512), 16.0, 7, variable5, null), new String[0]);
        layout9.add(UWKit.newLabel(machState.getLengthUnit()), "");
        layout9.add(UWKit.newColorPicker(machState.getVariable(15322)), "wrap");
        Layout layout12 = UWKit.newTitledLayout("Machined Path Display", "");
        layout12.add(UWKit.newLabel("Spindle ON:"), "align right");
        layout12.add(UWKit.newColorPicker(machState.getVariable(15335)), "wrap");
        layout12.add(UWKit.newLabel("OFF:"), "align right");
        layout12.add(UWKit.newColorPicker(machState.getVariable(15336)), "wrap");
        layout12.add(UWKit.newLabel("Width:"), "align right");
        layout12.add(UWKit.newTextField((Variable)machState.getVariable(15340), 16.0, 7, new SimpleVariable("0.0"), null), "");
        layout12.add(UWKit.newLabel("pxls"), "");
        layout12.add(UWKit.newLabel("(*)"), "top");
        Layout layout13 = UWKit.newTitledLayout("Planned Path Display");
        layout13.add(UWKit.newLabel("Spindle ON:"), "align right");
        layout13.add(UWKit.newColorPicker(machState.getVariable(15337)), "wrap");
        layout13.add(UWKit.newLabel("OFF:"), "align right");
        layout13.add(UWKit.newColorPicker(machState.getVariable(15338)), "wrap");
        layout13.add(UWKit.newLabel("Width:"), "align right");
        layout13.add(UWKit.newTextField((Variable)machState.getVariable(15339), 16.0, 7, new SimpleVariable("0.0"), null), "");
        layout13.add(UWKit.newLabel("pxls"), "");
        Layout layout14 = UWKit.newTitledLayout("Tool Display");
        layout14.add(UWKit.newLabel("Tool:"), "align right");
        layout14.add(UWKit.newColorPicker(machState.getVariable(15331)), "wrap");
        layout14.add(UWKit.newLabel("Diameter:"), "align right");
        layout14.add(UWKit.newTextField((Variable)machState.getScaledVariable(15330), 16.0, 7, new SimpleVariable("0.00"), null), "");
        layout14.add(UWKit.newLabel(variable4), "");
        layout14.add(UWKit.newLabel("(*)"), "top");
        if (!main.isAndroid()) {
            machState.getVariable(15298).addObserver(new VariableObserver(){
                boolean first = true;

                @Override
                public void valueChanged(Variable variable) {
                    if (!this.first) {
                        UWKit.showInformationDialog("Screen Layout Changed", "<b>For the Layout change change to take effect you need to <br>both <u>Save</u> the settings and <u>re-start</u> EazyCNC.</b>", "Ok", null, null, null);
                    }
                    this.first = false;
                }
            });
        }
        Layout layout15 = UWKit.newLayout("flowx");
        layout15.add(UWKit.newLabel("(*)"), "top");
        layout15.add(UWKit.newLabel("non-zero value overrides actual diameter"), "");
        Layout layout16 = UWKit.newLayout("flowy,filly");
        layout16.add(layout8, "grow,top,spany 4,cell 0 0");
        layout16.add(layout10, "grow,bottom,spany 4,cell 0 0");
        layout16.add(layout11, "grow,top,cell 1 0,gap push");
        layout16.add(layout9, "grow,bottom,cell 1 0");
        layout16.add(layout12, "grow,top,cell 2 0,flowy");
        layout16.add(layout13, "grow,left,top,cell 2 0");
        layout16.add(layout14, "grow,top,cell 2 0 ");
        if (!main.isAndroid()) {
            layout16.add(layout15, "grow,left,bottom,cell 1 2");
        }
        LinkedList<SubPanel> linkedList = new LinkedList<SubPanel>();
        linkedList.add(new SubPanel("Screen", layout16));
        linkedList.add(new SubPanel("Options", MachineSetupPanel.newOptionsPanel(machState)));
        linkedList.add(new SubPanel("Motion", MachineSetupPanel.newMotionPanel(machState)));
        linkedList.add(new SubPanel("I/O", layout2));
        linkedList.add(new SubPanel("Shortcuts", Main.m_ShortCutManager.getLayout(main)));
        linkedList.add(new SubPanel("Test", TOAD5TestPanel.getTestPanel(main)));
        linkedList.add(new SubPanel("Controller", layout6));
        linkedList.add(new SubPanel("Info", MachineSetupPanel.newInfoPanel(main)));
        boolean bl = false;
        if (bl) {
            TabbedLayout tabbedLayout = UWKit.newTabbedLayout();
            for (SubPanel subPanel : linkedList) {
                tabbedLayout.addTab(subPanel.m_String, subPanel.m_Layout);
            }
            layout.add(tabbedLayout, "grow");
            return layout;
        }
        SimpleVariable simpleVariable2 = new SimpleVariable("");
        final CardLayout cardLayout = UWKit.newCardLayout();
        Layout layout17 = UWKit.newLayout("flowx,filly");
        layout17.add(UWKit.newLabel("Setup:"), new String[0]);
        int n = 0;
        Main.m_ScreenCap.push(simpleVariable2);
        for (SubPanel subPanel : linkedList) {
            if (n++ == 0) {
                simpleVariable2.setValue(subPanel.m_String);
            }
            cardLayout.addCard(subPanel.m_String, subPanel.m_Layout);
            layout17.add(UWKit.newToggleButton((Variable)simpleVariable2, subPanel.m_String, (Object)subPanel.m_String), "growx,sizegroup");
            Main.m_ScreenCap.addValue(subPanel.m_String);
            if (!"G-code".equals(subPanel.m_String)) continue;
            Main.m_ScreenCap.push(machState.getVariable(15170));
            Main.m_ScreenCap.addValue(true);
            Main.m_ScreenCap.addValue(false);
            Main.m_ScreenCap.pop();
        }
        Main.m_ScreenCap.pop();
        Layout layout18 = UWKit.newTitledLayout("Machine Setup", "flowy");
        layout18.add(layout17, "gap 0");
        layout18.add(cardLayout, "growx,growy");
        simpleVariable2.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                cardLayout.selectCard(variable.getValue().toString());
            }
        });
        return layout18;
    }

    static class SubPanel {
        String m_String;
        Layout m_Layout;

        SubPanel(String string, Layout layout) {
            this.m_String = string;
            this.m_Layout = layout;
        }
    }
}

