/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import builtin.BuiltInPlugins;
import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.plugin.EazyCNC;
import com.eazycnc.plugin.Plugin;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.ResourceLoader;
import com.eazycnc.uwk.Translator;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.ChangeListener;
import com.eazycnc.uwk.widgets.SplitLayout;
import com.jogamp.opengl.JoglVersion;
import eazycnc.BackgroundCompiler;
import eazycnc.Dictionary;
import eazycnc.GCodeEditorPanel;
import eazycnc.JavaConsole;
import eazycnc.Joystick;
import eazycnc.JoystickListener;
import eazycnc.MainWindow;
import eazycnc.OnscreenKeyboard;
import eazycnc.PendantActions;
import eazycnc.PendantManager;
import eazycnc.PluginMethods;
import eazycnc.ScreenCapture;
import eazycnc.ShortcutManager;
import eazycnc.Splash;
import eazycnc.StatusPanel;
import eazycnc.ToadCommLogger;
import eazycnc.ToolpathDisplayPanel;
import eazycnc.UserActions;
import eazycnc.UserButtons;
import eazycnc.configfile.OldFormatConfiFileReader;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Parser;
import eazycnc.plugins.PluginManager;
import eazycnc.udevrules.UdevRules;
import examples.Examples;
import graphics.GraphicsLoader;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import motorcontrol.MachController;
import motorcontrol.MachiningState;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.InputReportListener;
import purejavahidapi.PureJavaHidApi;
import swing.SwingWidgetFactory;
import toad4plus.Toad4PlusComm;
import toad4plus.Toad4PlusMotorController;
import virtualmill3ax.MachSimulator;

public class Main {
    public static MachSimulator m_Simulator;
    public static JFrame m_Window;
    static int m_UIsize;
    public static String m_HomeDir;
    public static String m_DebugLogsDir;
    public Dictionary m_Dictionary;
    public static String m_ConfigFile;
    public static ToadCommLogger m_ToadCommLogger;
    public static String m_VersionString;
    public static String m_CopyrightString;
    public static Main m_Main;
    public static Joystick m_Joystick;
    public UserActions m_Actions;
    public PluginManager m_PluginManager;
    public PluginMethods m_PluginMethods;
    public MachController m_MachController;
    public MachState m_ActualMachState;
    private static String m_MyPath;
    public Interpreter m_Interpreter;
    public Parser m_Parser;
    public BackgroundCompiler m_Compiler;
    public GCodeEditorPanel m_GCodeEditor;
    public SplitLayout m_Split;
    public StatusPanel m_StatusPanel;
    public static ShortcutManager m_ShortCutManager;
    public Toad4PlusMotorController.ToadPlusCommInterface m_ToadComm;
    public PendantManager m_PendantManager;
    public PendantActions m_PendantActions;
    public static MainWindow m_MainWindow;
    public static boolean m_Started;
    public JMenuItem m_NewMenuItem;
    public JMenuItem m_SaveMenuItem;
    public JMenuItem m_OpenMenuItem;
    public JMenuItem m_CloseMenuItem;
    public JMenuItem m_UndoMenuItem;
    public JMenuItem m_RedoMenuItem;
    public JMenuItem m_CopyMenuItem;
    public JMenuItem m_CutMenuItem;
    public JMenuItem m_PasteMenuItem;
    public ToolpathDisplayPanel m_ToolpathDisplayPanel;
    public JMenuBar m_MenuBar;
    public static boolean m_OSisAndroid;
    public static boolean m_OSisWindows;
    public static boolean m_OSisMacOS;
    public static boolean m_OSisLinux;
    public static boolean m_OSisRasbian;
    private static boolean m_NoJavaConsole;
    private static boolean m_DevelopmentMode;
    private static boolean m_AutoRunEnabled;
    private static boolean m_AutomaticTestMode;
    private static Timer m_AutomaticTestModeSchedulerTimer;
    private LinkedList<ChangeListener> m_Listeners = new LinkedList();
    private static boolean m_IsSpecialDown;
    static ScreenCapture m_ScreenCap;
    private ConnectionState m_TargetConnectionStatus;
    public static MyEventQueue m_EventQueue;
    private boolean m_AllReadyOfferedUdevHelp = false;

    public static boolean isSpecialDown() {
        return m_IsSpecialDown;
    }

    public static boolean isMacOS() {
        return m_OSisMacOS;
    }

    public static boolean isLinux() {
        return m_OSisLinux;
    }

    public static boolean isWindows() {
        return m_OSisWindows;
    }

    public static boolean isAndroid() {
        return m_OSisAndroid;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_Listeners.add(changeListener);
    }

    public static boolean compactUI() {
        return m_UIsize != 0;
    }

    static void setLookAndFeel() {
        try {
            String string = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            JFrame.setDefaultLookAndFeelDecorated(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runShutdownScript() {
        try {
            String[] stringArray;
            Object object;
            String string = m_HomeDir + "shutdown";
            string = m_OSisWindows ? string + ".BAT" : string + ".sh";
            if (new File(string).exists()) {
                object = System.getenv("SHELL");
                stringArray = new String[]{object, string};
            } else {
                stringArray = new String[]{"shutdown", "now"};
            }
            object = new ProcessBuilder(stringArray).inheritIO().start();
            if (!((Process)object).waitFor(1000L, TimeUnit.MILLISECONDS)) {
                System.err.println("shutdown failed");
            }
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void tryToQuit() {
        UWKit.showConfirmDialog("Quit EazyCNC", "<b>Are you sure you want to Quit EazyCNC?</b><br><br>This will abort any machining operation in progress and<br>lose unsaved machine setup information.<br>", "Yes", null, "Cancel", new DialogCallback(){

            @Override
            public void onClose(DialogCallback.DialogOptions dialogOptions) {
                if (dialogOptions == DialogCallback.DialogOptions.YES) {
                    Main.this.m_GCodeEditor.closeAllSourceCodeEditors(new Runnable(){

                        @Override
                        public void run() {
                            if (Main.m_Main.m_MachController.m_MachState.getParamBoolean(15221)) {
                                Main.this.runShutdownScript();
                            }
                            System.exit(0);
                        }
                    });
                }
            }
        });
    }

    private static void setWindowIcons(JFrame jFrame) {
        try {
            LinkedList<Image> linkedList = new LinkedList<Image>();
            linkedList.add(new ImageIcon(GraphicsLoader.class.getResource("EazyCNC-logo-yellow-32.png")).getImage());
            linkedList.add(new ImageIcon(GraphicsLoader.class.getResource("EazyCNC-logo-yellow-64.png")).getImage());
            linkedList.add(new ImageIcon(GraphicsLoader.class.getResource("EazyCNC-logo-yellow-128.png")).getImage());
            linkedList.add(new ImageIcon(GraphicsLoader.class.getResource("EazyCNC-logo-yellow-256.png")).getImage());
            linkedList.add(new ImageIcon(GraphicsLoader.class.getResource("EazyCNC-logo-yellow-512.png")).getImage());
            jFrame.setIconImages(linkedList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void output(final InputStream inputStream) {
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                byte[] byArray = new byte[1];
                try {
                    int n;
                    while ((n = inputStream.read(byArray)) >= 0) {
                        System.out.write(byArray);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        thread2.setUncaughtExceptionHandler((thread, throwable) -> {
            System.err.println("class Main: uncaught exception");
            throwable.printStackTrace();
        });
        thread2.start();
    }

    private static void exec(String[] stringArray) {
        System.out.println("Executing ");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.print(stringArray[i] + " ");
        }
        System.out.println();
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            PrintStream printStream = new PrintStream(process.getOutputStream());
            InputStream inputStream = process.getInputStream();
            InputStream inputStream2 = process.getErrorStream();
            Main.output(inputStream);
            Main.output(inputStream2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void setWindowsFileAssociaton() {
        try {
            String string = "eazycnc";
            String[] stringArray = new String[]{"REG", "ADD", "HKCR\\.ecnc", "/f", "/v", "\"\"", "/t", "REG_SZ", "/d", string};
            Main.exec(stringArray);
            String[] stringArray2 = new String[]{"REG", "ADD", "HKCR\\" + string, "/f", "/v", "\"\"", "/t", "REG_SZ", "/d", "\"EazyCNC - machine configuration file\""};
            Main.exec(stringArray2);
            String string2 = "\"" + m_MyPath + "\",0";
            String[] stringArray3 = new String[]{"REG", "ADD", "HKCR\\" + string + "\\DefaultIcon", "/f", "/v", "\"\"", "/t", "REG_SZ", "/d", string2};
            Main.exec(stringArray3);
            String string3 = "\"" + m_MyPath + " %1\"";
            String[] stringArray4 = new String[]{"REG", "ADD", "HKCR\\" + string + "\\shell\\open\\command", "/f", "/v", "\"\"", "/t", "REG_SZ", "/d", string3};
            Main.exec(stringArray4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void postInitialization(int n, int n2) {
        if (m_OSisWindows) {
            Main.setWindowsFileAssociaton();
        }
        if (m_OSisMacOS) {
            try {
                Class.forName("macstuff.MacStuff").getConstructor(this.getClass()).newInstance(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Main.m_MainWindow.m_Old_UI_SIZE = m_UIsize;
        int n3 = Main.m_Main.m_MachController.m_MachState.getParamInt(15215);
        if (n3 == 0) {
            Main.m_Main.m_Split.setSplit(m_Window.getWidth() / 2);
        }
    }

    private static Properties fetchEazyCNCProperties() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = Main.class.getResourceAsStream("eazycnc.properties");
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    public boolean checkConnected() {
        ConnectionState connectionState = Main.m_Main.m_MachController.getConnectionState();
        if (!Main.m_Main.m_MachController.isConnected()) {
            m_MainWindow.setButtonErrorAndBeep("Motor controller not connected");
            return false;
        }
        return true;
    }

    public Main(MachState machState, boolean bl, Joystick joystick, String string, String string2, Toad4PlusMotorController.ToadPlusCommInterface toadPlusCommInterface) {
        m_Main = this;
        EazyCNC.m_Main = this;
        this.m_PluginManager = new PluginManager();
        BuiltInPlugins.updateBuiltinPlugins(this.m_PluginManager.getPluginsDir() + "builtin/");
        this.m_PluginManager.loadPluginClasses();
        this.m_PluginMethods = new PluginMethods();
        m_HomeDir = string + File.separator + "EazyCNC" + File.separator;
        m_ConfigFile = string2;
        m_DebugLogsDir = m_HomeDir + "debuglogs" + File.separator;
        m_ToadCommLogger = new ToadCommLogger(bl ? null : m_DebugLogsDir);
        m_OSisAndroid = bl;
        m_Joystick = joystick;
        this.m_Interpreter = new Interpreter();
        this.m_ToolpathDisplayPanel = new ToolpathDisplayPanel();
        this.m_StatusPanel = new StatusPanel(this);
        this.m_ToadComm = toadPlusCommInterface;
        this.m_MachController = new MachController(machState, 6, this.m_ToadComm, this.m_StatusPanel, this.m_ToolpathDisplayPanel, this.m_PluginMethods);
        this.m_ActualMachState = this.m_MachController.getMachState();
        this.m_StatusPanel.init(this.m_MachController, this.m_ToolpathDisplayPanel);
        this.m_Parser = new Parser(this.m_Interpreter);
        this.m_Compiler = new BackgroundCompiler(this);
        m_ShortCutManager = new ShortcutManager(this);
        m_ShortCutManager.loadShortcuts(this.m_MachController.getMachState());
        this.m_Actions = new UserActions(this);
        String string3 = this.m_MachController.getMachState().getParamString(15299);
        this.loadDictionary(string3);
        this.configureUWKit();
        this.m_PluginManager.instantiatePlugins(string3, this.m_PluginMethods, this.createMachControllerProxy());
        this.m_Interpreter.setExtensions(this.m_PluginMethods.getCompilerExtension());
        if (!m_OSisAndroid) {
            this.m_PendantManager = new PendantManager(this);
        }
        m_Main.addChangeListener(object -> this.checkAccessDenied());
    }

    private void loadDictionary(String string) {
        this.m_Dictionary = new Dictionary("Did not");
        this.m_Dictionary.load(this.getClass(), "strings.properties");
        this.m_Dictionary.load(new File(m_HomeDir + File.separator + "strings.properties"));
        this.m_Dictionary.load("eazycnc.locales." + string + ".Locale", "strings.properties");
        this.m_Dictionary.load(new File(m_HomeDir + "locales" + File.separator + string + File.separator + "strings.properties"));
    }

    private void configureUWKit() {
        UWKit.setTranslator(new Translator(){

            @Override
            public String translate(String string) {
                Class clazz = Main.this.m_PluginManager.getCallingPluginsClass();
                if (clazz != null) {
                    Dictionary dictionary = Main.this.m_PluginManager.getDictionary(clazz);
                    if (dictionary != null) {
                        return dictionary.lookup(string);
                    }
                    return string;
                }
                return Main.this.m_Dictionary.lookup(string);
            }
        });
        UWKit.setResourceLoader(new ResourceLoader(){

            @Override
            public BufferedImage loadImage(String string) {
                Class clazz;
                Class clazz2 = GraphicsLoader.class;
                Class clazz3 = Main.this.m_PluginManager.getCallingPluginsClass();
                if (clazz3 != null && null != (clazz = Main.this.m_PluginManager.getResourceLoaderClass(clazz3)) && clazz.getResource(string) != null) {
                    clazz2 = clazz;
                }
                return GraphicsLoader.loadImage(clazz2, string);
            }

            @Override
            public ImageIcon loadIcon(String string) {
                Class clazz;
                Class clazz2 = GraphicsLoader.class;
                Class clazz3 = Main.this.m_PluginManager.getCallingPluginsClass();
                if (clazz3 != null && null != (clazz = Main.this.m_PluginManager.getResourceLoaderClass(clazz3)) && clazz.getResource(string) != null) {
                    clazz2 = clazz;
                }
                return GraphicsLoader.loadIcon(clazz2, string);
            }

            @Override
            public void setResourceClass(Class clazz) {
                Class clazz2 = Main.this.m_PluginManager.getCallingPluginsClass();
                if (clazz2 != null) {
                    Main.this.m_PluginManager.setResourceClass(clazz2);
                }
            }
        });
        UWKit.setDefaultFloatFormat(new DecimalFormat("0.000"));
    }

    public void requestConnectionStatus(ConnectionState connectionState) {
        this.m_TargetConnectionStatus = connectionState;
    }

    private void updateConnections() {
        if (this.m_TargetConnectionStatus != this.m_MachController.getConnectionState()) {
            this.m_MachController.setConnectionState(this.m_TargetConnectionStatus);
        }
        for (Plugin plugin : this.m_PluginManager.getPlugins()) {
            if (this.m_TargetConnectionStatus == plugin.getConnectionState()) continue;
            plugin.setConnectionState(this.m_TargetConnectionStatus);
        }
    }

    private void autoRun() {
        if ((Main.m_Main.m_MachController.getConnectionState() == ConnectionState.CONNECTED || Main.m_Main.m_MachController.getConnectionState() == ConnectionState.SIMULATION) && Main.m_Main.m_MachController.getMachiningState() != MachiningState.RUNNING) {
            UWKit.scheduleInEDT(() -> {
                try {
                    Main.m_Main.m_MachController.startCycle(true);
                }
                catch (Exception exception) {
                    System.out.println("autoRun/startCycle exception: " + exception.getMessage());
                }
            });
        }
    }

    public void start() {
        UWKit.scheduleInEDT(() -> this.m_Compiler.setPriority(Thread.currentThread().getPriority() - 2));
        if (this.m_PluginManager.getLastInitError() != null) {
            m_MainWindow.setButtonErrorAndBeep(this.m_PluginManager.getLastInitError());
        }
        m_ToadCommLogger.cleanupLogDir();
        UWKit.scheduleInEDT(100, 100, new Runnable(){

            @Override
            public void run() {
                m_ToadCommLogger.enableToadCommLogging(Main.this.m_MachController.m_MachState.getParamBoolean(15295));
                JavaConsole.enableJavaConsoleLogToFile(Main.this.m_MachController.m_MachState.getParamBoolean(15296));
                for (ChangeListener changeListener : Main.this.m_Listeners) {
                    try {
                        changeListener.stateChanged(null);
                        Main.this.updateConnections();
                        if (!m_AutoRunEnabled) continue;
                        Main.this.autoRun();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    public void startAutoRun() {
        m_AutoRunEnabled = true;
    }

    public void stopAutoRun() {
        m_AutoRunEnabled = false;
    }

    public static Joystick getJoystick() {
        System.out.print("looking for joystick... ");
        List list = PureJavaHidApi.enumerateDevices();
        HidDeviceInfo hidDeviceInfo = null;
        for (HidDeviceInfo hidDeviceInfo2 : list) {
            if (hidDeviceInfo2.getVendorId() != 2064 || hidDeviceInfo2.getProductId() != 5) continue;
            hidDeviceInfo = hidDeviceInfo2;
        }
        if (hidDeviceInfo != null) {
            System.out.println("found");
            try {
                HidDeviceInfo hidDeviceInfo2;
                Joystick joystick = new Joystick();
                hidDeviceInfo2 = PureJavaHidApi.openDevice(hidDeviceInfo);
                hidDeviceInfo2.setInputReportListener((InputReportListener)joystick);
                return joystick;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        System.out.println("not found");
        return new Joystick();
    }

    private static void toggleAutomaticTest() {
        System.out.println("AUTOMATIC TEST STARTED");
        if (!m_AutomaticTestMode) {
            m_AutomaticTestMode = true;
            if (m_AutomaticTestModeSchedulerTimer == null) {
                m_AutomaticTestModeSchedulerTimer = new Timer(250, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (Main.m_Main.m_MachController.machiningIsAtEnd()) {
                            Main.m_Main.m_Actions.m_Action_STOP.onAction();
                        } else if (Main.m_Main.m_MachController.getMachiningState() == MachiningState.PAUSED || Main.m_Main.m_MachController.getMachiningState() == MachiningState.STOPPED) {
                            Main.m_Main.m_Actions.m_Action_RUN.onAction();
                        }
                    }
                });
                m_AutomaticTestModeSchedulerTimer.setInitialDelay(1000);
            }
            m_AutomaticTestModeSchedulerTimer.start();
        } else {
            m_AutomaticTestMode = false;
            if (m_AutomaticTestModeSchedulerTimer != null) {
                m_AutomaticTestModeSchedulerTimer.stop();
            }
        }
    }

    private static void generateScreenDumps() {
        System.out.println("generating screen dump");
        LinkedList<ScreenCapture.VariableValue> linkedList = new LinkedList<ScreenCapture.VariableValue>();
        m_ScreenCap.formFlatList(linkedList);
        String[] stringArray = new String[]{null};
        boolean[] blArray = new boolean[]{true};
        new Timer(100, actionEvent -> {
            int n;
            if (stringArray[0] != null) {
                System.out.println("creating screen dump: " + stringArray[0]);
                SwingWidgetFactory.makeScreenshot(new File(stringArray[0]), 0.0, blArray[0] ? 1.0 : 0.5);
                blArray[0] = false;
            }
            if (linkedList.isEmpty()) {
                ((Timer)actionEvent.getSource()).stop();
                return;
            }
            ScreenCapture.VariableValue variableValue = (ScreenCapture.VariableValue)linkedList.removeFirst();
            variableValue.m_Variable.setValue(variableValue.m_Value);
            Object object = variableValue.m_Path;
            while ((n = ((String)object).indexOf("/")) >= 0) {
                object = ((String)object).substring(0, n) + ((String)object).substring(n + 1);
            }
            stringArray[0] = "screencaps/" + (String)object + ".png";
        }).start();
    }

    private static void launchSimulator() {
        m_Simulator = new MachSimulator();
        m_Simulator.resimulate();
    }

    private static void setupShortcutListeners() {
        m_EventQueue = new MyEventQueue(){
            public boolean[] m_Pressed = new boolean[1024];
            public boolean m_IgnoreSave;

            boolean stealKeyEvent(KeyEvent keyEvent) {
                try {
                    String string;
                    boolean bl;
                    Component component;
                    boolean bl2 = m_IsSpecialDown = keyEvent.isAltDown() && keyEvent.isControlDown() && keyEvent.isMetaDown();
                    if (keyEvent.getKeyCode() == 123 && keyEvent.getID() == 401) {
                        if (!(keyEvent.isShiftDown() || keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isAltGraphDown() || keyEvent.isMetaDown())) {
                            JavaConsole.openConsole(false, true, true);
                        }
                        if (keyEvent.isControlDown() && keyEvent.isMetaDown() && keyEvent.isAltDown()) {
                            Toad4PlusMotorController toad4PlusMotorController = Main.m_Main.m_MachController.m_MotorController;
                            toad4PlusMotorController.testWatchdog();
                        }
                        return true;
                    }
                    if (keyEvent.getKeyCode() == 121 && keyEvent.getID() == 401 && !keyEvent.isAltDown() && keyEvent.isMetaDown()) {
                        Main.launchSimulator();
                        return true;
                    }
                    if (keyEvent.getKeyCode() == 122 && keyEvent.getID() == 401) {
                        Main.m_Main.m_MachController.showPlanPlotter();
                        return true;
                    }
                    if (keyEvent.getKeyCode() == 121 && keyEvent.getID() == 401 && keyEvent.isAltDown() && keyEvent.isControlDown()) {
                        Main.generateScreenDumps();
                        return true;
                    }
                    boolean bl3 = false;
                    if (Main.isMacOS() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 83) {
                        boolean bl4 = bl3 = keyEvent.isAltDown() && !keyEvent.isAltGraphDown() && !keyEvent.isControlDown() && keyEvent.isMetaDown() && !keyEvent.isShiftDown();
                    }
                    if (Main.isLinux() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 83) {
                        boolean bl5 = bl3 = !keyEvent.isAltDown() && !keyEvent.isAltGraphDown() && keyEvent.isControlDown() && !keyEvent.isMetaDown() && !keyEvent.isShiftDown();
                    }
                    if (Main.isWindows() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 83) {
                        boolean bl6 = bl3 = !keyEvent.isAltDown() && !keyEvent.isAltGraphDown() && keyEvent.isControlDown() && !keyEvent.isMetaDown() && !keyEvent.isShiftDown();
                    }
                    if (bl3 && !this.m_IgnoreSave) {
                        m_MainWindow.saveAll();
                        this.m_IgnoreSave = true;
                    }
                    if (keyEvent.getID() == 402) {
                        this.m_IgnoreSave = false;
                    }
                    if ((component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && component instanceof JTextComponent) {
                        return false;
                    }
                    if (keyEvent.getKeyCode() == 10 && keyEvent.getID() == 401) {
                        Main.m_Main.m_StatusPanel.activateCommandLineEntry();
                        return true;
                    }
                    if (keyEvent.getID() != 401 && keyEvent.getID() != 402) {
                        return false;
                    }
                    int n = keyEvent.getKeyCode();
                    if (18 == n) {
                        return false;
                    }
                    if (65406 == n) {
                        return false;
                    }
                    if (20 == n) {
                        return false;
                    }
                    if (17 == n) {
                        return false;
                    }
                    if (157 == n) {
                        return false;
                    }
                    if (16 == n) {
                        return false;
                    }
                    boolean bl7 = bl = keyEvent.getID() == 401;
                    if (bl && this.m_Pressed[n]) {
                        return true;
                    }
                    this.m_Pressed[n] = bl;
                    Object object = "";
                    if (keyEvent.isAltGraphDown()) {
                        object = (String)object + "ALT-GRAPH ";
                    }
                    if (keyEvent.isControlDown()) {
                        object = (String)object + "CTRL ";
                    }
                    if (keyEvent.isMetaDown()) {
                        object = (String)object + "CMD ";
                    }
                    if (keyEvent.isShiftDown()) {
                        object = (String)object + "SHIFT ";
                    }
                    switch (keyEvent.getKeyCode()) {
                        case 32: {
                            string = "SPACE";
                            break;
                        }
                        case 37: {
                            string = "LEFT";
                            break;
                        }
                        case 39: {
                            string = "RIGHT";
                            break;
                        }
                        case 38: {
                            string = "UP";
                            break;
                        }
                        case 40: {
                            string = "DOWN";
                            break;
                        }
                        default: {
                            string = KeyEvent.getKeyText(keyEvent.getKeyCode());
                        }
                    }
                    String string2 = (String)object + string;
                    if (UserButtons.executeUserButtonFromKey(bl, string2)) {
                        return true;
                    }
                    if (m_ShortCutManager.dispatchShortcutEvent(keyEvent, bl ? ShortcutManager.Press.PRESSED : ShortcutManager.Press.RELEASED, string2)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return false;
            }

            @Override
            public void dispatchEvent(AWTEvent aWTEvent) {
                if (aWTEvent instanceof KeyEvent && this.stealKeyEvent((KeyEvent)aWTEvent)) {
                    return;
                }
                if (aWTEvent.getID() == 501) {
                    SwingWidgetFactory.clickx();
                }
                if (m_OSisRasbian && aWTEvent.getID() == 501) {
                    OnscreenKeyboard.tactileFeedback();
                }
                if (m_OSisRasbian && aWTEvent.getID() == 502) {
                    OnscreenKeyboard.tactileFeedback();
                }
                super.dispatchEvent(aWTEvent);
            }
        };
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(m_EventQueue);
        if (m_Joystick != null && m_Joystick.getJoystickListener() == null) {
            m_Joystick.setJoystickListener(new JoystickListener(){

                @Override
                public void stickDeflected(int n, int n2) {
                }

                @Override
                public void buttonPressed(final int n, final boolean bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Object object = null;
                            switch (n) {
                                case 1: {
                                    object = "BUTTON 1";
                                    break;
                                }
                                case 2: {
                                    object = "BUTTON 2";
                                    break;
                                }
                                case 3: {
                                    object = "BUTTON 3";
                                    break;
                                }
                                case 4: {
                                    object = "BUTTON 4";
                                    break;
                                }
                                case 5: {
                                    object = "BUTTON 5";
                                    break;
                                }
                                case 6: {
                                    object = " BUTTON 6";
                                    break;
                                }
                                case 7: {
                                    object = " BUTTON 7";
                                    break;
                                }
                                case 8: {
                                    object = "BUTTON 8";
                                    break;
                                }
                                case 9: {
                                    object = "BUTTON 9";
                                    break;
                                }
                                case 10: {
                                    object = "BUTTON 10";
                                    break;
                                }
                                case 32: {
                                    object = "STICK LEFT";
                                    break;
                                }
                                case 33: {
                                    object = "STICK RIGHT";
                                    break;
                                }
                                case 34: {
                                    object = "STICK DOWN";
                                    break;
                                }
                                case 35: {
                                    object = "STICK UP";
                                }
                            }
                            if (object != null) {
                                if (m_Joystick.getShiftLock()) {
                                    object = "SHIFT " + (String)object;
                                }
                                m_ShortCutManager.dispatchShortcutEvent(m_Joystick, bl ? ShortcutManager.Press.PRESSED : ShortcutManager.Press.RELEASED, (String)object);
                            }
                        }
                    });
                }
            });
        }
    }

    public void load(String string) throws Exception {
        if (this.m_GCodeEditor != null) {
            this.m_GCodeEditor.scheduleZoomOut(false);
            this.m_GCodeEditor.loadFile(false, new File(string));
        } else {
            System.err.println("could not load '" + string + "' because m_GCodeEditor was null");
        }
    }

    public int getUIsize() {
        return this.m_MachController.m_MachState.getParamInt(15298);
    }

    private static void centerWindow(Window window) {
        Dimension dimension = window.getToolkit().getScreenSize();
        int n = Main.m_Main.m_MachController.m_MachState.getParamInt(15216);
        int n2 = Main.m_Main.m_MachController.m_MachState.getParamInt(15217);
        int n3 = Main.m_Main.m_MachController.m_MachState.getParamInt(15218);
        int n4 = Main.m_Main.m_MachController.m_MachState.getParamInt(15219);
        boolean bl = false;
        if (!m_OSisMacOS && Main.m_Main.m_MachController.m_MachState.getParamInt(15220) == 2) {
            System.out.println("DONT TOUCH FULL SCREEN!");
        } else {
            Object object;
            Object object2;
            Point point = new Point(n, n2);
            Point point2 = new Point(n + n3 - 1, n2 + n4 - 1);
            if (n3 > 0 && n4 > 0) {
                object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
                object = ((GraphicsEnvironment)object2).getDefaultScreenDevice();
                for (GraphicsConfiguration graphicsConfiguration : ((GraphicsDevice)object).getConfigurations()) {
                    Rectangle rectangle = graphicsConfiguration.getBounds();
                    System.out.printf(" x %d y %d w %d h %d\n", rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    if (!rectangle.contains(point) || !rectangle.contains(point2)) continue;
                    bl = true;
                }
            }
            if (bl) {
                window.setBounds(n, n2, n3, n4);
            } else {
                object2 = new Rectangle(0, 0, dimension.width, dimension.height);
                object = window.getSize();
                int n5 = (((Rectangle)object2).width - ((Dimension)object).width) / 2 + ((Rectangle)object2).x;
                int n6 = (((Rectangle)object2).height - ((Dimension)object).height) / 3 + ((Rectangle)object2).y;
                window.setBounds(n5, n6, ((Dimension)object).width, ((Dimension)object).height);
            }
        }
    }

    private static void readConfigFile(MachState machState, String string, String string2) throws Exception {
        String string3;
        System.out.println("Reading config file '" + string + "'");
        try {
            string3 = new String(Files.readAllBytes(Paths.get(string, new String[0])), StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException noSuchFileException) {
            System.err.println("...could not find config file '" + string + "'");
            if (string2 == null || !new File(string2).exists()) {
                throw noSuchFileException;
            }
            string = string2;
            try {
                System.out.println("...reading old format config file '" + string + "'");
                string3 = new String(Files.readAllBytes(Paths.get(string, new String[0])), StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                System.err.println("...could not read config file '" + string + "'");
                noSuchFileException.printStackTrace();
                throw exception;
            }
        }
        try {
            if (string3.startsWith("0")) {
                OldFormatConfiFileReader.read(machState, string3);
                throw new OldConfigFileException();
            }
            machState.loadStateFromJSON(string3);
        }
        catch (OldConfigFileException oldConfigFileException) {
            throw oldConfigFileException;
        }
        catch (Exception exception) {
            System.err.println("...could not parse config file '" + string + "'");
            exception.printStackTrace();
            throw exception;
        }
    }

    private void checkAccessDenied() {
        if ((this.m_ToadComm.getAccessDenied() || this.m_PendantManager.getAccessDenied()) && m_OSisLinux && !this.m_AllReadyOfferedUdevHelp) {
            this.m_AllReadyOfferedUdevHelp = true;
            UdevRules.offerToFixUdevRule(this.m_ToadComm.getAccessDenied(), this.m_PendantManager.getAccessDenied(), m_HomeDir);
        }
    }

    private static void installAndOpenExample() {
        File file = new File(m_HomeDir + "g-code-examples/");
        File file2 = new File(file.getAbsolutePath() + "/eazycnc-logo.txt");
        try {
            file.mkdirs();
            Files.copy(Examples.class.getResourceAsStream("eazycnclogo.txt"), file2.toPath(), new CopyOption[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            m_Main.load(file2.getAbsolutePath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void reportReadConfigExcepion(Exception exception) {
        if (exception instanceof OldConfigFileException) {
            UWKit.showInformationDialog("Old configuration file", "Configuration was read from old format file ('.ecnc').<br><br><b>The configuration will be saved in the new format '.ecnc2'.</b>", "Close", null, null, null);
        } else if (exception instanceof NoSuchFileException) {
            UWKit.showWarningDialog("Missing configuration file", "No configuration file was found.<br><br>You are now running with the default values.<br> <br><b>Do not attempt real machining with the default settings!</b>", "Close", null, null, dialogOptions2 -> UWKit.showConfirmDialog("Load example", "It appears you are trying EazyCNC for the first time.<br><br>Would you like to load an example G-code file?", "Yes", "No", null, dialogOptions -> {
                if (dialogOptions == DialogCallback.DialogOptions.YES) {
                    Main.installAndOpenExample();
                }
            }));
        } else {
            UWKit.showWarningDialog("Bad configuration file", "You are now running with the default values.<br> <br><b>Do not attempt real machining with the default settings!</b>", "Close", null, null, null);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        Object object;
        System.out.println("EazyCNC starting... ");
        Main.setLookAndFeel();
        Splash.displaySplash(m_VersionString, m_CopyrightString);
        JavaConsole.redirectStdOutputStreamsToConsole();
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> throwable.printStackTrace());
        Thread.currentThread().setUncaughtExceptionHandler((thread, throwable) -> throwable.printStackTrace());
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            string = "";
            if (i + 1 < stringArray.length) {
                string = stringArray[i + 1];
            }
            if ("-noconsole".equals(object)) {
                m_NoJavaConsole = true;
            }
            if ("-developmode".equals(object)) {
                m_DevelopmentMode = true;
            }
            if ("-configfile".equals(object) && ++i > 0) {
                string2 = string;
            }
            if (!"-loadfile".equals(object) || ++i <= 0) continue;
            string3 = string;
        }
        String string4 = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        m_OSisWindows = string4.indexOf("win") >= 0;
        m_OSisMacOS = string4.indexOf("mac os") >= 0;
        boolean bl = m_OSisLinux = string4.indexOf("nux") >= 0;
        if (m_OSisLinux) {
            try {
                m_OSisRasbian = Files.readString(Paths.get("/proc/cpuinfo", new String[0]), StandardCharsets.US_ASCII).contains("Raspberry");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("m_OSisRasbian " + m_OSisRasbian);
        string = string3;
        String string5 = System.getProperty("user.home");
        String string6 = null;
        if (string2 == null) {
            string6 = string5 + File.separator + "EazyCNC" + File.separator + "EazyCNC-Mach-Config.ecnc";
            object = string5 + File.separator + "EazyCNC" + File.separator + "EazyCNC-Mach-Config.ecnc2";
        } else {
            object = string2;
        }
        String string7 = string5 + File.separator + "EazyCNC" + File.separator + "java-console" + File.separator;
        JavaConsole.setLogDir(string7);
        final MachState machState = new MachState("MACHCONTROLLER", true);
        Exception exception = null;
        try {
            Main.readConfigFile(machState, (String)object, string6);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        Exception exception3 = exception;
        JavaConsole.enableJavaConsoleLogToFile(machState.getParamBoolean(15296));
        JavaConsole.cleanupLogDir();
        System.out.println("JOGAMP JoglVersion");
        System.out.println(JoglVersion.getInstance());
        try {
            String string8;
            String string9 = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (string9.indexOf("!") >= 0) {
                string9 = string9.substring(0, string9.indexOf("!"));
            }
            if (string9.startsWith(string8 = "file:")) {
                string9 = string9.substring(string8.length());
            }
            if (m_OSisWindows) {
                if (string9.startsWith("/")) {
                    string9 = string9.substring(1);
                }
                string9 = string9.replace('/', File.separatorChar);
            }
            if (m_OSisMacOS && string9.endsWith(string8 = ".app/Contents/Resources/Java")) {
                string9 = string9.substring(0, string9.length() - string8.length());
                int n = string9.lastIndexOf("/");
                string9 = string9.substring(0, n);
            }
            m_MyPath = string9;
            SwingUtilities.invokeAndWait(new Runnable(){
                final /* synthetic */ String val$configFileName;
                final /* synthetic */ String val$loadFileName;
                final /* synthetic */ Exception val$readConfigException;
                {
                    this.val$configFileName = string;
                    this.val$loadFileName = string2;
                    this.val$readConfigException = exception;
                }

                @Override
                public void run() {
                    try {
                        Object object;
                        Thread.currentThread().setUncaughtExceptionHandler((thread, throwable) -> throwable.printStackTrace());
                        int n = Thread.currentThread().getPriority();
                        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "EazyCNC");
                        System.setProperty("apple.laf.useScreenMenuBar", "true");
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        Dimension dimension = toolkit.getScreenSize();
                        new Main(machState, false, Main.getJoystick(), System.getProperty("user.home"), this.val$configFileName, new Toad4PlusComm());
                        m_UIsize = Main.m_Main.m_MachController.m_MachState.getParamInt(15298);
                        Main.setLookAndFeel();
                        if (m_UIsize != 0) {
                            Insets insets = new Insets(6, 6, 6, 6);
                            UIManager.getLookAndFeelDefaults().put("Button.contentMargins", insets);
                            UIManager.getLookAndFeelDefaults().put("ToggleButton.contentMargins", insets);
                        }
                        UWKit.m_Factory = new SwingWidgetFactory(m_UIsize, () -> Splash.hideSplash());
                        new MainWindow(m_Main);
                        m_Window = SwingWidgetFactory.m_Window;
                        m_Window.setTitle("EazyCNC - " + m_VersionString);
                        if (Main.isMacOS()) {
                            Main.enableOSXFullscreen(m_Window);
                            Main.requestOSXFullscreen(m_Window);
                        }
                        if (Main.m_Main.m_MachController.m_MachState.getParamInt(15220) != 0) {
                            m_Window.setUndecorated(true);
                        }
                        Main.setWindowIcons(m_Window);
                        boolean bl = false;
                        if (!m_OSisMacOS && Main.m_Main.m_MachController.m_MachState.getParamInt(15220) == 2) {
                            bl = true;
                        }
                        if (bl) {
                            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                            m_Window.setUndecorated(true);
                            try {
                                ((GraphicsDevice)object).setFullScreenWindow(m_Window);
                            }
                            catch (Exception exception) {
                                ((GraphicsDevice)object).setFullScreenWindow(null);
                            }
                        }
                        m_Window.setDefaultCloseOperation(0);
                        m_Window.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent windowEvent) {
                                m_Main.tryToQuit();
                            }
                        });
                        UWKit.m_Factory.setRootWidget(m_MainWindow.getLayout());
                        UWKit.m_Factory.realize();
                        if (bl) {
                            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        }
                        Main.m_MainWindow.m_Old_UI_SIZE = m_UIsize;
                        int n2 = Main.m_Main.m_MachController.m_MachState.getParamInt(15215);
                        if (n2 == 0) {
                            Main.m_Main.m_Split.setSplit(m_Window.getWidth() / 2);
                        }
                        Main.centerWindow(m_Window);
                        m_Window.addWindowFocusListener(new WindowFocusListener(){

                            @Override
                            public void windowLostFocus(WindowEvent windowEvent) {
                            }

                            @Override
                            public void windowGainedFocus(WindowEvent windowEvent) {
                                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                            }
                        });
                        Main.setupShortcutListeners();
                        m_Main.postInitialization(m_Window.getWidth(), m_Window.getHeight());
                        m_Main.start();
                        m_Started = true;
                        if (this.val$loadFileName != null) {
                            if (new File(this.val$loadFileName).exists()) {
                                m_Main.load(this.val$loadFileName);
                            } else {
                                System.out.println("Argument -loadfile '" + this.val$loadFileName + "' was given on the commandline but the file does not exist");
                            }
                        }
                        if (this.val$readConfigException != null) {
                            Main.reportReadConfigExcepion(this.val$readConfigException);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exception4) {
            exception4.printStackTrace();
        }
    }

    public static void enableOSXFullscreen(Window window) {
    }

    public static void requestOSXFullscreen(Window window) {
    }

    com.eazycnc.plugin.MachController createMachControllerProxy() {
        return new com.eazycnc.plugin.MachController(){

            @Override
            public void startHoming(int n) {
                System.out.println("HOMING!");
            }

            @Override
            public void setWorkOffset(int n, int n2, int n3) {
            }
        };
    }

    private static /* synthetic */ void lambda$main$7() {
        JFrame jFrame = new JFrame("");
        jFrame.setVisible(true);
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        try {
            graphicsDevice.setFullScreenWindow(jFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        Properties properties = Main.fetchEazyCNCProperties();
        m_VersionString = properties.getProperty("version", "?.?.?");
        m_CopyrightString = properties.getProperty("copyright", "Copyright \u00a9 2023 Kustaa Nyholm");
        m_ConfigFile = "";
        m_ScreenCap = new ScreenCapture();
    }

    static class MyEventQueue
    extends EventQueue {
        MyEventQueue() {
        }

        @Override
        public void dispatchEvent(AWTEvent aWTEvent) {
            super.dispatchEvent(aWTEvent);
        }
    }

    private static class OldConfigFileException
    extends Exception {
        private OldConfigFileException() {
        }
    }
}

