/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.plugin.Plugin;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.ErrorHandler;
import com.eazycnc.uwk.InvalidValueException;
import com.eazycnc.uwk.Multiplexer;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.Observable;
import com.eazycnc.uwk.Observer;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Validator;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.Canvas;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.ChangeListener;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.ToggleButton;
import com.eazycnc.uwk.widgets.Widget;
import eazycnc.AnimationScheduler;
import eazycnc.AxisSetupPanel;
import eazycnc.BackgroundCompiler;
import eazycnc.ConfigSaveOnAndroid;
import eazycnc.CoordinatesPanel;
import eazycnc.GCodeEditorPanel;
import eazycnc.HomeButtonLogic;
import eazycnc.MachineSetupPanel;
import eazycnc.Main;
import eazycnc.OnscreenKeyboard;
import eazycnc.ToolSetupPanel;
import eazycnc.UserActions;
import eazycnc.UserButtons;
import eazycnc.WorkOffsetPanel;
import eazycnc.gcode.FilePos;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;
import eazycnc.gcode.Machcode;
import eazycnc.gcode.ParameterValidators;
import eazycnc.gcode.Parser;
import eazycnc.plugins.PluginManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTextField;
import motorcontrol.MachController;
import motorcontrol.MachiningState;

public class MainWindow {
    public OnscreenKeyboard m_OnscreenKeyboard;
    public Button m_JogButtonXPlus;
    public Button m_JogButtonYPlus;
    public Button m_JogButtonZPlus;
    public Button m_JogButtonAPlus;
    public Button m_JogButtonXMinus;
    public Button m_JogButtonYMinus;
    public Button m_JogButtonZMinus;
    public Button m_JogButtonAMinus;
    Layout m_DroPanel_A;
    private volatile Main m_Main;
    private volatile Layout m_Layout;
    private volatile int m_PrevChangeCount;
    private volatile Canvas m_HistoPanel;
    private volatile LinkedList<Widget> m_ZeroButtons = new LinkedList();
    private volatile SimpleVariable m_SimuONVariable;
    private final Object SIMU = new Object();
    private final Object MACH = new Object();
    private volatile Button m_QuitButton;
    private volatile Button m_SaveButton;
    private volatile ToggleButton m_SimuButton;
    private volatile ToggleButton m_MachButton;
    private volatile ToggleButton m_CoolantButton;
    private volatile ToggleButton m_RunButton;
    private volatile ToggleButton m_StopButton;
    private volatile ToggleButton m_HoldButton;
    private volatile ToggleButton m_ReverseButton;
    private volatile ToggleButton m_FeedOverrideButton;
    private volatile ToggleButton m_SpindleOverrideButton;
    private volatile ToggleButton m_SpindleButton;
    private volatile ToggleButton m_StepButton;
    private volatile Button[] m_FuncButton;
    private volatile boolean[] m_MotorPosChanged;
    private volatile double[] m_OldMotorPos;
    private volatile Button[] m_HomeButtons;
    private volatile MotorController.MotorState[] m_HomeButtonStates;
    private volatile NumericVariable[] m_DROvariables;
    private volatile Layout[] m_DroPanels;
    private volatile boolean m_DRObeingUpdated = false;
    private volatile Widget[] m_DRO;
    private volatile NumericVariable m_SpindleSpeed;
    private volatile NumericVariable m_SpindleOverrideON;
    private volatile NumericVariable m_SpindleSpeedOverride;
    private volatile Variable m_FeedOverrideON;
    private volatile NumericVariable m_FeedOverride;
    private volatile NumericVariable m_FeedRate;
    SimpleVariable m_GlVendor = new SimpleVariable("");
    SimpleVariable m_GlRenderer = new SimpleVariable("");
    SimpleVariable m_GlVersion = new SimpleVariable("");
    private volatile boolean m_MacroRunning;
    private volatile SimpleVariable m_A_axisDroLetter = new SimpleVariable("");
    Map<Button, Integer> m_HomeButtonState;
    int m_Old_UI_SIZE;

    public void setGlInfo(String string, String string2, String string3) {
        this.m_GlVendor.setValue(string);
        this.m_GlRenderer.setValue(string2);
        this.m_GlVersion.setValue(string3);
    }

    public void setButtonErrorMotorControllerNotConnected() {
        this.setButtonErrorAndBeep("Motor controller not connected");
    }

    public void setParseErrorText(String string) {
        this.m_Main.m_StatusPanel.setParseErrorText(string);
    }

    public void setButtonErrorAndBeep(String string) {
        this.m_Main.m_StatusPanel.setButtonError(string);
        UWKit.beep();
    }

    public void setButtonErrorNoBeep(String string) {
        this.m_Main.m_StatusPanel.setButtonError(string);
    }

    public void setOperatorMessage(String string) {
        this.m_Main.m_StatusPanel.setOperatorMessage(string);
    }

    public void turnSimuAndMachOff() {
        this.m_SimuONVariable.setValue(null);
    }

    public void saveState() throws Exception {
        Main.m_ShortCutManager.storeShortcuts(this.m_Main.m_MachController.m_MachState);
        this.m_Main.m_MachController.saveState(Main.m_ConfigFile);
    }

    private void updateDRObackgroundColor(boolean bl) {
        MainWindow mainWindow = this;
        if (!mainWindow.m_Main.isAndroid()) {
            for (int i = 0; i < this.m_DRO.length; ++i) {
                JTextField jTextField = (JTextField)((Object)this.m_DRO[i]);
                if (bl) {
                    jTextField.setBackground(Color.RED);
                    continue;
                }
                jTextField.setBackground(Color.WHITE);
            }
        }
    }

    public void tryToZeroAxis(int n) {
        try {
            if (!this.m_Main.checkConnected()) {
                return;
            }
            MachiningState machiningState = this.m_Main.m_MachController.m_MachState.getMachiningState();
            if (machiningState != MachiningState.PAUSED && machiningState != MachiningState.STOPPED) {
                this.setButtonErrorAndBeep("ZERO available only when the system is in HOLD or STOP state");
                return;
            }
            if (n == 3 && this.m_Main.m_MachController.isPairXA()) {
                this.setButtonErrorAndBeep("ZERO A-axis not available because X and A are paired");
                return;
            }
            if (n >= 0 && !this.m_Main.m_MachController.m_MachState.isAxisEnabled(n)) {
                this.setButtonErrorAndBeep("This axis is not configured for use");
                return;
            }
            this.m_Main.m_MachController.syncMachStateWithMotorPositions();
            if (n >= 0) {
                this.m_Main.m_MachController.getMachState().setWorkOffsetFromLocal(n, 0.0);
            } else if (n == -1) {
                for (int i = 0; i < 6; ++i) {
                    if (!this.m_Main.m_MachController.m_MachState.isAxisEnabled(i)) continue;
                    this.m_Main.m_MachController.getMachState().setWorkOffsetFromLocal(i, 0.0);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Layout newDROPanels(boolean bl) {
        Widget widget;
        Widget widget2;
        Widget widget3;
        Interpreter cfr_ignored_0 = this.m_Main.m_Interpreter;
        int n = 6;
        final int[] nArray = new int[]{0, 1, 2, 3, 4, 5};
        final int n2 = nArray.length;
        this.m_OldMotorPos = new double[n];
        this.m_MotorPosChanged = new boolean[n];
        this.m_DROvariables = new NumericVariable[n2];
        this.m_HomeButtons = new Button[n2];
        this.m_HomeButtonStates = new MotorController.MotorState[n2];
        this.m_DRO = new TextField[n2];
        this.m_DroPanels = new Layout[n2];
        for (int i = 0; i < n2; ++i) {
            widget3 = UWKit.newLayout(true, "flowx,insets 0,gap  0!");
            this.m_DroPanels[i] = widget3;
            if (i == 3) {
                this.m_DroPanel_A = widget3;
            }
            widget2 = UWKit.newButton("push", "HOME");
            final int n3 = nArray[i];
            this.m_HomeButtons[n3] = widget2;
            widget2.addActionListener(new ButtonAction((Button)widget2, n3){
                final /* synthetic */ Button val$home;
                final /* synthetic */ int val$axis;
                {
                    this.val$home = button;
                    this.val$axis = n;
                }

                @Override
                public void onActionDo() {
                    MainWindow.this.doHomeAction(this.val$home, this.val$axis);
                }
            });
            widget = UWKit.newButton("push", "ZERO");
            this.m_ZeroButtons.add(widget);
            widget.addActionListener(new ActionListener(){

                @Override
                public void onAction() {
                    MainWindow.this.tryToZeroAxis(n3);
                }
            });
            MainWindow mainWindow = this;
            int n4 = mainWindow.m_Main.compactUI() ? 32 : 40;
            MainWindow mainWindow2 = this;
            int n5 = mainWindow2.m_Main.compactUI() ? 7 : 8;
            MainWindow mainWindow3 = this;
            int n6 = mainWindow3.m_Main.compactUI() ? 36 : 40;
            TextField textField = UWKit.newTextField(new SimpleVariable(Interpreter.getAxisLetter(n3)), n4, 1);
            textField.setEditable(false);
            this.m_DROvariables[i] = new NumericVariable(0);
            this.m_DROvariables[i].setValidator(new Validator(){
                boolean firstTime = true;

                @Override
                public void validate(Object object) {
                    if (this.firstTime) {
                        this.firstTime = false;
                        return;
                    }
                    ConnectionState connectionState = MainWindow.this.m_Main.m_MachController.getConnectionState();
                    if (!MainWindow.this.m_DRObeingUpdated && !MainWindow.this.m_Main.m_MachController.isConnected()) {
                        throw new InvalidValueException("Motor controller not connected");
                    }
                    MachiningState machiningState = MainWindow.this.m_Main.m_MachController.m_MachState.getMachiningState();
                    if (!MainWindow.this.m_DRObeingUpdated && machiningState != MachiningState.PAUSED && machiningState != MachiningState.STOPPED) {
                        throw new InvalidValueException("DROs can only be set when the  system is in HOLD or STOP state");
                    }
                }
            });
            Format format = new Format(){
                DecimalFormat m_DroFormatter = null;
                {
                    MainWindow.this.m_Main.m_MachController.m_MachState.getDroFormatVariable().addObserver(observable -> {
                        this.m_DroFormatter = new DecimalFormat(((SimpleVariable)observable).getValue().toString());
                        this.m_DroFormatter.setRoundingMode(RoundingMode.HALF_UP);
                        MainWindow.this.m_DROvariables[n3].fireChangeEvent();
                    });
                    MainWindow.this.m_Main.m_MachController.m_MachState.getVariable(-2147483645, n3).addObserver(observable -> MainWindow.this.m_DROvariables[n3].fireChangeEvent());
                }

                @Override
                public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    if (!MainWindow.this.m_Main.m_MachController.getMachState().isAxisEnabled(n3)) {
                        return new StringBuffer();
                    }
                    ConnectionState connectionState = MainWindow.this.m_Main.m_MachController.getConnectionState();
                    if (!MainWindow.this.m_Main.m_MachController.isConnected()) {
                        String string = MainWindow.this.m_Main.m_MachController.getMachState().getParamString(15300);
                        string = string.replace("0", "-");
                        return new StringBuffer(string);
                    }
                    return this.m_DroFormatter.format(object, stringBuffer, fieldPosition);
                }

                @Override
                public Object parseObject(String string, ParsePosition parsePosition) {
                    return this.m_DroFormatter.parseObject(string, parsePosition);
                }
            };
            TextField textField2 = UWKit.newTextField((Variable)this.m_DROvariables[i], (double)n4, n5, format, null);
            this.m_DRO[i] = textField2;
            widget3.add(widget2, "gap 0,growy");
            widget3.add(textField, "gap 0,width " + n6 + "!");
            widget3.add(textField2, "gap 0");
            widget3.add(widget, "gap 0,growy");
            this.m_DROvariables[i].addObserver(new VariableObserver(){
                boolean firstTime = true;

                @Override
                public void valueChanged(Variable variable) {
                    if (!MainWindow.this.m_DRObeingUpdated) {
                        if (!this.firstTime) {
                            MainWindow.this.m_Main.m_MachController.syncMachStateWithMotorPositions();
                            MainWindow.this.m_Main.m_MachController.getMachState().setWorkOffsetFromLocal(n3, ((Number)variable.getValue()).doubleValue());
                        }
                        this.firstTime = false;
                    }
                }
            });
        }
        Layout layout = UWKit.newTitledLayout("Position Display", "flowy,fillx,gap 0,hidemode 3");
        widget3 = UWKit.newCardLayout();
        widget2 = UWKit.newLayout("flowy");
        Layout layout2 = UWKit.newLayout("flowy");
        widget3.addCard("XYZ", widget2);
        widget3.addCard("ABC", layout2);
        layout.add(widget3, new String[0]);
        this.m_Main.m_MachController.getMachState().getVariable(15167).addObserver(arg_0 -> this.lambda$newDROPanels$0((CardLayout)widget3, arg_0));
        widget2.add(this.m_DroPanels[0], new String[0]);
        widget2.add(this.m_DroPanels[1], new String[0]);
        widget2.add(this.m_DroPanels[2], new String[0]);
        layout2.add(this.m_DroPanels[3], new String[0]);
        layout2.add(this.m_DroPanels[4], new String[0]);
        layout2.add(this.m_DroPanels[5], new String[0]);
        widget = UWKit.newLayout("fill,insets 0,gap 0!");
        layout.add(widget, "push, grow,center");
        widget.add(UserButtons.createButton(0), new String[0]);
        widget.add(UserButtons.createButton(1), new String[0]);
        widget.add(UserButtons.createButton(2), new String[0]);
        widget.add(UserButtons.createButton(3), new String[0]);
        widget.add(UserButtons.createButton(4), new String[0]);
        final Object object = new Object();
        ChangeListener changeListener = new ChangeListener(){
            double[] m_Prev_lpos;
            boolean m_Prev_connected;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(Object object2) {
                boolean bl = MainWindow.this.m_Main.m_MachController.isConnected();
                if (!bl) {
                    return;
                }
                int n = MainWindow.this.m_Main.m_MachController.getNumberOfMotors();
                double[] dArray = new double[n];
                double[] dArray2 = new double[n];
                if (this.m_Prev_lpos == null) {
                    this.m_Prev_lpos = new double[n];
                }
                dArray2 = MainWindow.this.m_Main.m_MachController.axisPositionFromMotorPosition(MainWindow.this.m_Main.m_MachController.getMotorPosition());
                dArray = MainWindow.this.m_Main.m_MachController.getMachState().axisToLocal(dArray2);
                boolean bl2 = false;
                if (bl != this.m_Prev_connected) {
                    this.m_Prev_connected = bl;
                    bl2 = true;
                } else if (object2 == object) {
                    bl2 = true;
                } else if (!bl2) {
                    for (int i = 0; i < n; ++i) {
                        if (dArray[i] == this.m_Prev_lpos[i]) continue;
                        this.m_Prev_lpos[i] = dArray[i];
                        bl2 = true;
                    }
                }
                if (bl2) {
                    double d = MainWindow.this.m_Main.m_MachController.getMachState().getParamDouble(15141);
                    for (int i = 0; i < n2; ++i) {
                        int n22 = nArray[i];
                        MainWindow.this.m_DRObeingUpdated = true;
                        try {
                            if (i >= dArray.length) continue;
                            MainWindow.this.m_DROvariables[i].setValue(dArray[n22] / d);
                            continue;
                        }
                        finally {
                            MainWindow.this.m_DRObeingUpdated = false;
                        }
                    }
                }
            }
        };
        this.m_Main.addChangeListener(changeListener);
        this.m_Main.m_MachController.getMachState().getVariable(15141).addObserver(observable -> changeListener.stateChanged(object));
        return layout;
    }

    private Button newJogButton(String string, String string2, int n, boolean bl, final UserActions.Action action) {
        Button button = UWKit.newButton("button_" + string, string2);
        button.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
            }
        });
        if (n < 0) {
            throw new IllegalArgumentException("Emergency button not implemented");
        }
        button.addButtonListener(new Button.ButtonListener(){

            @Override
            public void buttonPressed(Button button) {
                if (MainWindow.this.m_Main.m_MachController.getMachState().getParamInt(15168) == 7) {
                    MainWindow.this.setButtonErrorAndBeep("In MANUAL mode use the handwheels to 'jog' the axis");
                    return;
                }
                action.callOnPressed(button);
            }

            @Override
            public void buttonReleased(Button button) {
                if (MainWindow.this.m_Main.m_MachController.getMachState().getParamInt(15168) == 7) {
                    return;
                }
                action.callOnReleased(button);
            }
        });
        return button;
    }

    private Layout newJogPanel(final MachState machState, Widget widget) {
        Object object;
        Button button;
        Object object2;
        Layout layout;
        final CardLayout cardLayout = UWKit.newCardLayout();
        Layout layout2 = UWKit.newLayout();
        NumericVariable numericVariable = this.m_Main.m_MachController.getMachState().getNumericVariable(15168);
        final SimpleVariable simpleVariable = new SimpleVariable(false);
        SimpleVariable simpleVariable2 = new SimpleVariable("x1000");
        numericVariable.addObserver(observable -> {
            String string = "";
            switch (numericVariable.intValue()) {
                case 0: {
                    string = "FAST";
                    break;
                }
                case 1: {
                    string = "SLOW";
                    break;
                }
                case 2: {
                    string = "x1000";
                    break;
                }
                case 3: {
                    string = "x100";
                    break;
                }
                case 4: {
                    string = "x10";
                    break;
                }
                case 5: {
                    string = "x1";
                    break;
                }
                case 6: {
                    string = "x0";
                    break;
                }
                case 7: {
                    string = "MANUAL";
                }
            }
            simpleVariable2.setValue(string);
        });
        if (Main.m_UIsize == 2) {
            layout = UWKit.newLayout();
            layout.add(UWKit.newLabel("Mode:"), "wrap,center");
            layout.add(UWKit.newLabel(simpleVariable2), "wrap,center");
            object2 = UWKit.newButton("push", "MODE++");
            layout.add((Widget)object2, "wrap");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "MANUAL", (Object)7), "wrap");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)simpleVariable, "SPECIAL", (Object)true, (Object)false), "wrap");
            button = UWKit.newButton("button_green", "SAFE Z");
            layout.add(button, "wrap");
            object2.addActionListener(() -> {
                int n = numericVariable.intValue();
                ++n;
                if (this.m_Main.m_MachController.getMachState().getParamDouble(15141) == 1.0) {
                    if (n == 5) {
                        n = 6;
                    }
                } else if (n == 2) {
                    n = 3;
                }
                if (n >= 7) {
                    n = 0;
                }
                numericVariable.setValue(n);
            });
        } else {
            layout = UWKit.newLayout("flowy");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "SLOW", (Object)1), "");
            object2 = UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "x1000", (Object)2);
            layout.add((Widget)object2, "hidemode 3");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "x100", (Object)3), "");
            object = UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "x10", (Object)5);
            layout.add((Widget)object, "hidemode 3");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "x0", (Object)6), "wrap");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "FAST", (Object)0), "");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)simpleVariable, "SPECIAL", (Object)true, (Object)false), "");
            layout.add(UWKit.newToggleButton("button_white_low", (Variable)numericVariable, "MANUAL", (Object)7), "");
            button = UWKit.newButton("button_green_low", "SAFE Z");
            layout.add(button, "");
            machState.getVariable(15141).addObserver(new VariableObserver((ToggleButton)object2, (ToggleButton)object){
                final /* synthetic */ ToggleButton val$x1000;
                final /* synthetic */ ToggleButton val$x10;
                {
                    this.val$x1000 = toggleButton;
                    this.val$x10 = toggleButton2;
                }

                @Override
                public void valueChanged(Variable variable) {
                    boolean bl = machState.getParamDouble(15141) == 1.0;
                    this.val$x1000.setVisible(bl);
                    this.val$x10.setVisible(!bl);
                }
            });
        }
        button.addActionListener(() -> Main.m_MainWindow.gotoSafeZ());
        simpleVariable.addObserver(new Observer(){

            @Override
            public void valueChanged(Observable observable) {
                if (simpleVariable.getValue().equals(true)) {
                    cardLayout.selectCard("special-jogs");
                } else {
                    cardLayout.selectCard("normal-jogs");
                }
            }
        });
        object2 = "";
        object = this.m_Main.m_Actions;
        this.m_JogButtonAPlus = this.newJogButton("up", "+A", 3, true, ((UserActions)object).m_Action_JOG_A_PLUS);
        layout2.add(this.m_JogButtonAPlus, new String[]{object2});
        this.m_JogButtonYPlus = this.newJogButton("up", "+Y", 1, true, ((UserActions)object).m_Action_JOG_Y_PLUS);
        layout2.add(this.m_JogButtonYPlus, new String[]{object2});
        this.m_JogButtonZPlus = this.newJogButton("up", "+Z", 2, true, ((UserActions)object).m_Action_JOG_Z_PLUS);
        layout2.add(this.m_JogButtonZPlus, (String)object2 + ",wrap");
        this.m_JogButtonXMinus = this.newJogButton("left", "-X", 0, false, ((UserActions)object).m_Action_JOG_X_MINUS);
        layout2.add(this.m_JogButtonXMinus, new String[]{object2});
        layout2.add(UWKit.newToggleButton("button_xyz", (Variable)this.m_Main.m_MachController.getMachState().getVariable(15167), "", (Object)1, (Object)2), new String[]{object2});
        this.m_JogButtonXPlus = this.newJogButton("right", "+X", 0, true, ((UserActions)object).m_Action_JOG_X_PLUS);
        layout2.add(this.m_JogButtonXPlus, (String)object2 + ",wrap");
        this.m_JogButtonAMinus = this.newJogButton("down", "-A", 3, false, ((UserActions)object).m_Action_JOG_A_MINUS);
        layout2.add(this.m_JogButtonAMinus, new String[]{object2});
        this.m_JogButtonYMinus = this.newJogButton("down", "-Y", 1, false, ((UserActions)object).m_Action_JOG_Y_MINUS);
        layout2.add(this.m_JogButtonYMinus, new String[]{object2});
        this.m_JogButtonZMinus = this.newJogButton("down", "-Z", 2, false, ((UserActions)object).m_Action_JOG_Z_MINUS);
        layout2.add(this.m_JogButtonZMinus, (String)object2 + ",wrap");
        Layout layout3 = UWKit.newTitledLayout("Jog", "flowx,fill");
        layout3.add(cardLayout, "grow");
        layout3.add(layout, new String[0]);
        cardLayout.addCard("normal-jogs", layout2);
        cardLayout.addCard("special-jogs", widget);
        return layout3;
    }

    private Layout newUserFuncPanel() {
        Layout layout = UWKit.newTitledLayout("User Defined", "flowx,fill");
        this.m_FuncButton = new Button[8];
        for (int i = 0; i < this.m_FuncButton.length; ++i) {
            final int n = i + 1;
            this.m_FuncButton[i] = UWKit.newButton("push", "F" + n);
            layout.add(this.m_FuncButton[i], "center," + (i % 2 == 1 ? "wrap" : ""));
            this.m_FuncButton[i].addButtonListener(new Button.ButtonListener(){
                boolean cancel;

                @Override
                public void buttonPressed(Button button) {
                    this.cancel = false;
                    UWKit.scheduleInEDT(1000, 0, new Runnable(){

                        @Override
                        public void run() {
                            if (!cancel) {
                                String string = MainWindow.this.m_Main.m_MachController.getMachState().getParamString(15301);
                                UWKit.showFileDialog(string, false, new FileDialogCallback(){

                                    @Override
                                    public void onFileSelected(String string) {
                                        if (string != null) {
                                            String string2 = new File(string).getParentFile().getPath();
                                            MainWindow.this.m_Main.m_MachController.getMachState().setParam(15310 + n - 1, string);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }

                @Override
                public void buttonReleased(Button button) {
                    this.cancel = true;
                }
            });
            this.m_FuncButton[i].addActionListener(new ActionListener(){

                @Override
                public void onAction() {
                    String string = MainWindow.this.m_Main.m_MachController.getMachState().getParamString(15310 + n - 1);
                    if (string == null || string.isEmpty()) {
                        MainWindow.this.setButtonErrorAndBeep("User function F" + n + " not set, press long to set");
                    } else {
                        File file = new File(string);
                        if (!file.exists()) {
                            MainWindow.this.setButtonErrorAndBeep("File '" + string + "' not found");
                        } else {
                            MainWindow.this.execute(file, null);
                        }
                    }
                }
            });
        }
        layout.add(UWKit.newLayout(), "grow");
        return layout;
    }

    private byte[] readFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = 0;
        int n2 = (int)file.length();
        byte[] byArray = new byte[n2];
        while ((n += fileInputStream.read(byArray, n, n2 - n)) < n2) {
        }
        fileInputStream.close();
        return byArray;
    }

    public void execute(String string, final MachController.CompletionCallback completionCallback) {
        try {
            LinkedHashMap<String, byte[]> linkedHashMap = new LinkedHashMap<String, byte[]>();
            File file = new File("anonymous");
            linkedHashMap.put(file.getCanonicalPath(), string.getBytes());
            this.m_Main.m_Compiler.compile(null, linkedHashMap, new BackgroundCompiler.CompileCompleted(){

                @Override
                public void compileError(List<File> list, Parser.ParseException parseException) {
                    String string = parseException.getError() + " in file '" + parseException.getFilePos().getFileName() + "' on line " + parseException.getFilePos().getLineNo();
                    System.out.println(string);
                    MainWindow.this.setButtonErrorAndBeep(string);
                }

                @Override
                public void compileCompleted(List<File> list, Machcode machcode) {
                    try {
                        MainWindow.this.m_MacroRunning = true;
                        MainWindow.this.m_Main.m_MachController.push();
                        MainWindow.this.m_Main.m_MachController.load(machcode, false);
                        MainWindow.this.m_Main.m_MachController.setCompiling(false);
                        MainWindow.this.m_Main.m_MachController.startCycle(completionCallback);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exception) {
            this.setButtonErrorAndBeep("Unexpected exception " + exception);
            exception.printStackTrace();
        }
    }

    public void execute(final File file, final MachController.CompletionCallback completionCallback) {
        try {
            LinkedHashMap<String, byte[]> linkedHashMap = new LinkedHashMap<String, byte[]>();
            linkedHashMap.put(file.getCanonicalPath(), this.readFile(file));
            this.m_Main.m_Compiler.compile(file, linkedHashMap, new BackgroundCompiler.CompileCompleted(){

                @Override
                public void compileError(List<File> list, Parser.ParseException parseException) {
                    String string = parseException.getError() + " in file '" + parseException.getFilePos().getFileName() + "' on line " + parseException.getFilePos().getLineNo();
                    System.out.println(string);
                    MainWindow.this.setButtonErrorAndBeep(string);
                }

                @Override
                public void compileCompleted(List<File> list, Machcode machcode) {
                    System.out.println("Compiled");
                    String string = "Executing file '" + file.getName() + "'";
                    MainWindow.this.m_Main.m_StatusPanel.setMacroMessage(string);
                    MainWindow.this.m_MacroRunning = true;
                    MainWindow.this.m_Main.m_MachController.push();
                    MainWindow.this.m_Main.m_MachController.load(machcode, false);
                    MainWindow.this.m_Main.m_MachController.startCycle(completionCallback);
                }
            });
        }
        catch (Exception exception) {
            this.setButtonErrorAndBeep("Unexpected exception " + exception);
            exception.printStackTrace();
        }
    }

    private Layout newSpindlePanel() {
        final MachState machState = this.m_Main.m_MachController.getMachState();
        Multiplexer multiplexer = new Multiplexer((Variable)machState.getVariable(15162), new Variable[]{machState.getVariable(15161), machState.getVariable(15127)}){

            @Override
            public Variable getVariable(Variable variable) {
                return new NumericVariable(machState.getParamDouble(15127)){

                    @Override
                    public Object getValue() {
                        if (machState.getParamBoolean(15162)) {
                            return machState.getParamDouble(15161);
                        }
                        return machState.getParamDouble(15127);
                    }

                    @Override
                    public void setValue(Object object) {
                        this.validate(object);
                        machState.setParam(15161, object);
                        machState.setParam(15162, true);
                        super.setValue(object);
                    }

                    @Override
                    public Number getMinValue() {
                        return machState.getParamDouble(15156);
                    }

                    @Override
                    public Number getMaxValue() {
                        return machState.getParamDouble(15157);
                    }
                };
            }
        };
        Layout layout = UWKit.newTitledLayout("Spindle / Override", "flowx");
        SimpleVariable simpleVariable = machState.getVariable(15162);
        SimpleVariable simpleVariable2 = machState.getVariable(15128);
        TextField textField = UWKit.newTextField((Variable)multiplexer, 32.0, 5, new SimpleVariable("0"), null);
        layout.add(UWKit.newToggleButton("button_spindle", (Variable)simpleVariable2, "", (Object)2, (Object)1), "align center,cell 1 1,span 3");
        layout.add(textField, "cell 1 1,right,aligny center");
        layout.add(UWKit.newLabel("rpm"), "cell 1 1");
        Button button = UWKit.newButton("push", "-");
        layout.add(button, "cell 1 2");
        this.m_SpindleOverrideButton = UWKit.newToggleButton("button_yellow", (Variable)simpleVariable, "OVERRIDE", (Object)true, (Object)false);
        layout.add(this.m_SpindleOverrideButton, "cell 2 2");
        Button button2 = UWKit.newButton("push", "+");
        layout.add(button2, "cell 3 2");
        button2.addActionListener(this.m_Main.m_Actions.m_Action_SPINDLE_PLUS);
        button.addActionListener(this.m_Main.m_Actions.m_Action_SPINDLE_MINUS);
        return layout;
    }

    private Layout newFeedOverridePanel() {
        final MachState machState = this.m_Main.m_MachController.getMachState();
        Multiplexer multiplexer = new Multiplexer((Variable)machState.getVariable(15131), new Variable[]{machState.getVariable(15132)}){

            @Override
            public Variable getVariable(Variable variable) {
                return new NumericVariable(0.0){

                    @Override
                    public Object getValue() {
                        if (machState.getParamBoolean(15131)) {
                            return machState.getParamDouble(15132);
                        }
                        return 1.0;
                    }

                    @Override
                    public void setValue(Object object) {
                        this.validate(object);
                        machState.setParam(15132, object);
                        machState.setParam(15131, true);
                        super.setValue(object);
                    }
                };
            }
        };
        Multiplexer multiplexer2 = new Multiplexer((Variable)machState.getVariable(15163), new Variable[]{machState.getVariable(15141), machState.getVariable(15145)}){

            @Override
            public Variable getVariable(Variable variable) {
                return new NumericVariable(0.0){

                    @Override
                    public Object getValue() {
                        if (machState.getParamBoolean(15163)) {
                            return machState.getParamDouble(15145) / machState.getParamDouble(15141);
                        }
                        return 100;
                    }

                    @Override
                    public void setValue(Object object) {
                        throw new IllegalArgumentException("SHOULD NEVER GET HERE");
                    }
                };
            }
        };
        Layout layout = UWKit.newTitledLayout("Feed / Override", "flowx,ins 0");
        TextField textField = UWKit.newTextField((Variable)UWKit.multiply((Variable)multiplexer, multiplexer2), 32.0, 5, new SimpleVariable("0"), null);
        boolean bl = machState.getParamDouble(15141) == 1.0;
        final ToggleButton toggleButton = UWKit.newToggleButton("feedratemm", (Variable)machState.getVariable(15163), "", (Object)true, (Object)false);
        toggleButton.setVisible(bl);
        final ToggleButton toggleButton2 = UWKit.newToggleButton("feedrateinch", (Variable)machState.getVariable(15163), "", (Object)true, (Object)false);
        toggleButton2.setVisible(!bl);
        machState.getVariable(15141).addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                boolean bl = machState.getParamDouble(15141) == 1.0;
                toggleButton.setVisible(bl);
                toggleButton2.setVisible(!bl);
            }
        });
        layout.add(textField, "cell 1 1,span 3,split 2,center,aligny center");
        layout.add(toggleButton, "cell 1 1,span 3,split 2,center,aligny center,hidemode 3");
        layout.add(toggleButton2, "cell 1 1,span 3,split 2,center,aligny center,hidemode 3");
        Button button = UWKit.newButton("push", "-");
        layout.add(button, "cell 1 2");
        this.m_FeedOverrideButton = UWKit.newToggleButton("button_yellow", (Variable)machState.getVariable(15131), "OVERRIDE", (Object)true, (Object)false);
        layout.add(this.m_FeedOverrideButton, "cell 2 2");
        Button button2 = UWKit.newButton("push", "+");
        layout.add(button2, "cell 3 2");
        button2.addActionListener(this.m_Main.m_Actions.m_Action_OVERRIDE_PLUS);
        button.addActionListener(this.m_Main.m_Actions.m_Action_OVERRIDE_MINUS);
        return layout;
    }

    public MainWindow(Main main) {
        this(main, null);
    }

    public MainWindow(Main main, Object object) {
        boolean bl = Main.m_UIsize == 2;
        Locale.setDefault(Locale.ENGLISH);
        this.m_Main = main;
        Main.m_MainWindow = this;
        UWKit.setErrorHandler(new ErrorHandler(){

            @Override
            public void handleException(Exception exception, Variable variable, Object object) {
                MainWindow.this.setButtonErrorAndBeep(exception.getMessage());
            }
        });
        try {
            Layout layout;
            this.m_Main.m_GCodeEditor = new GCodeEditorPanel(this.m_Main, this.m_Main.m_StatusPanel.getLayout());
            this.m_SpindleSpeed = (NumericVariable)this.m_Main.m_MachController.getMachState().getVariable(15127);
            this.m_SpindleSpeedOverride = (NumericVariable)this.m_Main.m_MachController.getMachState().getVariable(15161);
            this.m_FeedOverrideON = this.m_Main.m_MachController.getMachState().getVariable(15131);
            this.m_FeedOverride = (NumericVariable)this.m_Main.m_MachController.getMachState().getVariable(15132);
            this.m_FeedRate = (NumericVariable)this.m_Main.m_MachController.getMachState().getVariable(15145);
            Layout layout2 = this.m_Main.m_ToolpathDisplayPanel.createDisplayPanel(main);
            Layout layout3 = this.m_Main.m_GCodeEditor.getLayout();
            this.m_Main.m_Split = UWKit.newSplitLayout(layout2, layout3);
            int n = this.m_Main.m_MachController.m_MachState.getParamInt(15215);
            if (n != 0) {
                this.m_Main.m_Split.setSplit(n);
            }
            SimpleVariable simpleVariable = new SimpleVariable("g-code-view");
            Main.m_ScreenCap.push(simpleVariable);
            Main.m_ScreenCap.addValue("g-code-view");
            Widget widget = this.m_Main.m_PluginMethods.onCreateMachView();
            if (widget == null) {
                widget = main.m_Split;
            }
            Main.m_ScreenCap.addValue("coordinates-view");
            Layout layout4 = this.m_Main.m_PluginMethods.onCreateCoordinatesView();
            if (layout4 == null) {
                layout4 = CoordinatesPanel.newOffsetsPanel(this.m_Main, this.m_Main.m_MachController.getMachState());
            }
            Main.m_ScreenCap.addValue("work-offsets-view");
            Layout layout5 = this.m_Main.m_PluginMethods.onCreateWorkOffsetsView();
            if (layout5 == null) {
                layout5 = WorkOffsetPanel.newWorkOffsetPanel(this.m_Main, this.m_Main.m_MachController.getMachState());
            }
            Main.m_ScreenCap.addValue("tool-setup-view");
            Layout layout6 = this.m_Main.m_PluginMethods.onCreateToolSetupView();
            if (layout6 == null) {
                layout6 = ToolSetupPanel.newToolOffsetPanel(this.m_Main, this.m_Main.m_MachController.getMachState());
            }
            Main.m_ScreenCap.addValue("axis-setup-view");
            Layout layout7 = this.m_Main.m_PluginMethods.onCreateAxisSetupView();
            if (layout7 == null) {
                layout7 = AxisSetupPanel.newAxisSetupPenel(this.m_Main);
            }
            Main.m_ScreenCap.addValue("mach-setup-view");
            Layout layout8 = this.m_Main.m_PluginMethods.onCreateMachSetupView();
            if (layout8 == null) {
                layout8 = MachineSetupPanel.newMachineSetupPanel(this.m_Main);
            }
            Main.m_ScreenCap.pop();
            final CardLayout cardLayout = UWKit.newCardLayout();
            cardLayout.addCard("g-code-view", widget);
            cardLayout.addCard("coordinates-view", layout4);
            cardLayout.addCard("work-offsets-view", layout5);
            cardLayout.addCard("tool-setup-view", layout6);
            cardLayout.addCard("axis-setup-view", layout7);
            cardLayout.addCard("mach-setup-view", layout8);
            Layout layout9 = main.m_PluginMethods.onCreateViewButtons(simpleVariable, cardLayout);
            if (layout9 == null) {
                layout9 = UWKit.newTitledLayout("View", "flowy,fillx");
                layout9.add(UWKit.newToggleButton((Variable)simpleVariable, "G-Code", (Object)"g-code-view"), "grow");
                layout9.add(UWKit.newToggleButton((Variable)simpleVariable, "Coordinates", (Object)"coordinates-view"), "growx");
                layout9.add(UWKit.newToggleButton((Variable)simpleVariable, "Work Offsets", (Object)"work-offsets-view"), "growx");
                layout9.add(UWKit.newToggleButton((Variable)simpleVariable, "Tool Setup", (Object)"tool-setup-view"), "growx");
                layout9.add(UWKit.newToggleButton((Variable)simpleVariable, "Axis Setup", (Object)"axis-setup-view"), "growx");
                layout9.add(UWKit.newToggleButton((Variable)simpleVariable, "Mach Setup", (Object)"mach-setup-view"), "growx");
            }
            main.m_PluginMethods.onAddViewButtons(layout9, simpleVariable, cardLayout);
            Layout layout10 = UWKit.newLayout("fill");
            layout10.add(cardLayout, "push,grow,bottom");
            layout10.add(layout9, "west");
            simpleVariable.addObserver(new VariableObserver(){

                @Override
                public void valueChanged(Variable variable) {
                    cardLayout.selectCard(variable.getValue().toString());
                }
            });
            Layout layout11 = UWKit.newLayout("nogrid,fillx");
            Layout layout12 = this.m_Main.m_PluginMethods.onCreateDROPanel();
            Layout layout13 = this.m_Main.m_PluginMethods.onCreateJogPanel();
            Layout layout14 = this.m_Main.m_PluginMethods.onCreateUserFuncPanel();
            Layout layout15 = this.m_Main.m_PluginMethods.onCreateSpindlePanel();
            Layout layout16 = this.m_Main.m_PluginMethods.onCreateFeedPanel();
            if (layout12 == null) {
                layout12 = this.newDROPanels(bl);
            }
            if (layout14 == null) {
                layout14 = this.newUserFuncPanel();
            }
            if (layout13 == null) {
                layout13 = this.newJogPanel(main.m_MachController.getMachState(), layout14);
            }
            if (layout15 == null) {
                layout15 = this.newSpindlePanel();
            }
            if (layout16 == null) {
                layout16 = this.newFeedOverridePanel();
            }
            Layout layout17 = UWKit.newLayout("flowy,filly,gap 0");
            layout17.add(layout15, new String[0]);
            layout17.add(layout16, new String[0]);
            CardLayout cardLayout2 = UWKit.newCardLayout();
            String string = "jogcard";
            cardLayout2.addCard(string, layout13);
            layout11.add(layout12, "center");
            layout11.add(UWKit.newLayout(), "gap 1 push");
            layout11.add(cardLayout2, "center");
            layout11.add(UWKit.newLayout(), "gap 1 push");
            layout11.add(layout17, "center");
            this.m_SimuONVariable = new SimpleVariable(null);
            this.m_SimuONVariable.addObserver(new VariableObserver(){

                @Override
                public void valueChanged(Variable variable) {
                    Object object = variable.getValue();
                    MainWindow.this.m_Main.m_MachController.getMachState().setParam(15126, false);
                    if (object == null) {
                        MainWindow.this.m_Main.requestConnectionStatus(ConnectionState.SHUTDOWN);
                    }
                    if (object == MainWindow.this.SIMU) {
                        MainWindow.this.m_Main.requestConnectionStatus(ConnectionState.SIMULATION);
                    }
                    if (object == MainWindow.this.MACH) {
                        MainWindow.this.m_Main.requestConnectionStatus(ConnectionState.CONNECTED);
                    }
                }
            });
            Layout layout18 = this.m_Main.m_PluginMethods.onCreateMachControlButtons();
            SimpleVariable simpleVariable2 = new SimpleVariable("top");
            if (layout18 == null) {
                layout18 = UWKit.newLayout("nogrid,fill");
                if (bl) {
                    layout18.add(UWKit.newLayout(), "gap 1 push");
                    layout18.add(UWKit.newToggleButton("windowtoggle", (Variable)simpleVariable2, "", (Object)"bot", (Object)"top"), "");
                }
                layout18.add(UWKit.newLayout(), "gap 1 push");
                this.m_QuitButton = UWKit.newButton("off_button", "");
                layout18.add(this.m_QuitButton, "");
                layout18.add(UWKit.newLayout(), "gap 1 push");
                this.m_SaveButton = UWKit.newButton("push", "Save");
                layout18.add(this.m_SaveButton, "growy");
                layout18.add(UWKit.newLayout(), "gap 1 push");
                this.m_SimuButton = UWKit.newToggleButton("button_green", (Variable)this.m_SimuONVariable, "SIMU", this.SIMU, null);
                layout18.add(this.m_SimuButton, new String[0]);
                this.m_MachButton = UWKit.newToggleButton("button_green", (Variable)this.m_SimuONVariable, "MACH", this.MACH, null);
                layout18.add(this.m_MachButton, new String[0]);
                layout18.add(UWKit.newLayout(), "gap 1 push");
                this.m_CoolantButton = UWKit.newToggleButton("button_blue", (Variable)this.m_Main.m_MachController.getMachState().getVariable(15124), "COOLANT", (Object)true, (Object)false);
                layout18.add(this.m_CoolantButton, new String[0]);
                this.m_SpindleButton = UWKit.newToggleButton("button_blue", (Variable)this.m_Main.m_MachController.getMachState().getVariable(15126), "SPINDLE", (Object)true, (Object)false);
                layout18.add(this.m_SpindleButton, new String[0]);
                layout18.add(UWKit.newLayout(), "gap 1 push");
                this.m_StepButton = UWKit.newToggleButton("button_white", (Variable)new SimpleVariable(false), "STEP", (Object)true);
                layout18.add(this.m_StepButton, new String[0]);
                this.m_ReverseButton = UWKit.newToggleButton("button_white", (Variable)new SimpleVariable(false), "REVERSE", (Object)true);
                layout18.add(this.m_ReverseButton, new String[0]);
                layout18.add(UWKit.newLayout(), "gap 1 push");
                layout18.add(UWKit.newToggleButton("button_M1", (Variable)this.m_Main.m_MachController.getMachState().getVariable(15166), "", (Object)true, (Object)false), new String[0]);
                layout18.add(UWKit.newLayout(), "gap 1 push");
                this.m_RunButton = UWKit.newToggleButton("button_green", (Variable)new SimpleVariable(false), "RUN", (Object)true);
                layout18.add(this.m_RunButton, new String[0]);
                this.m_HoldButton = UWKit.newToggleButton("button_yellow", (Variable)new SimpleVariable(false), "HOLD", (Object)true);
                layout18.add(this.m_HoldButton, new String[0]);
                this.m_StopButton = UWKit.newToggleButton("button_red", (Variable)new SimpleVariable(false), "STOP", (Object)true);
                layout18.add(this.m_StopButton, new String[0]);
                layout18.add(UWKit.newLayout(), "gap 1 push");
            }
            if ((layout = this.m_Main.m_PluginMethods.onCreateMachControlsPanel()) == null) {
                layout = UWKit.newTitledLayout("Machining Control", "nogrid,fill");
                layout.add(this.m_Main.m_StatusPanel.getLayout(), "gapbottom 4,gaptop 4,growx,bottom");
                layout.add(layout18, "south");
            }
            this.m_RunButton.setSelected(false);
            this.m_HoldButton.setSelected(false);
            this.m_StopButton.setSelected(false);
            this.m_StepButton.setSelected(false);
            this.m_ReverseButton.setSelected(false);
            this.m_CoolantButton.setSelected(false);
            this.m_SpindleButton.setSelected(false);
            this.m_FeedOverrideButton.setSelected(false);
            CardLayout cardLayout3 = UWKit.newCardLayout();
            this.m_OnscreenKeyboard = new OnscreenKeyboard(cardLayout3);
            if (bl) {
                cardLayout3.addCard("top", layout10);
                cardLayout3.addCard("bot", layout11);
                cardLayout3.addCard("kbd", this.m_OnscreenKeyboard.getLayout());
                this.m_Layout = UWKit.newLayout("flowy,fill,nogrid,insets 0");
                this.m_Layout.add(cardLayout3, "grow");
                this.m_Layout.add(layout, "growx");
                simpleVariable2.addObserver(observable -> cardLayout3.selectCard(simpleVariable2.getValue().toString()));
            } else {
                Layout layout19 = UWKit.newLayout("flowy,fill,nogrid,insets 0");
                layout19.add(layout11, "growx,gapy 0");
                layout19.add(layout, "growx,gapy 0");
                cardLayout3.addCard("bot", layout19);
                cardLayout3.addCard("kbd", this.m_OnscreenKeyboard.getLayout());
                this.m_Layout = UWKit.newLayout("flowy,fill,nogrid,insets 0");
                this.m_Layout.add(layout10, "grow,gapy 0");
                this.m_Layout.add(cardLayout3, "center");
            }
            this.setUpActions();
            ParameterValidators.initValidators(this.m_Main.m_MachController);
            this.m_Main.m_MachController.getMachState().getVariable(15297).addObserver(observable -> {
                double d = this.m_Main.m_MachController.getMachState().getParamDouble(15297);
                AnimationScheduler.setAnimationFPS(d);
            });
            this.m_Main.m_MachController.getMachState().setRecompileCallback(() -> this.m_Main.m_GCodeEditor.retrigCompile());
            UWKit.setTextFieldCallback(textField -> {
                if (this.m_Main.m_MachController.getMachState().getParamBoolean(15222)) {
                    if (textField == Main.m_Main.m_StatusPanel.m_TextField) {
                        textField.setFieldText("");
                    }
                    this.m_OnscreenKeyboard.activateKeyabord(textField);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Layout getLayout() {
        return this.m_Layout;
    }

    private void doHomeAction(Button button, int ... nArray) {
        HomeButtonLogic.doHomeAction(button, nArray);
    }

    private void setUpActions() {
        this.m_Main.addChangeListener(new ChangeListener(){
            boolean wasRunning = false;
            boolean isRunning = false;
            double[] m_Progress = new double[6];
            double spindleSpeed = -1.0;
            double feedRate = -1.0;

            @Override
            public void stateChanged(Object object) {
                int n;
                Object object2 = MainWindow.this.m_Main.m_MachController.getError();
                if (object2 != null) {
                    FilePos filePos = MainWindow.this.m_Main.m_MachController.getErrorFilePos();
                    if (filePos != null) {
                        object2 = (String)object2 + ", on " + filePos;
                        MainWindow.this.m_Main.m_GCodeEditor.setError(filePos);
                    }
                    Main cfr_ignored_0 = MainWindow.this.m_Main;
                    Main.m_MainWindow.setButtonErrorAndBeep((String)object2);
                }
                MainWindow.this.m_Main.m_StatusPanel.update();
                while ((n = MainWindow.this.m_Main.m_MachController.m_ProgressQueue.get(this.m_Progress)) >= 0) {
                    int n2;
                    double d = Math.abs(MainWindow.this.m_Main.m_ActualMachState.getParamDouble(15136));
                    if (d == 0.0 && (n2 = MainWindow.this.m_Main.m_ActualMachState.getParamInt(15147)) > 0 && n2 <= 255) {
                        d = MainWindow.this.m_Main.m_ActualMachState.getParamDouble(0x40000000, n2 - 1) / 2.0;
                    }
                    n2 = MainWindow.this.m_Main.m_ActualMachState.getParamDouble(15340) == 0.0 ? 1 : 0;
                    MainWindow.this.m_Main.m_ToolpathDisplayPanel.updatePath(n2 != 0, n > 0, d, this.m_Progress);
                }
                if (!MainWindow.this.m_Main.m_Compiler.isCompiling()) {
                    MainWindow.this.m_Main.m_GCodeEditor.setCurrentMachCode(MainWindow.this.m_Main.m_MachController.getCurrentMachCodeFilePos());
                }
                MachiningState machiningState = MainWindow.this.m_Main.m_MachController.getMachiningState();
                MainWindow.this.m_Main.m_GCodeEditor.setEnabled(machiningState);
                if (machiningState != MachiningState.START_LOADING && machiningState != MachiningState.LOADING) {
                    if (!MachiningState.isRunState(machiningState) && MainWindow.this.m_MacroRunning) {
                        MainWindow.this.m_MacroRunning = false;
                        MainWindow.this.setButtonErrorAndBeep("Done.");
                    }
                    this.wasRunning = this.isRunning;
                    this.isRunning = MachiningState.isRunState(machiningState);
                    if (this.wasRunning && !this.isRunning) {
                        MachState machState = MainWindow.this.m_Main.m_MachController.getMachState();
                        if (machState.getParamBoolean(15126) && machState.getParamBoolean(15174)) {
                            machState.setParam(15126, false);
                        }
                        if (machState.getParamBoolean(15124) && machState.getParamBoolean(15175)) {
                            machState.setParam(15124, false);
                        }
                    }
                    MainWindow.this.m_RunButton.setSelected(MachiningState.isRunState(machiningState));
                    MainWindow.this.m_HoldButton.setSelected(MachiningState.isHoldState(machiningState));
                    MainWindow.this.m_StopButton.setSelected(MachiningState.isStopState(machiningState));
                    MainWindow.this.m_StepButton.setSelected(MainWindow.this.m_Main.m_MachController.getSingleStepMode());
                    MainWindow.this.m_ReverseButton.setSelected(MainWindow.this.m_Main.m_MachController.getRunReverse());
                    MainWindow.this.m_FeedOverrideButton.setSelected(MainWindow.this.m_Main.m_ActualMachState.getParamBoolean(15131));
                    MainWindow.this.m_SpindleButton.setSelected(MainWindow.this.m_Main.m_ActualMachState.getParamBoolean(15126));
                    MainWindow.this.m_CoolantButton.setSelected(MainWindow.this.m_Main.m_ActualMachState.getParamBoolean(15124));
                    MainWindow.this.m_Main.m_GCodeEditor.enableButtons();
                }
            }
        });
        this.m_QuitButton.addActionListener(new ButtonAction(){

            @Override
            public void onActionDo() {
                MainWindow.this.m_Main.tryToQuit();
            }
        });
        this.m_SaveButton.addActionListener(new ButtonAction(){

            @Override
            public void onActionDo() {
                MainWindow.this.saveAll();
            }
        });
        UserActions userActions = this.m_Main.m_Actions;
        this.m_RunButton.addActionListener(userActions.m_Action_AUTO_RUN, 10);
        this.m_RunButton.addActionListener(userActions.m_Action_RUN);
        this.m_HoldButton.addActionListener(userActions.m_Action_HOLD);
        this.m_StopButton.addActionListener(userActions.m_Action_STOP);
        this.m_ReverseButton.addActionListener(userActions.m_Action_REVERSE);
        this.m_StepButton.addActionListener(userActions.m_Action_STEP);
    }

    public void saveAll() {
        UWKit.showConfirmDialog("Save configuration", "<b>Are you sure you want to Save the congiguration?</b><br>", "Yes", null, "Cancel", new DialogCallback(){

            @Override
            public void onClose(DialogCallback.DialogOptions dialogOptions) {
                if (dialogOptions == DialogCallback.DialogOptions.YES) {
                    MainWindow.this.saveAll2();
                }
            }
        });
    }

    private void saveAll2() {
        try {
            int n = this.m_Main.m_Split.getSplit();
            Point object = Main.m_Window.getLocationOnScreen();
            Dimension dimension = Main.m_Window.getSize();
            int n2 = this.m_Main.m_MachController.m_MachState.getParamInt(15298);
            if (this.m_Old_UI_SIZE != n2) {
                dimension = new Dimension(0, 0);
                this.m_Old_UI_SIZE = n2;
                n = 0;
            }
            this.m_Main.m_MachController.m_MachState.setParam(15215, n);
            this.m_Main.m_MachController.m_MachState.setParam(15216, object.x);
            this.m_Main.m_MachController.m_MachState.setParam(15217, object.y);
            this.m_Main.m_MachController.m_MachState.setParam(15218, dimension.width);
            this.m_Main.m_MachController.m_MachState.setParam(15219, dimension.height);
            System.out.println("SAVED WINDOW SIZE " + dimension.width + " x " + dimension.height);
            this.saveState();
            this.setButtonErrorNoBeep("Machine parameters and state saved");
            MainWindow mainWindow = this;
            if (mainWindow.m_Main.isAndroid()) {
                ConfigSaveOnAndroid.saveConfigToFileSystem(this.m_Main);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Save failed with exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
            this.setButtonErrorAndBeep("Save failed with exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
        }
        for (Plugin plugin : this.m_Main.m_PluginManager.getPlugins()) {
            try {
                PluginManager cfr_ignored_0 = this.m_Main.m_PluginManager;
                plugin.onSave(PluginManager.getPluginDataFilePath(plugin));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                PluginManager cfr_ignored_1 = this.m_Main.m_PluginManager;
                String string = PluginManager.getPluginName(plugin);
                System.out.println("Save for plugin '" + string + "' failed with exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
                this.setButtonErrorAndBeep("Save for plugin '" + string + "' failed with exception " + exception.getClass().getSimpleName() + " " + exception.getMessage());
            }
        }
    }

    public void gotoSafeZ() {
        if (!this.m_Main.checkConnected()) {
            return;
        }
        MachState machState = this.m_Main.m_MachController.getMachState();
        if (Double.isNaN(this.m_Main.m_MachController.getMachState().getParamDouble(15192))) {
            Main.m_MainWindow.setButtonErrorAndBeep("Safe Z not set");
            return;
        }
        this.m_Main.m_MachController.m_MotorController.setMpgTarget(2, (int)(machState.getParamDouble(15192) * machState.getParamDouble(-2147483646, 2)), Integer.MAX_VALUE);
    }

    public void gotoXYOrigin() {
        if (!this.m_Main.checkConnected()) {
            return;
        }
        MachState machState = this.m_Main.m_MachController.getMachState();
        double[] dArray = this.m_Main.m_MachController.getMachState().localToAxis(new double[]{0.0, 0.0, 0.0});
        this.m_Main.m_MachController.m_MotorController.setMpgTarget(0, (int)(dArray[0] * machState.getParamDouble(-2147483646, 0)), Integer.MAX_VALUE);
        this.m_Main.m_MachController.m_MotorController.setMpgTarget(1, (int)(dArray[1] * machState.getParamDouble(-2147483646, 1)), Integer.MAX_VALUE);
    }

    private /* synthetic */ void lambda$newDROPanels$0(CardLayout cardLayout, Observable observable) {
        int n = this.m_Main.m_MachController.getMachState().getParamInt(15167);
        if (n == 1) {
            cardLayout.selectCard("XYZ");
        } else {
            cardLayout.selectCard("ABC");
        }
    }

    private abstract class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        abstract void onActionDo();

        @Override
        public void onAction() {
            try {
                this.onActionDo();
            }
            catch (Exception exception) {
                MainWindow.this.setButtonErrorAndBeep(exception.getMessage());
            }
        }
    }
}

