/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.Widget;
import eazycnc.Main;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JTextField;

public class OnscreenKeyboard {
    private String m_PrevCard;
    private CardLayout m_ParentLayout;
    private Layout m_Layout;
    private TextField m_TargetField;
    private TextField m_EntryField;
    private static final String BUTTON_HEIGHT = "height 50!";
    private static final String BUTTON_SIZE = "width 58!,height 50!";
    private static OutputStream m_GPIO;

    public static void tactileFeedback() {
        if (m_GPIO != null) {
            try {
                m_GPIO.write("1".getBytes());
                Thread.sleep(5L);
                m_GPIO.write("0".getBytes());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                m_GPIO = null;
            }
        }
    }

    private void sendFakeKeyEvent(int n, int n2, char c) {
        Main.m_EventQueue.dispatchEvent(new KeyEvent((Component)((Object)this.m_EntryField), n, System.currentTimeMillis(), 0, n2, c));
    }

    private Layout addKeys(int n, String string) {
        Layout layout = UWKit.newLayout("insets 0,gap  0!");
        layout.add(UWKit.newLabel(""), "width " + n + "!");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Button button = UWKit.newButton("" + c);
            layout.add(button, "span 2,width 58!,height 50!");
            button.addActionListener(() -> this.sendFakeKeyEvent(400, 0, c));
        }
        return layout;
    }

    public OnscreenKeyboard(CardLayout cardLayout) {
        Object object;
        if (Main.m_OSisRasbian) {
            for (int i = 0; i < 5; ++i) {
                if (!new File("/sys/class/gpio/gpio21").exists()) {
                    System.out.println("Try to initialize GPIO 21");
                    try {
                        object = new FileOutputStream("/sys/class/gpio/export");
                        try {
                            ((OutputStream)object).write("21".getBytes());
                        }
                        finally {
                            ((OutputStream)object).close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                try {
                    object = new FileOutputStream("/sys/class/gpio/gpio21/direction");
                    try {
                        ((OutputStream)object).write("out".getBytes());
                    }
                    finally {
                        ((OutputStream)object).close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                try {
                    m_GPIO = new FileOutputStream("/sys/class/gpio/gpio21/value");
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.m_ParentLayout = cardLayout;
        Layout layout = UWKit.newLayout("");
        object = UWKit.newLayout("");
        this.m_EntryField = UWKit.newTextField(new SimpleVariable(""), 18.0, 20);
        Button button = UWKit.newButton("Cancel");
        Button button2 = UWKit.newButton("ENTER");
        button2.addActionListener(() -> this.enterAction());
        button.addActionListener(() -> this.cancelAction());
        layout.add(this.m_EntryField, "growx,split");
        layout.add(button, "aligny center,height 60!");
        layout.add(button2, "aligny center,height 60!,wrap");
        layout.add((Widget)object, "span 3");
        Layout layout2 = UWKit.newLayout();
        Button button3 = UWKit.newButton("");
        Button button4 = UWKit.newButton("\u232b");
        Button button5 = UWKit.newButton("\u25c0");
        Button button6 = UWKit.newButton("\u25b6");
        layout2.add(button4, BUTTON_SIZE);
        layout2.add(button3, "gap 20,width 180!,height 50!");
        layout2.add(button5, "gap 20,width 58!,height 50!");
        layout2.add(button6, BUTTON_SIZE);
        object.add(this.addKeys(0, "1234567890-+="), "wrap");
        object.add(this.addKeys(30, "QWERTYUIOP[]"), "wrap");
        object.add(this.addKeys(60, "ASDFGHJKL:*"), "wrap");
        object.add(this.addKeys(90, "ZXCVBNM,./"), "wrap");
        object.add(layout2, "center");
        Layout layout3 = UWKit.newLayout("align center center,");
        layout3.add(layout, new String[0]);
        this.m_EntryField.setEditListener(bl -> {
            if (bl) {
                this.enterAction();
            } else {
                this.cancelAction();
            }
        });
        button3.addActionListener(() -> this.sendFakeKeyEvent(400, 0, ' '));
        button4.addActionListener(() -> {
            this.sendFakeKeyEvent(401, 8, '\b');
            this.sendFakeKeyEvent(402, 8, '\b');
        });
        button5.addActionListener(() -> {
            this.sendFakeKeyEvent(401, 37, '\uffff');
            this.sendFakeKeyEvent(402, 37, '\uffff');
        });
        button6.addActionListener(() -> {
            this.sendFakeKeyEvent(401, 39, '\uffff');
            this.sendFakeKeyEvent(402, 39, '\uffff');
        });
        this.m_Layout = layout3;
    }

    private void cancelAction() {
        this.m_ParentLayout.selectCard(this.m_PrevCard);
        this.m_TargetField = null;
    }

    private void enterAction() {
        if (this.m_TargetField == null) {
            return;
        }
        this.m_TargetField.setFieldText(this.m_EntryField.getFieldText());
        this.m_TargetField.fireOnEndEdit(true);
        this.m_ParentLayout.selectCard(this.m_PrevCard);
        this.m_TargetField = null;
    }

    public Layout getLayout() {
        return this.m_Layout;
    }

    public void activateKeyabord(TextField textField) {
        if (textField == this.m_EntryField) {
            return;
        }
        if (this.m_TargetField != null) {
            return;
        }
        this.m_TargetField = textField;
        this.m_EntryField.setFieldText(this.m_TargetField.getFieldText());
        this.m_EntryField.selectAll();
        this.m_PrevCard = this.m_ParentLayout.selectCard("kbd");
        UWKit.scheduleInEDT(10, 0, () -> {
            ((JTextField)((Object)this.m_EntryField)).setFocusable(true);
            ((JTextField)((Object)this.m_EntryField)).requestFocus();
        });
    }

    private /* synthetic */ void lambda$new$10() {
        this.m_ParentLayout.selectCard(this.m_PrevCard);
    }

    private /* synthetic */ void lambda$new$9(String string) {
        this.m_EntryField.setFieldText(this.m_EntryField.getFieldText() + string);
        boolean bl = false;
    }

    private /* synthetic */ void lambda$new$8() {
        this.m_TargetField.setFieldText(this.m_EntryField.getFieldText());
        this.m_TargetField.fireOnEndEdit(true);
    }
}

