/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import eazycnc.Main;
import eazycnc.pendant.Pendant;
import hb04pendant.WHB04;
import hb04pendant.WHB04B;
import java.nio.file.AccessDeniedException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import printf.Printf;
import purejavahidapi.HidDeviceInfo;
import purejavahidapi.PureJavaHidApi;

public class PendantManager {
    private Thread m_Thread;
    private Main m_Main;
    private Map<String, Pendant> m_Path2Pendant = new Hashtable<String, Pendant>();
    private boolean m_AccessDenied = false;

    public PendantManager(Main main) {
        this.m_Main = main;
        this.m_Thread = new Thread(() -> this.runOnBackground());
        this.m_Thread.start();
    }

    public boolean getAccessDenied() {
        return this.m_AccessDenied;
    }

    private void addPendant(String string, Pendant pendant) {
        this.m_Path2Pendant.put(string, pendant);
        Printf.println("Add pendant " + pendant.getClass().getSimpleName() + " : " + string);
    }

    private String getPath(HidDeviceInfo hidDeviceInfo) {
        return String.format("%04X:%04X", hidDeviceInfo.getVendorId() & 0xFFFF, hidDeviceInfo.getProductId());
    }

    public void removePendant(HidDeviceInfo hidDeviceInfo) {
        if (hidDeviceInfo == null) {
            throw new IllegalArgumentException();
        }
        String string = this.getPath(hidDeviceInfo);
        Pendant pendant = this.m_Path2Pendant.get(string);
        Printf.println("Remove pendant " + pendant.getClass().getSimpleName() + " : " + string);
        this.m_Path2Pendant.remove(string);
    }

    private void runOnBackground() {
        while (true) {
            try {
                block4: while (true) {
                    Thread.sleep(1000L);
                    List list = PureJavaHidApi.enumerateDevices();
                    Iterator iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        HidDeviceInfo hidDeviceInfo = (HidDeviceInfo)iterator.next();
                        String string = this.getPath(hidDeviceInfo);
                        if (string == null || this.m_Path2Pendant.containsKey(string)) continue;
                        if (hidDeviceInfo.getVendorId() == 4302 && hidDeviceInfo.getProductId() == -5264) {
                            this.addPendant(string, new WHB04(this.m_Main, hidDeviceInfo));
                            this.m_AccessDenied = false;
                        }
                        if (hidDeviceInfo.getVendorId() != 4302 || hidDeviceInfo.getProductId() != -5229) continue;
                        this.addPendant(string, new WHB04B(this.m_Main, hidDeviceInfo));
                        this.m_AccessDenied = false;
                    }
                    break;
                }
            }
            catch (AccessDeniedException accessDeniedException) {
                this.m_AccessDenied = true;
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
    }
}

