/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.UWKit;
import eazycnc.Main;
import eazycnc.gcode.MachState;

public class ProbeCalibration {
    static final int SIM_GAUGE_CENTER = 494;
    static final int SIM_GAUGE_SIZE = 10000;
    static final int SIM_PROBE_SIZE = 2000;
    static final int SIM_PROBE_OFFSET = 400;
    static double[] probngs = new double[4];
    static int ri;
    static int step;

    public static void executeCalibrationSequence(final Main main) {
        ri = 0;
        step = 0;
        UWKit.showConfirmDialog("Calibration Axis", "Select Calibration Axis ", "Cancel", "Y-Axis", "X-Axis", new DialogCallback(){

            @Override
            public void onClose(DialogCallback.DialogOptions dialogOptions) {
                if (dialogOptions == DialogCallback.DialogOptions.YES) {
                    // empty if block
                }
                if (dialogOptions == DialogCallback.DialogOptions.NO) {
                    UWKit.scheduleInEDT(() -> ProbeCalibration.executeCalibrationSequence(main, 1));
                }
                if (dialogOptions == DialogCallback.DialogOptions.CANCEL) {
                    UWKit.scheduleInEDT(() -> ProbeCalibration.executeCalibrationSequence(main, 0));
                }
            }
        });
    }

    private static void executeCalibrationSequence(final Main main, final int n) {
        int n2;
        System.out.println("executeCalibrationSequence " + step);
        boolean bl = main.m_MachController.getMachState().getParamBoolean(15133);
        String string = null;
        if (n == 0) {
            n2 = 0;
            string = "X";
        } else if (n == 1) {
            n2 = 1;
            string = "Y";
        } else {
            Main.m_MainWindow.setButtonErrorAndBeep("BUG, wrong axis " + n);
            return;
        }
        String string2 = null;
        switch (step++) {
            default: {
                return;
            }
            case 0: {
                UWKit.showConfirmDialog("Probe at 0\u00b0", "Orient the probe at normal usage orientation, 0\u00b0.<br><br>Then press <b>RUN</b>. ", "Cancel", "RUN", null, new DialogCallback(){

                    @Override
                    public void onClose(DialogCallback.DialogOptions dialogOptions) {
                        if (dialogOptions == DialogCallback.DialogOptions.NO) {
                            UWKit.scheduleInEDT(() -> ProbeCalibration.executeCalibrationSequence(main, n));
                        }
                    }
                });
                break;
            }
            case 1: {
                string2 = "G91 F60 G31 " + string + "-20 \nG91 G0 " + string + "20";
                break;
            }
            case 2: {
                string2 = "G91 F60 G31 " + string + "20 \nG91 G0 " + string + "-20";
                break;
            }
            case 3: {
                UWKit.showConfirmDialog("Probe at 180\u00b0", "Rotate the probe to the <b>180\u00b0</b> orientation.<br><br>Then press <b>RUN</b>. ", "Cancel", "RUN", null, new DialogCallback(){

                    @Override
                    public void onClose(DialogCallback.DialogOptions dialogOptions) {
                        if (dialogOptions == DialogCallback.DialogOptions.NO) {
                            UWKit.scheduleInEDT(() -> ProbeCalibration.executeCalibrationSequence(main, n));
                        }
                    }
                });
                break;
            }
            case 4: {
                string2 = "G91 F60 G31 " + string + "-20 \nG91 G0 " + string + "20";
                break;
            }
            case 5: {
                string2 = "G91 F60 G31 " + string + "20 \nG91 G0 " + string + "-20";
            }
        }
        if (string2 != null) {
            System.out.println(string2);
            Main.m_MainWindow.execute(string2, object -> {
                MachState machState = main.m_MachController.getMachState();
                machState.setParam(15133, bl);
                if (object == null) {
                    ProbeCalibration.probngs[ProbeCalibration.ri++] = machState.getParamDouble(2000 + n2);
                    if (ri > 3) {
                        System.out.println("probngs[0] " + probngs[0]);
                        System.out.println("probngs[1] " + probngs[1]);
                        System.out.println("probngs[2] " + probngs[2]);
                        System.out.println("probngs[3] " + probngs[3]);
                        double d = machState.getParamDouble(15193) - (probngs[1] - probngs[0]);
                        double d2 = ((probngs[0] - probngs[2]) / 2.0 + (probngs[1] - probngs[3]) / 2.0) / 2.0;
                        System.out.println("probe effective size " + d);
                        System.out.println("probe offset         " + d2);
                    } else {
                        UWKit.scheduleInEDT(() -> ProbeCalibration.executeCalibrationSequence(main, n));
                    }
                }
            });
        }
    }
}

