/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.UWKit;
import eazycnc.Main;
import eazycnc.gcode.MachState;

public class ProbeCalibration2 {
    static final String NOP = ";\n";
    double[] m_ProbeRes = new double[16];
    int m_ResIdx;
    int m_CalibrationStep;
    int m_CalibLoop;
    int m_Axis;
    double[] m_StartPos;
    double m_CalibGageSize;
    boolean m_ProbeAt180;
    boolean m_Capture;
    int m_NextStep;

    public void startCalibration(Main main, double d) {
        this.m_CalibLoop = 0;
        this.m_ProbeAt180 = false;
        this.m_ResIdx = 0;
        main.m_MachController.syncMachStateWithMotorPositions();
        this.m_StartPos = main.m_MachController.m_MachState.getAxisPos();
        this.m_CalibGageSize = d;
        this.m_Capture = false;
        this.m_NextStep = 1;
        System.out.println("SHOW DIALOG 1");
        UWKit.showConfirmDialog("Probe Calibration", "Confirm Probe Calibration?<br><br>Pressing 'Yes' will start the calibration.", "Yes", null, "Cancel", dialogOptions -> {
            if (dialogOptions == DialogCallback.DialogOptions.YES) {
                MachState machState = main.m_MachController.getMachState();
                int n = machState.getWorkOffsetBaseIndex();
                machState.setParam(n + 19, 0);
                machState.setParam(n + 0, 0);
                machState.setParam(n + 1, 0);
                this.m_NextStep = ConnectionState.SIMULATION == main.m_MachController.getConnectionState() ? -1 : 0;
                this.executeNextStep(main);
            }
        });
    }

    private void executeNextStep(Main main) {
        String string = "F60";
        Object object2 = "";
        MachState machState = main.m_MachController.getMachState();
        double d = machState.getParamDouble(15193);
        double d2 = this.m_StartPos[0];
        double d3 = this.m_StartPos[1];
        double d4 = this.m_StartPos[2];
        switch (this.m_NextStep++) {
            case -1: {
                object2 = (String)object2 + "G0 Z15 \n";
                object2 = (String)object2 + "G0 X39.0 Y28.0\n";
                object2 = (String)object2 + "G0 Z5";
                this.m_CalibGageSize = 20.0;
                break;
            }
            case 0: {
                System.out.println("CLOSE DIALOG 1");
                UWKit.closeDialog();
                main.m_MachController.syncMachStateWithMotorPositions();
                this.m_StartPos = main.m_MachController.m_MachState.getAxisPos();
                main.m_MachController.m_MotorController.m_Simulator.m_ProbeSimulator.setProbeOrienation(this.m_ProbeAt180);
                String string2 = this.m_ProbeAt180 ? "180\u00b0" : "0\u00b0";
                System.out.println("SHOW DIALOG 3");
                UWKit.showConfirmDialog("Probe Calibration", "Confirm that the probe is in " + string2 + " orientation?<br><br>Pressing 'Yes' will start the calibration.", "Yes", null, "Cancel", dialogOptions2 -> {
                    if (dialogOptions2 == DialogCallback.DialogOptions.YES) {
                        this.executeNextStep(main);
                        System.out.println("SHOW DIALOG 3");
                        UWKit.showInformationDialog("Probe Calibration", "Calibration in progress.<br><br>Press Cancel to STOP", null, null, "Cancel", dialogOptions -> {
                            this.m_NextStep = 99;
                            main.m_MachController.stopCycle();
                        });
                    }
                });
                break;
            }
            case 1: {
                object2 = (String)object2 + ";case 1\n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                object2 = (String)object2 + string + " G31 X" + (d2 - d) + " \n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                this.m_Capture = true;
                break;
            }
            case 2: {
                object2 = (String)object2 + ";case 2\n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                object2 = (String)object2 + string + " G31 X" + (d2 + d) + " \n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                this.m_Capture = true;
                break;
            }
            case 3: {
                object2 = (String)object2 + ";case 3\n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                object2 = (String)object2 + string + " G31 Y" + (d3 - d) + " \n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                this.m_Capture = true;
                break;
            }
            case 4: {
                object2 = (String)object2 + ";case 4\n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                object2 = (String)object2 + string + " G31 Y" + (d3 + d) + " \n";
                object2 = (String)object2 + "G0 X" + d2 + " Y" + d3 + " \n";
                this.m_Capture = true;
                break;
            }
            case 5: {
                switch (this.m_CalibLoop++) {
                    case 0: {
                        this.m_StartPos[0] = (this.m_ProbeRes[0] + this.m_ProbeRes[1]) / 2.0;
                        this.m_StartPos[1] = (this.m_ProbeRes[2] + this.m_ProbeRes[3]) / 2.0;
                        System.out.printf("center %f %f\n", this.m_StartPos[0], this.m_StartPos[1]);
                        this.m_NextStep = 1;
                        object2 = NOP;
                        break;
                    }
                    case 1: {
                        this.m_ProbeAt180 = true;
                        this.m_NextStep = 0;
                        object2 = NOP;
                        break;
                    }
                    case 2: {
                        this.m_StartPos[0] = (this.m_ProbeRes[8] + this.m_ProbeRes[9]) / 2.0;
                        this.m_StartPos[1] = (this.m_ProbeRes[10] + this.m_ProbeRes[11]) / 2.0;
                        System.out.printf("center %f %f\n", this.m_StartPos[0], this.m_StartPos[1]);
                        this.m_NextStep = 1;
                        object2 = NOP;
                        break;
                    }
                    case 3: {
                        UWKit.closeDialog();
                        for (int i = 0; i < this.m_ProbeRes.length; i += 2) {
                            System.out.printf("r[%d] = %1.3f r[%d] = %1.3f\n", i, this.m_ProbeRes[i], i + 1, this.m_ProbeRes[i + 1]);
                        }
                        double d5 = 0.0;
                        double d6 = 0.0;
                        for (int i = 0; i < this.m_ProbeRes.length; i += 8) {
                            d5 += this.m_CalibGageSize - (this.m_ProbeRes[i + 5] - this.m_ProbeRes[i + 4]);
                            d6 += this.m_CalibGageSize - (this.m_ProbeRes[i + 7] - this.m_ProbeRes[i + 6]);
                            System.out.printf("xsize=%f ", this.m_CalibGageSize - (this.m_ProbeRes[i + 5] - this.m_ProbeRes[i + 4]));
                            System.out.printf("ysize=%f \n", this.m_CalibGageSize - (this.m_ProbeRes[i + 7] - this.m_ProbeRes[i + 6]));
                        }
                        d5 *= 0.5;
                        d6 *= 0.5;
                        double d7 = 0.0;
                        double d8 = 0.0;
                        for (int i = 0; i < 2; ++i) {
                            d7 += (this.m_ProbeRes[12 + i] - this.m_ProbeRes[4 + i]) * 0.5;
                            d8 += (this.m_ProbeRes[14 + i] - this.m_ProbeRes[6 + i]) * 0.5;
                            System.out.printf("xoffs=%f ", (this.m_ProbeRes[12 + i] - this.m_ProbeRes[4 + i]) * 0.5);
                            System.out.printf("yoffs=%f \n", (this.m_ProbeRes[14 + i] - this.m_ProbeRes[6 + i]) * 0.5);
                        }
                        System.out.printf("PROBE SIZE   X=%1.3f    Y=%1.3f\n", d5, d6);
                        System.out.printf("PROBE OFFSET X=%1.3f    Y=%1.3f\n", d7 *= 0.5, d8 *= 0.5);
                        double d9 = d5 / 2.0 + d7;
                        double d10 = d6 / 2.0 + d8;
                        double d11 = d5 / 2.0 - d7;
                        double d12 = d6 / 2.0 - d8;
                        System.out.println("PROBE_CALIB_NEG_OFFSET (x) " + d11);
                        System.out.println("PROBE_CALIB_NEG_OFFSET (y) " + d12);
                        System.out.println("PROBE_CALIB_POS_OFFSET (x) " + d9);
                        System.out.println("PROBE_CALIB_POS_OFFSET (y) " + d10);
                        machState.setParam(0x4000000, 0, d11);
                        machState.setParam(0x4000000, 1, d12);
                        machState.setParam(0x4000001, 0, d9);
                        machState.setParam(0x4000001, 1, d10);
                        this.m_NextStep = 99;
                        UWKit.showInformationDialog("Probe Calibration", "Probe calibration completed!", "OK", null, null, null);
                    }
                }
                break;
            }
        }
        if (!((String)object2).isEmpty()) {
            object2 = (String)object2 + "M2 \n";
            System.out.println("m_NextStep " + this.m_NextStep + " m_CalibLoop=" + this.m_CalibLoop + " script=\n" + (String)object2);
            Main.m_MainWindow.execute((String)object2, object -> {
                try {
                    if (object == null) {
                        if (this.m_Capture) {
                            double[] dArray = main.m_MachController.getProbedPosition();
                            if (dArray == null) {
                                System.err.println("Probing script failed!");
                            } else {
                                this.m_ProbeRes[this.m_ResIdx] = dArray[this.m_ResIdx / 2 % 2];
                            }
                            System.out.printf("m_ProbeRes[%d] = %f\n", this.m_ResIdx, this.m_ProbeRes[this.m_ResIdx]);
                            ++this.m_ResIdx;
                            this.m_Capture = false;
                        }
                    } else {
                        System.out.println("Error " + object);
                        UWKit.showInformationDialog("Probe Calibration", "Probe calibration failed!", "OK", null, null, null);
                        this.m_NextStep = 99;
                    }
                    UWKit.scheduleInEDT(() -> this.executeNextStep(main));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
    }
}

