/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.ComboBox;
import com.eazycnc.uwk.widgets.Layout;
import eazycnc.Main;
import eazycnc.UserActions;
import eazycnc.gcode.MachState;
import java.util.Hashtable;
import java.util.LinkedList;

public class ShortcutManager {
    private String[] m_ActionNames;
    private static String BUTTON_SIZE = "width 150:150:150";
    private Main m_Main;
    private LinkedList<ShortcutEntry> m_Shortcuts = new LinkedList();
    private Hashtable<String, ShortcutEntry> m_ShortcutsMap = new Hashtable();
    private boolean m_Capture;
    private String m_CapturedKey;

    private void addShortCut(ShortcutEntry shortcutEntry) {
        this.m_Shortcuts.add(shortcutEntry);
        this.m_ShortcutsMap.put(shortcutEntry.m_KeyName, shortcutEntry);
    }

    public ShortcutManager(Main main) {
        this.m_Main = main;
    }

    public void loadShortcuts(MachState machState) {
        int n = machState.getParamInt(15306);
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            try {
                string = machState.getParamString(0x10000000, i);
                string2 = machState.getParamString(0x10000001, i);
                if (string == null || string2 == null) continue;
                this.addShortCut(new ShortcutEntry(string, string2));
                continue;
            }
            catch (Exception exception) {
                System.err.println("Failed to load short cut key='" + string + "' action='" + string2 + "' no " + i);
            }
        }
    }

    public void storeShortcuts(MachState machState) {
        int n = this.m_Shortcuts.size();
        machState.setParam(15306, n);
        int n2 = 0;
        for (ShortcutEntry shortcutEntry : this.m_Shortcuts) {
            machState.setParam(0x10000000, n2, shortcutEntry.m_KeyName);
            machState.setParam(0x10000001, n2, shortcutEntry.m_ActionName);
            ++n2;
        }
    }

    public boolean dispatchShortcutEvent(Object object, Press press, String string) {
        if (this.m_Capture) {
            this.m_CapturedKey = string;
            this.m_Capture = false;
            UWKit.closeDialog();
        } else {
            ShortcutEntry shortcutEntry = this.m_ShortcutsMap.get(string);
            if (shortcutEntry == null) {
                return false;
            }
            UserActions.Action action = this.m_Main.m_Actions.getActionByName(shortcutEntry.m_ActionName);
            if (action == null) {
                Main.m_MainWindow.setButtonErrorAndBeep("Action '" + shortcutEntry.m_ActionName + "' defined for key/button '" + string + "' does not exist.");
            } else {
                if (press == Press.PRESSED) {
                    action.callOnPressed(object);
                }
                if (press == Press.RELEASED) {
                    action.callOnReleased(object);
                }
                if (press == Press.PRESSED_LONG) {
                    action.callOnPressedLong(object);
                }
            }
        }
        return true;
    }

    private void createButtons(final Layout layout, ShortcutEntry shortcutEntry) {
        final String[] stringArray = new String[]{shortcutEntry.m_KeyName};
        SimpleVariable simpleVariable = new SimpleVariable(shortcutEntry.m_ActionName);
        final Button button = UWKit.newButton(stringArray[0]);
        layout.add(button, BUTTON_SIZE);
        final ComboBox comboBox = UWKit.newComboBox((Variable)simpleVariable, (Object[])this.m_ActionNames, (Object[])this.m_ActionNames);
        layout.add(comboBox, "wrap");
        button.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                ShortcutManager.this.m_Capture = true;
                ShortcutManager.this.m_CapturedKey = null;
                UWKit.showInformationDialog("Set Shortcut", "<b>Press a Keyboard Key or Joystick Button to define a shortcut key,</b><br><br> or press Delete to remove this shortcut.<br<bRor click Cancel", "Delete", null, "Cancel", new DialogCallback(){

                    @Override
                    public void onClose(DialogCallback.DialogOptions dialogOptions) {
                        if (dialogOptions == DialogCallback.DialogOptions.YES) {
                            ShortcutManager.this.m_Shortcuts.remove(stringArray[0]);
                            ShortcutManager.this.m_ShortcutsMap.remove(stringArray[0]);
                            layout.remove(button);
                            layout.remove(comboBox);
                            layout.relayout();
                        } else if (ShortcutManager.this.m_CapturedKey != null) {
                            if (ShortcutManager.this.m_ShortcutsMap.containsKey(ShortcutManager.this.m_CapturedKey)) {
                                UWKit.showErrorDialog("Shortcut Conflict", "<b>The shortcut you have selected, '" + ShortcutManager.this.m_CapturedKey + "', is already in use.</b><br><br>You must delete the previous usage before you can continue.", null, null, "OK", null);
                                return;
                            }
                            ShortcutEntry shortcutEntry = ShortcutManager.this.m_ShortcutsMap.get(stringArray[0]);
                            ShortcutManager.this.m_ShortcutsMap.remove(stringArray[0]);
                            stringArray[0] = ShortcutManager.this.m_CapturedKey;
                            button.setText(stringArray[0]);
                            shortcutEntry.m_KeyName = stringArray[0];
                            ShortcutManager.this.m_ShortcutsMap.put(shortcutEntry.m_KeyName, shortcutEntry);
                        }
                    }
                });
            }
        });
        simpleVariable.addObserver(new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                ShortcutManager.this.m_ShortcutsMap.get((Object)stringArray[0]).m_ActionName = variable.getValue().toString();
            }
        });
    }

    public Layout getLayout(Main main) {
        String[] stringArray = main.m_Actions.getActionNames();
        this.m_ActionNames = new String[stringArray.length + 1];
        this.m_ActionNames[stringArray.length] = "Undefined";
        System.arraycopy(stringArray, 0, this.m_ActionNames, 0, stringArray.length);
        Layout layout = UWKit.newTitledLayout("Keyboard/Joystick Shortcuts");
        Layout layout2 = UWKit.newScrollLayout();
        final Layout layout3 = UWKit.newLayout("filly");
        layout.add(UWKit.newLabel("Key/Button"), "gap 10," + BUTTON_SIZE);
        layout.add(UWKit.newLabel("Action"), "wrap");
        layout.add(layout2, "height 180,span 2");
        layout2.add(layout3, new String[0]);
        String[] stringArray2 = main.m_Actions.getActionNames();
        for (ShortcutEntry shortcutEntry : this.m_Shortcuts) {
            this.createButtons(layout3, shortcutEntry);
        }
        final Button button = UWKit.newButton("<html><i>New Shortcut</i></html>");
        layout3.add(button, BUTTON_SIZE);
        button.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                if (ShortcutManager.this.m_Shortcuts.size() >= 200) {
                    UWKit.showErrorDialog("Too Many Shortcuts", "<b>You can have maximum of 200 shortcuts.</b><br><br>", null, null, "OK", null);
                    return;
                }
                ShortcutManager.this.m_Capture = true;
                ShortcutManager.this.m_CapturedKey = null;
                UWKit.showInformationDialog("Set Shortcut", "<b>Press a Keyboard Key or Joystick Button to define a shortcut key,</b><br><br>or click Cancel", null, null, "Cancel", dialogOptions -> {
                    if (ShortcutManager.this.m_CapturedKey == null) {
                        return;
                    }
                    if (ShortcutManager.this.m_ShortcutsMap.containsKey(ShortcutManager.this.m_CapturedKey)) {
                        UWKit.showErrorDialog("Shortcut Conflict", "<b>The shortcut you have selected, '" + ShortcutManager.this.m_CapturedKey + "', is already in use.</b><br><br>You must delete the previous usage before you can continue.", null, null, "OK", null);
                        return;
                    }
                    layout3.remove(button);
                    ShortcutEntry shortcutEntry = new ShortcutEntry(ShortcutManager.this.m_CapturedKey, "Undefined");
                    ShortcutManager.this.m_Shortcuts.add(shortcutEntry);
                    ShortcutManager.this.m_ShortcutsMap.put(shortcutEntry.m_KeyName, shortcutEntry);
                    ShortcutManager.this.createButtons(layout3, shortcutEntry);
                    layout3.add(button, BUTTON_SIZE);
                });
            }
        });
        return layout;
    }

    static class ShortcutEntry {
        String m_KeyName;
        String m_ActionName;

        ShortcutEntry(String string, String string2) {
            this.m_KeyName = string;
            this.m_ActionName = string2;
        }
    }

    public static enum Press {
        PRESSED,
        RELEASED,
        PRESSED_LONG;

    }
}

