/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.FocusListener;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.Widget;
import eazycnc.Main;
import eazycnc.ToolpathDisplayPanel;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import motorcontrol.MachController;
import motorcontrol.MachiningState;

public class StatusPanel
implements MachController.StatusDisplay {
    private boolean m_ShowLastError;
    private MachController m_MotorController;
    public TextField m_TextField;
    private SimpleVariable m_StatusText;
    private Layout m_Layout;
    private ConnectionState m_ConnectionStatus;
    private MachiningState m_MachiningStatus;
    private int m_ChangeCount = 1;
    private int m_PrevChangeCount = 0;
    private String m_ParseErrorText;
    private int m_Timeout;
    private String m_ButtonError;
    private boolean m_ButtonRed;
    private String m_OperatorMessage;
    private String m_MacroExecutingText;
    private String m_MotorUnderTest;
    private ToolpathDisplayPanel m_ToolPathDisplay;
    private Main m_Main;
    private boolean m_Flag;
    public JTextField m_Hack;
    private LinkedList<String> m_CommandHistory = new LinkedList();
    private int m_HistoryIndex = 0;

    public StatusPanel(Main main) {
        this.m_Main = main;
    }

    public void init(MachController machController, ToolpathDisplayPanel toolpathDisplayPanel) {
        this.m_ToolPathDisplay = toolpathDisplayPanel;
        this.m_MotorController = machController;
    }

    public void activateCommandLineEntry() {
        if (this.m_Hack != null) {
            this.m_Hack.setFocusable(true);
            this.m_Hack.requestFocus();
            this.m_Hack.setText("");
        }
        this.m_Timeout = 0;
    }

    public void cancelCommand() {
        if (this.m_Hack != null) {
            this.m_Hack.setFocusable(false);
            this.m_Hack.setText("");
        }
    }

    private void popHistory(int n) {
        this.m_HistoryIndex -= n;
        if (this.m_HistoryIndex < 0) {
            this.m_HistoryIndex = this.m_CommandHistory.size() - 1;
        } else if (this.m_HistoryIndex >= this.m_CommandHistory.size()) {
            this.m_HistoryIndex = 0;
        }
        if (this.m_HistoryIndex < this.m_CommandHistory.size() && this.m_Hack != null) {
            this.m_Hack.setText(this.m_CommandHistory.get(this.m_HistoryIndex));
        }
    }

    private void pushHistory(String string) {
        this.m_CommandHistory.add(string);
        this.m_HistoryIndex = this.m_CommandHistory.size();
    }

    public Layout getLayout() {
        this.m_StatusText = new SimpleVariable((Object)""){

            @Override
            public synchronized void setValue(Object object) {
                if (!StatusPanel.this.m_Flag) {
                    String string = object.toString();
                    if (!string.isEmpty()) {
                        StatusPanel.this.pushHistory(string);
                        StatusPanel.this.m_Main.m_StatusPanel.setMacroMessage("Executing: " + string);
                        Main cfr_ignored_0 = StatusPanel.this.m_Main;
                        Main.m_MainWindow.execute(string, null);
                    }
                    ++StatusPanel.this.m_ChangeCount;
                    StatusPanel.this.update();
                } else {
                    super.setValue(object);
                }
            }
        };
        this.m_TextField = UWKit.newTextField(this.m_StatusText, 16.0, 10);
        StatusPanel statusPanel = this;
        if (!statusPanel.m_Main.isAndroid()) {
            this.m_Hack = (JTextField)((Object)this.m_TextField);
            this.m_Hack.getInputMap().put(KeyStroke.getKeyStroke("UP"), "pophistoryu");
            this.m_Hack.getActionMap().put("pophistoryu", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatusPanel.this.popHistory(1);
                }
            });
            this.m_Hack.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "pophistoryd");
            this.m_Hack.getActionMap().put("pophistoryd", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatusPanel.this.popHistory(-1);
                }
            });
            this.m_Hack.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "cancelcommand");
            this.m_Hack.getActionMap().put("cancelcommand", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatusPanel.this.cancelCommand();
                }
            });
            this.m_Hack.setFocusable(false);
            this.m_Hack.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    StatusPanel.this.activateCommandLineEntry();
                }
            });
        }
        this.m_TextField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(Widget widget) {
                if (StatusPanel.this.m_Hack != null) {
                    StatusPanel.this.m_Hack.setFocusable(false);
                }
            }

            @Override
            public void focusGained(Widget widget) {
            }
        });
        this.m_Layout = UWKit.newLayout("fillx");
        Button button = UWKit.newButton("button_white_extra_small", "?");
        this.m_Layout.add(button, "split");
        this.m_Layout.add(this.m_TextField, "growx");
        button.addButtonListener(new Button.ButtonListener(){

            @Override
            public void buttonPressed(Button button) {
                StatusPanel.this.m_ShowLastError = true;
                StatusPanel.this.m_Timeout = 20;
                ++StatusPanel.this.m_ChangeCount;
                StatusPanel.this.update();
            }

            @Override
            public void buttonReleased(Button button) {
                StatusPanel.this.m_ShowLastError = false;
                ++StatusPanel.this.m_ChangeCount;
                StatusPanel.this.update();
            }
        });
        return this.m_Layout;
    }

    @Override
    public void setMacroMessage(String string) {
        this.m_MacroExecutingText = string;
        ++this.m_ChangeCount;
    }

    private String getText() {
        if (this.m_ShowLastError) {
            if (this.m_ButtonError == null) {
                return "No 'last error' to show";
            }
            return this.m_ButtonError;
        }
        if (this.m_Timeout > 0) {
            return this.m_ButtonError;
        }
        if (this.m_ParseErrorText != null) {
            return this.m_ParseErrorText;
        }
        if (this.m_MotorUnderTest != null) {
            return "Motor test running on axis " + this.m_MotorUnderTest;
        }
        if ((this.m_ConnectionStatus == ConnectionState.CONNECTED || this.m_ConnectionStatus == ConnectionState.SIMULATION) && this.m_MachiningStatus != MachiningState.STOPPED) {
            if (this.m_OperatorMessage != null) {
                return this.m_OperatorMessage;
            }
            if (this.m_MachiningStatus == MachiningState.PAUSED) {
                return "Machinging on hold";
            }
            if (this.m_Main.m_MachController.isMacro()) {
                return this.m_MacroExecutingText;
            }
            return String.format("Machining in progress, elapsed %s", this.m_Main.m_MachController.getElapseRunTimeString());
        }
        switch (this.m_ConnectionStatus) {
            case CONTROLLER_FOUND: {
                return "Controller: Device found";
            }
            case ACCESS_DENIED: {
                return "Controller: Access denied";
            }
            case CONNECTED: {
                if (this.m_MotorController.getVersion() == null) {
                    ++this.m_ChangeCount;
                    return "Controller: Connected -- waiting for firmware version";
                }
                return "Controller: Connected -- firmware version " + this.m_MotorController.getVersion();
            }
            case SIMULATION: {
                if (this.m_MotorController.getVersion() == null) {
                    ++this.m_ChangeCount;
                }
                return "Simulator: Active -- simulator version " + this.m_MotorController.getVersion();
            }
            case DEVICE_NOT_FOUND: {
                return "Controller:  Device not found";
            }
            case DEVICE_NOT_RESPONDING: {
                return "Controller:  Not responding";
            }
            case DEVICE_BUSY: {
                return "Controller:  Device in use";
            }
            case DEVICE_INVALID: {
                return "Controller:  Device not responding properly";
            }
            case NO_PORT_SPECIFIED: {
                return "Controller:  No communication port specified";
            }
            case SHUTDOWN: {
                return "Controller:  Not connected";
            }
        }
        return this.m_ConnectionStatus.toString();
    }

    public synchronized void update() {
        int n;
        MachiningState machiningState;
        ConnectionState connectionState;
        String string = this.m_MotorController.getMotorUnderTest();
        if (string != this.m_MotorUnderTest) {
            this.m_MotorUnderTest = string;
            ++this.m_ChangeCount;
        }
        if ((connectionState = this.m_MotorController.getConnectionState()) != this.m_ConnectionStatus) {
            this.m_ConnectionStatus = connectionState;
            ++this.m_ChangeCount;
        }
        if ((machiningState = this.m_MotorController.getMachiningState()) != this.m_MachiningStatus) {
            this.m_MachiningStatus = machiningState;
            ++this.m_ChangeCount;
        }
        if (this.m_Timeout > 0 && !this.m_ShowLastError) {
            --this.m_Timeout;
            if (this.m_Timeout == 0) {
                ++this.m_ChangeCount;
            }
        }
        if ((n = this.m_ChangeCount) != this.m_PrevChangeCount || this.m_MachiningStatus == MachiningState.RUNNING) {
            this.m_PrevChangeCount = n;
            if (this.m_Timeout > 0) {
                this.m_TextField.setColor(this.m_ButtonRed ? 0xFF0000 : 0, 0xFFFFFF);
            } else {
                this.m_TextField.setColor(0xFFFFFF, 0);
            }
            this.m_Flag = true;
            StatusPanel statusPanel = this;
            if (statusPanel.m_Main.isAndroid()) {
                this.m_StatusText.setValue(this.getText());
            } else {
                this.m_Hack.setFocusable(false);
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.m_StatusText.setValue(this.getText());
                if (component != null) {
                    component.requestFocus();
                }
            }
            this.m_Flag = false;
        }
    }

    public synchronized void setParseErrorText(String string) {
        this.m_ParseErrorText = string;
        ++this.m_ChangeCount;
    }

    public synchronized void setButtonError(String string) {
        this.m_ButtonError = string;
        this.m_ButtonRed = string.indexOf("!!!") > 0;
        this.m_Timeout = this.m_ButtonRed ? 50 : 20;
        ++this.m_ChangeCount;
    }

    @Override
    public synchronized void setOperatorMessage(String string) {
        if (string != null && string.isEmpty()) {
            string = null;
        }
        if (this.m_OperatorMessage != string) {
            this.m_OperatorMessage = string;
            ++this.m_ChangeCount;
        }
    }
}

