/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.motorcontroller.MotorController;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.Canvas;
import com.eazycnc.uwk.widgets.CardLayout;
import com.eazycnc.uwk.widgets.ComboBox;
import com.eazycnc.uwk.widgets.Layout;
import eazycnc.AnimationScheduler;
import eazycnc.IndicatorLed;
import eazycnc.Main;
import eazycnc.gcode.Interpreter;
import eazycnc.gcode.MachState;

public class TOAD5TestPanel {
    static String[] axis = new String[]{"X", "Y", "Z", "A", "B"};

    private static void addInput(Layout layout, String string, IndicatorLed.GetState getState) {
        IndicatorLed indicatorLed = new IndicatorLed(IndicatorLed.Color.GREEN, getState);
        layout.add(indicatorLed.getWidget(), "");
        layout.add(UWKit.newLabel(string), "h 30, w 100, wrap");
    }

    private static void addADC(Layout layout, Main main) {
        SimpleVariable simpleVariable = new SimpleVariable(0);
        Layout layout2 = UWKit.newTitledLayout("SPEED Input", "filly");
        Canvas[] canvasArray = new Canvas[]{null};
        canvasArray[0] = UWKit.newCanvas((graphics, n, n2) -> {
            simpleVariable.setValue((double)(main.m_MachController.getMotorController().getAnalogInput(0) * 1000 / 255) / 10.0);
            AnimationScheduler.scheduleRepaint(canvasArray[0]);
        });
        layout.add(UWKit.newLabel("ADC:"), "align right");
        layout.add(UWKit.newTextField((Variable)simpleVariable, 16.0, 7, new SimpleVariable("0"), null), new String[0]);
        layout.add(canvasArray[0], "width 1:1:1,height 30:1:1,wrap");
    }

    private static void addDAC(Layout layout, SimpleVariable simpleVariable) {
        layout.add(UWKit.newLabel("DAC:"), "align right");
        layout.add(UWKit.newTextField((Variable)simpleVariable, 16.0, 7, new SimpleVariable("0"), null), "h 30");
    }

    private static void testMotor(Main main, int n, double d) {
        try {
            main.m_MachController.startTest(n, d);
        }
        catch (Exception exception) {
            Main.m_MainWindow.setButtonErrorAndBeep(exception.getMessage());
        }
    }

    private static Layout createTestPane(final Main main, final int n) {
        final double[] dArray = new double[]{0.0};
        final MachState machState = main.m_MachController.getMachState();
        Variable variable = n < 3 ? machState.getLengthUnit() : new SimpleVariable("deg");
        Variable variable2 = UWKit.concat(variable, "/s");
        Variable variable3 = UWKit.concat(variable, "/s^2");
        Variable variable4 = UWKit.concat(variable, "/s^3");
        Variable variable5 = variable;
        int n2 = 7;
        Layout layout = UWKit.newLayout();
        layout.add(UWKit.newLabel("Top veloc.:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15305), 16.0, n2, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable2), "align left,wrap");
        layout.add(UWKit.newLabel("Accel.:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15303), 16.0, n2, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable3), "align left,wrap");
        layout.add(UWKit.newLabel("Jerk:"), "align right");
        layout.add(UWKit.newTextField((Variable)machState.getScaledVariable(15308), 16.0, n2, machState.getDroFormatVariable(), null), new String[0]);
        layout.add(UWKit.newLabel(variable4), "align left,wrap");
        layout.add(UWKit.newLabel("Direction:"), "align right");
        layout.add(UWKit.newComboBox((Variable)machState.getVariable(15307), "Positive", 1, "Negative", -1), "wrap");
        Button button = UWKit.newButton(" TEST ");
        button.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                int n2 = main.m_MachController.motorFromAxis(n);
                double d = machState.getParamDouble(-2147483646, n2);
                double d2 = main.m_MachController.getVelocityUnit();
                double d3 = 65535.0 / (d * d2);
                double d4 = 65535.0 / (d * d2 * d2 * 0.25);
                if (machState.getParamDouble(15305) > d3) {
                    String string = machState.formatToUserUnits(d3);
                    Main.m_MainWindow.setButtonErrorAndBeep("Test Top Velocity too high, with current motor Step Ratio maximum is " + string);
                    return;
                }
                final double d5 = 25.0;
                String string = Interpreter.getAxisLetter(n);
                if (dArray[0] != d5) {
                    String string2 = (int)(d5 / machState.getParamDouble(15141)) + (machState.getParamDouble(15141) == 1.0 ? " mm" : " inch");
                    UWKit.showConfirmDialog("Confirm Test Run", "<b>Are you sure you want to test " + string + "-axis ?</b><br><br>This may cause the motor to run unpredictably for " + string2 + ".<br><br>You will not be warned again!<br>", "Yes", null, "Cancel", new DialogCallback(){

                        @Override
                        public void onClose(DialogCallback.DialogOptions dialogOptions) {
                            if (dialogOptions == DialogCallback.DialogOptions.YES) {
                                dArray[0] = d5;
                                TOAD5TestPanel.testMotor(main, n, (double)machState.getParamInt(15307) * d5);
                            }
                        }
                    });
                } else {
                    TOAD5TestPanel.testMotor(main, n, (double)machState.getParamInt(15307) * d5);
                }
            }
        });
        layout.add(button, "skip 1,align left,wrap");
        return layout;
    }

    public static Layout getTestPanel(Main main) {
        Layout layout = UWKit.newLayout("");
        Layout layout2 = UWKit.newTitledLayout("Inputs");
        Layout layout3 = UWKit.newTitledLayout("Outputs", "flowy,fill");
        Layout layout4 = UWKit.newTitledLayout("Analog I/O", "flowy,fill");
        Layout layout5 = UWKit.newLayout();
        Layout layout6 = UWKit.newLayout();
        MotorController motorController = main.m_MachController.getMotorController();
        TOAD5TestPanel.addInput(layout2, "REFIN-X", () -> motorController.getHomeInput(0));
        TOAD5TestPanel.addInput(layout2, "REFIN-Y", () -> motorController.getHomeInput(1));
        TOAD5TestPanel.addInput(layout2, "REFIN-Z", () -> motorController.getHomeInput(2));
        TOAD5TestPanel.addInput(layout2, "REFIN-A", () -> motorController.getHomeInput(3));
        TOAD5TestPanel.addInput(layout2, "REFIN-B", () -> motorController.getHomeInput(4));
        TOAD5TestPanel.addInput(layout2, "PROBE", () -> motorController.getProbeInput());
        TOAD5TestPanel.addInput(layout2, "ARC-TRANSFER", () -> motorController.getArcTransferInput());
        TOAD5TestPanel.addInput(layout2, "MAN-CTRL", () -> motorController.getIsControllerInManualMode());
        SimpleVariable simpleVariable = new SimpleVariable(false);
        simpleVariable.addObserver(observable -> motorController.setTestMode((Boolean)simpleVariable.getValue()));
        String string = "growx,center";
        layout3.add(UWKit.newToggleButton("button_yellow_low", (Variable)main.m_MachController.getOutputOverrideOn(), "OVERRIDE", (Object)true, (Object)false), string);
        layout3.add(UWKit.newLayout(), "grow,pushy");
        layout3.add(UWKit.newToggleButton("button_blue_low", (Variable)main.m_MachController.getSpindleForwardOverride(), "FORWARD", (Object)true, (Object)false), string);
        layout3.add(UWKit.newToggleButton("button_blue_low", (Variable)main.m_MachController.getSpindleReverseOverride(), "REVERSE", (Object)true, (Object)false), string);
        layout3.add(UWKit.newToggleButton("button_blue_low", (Variable)main.m_MachController.getCoolantOverride(), "COOLANT", (Object)true, (Object)false), string);
        layout3.add(UWKit.newToggleButton("button_blue_low", (Variable)main.m_MachController.getArcStartOverride(), "ARC-START", (Object)true, (Object)false), string);
        layout3.add(UWKit.newToggleButton("button_green_low", (Variable)simpleVariable, "STEP/DIR", (Object)true, (Object)false), string);
        layout3.add(UWKit.newLayout(), "grow,pushy");
        TOAD5TestPanel.addADC(layout5, main);
        TOAD5TestPanel.addDAC(layout6, main.m_MachController.getSpindleSpeedOverride());
        CardLayout cardLayout = UWKit.newCardLayout();
        Object[] objectArray = new String[6];
        for (int i = 0; i < 6; ++i) {
            objectArray[i] = Interpreter.getAxisLetter(i) + "-axis";
            cardLayout.addCard(objectArray[i], TOAD5TestPanel.createTestPane(main, i));
        }
        SimpleVariable simpleVariable2 = new SimpleVariable(objectArray[0]);
        simpleVariable2.addObserver(observable -> cardLayout.selectCard(simpleVariable2.getValue().toString()));
        ComboBox comboBox = UWKit.newComboBox((Variable)simpleVariable2, objectArray, objectArray);
        Layout layout7 = UWKit.newTitledLayout("Motor Test", "flowx");
        layout7.add(UWKit.newLabel("Test:"), "grow,cell 0 0");
        layout7.add(comboBox, "grow,cell 1 0");
        layout7.add(cardLayout, "grow,cell 0 1, span 2");
        layout4.add(layout5, "top");
        layout4.add(layout6, "top");
        layout.add(layout2, "grow");
        layout.add(layout3, "grow");
        layout.add(layout4, "grow");
        layout.add(layout7, "grow");
        return layout;
    }
}

