/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import motorcontrol.MachController;
import toad4.CommandFormatter;
import toad4.ResponseParser;
import toad4.ToadComm;
import toad4.ToadCommSerial;

public class TestToadConnection {
    private static volatile ResponseParser m_Parser = new ResponseParser();
    private static volatile CommandFormatter m_Formatter = new CommandFormatter();
    public static ToadComm m_ToadComm;

    private static void sendCommand(byte[] byArray, int n, byte[] byArray2, int n2, Object object) throws Exception {
        int n3 = 0;
        try {
            m_ToadComm.write(byArray, n);
            n3 = m_ToadComm.read(byArray2, n2);
            System.err.println("got bytes " + n3);
            m_Parser.reset(n3);
        }
        catch (Exception exception) {
            m_ToadComm.flush();
            try {
                throw exception;
            }
            catch (ResponseParser.ChecksumErrorException checksumErrorException) {
                System.err.println("checksum error, retrying ");
            }
            catch (ToadComm.TimeoutException timeoutException) {
                System.err.println("timeout, retrying ");
            }
        }
    }

    private static String getVersionString(int n) throws Exception {
        m_Formatter.reset();
        m_Formatter.appendGetVersion();
        m_Formatter.pack();
        int n2 = m_Formatter.getRespLength();
        int n3 = m_Formatter.getLength();
        if (n == 10) {
            System.err.println("read too little");
            --n2;
        }
        if (n == 20) {
            System.err.println("read too much");
            ++n2;
        }
        if (n == 30) {
            System.err.println("send too little");
            --n3;
        }
        if (n == 40) {
            System.err.println("send too much, ignored by toad?");
            ++n3;
        }
        TestToadConnection.sendCommand(m_Formatter.getBuffer(), n3, m_Parser.getBuffer(), n2, null);
        m_Parser.parseErrCode();
        return m_Parser.parseString();
    }

    public static void tesGt(ToadComm toadComm) {
        try {
            int n;
            int n2;
            int n3;
            MachController machController = new MachController(null, 8, null, null, null, null);
            CommandFormatter commandFormatter = new CommandFormatter();
            ResponseParser responseParser = new ResponseParser();
            String string = TestToadConnection.getVersionString(0);
            for (n3 = 0; n3 < 4; ++n3) {
                commandFormatter.reset();
                commandFormatter.appendGo(n3);
                commandFormatter.appendMode(n3, 15, true, true, 0, 0);
                commandFormatter.pack();
                TestToadConnection.sendCommand(commandFormatter.getBuffer(), commandFormatter.getLength(), responseParser.getBuffer(), commandFormatter.getRespLength(), null);
                responseParser.parseErrCode();
            }
            for (n3 = 0; n3 < 4; ++n3) {
                commandFormatter.reset();
                commandFormatter.appendSetPos(n3, n3);
                commandFormatter.pack();
                TestToadConnection.sendCommand(commandFormatter.getBuffer(), commandFormatter.getLength(), responseParser.getBuffer(), commandFormatter.getRespLength(), null);
                responseParser.parseErrCode();
            }
            for (n3 = 0; n3 < 4; ++n3) {
                commandFormatter.reset();
                commandFormatter.appendMove(0, 100, 1000);
                commandFormatter.appendMove(0, -100, 1000);
                commandFormatter.pack();
                TestToadConnection.sendCommand(commandFormatter.getBuffer(), commandFormatter.getLength(), responseParser.getBuffer(), commandFormatter.getRespLength(), null);
                responseParser.parseErrCode();
            }
            n3 = -1;
            do {
                commandFormatter.reset();
                commandFormatter.appendGetPos(0);
                commandFormatter.appendGetQueueState(0);
                commandFormatter.pack();
                TestToadConnection.sendCommand(commandFormatter.getBuffer(), commandFormatter.getLength(), responseParser.getBuffer(), commandFormatter.getRespLength(), null);
                responseParser.parseErrCode();
                n = responseParser.parseQuadByte();
                responseParser.parseErrCode();
                n2 = responseParser.parseByte();
                int n4 = responseParser.parseByte();
                if (n3 != n2) {
                    System.out.println("pos " + n + " size " + n2 + " cpcty " + n4);
                }
                n3 = n2;
            } while (n2 != 0);
            commandFormatter.reset();
            commandFormatter.appendHome(0, 100, 1000, 10000, 10000);
            commandFormatter.pack();
            TestToadConnection.sendCommand(commandFormatter.getBuffer(), commandFormatter.getLength(), responseParser.getBuffer(), commandFormatter.getRespLength(), null);
            n = -1;
            do {
                commandFormatter.reset();
                commandFormatter.appendGetState(0);
                commandFormatter.pack();
                TestToadConnection.sendCommand(commandFormatter.getBuffer(), commandFormatter.getLength(), responseParser.getBuffer(), commandFormatter.getRespLength(), null);
                responseParser.parseErrCode();
                n2 = responseParser.parseByte();
                if (n2 != n) {
                    System.out.println("state " + n2);
                }
                n = n2;
            } while (n2 != 2 && n2 != 1);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void doTestInputCommand() {
        try {
            while (true) {
                m_Formatter.reset();
                m_Formatter.appendGetInput(0);
                m_Formatter.pack();
                TestToadConnection.sendCommand(m_Formatter.getBuffer(), m_Formatter.getLength(), m_Parser.getBuffer(), m_Formatter.getRespLength(), null);
                m_Parser.parseErrCode();
                int n = m_Parser.parseByte();
                System.out.println("input value = " + n);
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void doTestOutputCommand() {
        try {
            int n = 0;
            while (true) {
                System.out.println("output value = " + n);
                m_Formatter.reset();
                m_Formatter.appendSetOutput(0, n);
                m_Formatter.pack();
                TestToadConnection.sendCommand(m_Formatter.getBuffer(), m_Formatter.getLength(), m_Parser.getBuffer(), m_Formatter.getRespLength(), null);
                m_Parser.parseErrCode();
                n = n == 1 ? 0 : 1;
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void doProbeTest() {
        try {
            System.out.println(System.currentTimeMillis());
            int n = 0;
            m_Formatter.reset();
            m_Formatter.appendGo(n);
            int n2 = 2;
            int n3 = 20;
            m_Formatter.appendMode(n, 15, true, true, 0, 0);
            m_Formatter.appendConfigProbe(0, 0);
            m_Formatter.appendArmProbe(n, 100, 10000);
            int n4 = 2000;
            int n5 = 1118;
            m_Formatter.appendMove(n, n4 * n2, n5 * n2);
            m_Formatter.pack();
            TestToadConnection.sendCommand(m_Formatter.getBuffer(), m_Formatter.getLength(), m_Parser.getBuffer(), m_Formatter.getRespLength(), null);
            m_Parser.parseErrCode();
            int n6 = 0;
            do {
                System.out.println("poll for probe completion");
                Thread.sleep(500L);
                m_Formatter.reset();
                m_Formatter.appendGetQueueState(n);
                m_Formatter.pack();
                TestToadConnection.sendCommand(m_Formatter.getBuffer(), m_Formatter.getLength(), m_Parser.getBuffer(), m_Formatter.getRespLength(), null);
                m_Parser.parseErrCode();
                n6 = m_Parser.parseByte();
                m_Parser.parseByte();
            } while (n6 > 0);
            m_Formatter.reset();
            m_Formatter.appendGetProbePos(n);
            m_Formatter.pack();
            TestToadConnection.sendCommand(m_Formatter.getBuffer(), m_Formatter.getLength(), m_Parser.getBuffer(), m_Formatter.getRespLength(), null);
            m_Parser.parseErrCode();
            int n7 = m_Parser.parseQuadByte();
            if (n7 == Integer.MIN_VALUE) {
                System.out.println("Probe fail");
            } else {
                System.out.println("Probe trig position " + n7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            m_ToadComm = new ToadCommSerial();
            m_ToadComm.openConnection("ttyACM0");
            for (int i = 0; i < 100; ++i) {
                try {
                    String string = TestToadConnection.getVersionString(i % 40 + 1);
                    System.out.println("firmware version: " + string);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception.getClass().getSimpleName() + " " + exception.getMessage());
                    Thread.sleep(500L);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

