/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ToadCommLogger {
    private String m_LogBaseDir;
    private FileOutputStream m_DebugOutStream;
    private File m_DebugOutFile;
    private boolean m_MessageSent;
    private boolean m_LoggingEnabled;

    public ToadCommLogger(String string) {
        this.m_LogBaseDir = string;
    }

    public void enableToadCommLogging(boolean bl) {
        this.m_LoggingEnabled = bl;
        if (!this.m_LoggingEnabled) {
            this.stopLogging();
        }
    }

    public void cleanupLogDir() {
        if (this.m_LogBaseDir == null) {
            return;
        }
        String[] stringArray = new File(this.m_LogBaseDir).list();
        if (stringArray == null) {
            return;
        }
        long l = System.currentTimeMillis();
        for (String string : stringArray) {
            long l2;
            File file = new File(this.m_LogBaseDir + string);
            if (!file.isFile() || (l2 = l - file.lastModified()) <= 604800000L) continue;
            System.out.println("Deleting old log file '" + file.getAbsolutePath() + "' from date " + new Date(file.lastModified()));
            if (file.delete()) continue;
            System.err.println("Failed to delete log file '" + file.getAbsolutePath() + "'");
        }
    }

    public synchronized void startLogging() {
        if (!this.m_LoggingEnabled) {
            return;
        }
        if (this.m_LogBaseDir == null) {
            return;
        }
        if (this.m_DebugOutStream == null) {
            try {
                try {
                    new File(this.m_LogBaseDir).mkdirs();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                String string = new SimpleDateFormat("'debuglog-'yyyy'.'MM'.'dd'-'HH'.'mm'.'ss'.bin'").format(new Date(System.currentTimeMillis()));
                this.m_DebugOutFile = new File(this.m_LogBaseDir + string);
                System.out.println("opening debug log: " + this.m_DebugOutFile.getAbsolutePath());
                this.m_MessageSent = false;
                this.m_DebugOutStream = new FileOutputStream(this.m_DebugOutFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void stopLogging() {
        try {
            if (this.m_DebugOutStream != null) {
                System.out.println("closing debug log: " + this.m_DebugOutFile.getAbsolutePath());
                this.m_DebugOutStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.m_DebugOutStream = null;
        }
    }

    private void logData(byte[] byArray) {
        if (this.m_LoggingEnabled && this.m_DebugOutStream == null) {
            this.startLogging();
        }
        if (this.m_DebugOutStream != null) {
            try {
                if (this.m_DebugOutStream != null && byArray != null) {
                    this.m_DebugOutStream.write(byArray);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void logMessage(byte[] byArray, byte[] byArray2) {
        long l = System.currentTimeMillis();
        byArray[8] = (byte)(l >>> 56);
        byArray[9] = (byte)(l >>> 48);
        byArray[10] = (byte)(l >>> 40);
        byArray[11] = (byte)(l >>> 32);
        byArray[12] = (byte)(l >>> 24);
        byArray[13] = (byte)(l >>> 16);
        byArray[14] = (byte)(l >>> 8);
        byArray[15] = (byte)(l >>> 0);
        this.logData(byArray);
        this.logData(byArray2);
        this.m_MessageSent = true;
    }

    public synchronized void logResponse(byte[] byArray) {
        if (this.m_MessageSent) {
            this.logData(byArray);
        }
    }
}

