/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.opengl.GL;
import com.eazycnc.toolpathrenderer.ToolpathRenderer;
import eazycnc.ToolPathSegment;
import eazycnc.VBODataStore;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class ToolPath
implements ToolpathRenderer {
    private float m_X;
    private float m_Y;
    private float m_Z;
    private float m_dX;
    private float m_dY;
    private int m_PutCount;
    private ToolPathSegment m_CurrentSegment;
    private VBODataStore m_CurrentVBODataStore;
    private LinkedList<VBODataStore> m_FreeVBOs = new LinkedList();
    private double m_Radius = 2.0;
    private ArrayList<ToolPathSegment> m_Segments = new ArrayList();
    private int VBO_SIZE = 0x100000;

    @Override
    public synchronized void resetToolPath() {
        for (ToolPathSegment toolPathSegment : this.m_Segments) {
            this.m_FreeVBOs.add(toolPathSegment.m_VBO);
        }
        this.m_Segments.clear();
        this.m_CurrentSegment = null;
        this.m_CurrentVBODataStore = null;
    }

    private boolean canCombine(float f, float f2, float f3) {
        float f4;
        ++this.m_PutCount;
        float f5 = f - this.m_X;
        float f6 = f2 - this.m_Y;
        float f7 = f3 - this.m_Z;
        float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6);
        if (f8 > 0.0f) {
            float f9 = 1.0f / f8;
            f4 = (f5 *= f9) * this.m_dX + (f6 *= f9) * this.m_dY;
        } else {
            f4 = 1.0f;
        }
        this.m_X = f;
        this.m_Y = f2;
        this.m_Z = f3;
        if (this.m_PutCount > 2 && (double)f7 == 0.0 && (double)f4 > 0.999 && (double)f4 < 1.001) {
            return true;
        }
        this.m_dX = f5;
        this.m_dY = f6;
        return false;
    }

    private boolean ensureSize(int n) {
        if (this.m_CurrentVBODataStore == null || this.m_CurrentVBODataStore.m_Data.capacity() <= this.m_CurrentVBODataStore.m_Data.position() + n) {
            this.m_CurrentVBODataStore = new VBODataStore(ByteBuffer.allocateDirect(this.VBO_SIZE).order(ByteOrder.nativeOrder()).asFloatBuffer());
            if (this.m_CurrentSegment != null) {
                boolean bl = this.m_CurrentSegment.m_SpindleOn;
                boolean bl2 = this.m_CurrentSegment.m_Plan;
                this.newSegment();
                this.m_CurrentSegment.m_Plan = bl2;
                this.m_CurrentSegment.m_SpindleOn = bl;
                return true;
            }
        }
        return false;
    }

    private void newSegment() {
        this.m_CurrentSegment = new ToolPathSegment();
        this.m_CurrentSegment.m_VBO = this.m_CurrentVBODataStore;
        this.m_CurrentSegment.m_DataStart = this.m_CurrentVBODataStore.m_Data.position();
        this.m_Segments.add(this.m_CurrentSegment);
        this.m_PutCount = 0;
    }

    @Override
    public synchronized void concatToolMove(boolean bl, boolean bl2, double d, double[] dArray) {
        float f = (float)dArray[0];
        float f2 = (float)dArray[1];
        float f3 = (float)dArray[2];
        if (bl) {
            this.putCut(bl2, d, f, f2, f3);
        } else {
            this.putPlan(bl2, f, f2, f3);
        }
    }

    public synchronized void putCut(boolean bl, double d, float f, float f2, float f3) {
        int n;
        float f4;
        float f5;
        if (this.ensureSize(36)) {
            this.putCut(bl, d, this.m_X, this.m_Y, this.m_Z);
        }
        if (this.m_CurrentSegment == null || this.m_CurrentSegment.m_Plan || this.m_CurrentSegment.m_SpindleOn != bl || d != this.m_Radius) {
            this.newSegment();
            this.m_CurrentSegment.m_Plan = false;
            this.m_CurrentSegment.m_SpindleOn = bl;
            this.m_Radius = d;
        }
        if (this.m_PutCount == 0 || f3 != this.m_Z) {
            this.m_PutCount = 0;
            this.m_X = f;
            this.m_Y = f2;
            this.m_Z = f3;
        }
        if (!bl) {
            d = 0.2;
        }
        float f6 = this.m_X;
        float f7 = this.m_Y;
        float f8 = this.m_Z;
        boolean bl2 = this.canCombine(f, f2, f3);
        float f9 = this.m_dX;
        float f10 = this.m_dY;
        if ((double)f9 != 0.0 || (double)f10 != 0.0) {
            f5 = -f10;
            f4 = f9;
        } else {
            f9 = 0.0f;
            f10 = 1.0f;
            f5 = 1.0f;
            f4 = 0.0f;
        }
        float f11 = d > 0.0 ? (float)d : 0.1f;
        f5 *= f11;
        f4 *= f11;
        f9 *= f11;
        f10 *= f11;
        float f12 = f3;
        float f13 = 0.70710677f;
        FloatBuffer floatBuffer = this.m_CurrentVBODataStore.m_Data;
        int n2 = floatBuffer.position();
        if (this.m_PutCount == 2) {
            n2 -= 36;
        } else if (bl2) {
            n2 -= 18;
        }
        floatBuffer.position(n2);
        if (!bl2) {
            floatBuffer.put(f6 - f9);
            floatBuffer.put(f7 - f10);
            floatBuffer.put(f12);
            floatBuffer.put(f6 - f9);
            floatBuffer.put(f7 - f10);
            floatBuffer.put(f12);
            floatBuffer.put(f6 - f13 * f9 - f13 * f5);
            floatBuffer.put(f7 - f13 * f10 - f13 * f4);
            floatBuffer.put(f12);
            floatBuffer.put(f6 - f13 * f9 + f13 * f5);
            floatBuffer.put(f7 - f13 * f10 + f13 * f4);
            floatBuffer.put(f12);
            floatBuffer.put(f6 - f5);
            floatBuffer.put(f7 - f4);
            floatBuffer.put(f12);
            floatBuffer.put(f6 + f5);
            floatBuffer.put(f7 + f4);
            floatBuffer.put(f12);
        }
        floatBuffer.put(f - f5);
        floatBuffer.put(f2 - f4);
        floatBuffer.put(f12);
        floatBuffer.put(f + f5);
        floatBuffer.put(f2 + f4);
        floatBuffer.put(f12);
        floatBuffer.put(f + f13 * f9 - f13 * f5);
        floatBuffer.put(f2 + f13 * f10 - f13 * f4);
        floatBuffer.put(f12);
        floatBuffer.put(f + f13 * f9 + f13 * f5);
        floatBuffer.put(f2 + f13 * f10 + f13 * f4);
        floatBuffer.put(f12);
        floatBuffer.put(f + f9);
        floatBuffer.put(f2 + f10);
        floatBuffer.put(f12);
        floatBuffer.put(f + f9);
        floatBuffer.put(f2 + f10);
        floatBuffer.put(f12);
        this.m_CurrentSegment.m_DataEnd = n = floatBuffer.position();
        this.m_CurrentSegment.updateDirty(n2, n);
    }

    public synchronized void putPlan(boolean bl, float f, float f2, float f3) {
        int n;
        if (this.ensureSize(3)) {
            this.putPlan(bl, this.m_X, this.m_Y, this.m_Z);
        }
        if (this.m_CurrentSegment == null || !this.m_CurrentSegment.m_Plan || this.m_CurrentSegment.m_SpindleOn != bl) {
            this.newSegment();
            this.m_CurrentSegment.m_Plan = true;
            this.m_CurrentSegment.m_SpindleOn = bl;
        }
        FloatBuffer floatBuffer = this.m_CurrentVBODataStore.m_Data;
        int n2 = floatBuffer.position();
        if (this.canCombine(f, f2, f3)) {
            n2 -= 3;
        }
        floatBuffer.position(n2);
        floatBuffer.put(f);
        floatBuffer.put(f2);
        floatBuffer.put(f3);
        this.m_CurrentSegment.m_DataEnd = n = floatBuffer.position();
        this.m_CurrentSegment.updateDirty(n2, n);
    }

    @Override
    public synchronized void onOpenGlSurfaceChanged() {
        for (ToolPathSegment toolPathSegment : this.m_Segments) {
            toolPathSegment.m_VBO.m_VBOValid = false;
        }
    }

    @Override
    public synchronized void renderToolPath(boolean bl, GL gL, Vector3f vector3f, Color3f[] color3fArray, float f) {
        boolean bl2 = false;
        if (!this.m_FreeVBOs.isEmpty()) {
            for (VBODataStore object : this.m_FreeVBOs) {
                if (!object.m_VBOValid) continue;
                int[] nArray = new int[]{object.m_VBOBuffer};
                gL.glDeleteBuffers(1, nArray, 0);
            }
            this.m_FreeVBOs.clear();
        }
        boolean bl3 = false;
        gL.glLineWidth(f);
        for (ToolPathSegment toolPathSegment : this.m_Segments) {
            int n;
            Object object;
            int n2 = 0;
            n2 = !bl ? (toolPathSegment.m_SpindleOn ? 0 : 1) : (toolPathSegment.m_SpindleOn ? 2 : 3);
            Color3f color3f = color3fArray[n2];
            gL.glColor3f(color3f.x, color3f.y, color3f.z);
            if (!toolPathSegment.m_VBO.m_VBOValid) {
                object = new int[1];
                gL.glGenBuffers(1, (int[])object, 0);
                toolPathSegment.m_VBO.m_VBOBuffer = object[0];
                toolPathSegment.m_VBO.m_VBOValid = true;
                gL.glBindBuffer(34962, toolPathSegment.m_VBO.m_VBOBuffer);
                n = toolPathSegment.m_VBO.m_Data.position();
                toolPathSegment.m_VBO.m_Data.position(0);
                gL.glBufferData(34962, this.VBO_SIZE, toolPathSegment.m_VBO.m_Data, 35048);
                toolPathSegment.m_VBO.m_Data.position(n);
                gL.glBindBuffer(34962, 0);
            }
            if (toolPathSegment.m_DirtyStart < toolPathSegment.m_DirtyEnd) {
                gL.glBindBuffer(34962, toolPathSegment.m_VBO.m_VBOBuffer);
                object = toolPathSegment.m_VBO.m_Data;
                n = ((Buffer)object).position();
                ((FloatBuffer)object).position(toolPathSegment.m_DirtyStart);
                gL.glBufferSubData(34962, toolPathSegment.m_DirtyStart * 4, (toolPathSegment.m_DirtyEnd - toolPathSegment.m_DirtyStart) * 4, (Buffer)object);
                toolPathSegment.m_DirtyEnd = 0;
                toolPathSegment.m_DirtyStart = 0;
                ((FloatBuffer)object).position(n);
                gL.glBindBuffer(34962, 0);
            }
            gL.glBindBuffer(34962, toolPathSegment.m_VBO.m_VBOBuffer);
            gL.glEnableClientState(32884);
            gL.glVertexPointer(3, 5126, 0, toolPathSegment.m_DataStart * 4);
            int n3 = toolPathSegment.m_DataEnd - toolPathSegment.m_DataStart;
            gL.glDrawArrays(toolPathSegment.m_Plan ? 3 : 5, 0, n3 / 3);
            gL.glDisableClientState(32884);
            gL.glBindBuffer(34962, 0);
        }
    }
}

