/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.uwk.Observable;
import com.eazycnc.uwk.Observer;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.VariableObserver;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.FileDialogCallback;
import com.eazycnc.uwk.widgets.Label;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.TextField;
import com.eazycnc.uwk.widgets.ToggleButton;
import eazycnc.Main;
import eazycnc.gcode.MachState;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedHashMap;
import java.util.Locale;

public class ToolSetupPanel {
    public static Layout newToolOffsetPanel(final Main main, final MachState machState) {
        Variable variable = machState.getDroFormatVariable();
        Layout layout = UWKit.newTitledLayout("Tool Setup", "flowy");
        Layout layout2 = UWKit.newLayout("flowx");
        Layout layout3 = UWKit.newLayout(true);
        Layout layout4 = UWKit.newLayout();
        Button button = UWKit.newButton("Touch");
        Button button2 = UWKit.newButton("button_green", "Touch");
        machState.getVariable(15147).addObserver(new Observer(){
            Integer oldValue = null;

            @Override
            public void valueChanged(Observable observable) {
                Integer n = machState.getParamInt(15147);
                boolean bl = this.oldValue != null && !this.oldValue.equals(n);
                this.oldValue = n;
                if (bl) {
                    machState.setParam(15137, n);
                }
            }
        });
        ToggleButton[] toggleButtonArray = new ToggleButton[5];
        for (int i = 1; i <= toggleButtonArray.length; ++i) {
            toggleButtonArray[i - 1] = UWKit.newToggleButton((Variable)machState.getVariable(15147), i + " (T" + i + ")", (Object)i);
        }
        Layout layout5 = UWKit.newLayout(true, "flowy");
        Label label = UWKit.newLabel("Current Tool:");
        int n = main.compactUI() ? 20 : 24;
        TextField textField = UWKit.newTextField((Variable)machState.getVariable(15147), (double)n, 3, new DecimalFormat("0"), null);
        final SimpleVariable simpleVariable = new SimpleVariable("");
        Label label2 = UWKit.newLabel(simpleVariable);
        Layout layout6 = UWKit.newLayout("flowy,fillx");
        for (int i = 0; i < toggleButtonArray.length; ++i) {
            layout6.add(toggleButtonArray[i], "growx");
        }
        Button button3 = UWKit.newButton("Save\u2026");
        Button button4 = UWKit.newButton("Load\u2026");
        Layout layout7 = UWKit.newLayout("flowy");
        layout7.add(button3, "growx");
        layout7.add(button4, "growx");
        Layout layout8 = UWKit.newLayout("flowy");
        layout8.add(layout6, "growx,gap push");
        if (!main.isAndroid()) {
            layout8.add(layout7, "growx");
        }
        layout3.add(UWKit.newLabel("Diameter:"), new String[0]);
        layout3.add(UWKit.newTextField((Variable)UWKit.divide((Variable)machState.getCurrentToolDiameterVariable(), machState.getVariable(15141)), 16.0, 7, variable, null), new String[0]);
        layout3.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout3.add(UWKit.newLabel("Length:"), new String[0]);
        layout3.add(UWKit.newTextField((Variable)UWKit.divide((Variable)machState.getCurrentToolLengthVariable(), machState.getVariable(15141)), 16.0, 7, variable, null), new String[0]);
        layout3.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout4.add(UWKit.newLabel("Gage Height:"), new String[0]);
        layout4.add(UWKit.newTextField((Variable)machState.getScaledVariable(15153), 16.0, 7, variable, null), new String[0]);
        layout4.add(UWKit.newLabel(machState.getLengthUnit()), "wrap");
        layout5.add(UWKit.newLabel("Set Tool Length"), "cell 1 0,span 3,right,top");
        layout5.add(layout4, "cell 1 1 2 1");
        if (main.compactUI()) {
            layout5.add(UWKit.newPicture("set-height-compact.png"), "cell 2 2");
        } else {
            layout5.add(UWKit.newPicture("set-height.png"), "cell 2 2");
        }
        machState.getVariable(15191).addObserver(observable -> {
            boolean bl = ((SimpleVariable)observable).getValue() == Boolean.TRUE;
            button.setVisible(!bl);
            button2.setVisible(bl);
        });
        layout5.add(button, "cell 2 3,center,hidemode 3,gap 4");
        layout5.add(button2, "cell 2 3,center,hidemode 3,gap 4");
        layout2.add(label, new String[0]);
        layout2.add(textField, new String[0]);
        layout2.add(label2, new String[0]);
        layout.add(layout2, "cell 1 1,span 2");
        layout.add(UWKit.newCheckBox((Variable)machState.getVariable(15191), "Use AUTO TOOL SETTER to Touch"), "cell 3 1,span 1");
        layout.add(layout8, "cell 1 2,top");
        layout.add(layout3, "cell 2 2,growy, spany 2");
        layout.add(layout5, "cell 3 2,spanx 4,growy, spany 2");
        final SimpleVariable simpleVariable2 = new SimpleVariable(0);
        machState.getVariable(15136).addObserver(new Observer(){

            @Override
            public void valueChanged(Observable observable) {
                double d = machState.getParamDouble(15136);
                if (d < 0.0) {
                    simpleVariable2.setValue(-1);
                } else if (d > 0.0) {
                    simpleVariable2.setValue(1);
                } else {
                    simpleVariable2.setValue(0);
                }
            }
        });
        ToggleButton toggleButton = UWKit.newToggleButton((Variable)simpleVariable2, "Off (G40)", (Object)0);
        ToggleButton toggleButton2 = UWKit.newToggleButton((Variable)simpleVariable2, "Left (G41)", (Object)-1);
        ToggleButton toggleButton3 = UWKit.newToggleButton((Variable)simpleVariable2, "Right (G42)", (Object)1);
        Layout layout9 = UWKit.newTitledLayout("Radius comp.", "flowy,fillx");
        layout9.add(toggleButton, "growx");
        layout9.add(toggleButton2, "growx");
        layout9.add(toggleButton3, "growx");
        Layout layout10 = UWKit.newTitledLayout("Length offset", "flowy,fillx");
        final SimpleVariable simpleVariable3 = new SimpleVariable(0);
        machState.getVariable(15137).addObserver(new Observer(){

            @Override
            public void valueChanged(Observable observable) {
                if (machState.getParamInt(15137) != 0) {
                    simpleVariable3.setValue(1);
                } else {
                    simpleVariable3.setValue(0);
                }
            }
        });
        ToggleButton toggleButton4 = UWKit.newToggleButton((Variable)simpleVariable3, "On (G43)", (Object)1);
        ToggleButton toggleButton5 = UWKit.newToggleButton((Variable)simpleVariable3, "Off (G49)", (Object)0);
        layout10.add(toggleButton5, "growx");
        layout10.add(toggleButton4, "growx");
        layout.add(layout9, "cell 7 2,growx,top");
        layout.add(layout10, "cell 7 3,growx,top");
        toggleButton.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                machState.setParam(15136, 0.0);
            }
        });
        toggleButton2.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                if (machState.getParamInt(15101) != 0) {
                    Main.m_MainWindow.setButtonErrorAndBeep("radius compensation only allowed when active plane is XY");
                } else {
                    int n = machState.getParamInt(15147);
                    if (n < 1 || n > 255) {
                        throw new IllegalArgumentException("Current tool value " + n + " is out of range 1 ... 255");
                    }
                    machState.setParam(15136, -machState.getParamDouble(0x40000000, n - 1) / 2.0);
                }
            }
        });
        toggleButton3.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                if (machState.getParamInt(15101) != 0) {
                    Main.m_MainWindow.setButtonErrorAndBeep("radius compensation only allowed when active plane is XY");
                } else {
                    int n = machState.getParamInt(15147);
                    if (n < 1 || n > 255) {
                        throw new IllegalArgumentException("Current tool value " + n + " is out of range 1 ... 255");
                    }
                    machState.setParam(15136, machState.getParamDouble(0x40000000, n - 1) / 2.0);
                }
            }
        });
        toggleButton4.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                int n = machState.getParamInt(15147);
                if (n < 1 || n > 255) {
                    throw new IllegalArgumentException("Current tool value " + n + " is out of range 1 ... 255");
                }
                double d = machState.getParamDouble(0x40000001, n - 1);
                machState.setParam(15137, n);
            }
        });
        toggleButton5.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                machState.setParam(15137, 0);
            }
        });
        VariableObserver variableObserver = new VariableObserver(){

            @Override
            public void valueChanged(Variable variable) {
                int n = machState.getParamInt(15147);
                String string = "(T" + n + " G43 H" + n + ")";
                simpleVariable.setValue(string);
            }
        };
        machState.getVariable(15147).addObserver(variableObserver);
        machState.getVariable(15137).addObserver(variableObserver);
        button.addActionListener(() -> {
            if (main.checkConnected()) {
                main.m_MachController.syncMachStateWithMotorPositions();
                ToolSetupPanel.setToolHeightFromPosition(machState.getLocalPos(2), main);
            }
        });
        button2.addActionListener(() -> {
            if (main.checkConnected()) {
                ToolSetupPanel.runAutoToolSetterScript(main);
            }
        });
        button4.addActionListener(() -> ToolSetupPanel.loadToolSetupFromFile(main));
        button3.addActionListener(() -> ToolSetupPanel.saveToolSetupToFile(main));
        return layout;
    }

    static DecimalFormat getDecimalFormat(String string, String string2) {
        if (",".equals(string)) {
            return new DecimalFormat(string2, new DecimalFormatSymbols(Locale.US));
        }
        if (";".equals(string)) {
            return new DecimalFormat(string2, new DecimalFormatSymbols(Locale.FRENCH));
        }
        throw new IllegalArgumentException("BUG: bad CSV_LIST_ITEM_SEPARATOR " + string);
    }

    static void loadToolSetupFromFile(final Main main) {
        final String string = main.m_MachController.getMachState().getParamString(15301);
        UWKit.showFileDialog(string, false, new FileDialogCallback(){

            @Override
            public void onFileSelected(String string5) {
                if (string5 != null) {
                    int n = 0;
                    try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string5));){
                        int n2;
                        Object object;
                        String string2;
                        MachState machState = main.m_MachController.getMachState();
                        machState.setParam(15301, string);
                        String string3 = machState.getParamString(15351);
                        String string4 = machState.getParamString(15352);
                        DecimalFormat decimalFormat = ToolSetupPanel.getDecimalFormat(string4, string3);
                        double d = machState.getParamDouble(15141);
                        LinkedHashMap<Integer, Double> linkedHashMap = new LinkedHashMap<Integer, Double>();
                        LinkedHashMap<Integer, Double> linkedHashMap2 = new LinkedHashMap<Integer, Double>();
                        while (null != (string2 = bufferedReader.readLine())) {
                            ++n;
                            if (string2.startsWith("#")) continue;
                            object = string2.split(string4);
                            if (((String[])object).length < 2) {
                                throw new IllegalArgumentException("no list separator found (\"" + string4 + "\")");
                            }
                            n2 = 0;
                            try {
                                object[0] = ((String)object[0]).replaceAll("\\s", "");
                                n2 = Integer.parseInt((String)object[0]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException("badly formated tool number");
                            }
                            if (n2 < 1 || n2 > 255) {
                                throw new IllegalArgumentException("illegal tool number (" + n2 + ")");
                            }
                            double d2 = 0.0;
                            try {
                                object[1] = ((String)object[1]).replaceAll("\\s", "");
                                d2 = decimalFormat.parse((String)object[1]).doubleValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException("badly formated diameter value");
                            }
                            double d3 = 0.0;
                            if (((Object)object).length > 2) {
                                try {
                                    object[2] = ((String)object[2]).replaceAll("\\s", "");
                                    d3 = decimalFormat.parse((String)object[2]).doubleValue();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new IllegalArgumentException("badly formated length value");
                                }
                            }
                            if (d2 < 0.0) {
                                throw new IllegalArgumentException("diameter value negative");
                            }
                            if (d3 < 0.0) {
                                throw new IllegalArgumentException("length value negative");
                            }
                            linkedHashMap.put(n2, d2);
                            linkedHashMap2.put(n2, d3);
                        }
                        object = linkedHashMap.keySet().iterator();
                        while (object.hasNext()) {
                            n2 = (Integer)object.next();
                            machState.getVariable(0x40000000, n2 - 1).setValue((Double)linkedHashMap.get(n2) * d);
                        }
                        object = linkedHashMap2.keySet().iterator();
                        while (object.hasNext()) {
                            n2 = (Integer)object.next();
                            machState.getVariable(0x40000001, n2 - 1).setValue((Double)linkedHashMap2.get(n2) * d);
                        }
                        Main.m_MainWindow.setButtonErrorAndBeep("Tool data loaded succesfully from: '" + string5 + "'");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Main.m_MainWindow.setButtonErrorAndBeep("Error loading tool data from file '" + string5 + "' on line " + n + " : " + illegalArgumentException.getMessage());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Main.m_MainWindow.setButtonErrorAndBeep("Opening file '" + string5 + "' failed because it could not be found ");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Main.m_MainWindow.setButtonErrorAndBeep("Opening file failed with exception " + exception);
                    }
                }
            }
        });
    }

    static void saveToolSetupToFile(final Main main) {
        final String string = main.m_MachController.getMachState().getParamString(15301);
        UWKit.showFileDialog(string, true, new FileDialogCallback(){

            @Override
            public void onFileSelected(String object) {
                if (object != null) {
                    String string4 = main.m_MachController.getMachState().getParamString(15350);
                    if (!(new File((String)object).exists() || ((String)object).endsWith(string4) || new File((String)object + string4).exists())) {
                        object = (String)object + string4;
                    }
                    try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter((String)object));){
                        MachState machState = main.m_MachController.getMachState();
                        machState.setParam(15301, string);
                        String string2 = machState.getParamString(15352);
                        String string3 = machState.getParamString(15351);
                        DecimalFormat decimalFormat = ToolSetupPanel.getDecimalFormat(string2, string3);
                        double d = machState.getParamDouble(15141);
                        bufferedWriter.write(String.format("#tool%s diameter%s length", string2, string2));
                        bufferedWriter.newLine();
                        for (int i = 1; i <= 255; ++i) {
                            double d2 = machState.getParamDouble(0x40000000, i - 1);
                            double d3 = machState.getParamDouble(0x40000001, i - 1);
                            bufferedWriter.write(Integer.toString(i));
                            bufferedWriter.write(string2);
                            bufferedWriter.write(" ");
                            bufferedWriter.write(decimalFormat.format(d2 / d));
                            bufferedWriter.write(string2);
                            bufferedWriter.write(" ");
                            bufferedWriter.write(decimalFormat.format(d3 / d));
                            bufferedWriter.newLine();
                        }
                        Main.m_MainWindow.setButtonErrorAndBeep("Tool data saved succesfully to: '" + (String)object + "'");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Main.m_MainWindow.setButtonErrorAndBeep("Opening file '" + (String)object + "' failed because it could not be found ");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                        Main.m_MainWindow.setButtonErrorAndBeep("Opening file failed,  " + illegalArgumentException.getMessage());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Main.m_MainWindow.setButtonErrorAndBeep("Opening file failed with exception " + exception);
                    }
                }
            }
        });
    }

    public static void runAutoToolSetterScript(Main main) {
        boolean bl = main.m_MachController.getMachState().getParamBoolean(15133);
        String string = "G91 F60 G31 Z-10 \n G0 Z10";
        Main.m_MainWindow.execute(string, object -> {
            MachState machState = main.m_MachController.getMachState();
            machState.setParam(15133, bl);
            if (object == null) {
                double d = machState.getParamDouble(2002);
                ToolSetupPanel.setToolHeightFromPosition(d, main);
            }
        });
    }

    public static void setToolHeightFromPosition(double d, Main main) {
        MachState machState = main.m_MachController.getMachState();
        double d2 = d - machState.getParamDouble(15153);
        if (d2 >= 0.0) {
            machState.getCurrentToolLengthVariable().setValue(d2);
        } else {
            Main.m_MainWindow.setButtonErrorAndBeep("'Touching' at current Z-axis position and Gage Height would set tool height to negative value " + d2);
        }
    }
}

