/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.opengl.GL;
import com.eazycnc.opengl.GLShape;
import com.eazycnc.opengl.GLU;
import com.eazycnc.toolpathrenderer.ToolRenderer;
import com.eazycnc.toolpathrenderer.ToolpathRenderer;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.Variable;
import com.eazycnc.uwk.widgets.ActionListener;
import com.eazycnc.uwk.widgets.Button;
import com.eazycnc.uwk.widgets.Layout;
import com.eazycnc.uwk.widgets.OpenGLCanvas;
import eazycnc.AnimationScheduler;
import eazycnc.Main;
import eazycnc.ToolPath;
import eazycnc.Vecmat2JOGL;
import eazycnc.gcode.FilePos;
import eazycnc.gcode.MachState;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class ToolpathDisplayPanel {
    private Variable m_DisplayMode = new SimpleVariable((Object)DispMode.MODE_FREEROTATE);
    private SimpleVariable m_RotateMode = new SimpleVariable(false);
    private Variable m_TrackMode = new SimpleVariable(false);
    private double m_Rotation = Math.toRadians(70.0);
    private double m_Tilt = Math.toRadians(-45.0);
    private double m_Distance = 10.0;
    private float m_Zoom = 1000.0f;
    private float m_ZoomFactor = 1.1f;
    int[] m_ViewPort = new int[4];
    float[] m_ViewMat = new float[16];
    float[] m_ProjectionMat = new float[16];
    private FilePos m_FilePos;
    private Main m_Main;
    private MachState m_State;
    private volatile boolean m_SurfaceChanged;
    private int m_Width;
    private int m_Height;
    private int m_SurfaceWidth;
    private int m_SurfaceHeight;
    private int m_LimitsChanged = 0;
    private OpenGLCanvas m_OpenGLView;
    private static GLU m_GLU;
    private boolean m_FirstRendering = true;
    private boolean m_FirstZoomSet = false;
    private boolean m_GridSet = false;
    private double m_RenderingTime;
    private boolean m_SpindleOn;
    public ToolpathRenderer m_PlannedToolPath;
    public ToolpathRenderer m_MachinedToolPath;
    public ToolpathRenderer m_DebugPath;
    private double[] m_ExtentsMin = new double[3];
    private double[] m_ExtentsMax = new double[3];
    private double[] m_DispGridMin = new double[3];
    private double[] m_DispGridMax = new double[3];
    private double[] m_GridMin = new double[3];
    private double[] m_GridMax = new double[3];
    private double[] m_AxesMinOld = new double[3];
    private double[] m_AxesMaxOld = new double[3];
    private Color3f[] m_AxisColor = new Color3f[3];
    private String[] m_OldAxisColor = new String[3];
    private float[] m_Origin = new float[3];
    private IntBuffer mToolPath;
    private int mToolPathSize;
    Point3f m_LookFrom = new Point3f(0.0f, -1.0f, 0.0f);
    Vector3f m_Up = new Vector3f(0.0f, 0.0f, 1.0f);
    Point3f m_LookAt = new Point3f(0.0f, 0.0f, 0.0f);
    float m_ToolRadius = 0.0f;
    float m_ToolTop = 0.0f;
    GLShape m_ToolShaft;
    GLShape m_ToolEnd;
    GLShape m_Sphere = GLShape.createSphere(0.2f, 16, 16);
    Vector3f[] m_AxisVector = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    GLShape[] m_AxisShaft;
    GLShape[] m_AxisCone;
    GLShape m_OriginSphere;
    float m_IndicatorSize = 0.1f;
    GLShape m_Xindicator = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, this.m_IndicatorSize, 0.0f, 0.0f});
    GLShape m_Yindicator = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 0.0f, this.m_IndicatorSize, 0.0f});
    GLShape m_Zindicator = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.m_IndicatorSize});
    double m_GridSpacing;
    float m_CharWidth = 0.02f;
    float m_CharHeight = 0.04f;
    GLShape m_XLetter = GLShape.createLines(new float[]{-this.m_CharWidth, -this.m_CharHeight, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, -this.m_CharWidth, this.m_CharHeight, 0.0f, this.m_CharWidth, -this.m_CharHeight, 0.0f});
    GLShape m_YLetter = GLShape.createLines(new float[]{0.0f, 0.0f, 0.0f, -this.m_CharWidth, this.m_CharHeight, 0.0f, 0.0f, 0.0f, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -this.m_CharHeight, 0.0f});
    GLShape m_ZLetter = GLShape.createLines(new float[]{-this.m_CharWidth, this.m_CharHeight, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, this.m_CharWidth, this.m_CharHeight, 0.0f, -this.m_CharWidth, -this.m_CharHeight, 0.0f, -this.m_CharWidth, -this.m_CharHeight, 0.0f, this.m_CharWidth, -this.m_CharHeight, 0.0f});
    private double[] m_ToolPos = new double[4];
    private FloatBuffer[] m_GridVertexes = new FloatBuffer[6];
    private FloatBuffer[] m_GridColors = new FloatBuffer[6];
    private ToolRenderer m_ToolRenderer;

    public void setToolPathExtents(double[] dArray, double[] dArray2) {
        for (int i = 0; i < 3; ++i) {
            this.m_ExtentsMin[i] = dArray[i];
            this.m_ExtentsMax[i] = dArray2[i];
        }
    }

    public void setFilePos(FilePos filePos) {
        this.m_FilePos = filePos;
    }

    public void updatePath(boolean bl, boolean bl2, double d, double[] dArray) {
        if (dArray != null) {
            this.m_MachinedToolPath.concatToolMove(bl, bl2, bl2 ? d : 0.2, dArray);
        }
    }

    private void setupViewMatrixes() {
        Matrix4d matrix4d;
        Matrix4d matrix4d2;
        this.m_Width = this.m_OpenGLView.getWidth();
        this.m_Height = this.m_OpenGLView.getHeight();
        this.m_ViewPort[0] = 0;
        this.m_ViewPort[1] = 0;
        this.m_ViewPort[2] = this.m_Width;
        this.m_ViewPort[3] = this.m_Height;
        double[] dArray = this.m_Main.m_MachController.axisPositionFromMotorPosition(this.m_Main.m_MachController.getMotorPosition());
        this.m_ToolPos = dArray;
        if (this.m_DebugPath != null) {
            this.m_DebugPath.concatToolMove(true, true, 0.1, this.m_ToolPos);
        }
        if (this.m_TrackMode.getValue() == Boolean.TRUE) {
            matrix4d2 = new Point3f((float)this.m_ToolPos[0], (float)this.m_ToolPos[1], (float)this.m_ToolPos[2]);
            matrix4d2.sub((Tuple3f)this.m_LookAt);
            this.m_LookAt.add((Tuple3f)matrix4d2);
            this.m_LookFrom.add((Tuple3f)matrix4d2);
        }
        matrix4d2 = new Matrix4d();
        Point3f point3f = new Point3f(this.m_LookFrom);
        Vector3f vector3f = new Vector3f(this.m_Up);
        switch ((DispMode)((Object)this.m_DisplayMode.getValue())) {
            case MODE_FREEROTATE: {
                point3f.sub((Tuple3f)this.m_LookAt);
                matrix4d = new Matrix4d();
                matrix4d.rotX(this.m_Tilt);
                matrix4d.transform(point3f, point3f);
                Matrix4d matrix4d3 = new Matrix4d();
                matrix4d3.rotZ(this.m_Rotation);
                matrix4d3.transform(point3f, point3f);
                break;
            }
            case MODE_XY: {
                vector3f.set(0.0f, 1.0f, 0.0f);
                point3f.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case MODE_ZX: {
                vector3f.set(0.0f, 0.0f, 1.0f);
                point3f.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case MODE_YZ: {
                vector3f.set(0.0f, 0.0f, 1.0f);
                point3f.set(1.0f, 0.0f, 0.0f);
            }
        }
        point3f.add((Tuple3f)this.m_LookAt);
        Vecmat2JOGL.lookAt(matrix4d2, (Tuple3f)point3f, (Tuple3f)this.m_LookAt, (Tuple3f)vector3f);
        matrix4d = new Matrix4d();
        double d = (double)this.m_Width / (double)this.m_Height;
        Vecmat2JOGL.glOrtho(matrix4d, 1.0 * d * (double)this.m_Zoom, -1.0 * d * (double)this.m_Zoom, -1.0 * (double)this.m_Zoom, 1.0 * (double)this.m_Zoom, -1000.0, 1000.0);
        Vecmat2JOGL.setOpenGlMatrixFromMatrix4d(this.m_ViewMat, matrix4d2);
        Vecmat2JOGL.setOpenGlMatrixFromMatrix4d(this.m_ProjectionMat, matrix4d);
    }

    void createGridLines(GL gL, float[] fArray, double d, int n, int n2, int n3, FloatBuffer[] floatBufferArray, FloatBuffer[] floatBufferArray2, int n4) {
        FloatBuffer floatBuffer;
        FloatBuffer floatBuffer2;
        int n5;
        if (d <= 0.0) {
            d = 1.0;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (n5 = 0; n5 < 3; ++n5) {
            dArray[n5] = this.m_DispGridMin[n5] - (double)fArray[n5];
            dArray2[n5] = this.m_DispGridMax[n5] - (double)fArray[n5];
        }
        n5 = (int)Math.floor(dArray[n] / d);
        int n6 = (int)Math.ceil(dArray2[n] / d);
        int n7 = n6 - n5 + 1;
        if (n7 <= 0) {
            floatBufferArray[n4] = null;
            floatBufferArray2[n4] = null;
            return;
        }
        int n8 = 2 * n7 * 3;
        int n9 = 2 * n7 * 4;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n8 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        floatBufferArray[n4] = floatBuffer2 = byteBuffer.asFloatBuffer();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n9 * 4);
        byteBuffer2.order(ByteOrder.nativeOrder());
        floatBufferArray2[n4] = floatBuffer = byteBuffer2.asFloatBuffer();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        vector3f4.set((Tuple3f)this.m_AxisVector[n3]);
        if (n3 == 1) {
            vector3f4.scale((float)(Math.ceil(dArray2[n3] / d) * d) + fArray[n3]);
        } else {
            vector3f4.scale((float)(Math.floor(dArray[n3] / d) * d) + fArray[n3]);
        }
        vector3f.set((Tuple3f)this.m_AxisVector[n2]);
        vector3f.scale((float)(Math.floor(dArray[n2] / d) * d) + fArray[n2]);
        vector3f2.set((Tuple3f)this.m_AxisVector[n2]);
        vector3f2.scale((float)(Math.ceil(dArray2[n2] / d) * d) + fArray[n2]);
        int n10 = 0;
        int n11 = 0;
        float[] fArray2 = new float[n8];
        float[] fArray3 = new float[n9];
        for (int i = n5; i <= n6; ++i) {
            float f;
            float f2;
            float f3;
            float f4 = (float)((double)i * d + (double)fArray[n]);
            vector3f3.set((Tuple3f)this.m_AxisVector[n]);
            vector3f3.scale(f4);
            vector3f3.add((Tuple3f)vector3f);
            vector3f3.add((Tuple3f)vector3f4);
            fArray2[n10++] = vector3f3.x;
            fArray2[n10++] = vector3f3.y;
            fArray2[n10++] = vector3f3.z;
            vector3f3.set((Tuple3f)this.m_AxisVector[n]);
            vector3f3.scale(f4);
            vector3f3.add((Tuple3f)vector3f2);
            vector3f3.add((Tuple3f)vector3f4);
            fArray2[n10++] = vector3f3.x;
            fArray2[n10++] = vector3f3.y;
            fArray2[n10++] = vector3f3.z;
            if (i != 0) {
                f3 = this.m_AxisColor[n3].x * 0.5f;
                f2 = this.m_AxisColor[n3].y * 0.5f;
                f = this.m_AxisColor[n3].z * 0.5f;
            } else {
                f3 = 1.0f;
                f2 = 1.0f;
                f = 1.0f;
            }
            fArray3[n11++] = f3;
            fArray3[n11++] = f2;
            fArray3[n11++] = f;
            fArray3[n11++] = 1.0f;
            fArray3[n11++] = f3;
            fArray3[n11++] = f2;
            fArray3[n11++] = f;
            fArray3[n11++] = 1.0f;
        }
        floatBuffer2.put(fArray2);
        floatBuffer.put(fArray3);
    }

    public void renderGrid(GL gL) {
        int n;
        int n2;
        boolean bl;
        double[] dArray = this.m_State.localToAxisWithoutOffsets(new double[]{0.0, 0.0, 0.0});
        float[] fArray = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
        boolean bl2 = false;
        for (int i = 0; i < 3; ++i) {
            if (this.m_Origin[i] == fArray[i]) continue;
            this.m_Origin[i] = fArray[i];
            bl2 = true;
        }
        double d = this.m_GridSpacing;
        this.m_GridSpacing = this.m_State.getParamDouble(16502);
        boolean bl3 = bl = this.m_GridSpacing != d;
        if (this.m_Main.m_MachController.getMachState().getParamInt(16500) == 1) {
            for (n2 = 0; n2 < 3; ++n2) {
                this.m_DispGridMin[n2] = this.m_ExtentsMin[n2];
                this.m_DispGridMax[n2] = this.m_ExtentsMax[n2];
            }
        } else {
            MachState machState = this.m_Main.m_MachController.getMachState();
            this.m_GridMin[0] = machState.getParamDouble(16503);
            this.m_GridMin[1] = machState.getParamDouble(16504);
            this.m_GridMin[2] = machState.getParamDouble(16506);
            this.m_GridMax[0] = machState.getParamDouble(16507);
            this.m_GridMax[1] = machState.getParamDouble(16508);
            this.m_GridMax[2] = machState.getParamDouble(16509);
            for (n = 0; n < 3; ++n) {
                this.m_DispGridMin[n] = this.m_GridMin[n] + (double)this.m_Origin[n];
                this.m_DispGridMax[n] = this.m_GridMax[n] + (double)this.m_Origin[n];
            }
        }
        this.m_GridSet = true;
        n2 = 0;
        for (n = 0; n < 3; ++n) {
            if (this.m_DispGridMin[n] != this.m_AxesMinOld[n]) {
                this.m_AxesMinOld[n] = this.m_DispGridMin[n];
                n2 = 1;
            }
            if (this.m_DispGridMax[n] == this.m_AxesMaxOld[n]) continue;
            this.m_AxesMaxOld[n] = this.m_DispGridMax[n];
            n2 = 1;
        }
        for (n = 0; n < 3; ++n) {
            int[] nArray = new int[]{15320, 15321, 15322};
            if (this.m_State.getParamString(nArray[n]).equals(this.m_OldAxisColor[n])) continue;
            this.m_OldAxisColor[n] = this.m_State.getParamString(nArray[n]);
            this.m_AxisColor[n] = this.m_State.stringAsColor3f(this.m_OldAxisColor[n]);
            n2 = 1;
        }
        if (n2 != 0 || bl2 || bl) {
            for (n = 0; n < 3; ++n) {
                int n3 = (n + 1) % 3;
                int n4 = (n + 2) % 3;
                this.createGridLines(gL, fArray, this.m_GridSpacing, n, n3, n4, this.m_GridVertexes, this.m_GridColors, n);
                this.createGridLines(gL, fArray, this.m_GridSpacing, n, n4, n3, this.m_GridVertexes, this.m_GridColors, n + 3);
            }
        }
        gL.glLineWidth((float)this.m_State.getParamDouble(16501));
        for (n = 0; n < 6; n += 3) {
            for (int i = 0; i < 3; ++i) {
                FloatBuffer floatBuffer = this.m_GridVertexes[i + n];
                FloatBuffer floatBuffer2 = this.m_GridColors[i + n];
                if (floatBuffer == null) continue;
                floatBuffer.position(0);
                floatBuffer2.position(0);
                gL.glEnableClientState(32884);
                gL.glVertexPointer(3, 5126, 0, floatBuffer);
                gL.glEnableClientState(32886);
                gL.glColorPointer(4, 5126, 0, floatBuffer2);
                gL.glDrawArrays(1, 0, floatBuffer.limit() / 3);
                gL.glDisableClientState(32884);
                gL.glDisableClientState(32886);
            }
        }
        float f = 0.4f;
        this.m_OriginSphere = GLShape.createSphere(f, 16, 16);
        gL.glPushMatrix();
        gL.glTranslatef(fArray[0], fArray[1], fArray[2]);
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        this.m_OriginSphere.render(gL);
        gL.glPopMatrix();
    }

    public void renderLimits(GL gL) {
        int n;
        int n2;
        int n3;
        gL.glLineWidth(1.0f);
        float[] fArray = new float[6];
        for (n3 = 0; n3 < 3; ++n3) {
            if (!this.m_State.getParamBoolean(-2147483640, n3)) continue;
            fArray[n3 * 2 + 0] = (float)this.m_State.getParamDouble(-2147483642, n3);
            fArray[n3 * 2 + 1] = (float)this.m_State.getParamDouble(-2147483641, n3);
        }
        n3 = 12;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * n3 * 3 * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 8; ++n) {
                int n4 = (n << 3) + n >> n2;
                int n5 = n4 >> 2 & 1;
                int n6 = n4 >> 1 & 1;
                int n7 = n4 >> 0 & 1;
                floatBuffer.put(fArray[0 + n5]);
                floatBuffer.put(fArray[2 + n6]);
                floatBuffer.put(fArray[4 + n7]);
            }
        }
        gL.glColor3f(1.0f, 1.0f, 1.0f);
        floatBuffer.position(0);
        gL.glEnableClientState(32884);
        gL.glVertexPointer(3, 5126, 0, floatBuffer);
        for (n2 = 0; n2 < 3; ++n2) {
            n = Main.m_Main.m_MachController.motorFromAxis(n2);
            if (!Main.m_Main.m_MachController.m_MotorController.isPositionReset(n) && System.currentTimeMillis() % 1000L >= 500L) continue;
            gL.glDrawArrays(1, n2 * 8, 8);
        }
        gL.glDisableClientState(32884);
    }

    private static double sqr(double d) {
        return d * d;
    }

    public void renderTool(GL gL, double[] dArray) {
        float f;
        float f2 = (float)Math.abs(this.m_State.getParamDouble(15136));
        int n = this.m_State.getParamInt(15147);
        if (f2 == 0.0f && n > 0) {
            f2 = (float)(this.m_State.getParamDouble(0x40000000, n - 1) / 2.0);
        }
        if (f2 < 0.1f) {
            f2 = 0.1f;
        }
        if ((f = (float)(this.m_State.getParamDouble(15330) / 2.0)) != 0.0f) {
            f2 = f;
        }
        if ((float)this.m_Height / this.m_Zoom * f2 < 2.0f) {
            f2 = 4.0f / ((float)(2 * this.m_Height) / this.m_Zoom);
        }
        if (this.m_ToolShaft == null || this.m_ToolRadius != f2) {
            this.m_ToolShaft = null;
            this.m_ToolEnd = null;
            float f3 = (float)(this.m_DispGridMax[2] - this.m_DispGridMin[2]);
            if (f3 <= 0.0f) {
                f3 = (float)(this.m_GridMax[2] - this.m_GridMin[2]);
            }
            if (f3 > 0.0f && f2 > 0.0f) {
                this.m_ToolShaft = GLShape.createCylinder(f2, f2, f3, 16, 1);
                this.m_ToolEnd = GLShape.createDisk(f2, 16);
            }
        }
        this.m_ToolRadius = f2;
        if (this.m_ToolShaft != null) {
            gL.glPushMatrix();
            gL.glEnable(2903);
            Color3f color3f = this.m_State.stringAsColor3f(this.m_State.getParamString(15331));
            gL.glColor3f(color3f.x, color3f.y, color3f.z);
            gL.glTranslatef((float)dArray[0], (float)dArray[1], (float)dArray[2]);
            this.m_ToolShaft.render(gL);
            gL.glTranslatef(0.0f, 0.0f, 0.0f);
            this.m_ToolEnd.render(gL);
            gL.glTranslatef(0.0f, 0.0f, 3.0f);
            this.m_ToolEnd.render(gL);
            gL.glPopMatrix();
        }
    }

    public void renderAxisIndicators(GL gL) {
        gL.glMatrixMode(5889);
        gL.glLoadMatrixf(this.m_ProjectionMat, 0);
        float f = 1.0f - 2.0f * this.m_IndicatorSize;
        gL.glTranslatef(f * this.m_Zoom * (float)this.m_Width / (float)this.m_Height, f * this.m_Zoom, 0.0f);
        gL.glMatrixMode(5888);
        gL.glLoadMatrixf(this.m_ViewMat, 0);
        gL.glTranslatef(this.m_LookAt.x, this.m_LookAt.y, this.m_LookAt.z);
        gL.glScalef(this.m_Zoom, this.m_Zoom, this.m_Zoom);
        gL.glColor3f(1.0f, 0.0f, 0.0f);
        this.m_Xindicator.render(gL);
        gL.glColor3f(0.0f, 1.0f, 0.0f);
        this.m_Yindicator.render(gL);
        gL.glColor3f(0.0f, 0.0f, 1.0f);
        this.m_Zindicator.render(gL);
        float[] fArray = new float[3];
        int[] nArray = new int[]{-1, -1, 2, 2};
        float[] fArray2 = new float[16];
        System.arraycopy(this.m_ProjectionMat, 0, fArray2, 0, 16);
        Vecmat2JOGL.glTranslate(fArray2, f * this.m_Zoom * (float)this.m_Width / (float)this.m_Height, f * this.m_Zoom, 0.0);
        float[] fArray3 = new float[16];
        System.arraycopy(this.m_ViewMat, 0, fArray3, 0, 16);
        Vecmat2JOGL.glTranslate(fArray3, this.m_LookAt.x, this.m_LookAt.y, this.m_LookAt.z);
        Vecmat2JOGL.glScale(fArray3, this.m_Zoom, this.m_Zoom, this.m_Zoom);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glPushMatrix();
        m_GLU.gluProject(this.m_IndicatorSize * 2.0f, 0.0f, 0.0f, fArray3, 0, fArray2, 0, nArray, 0, fArray, 0);
        gL.glTranslatef(fArray[0], fArray[1], 0.0f);
        gL.glColor3f(1.0f, 0.0f, 0.0f);
        this.m_XLetter.render(gL);
        gL.glPopMatrix();
        gL.glPushMatrix();
        m_GLU.gluProject(0.0f, this.m_IndicatorSize * 2.0f, 0.0f, fArray3, 0, fArray2, 0, nArray, 0, fArray, 0);
        gL.glTranslatef(fArray[0], fArray[1], 0.0f);
        gL.glColor3f(0.0f, 1.0f, 0.0f);
        this.m_YLetter.render(gL);
        gL.glPopMatrix();
        gL.glPushMatrix();
        m_GLU.gluProject(0.0f, 0.0f, this.m_IndicatorSize * 2.0f, fArray3, 0, fArray2, 0, nArray, 0, fArray, 0);
        gL.glTranslatef(fArray[0], fArray[1], 0.0f);
        gL.glColor3f(0.0f, 0.0f, 1.0f);
        this.m_ZLetter.render(gL);
        gL.glPopMatrix();
    }

    public void resetZoom(boolean bl) {
        double[] dArray = bl ? this.m_GridMin : this.m_ExtentsMin;
        double[] dArray2 = bl ? this.m_GridMax : this.m_ExtentsMax;
        this.m_Zoom = 0.0f;
        for (int i = 0; i < 3; ++i) {
            this.m_Zoom = (float)Math.max(dArray2[i] - dArray[i], (double)this.m_Zoom);
        }
        if (this.m_Zoom <= 0.0f) {
            this.m_Zoom = 100.0f;
        }
        this.m_Zoom = (float)((double)this.m_Zoom * 0.6);
        this.m_LookAt.x = (float)(dArray2[0] + dArray[0]) / 2.0f;
        this.m_LookAt.y = (float)(dArray2[1] + dArray[1]) / 2.0f;
        this.m_LookAt.z = (float)(dArray2[2] + dArray[2]) / 2.0f;
        this.m_LookFrom.x = this.m_LookAt.x + 0.0f;
        this.m_LookFrom.y = this.m_LookAt.y - 1.0f;
        this.m_LookFrom.z = this.m_LookAt.z + 0.0f;
        this.m_Rotation = Math.toRadians(30.0);
        this.m_Tilt = Math.toRadians(-45.0);
    }

    private void renderAll(GL gL) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object[] objectArray;
            long l = System.nanoTime();
            if (this.m_FirstRendering) {
                this.m_FirstRendering = false;
                objectArray = new int[]{0};
                object3 = gL.glGetString(7936);
                object2 = gL.glGetString(7937);
                object = gL.glGetString(7938);
                UWKit.scheduleInEDT(new Runnable(){
                    final /* synthetic */ String val$vendor;
                    final /* synthetic */ String val$renderer;
                    final /* synthetic */ String val$version;
                    {
                        this.val$vendor = string;
                        this.val$renderer = string2;
                        this.val$version = string3;
                    }

                    @Override
                    public void run() {
                        Main cfr_ignored_0 = ToolpathDisplayPanel.this.m_Main;
                        Main.m_MainWindow.setGlInfo(this.val$vendor, this.val$renderer, this.val$version);
                    }
                });
            }
            if (!this.m_FirstZoomSet && this.m_GridSet) {
                this.m_FirstZoomSet = true;
                this.resetZoom(true);
            }
            this.setupViewMatrixes();
            gL.glClear(16384);
            gL.glClear(256);
            gL.glDisable(2929);
            gL.glEnable(2848);
            gL.glLineWidth(2.0f);
            gL.glViewport(0, 0, this.m_SurfaceWidth, this.m_SurfaceHeight);
            gL.glMatrixMode(5889);
            gL.glLoadMatrixf(this.m_ProjectionMat, 0);
            gL.glMatrixMode(5888);
            gL.glLoadMatrixf(this.m_ViewMat, 0);
            objectArray = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            object3 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            object2 = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
            gL.glBlendFunc(770, 771);
            gL.glEnable(3042);
            gL.glEnable(2848);
            gL.glLineWidth(1.0f);
            gL.glLightfv(16384, 4609, (float[])objectArray, 0);
            gL.glLightfv(16384, 4608, (float[])object3, 0);
            gL.glEnable(16384);
            gL.glEnable(2896);
            gL.glLightfv(16384, 4611, (float[])object2, 0);
            gL.glEnable(2903);
            object = new float[4];
            float[] fArray = new float[4];
            m_GLU.gluUnProject(0.0f, 0.0f, 0.0f, this.m_ViewMat, 0, this.m_ProjectionMat, 0, this.m_ViewPort, 0, (float[])object, 0);
            m_GLU.gluUnProject(0.0f, 0.0f, 1.0f, this.m_ViewMat, 0, this.m_ProjectionMat, 0, this.m_ViewPort, 0, fArray, 0);
            float f = fArray[0] - object[0];
            float f2 = fArray[1] - object[1];
            float f3 = fArray[2] - object[2];
            float f4 = -((float)Math.sqrt(f * f + f2 * f2 + f3 * f3)) * 10.0f;
            Vector3f vector3f = new Vector3f(f / f4, f2 / f4, f3 / f4);
            gL.glEnable(2929);
            this.renderGrid(gL);
            this.renderLimits(gL);
            gL.glDisable(2929);
            gL.glLineWidth(10.0f);
            if (this.m_SurfaceChanged) {
                this.m_SurfaceChanged = false;
                if (this.m_ToolRenderer != null) {
                    this.m_ToolRenderer.onOpenGlSurfaceChanged();
                }
                this.m_PlannedToolPath.onOpenGlSurfaceChanged();
                this.m_MachinedToolPath.onOpenGlSurfaceChanged();
            }
            Color3f[] color3fArray = new Color3f[]{this.m_State.stringAsColor3f(this.m_State.getParamString(15335)), this.m_State.stringAsColor3f(this.m_State.getParamString(15336)), this.m_State.stringAsColor3f(this.m_State.getParamString(15337)), this.m_State.stringAsColor3f(this.m_State.getParamString(15338))};
            float f5 = (float)this.m_State.getParamDouble(15339);
            this.m_PlannedToolPath.renderToolPath(true, gL, vector3f, color3fArray, f5);
            float f6 = (float)this.m_State.getParamDouble(15340);
            if (f6 == 0.0f) {
                f6 = 1.0f;
            }
            this.m_MachinedToolPath.renderToolPath(false, gL, vector3f, color3fArray, f6);
            Color3f[] color3fArray2 = new Color3f[]{new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 0.0f, 1.0f)};
            if (this.m_DebugPath != null) {
                this.m_DebugPath.renderToolPath(true, gL, vector3f, color3fArray2, 0.1f);
            }
            if (this.m_Main.m_MachController.isConnected()) {
                if (this.m_ToolRenderer != null) {
                    this.m_ToolRenderer.renderTool(gL, this.m_ToolPos);
                } else {
                    this.renderTool(gL, this.m_ToolPos);
                }
            }
            gL.glLineWidth(2.0f);
            gL.glEnable(2929);
            this.renderAxisIndicators(gL);
            long l2 = System.nanoTime();
            this.m_RenderingTime += ((double)(l2 - l) / 1.0E9 - this.m_RenderingTime) / 10.0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    public Layout createDisplayPanel(Main main) {
        this.m_Main = main;
        this.m_State = this.m_Main.m_MachController.getMachState();
        this.m_ToolRenderer = main.m_PluginMethods.onCreateToolRenderer();
        this.m_MachinedToolPath = main.m_PluginMethods.onCreateToolpathRenderer();
        if (this.m_MachinedToolPath == null) {
            this.m_MachinedToolPath = new ToolPath();
        }
        this.m_PlannedToolPath = main.m_PluginMethods.onCreateToolpathRenderer();
        if (this.m_PlannedToolPath == null) {
            this.m_PlannedToolPath = new ToolPath();
        }
        this.m_OpenGLView = UWKit.newOpenGLView();
        m_GLU = this.m_OpenGLView.getGLU();
        Layout layout = UWKit.newTitledLayout("Tool Path", "fill");
        if (main.isAndroid()) {
            layout.add(this.m_OpenGLView, "push,grow,wmin 250, hmin 150");
        } else {
            layout.add(this.m_OpenGLView, "push,grow,wmin 200, hmin 200");
        }
        Layout layout2 = UWKit.newLayout("flowy,fillx");
        layout.add(layout2, "east,gapright 2,gapleft 4,gaptop 0,growx");
        this.m_OpenGLView.setRendererCallback(new OpenGLCanvas.RenderCallback(){

            @Override
            public void onDrawFrame(GL gL) {
                int n = 0;
                n |= 0x100;
                if ((n |= 0x4000) != 0) {
                    gL.glClear(n);
                }
                ToolpathDisplayPanel.this.renderAll(gL);
                AnimationScheduler.scheduleRepaint(ToolpathDisplayPanel.this.m_OpenGLView);
            }

            @Override
            public void onSurfaceChanged(GL gL, int n, int n2) {
                ToolpathDisplayPanel.this.m_Width = n;
                ToolpathDisplayPanel.this.m_Height = n2;
                ToolpathDisplayPanel.this.m_SurfaceHeight = ToolpathDisplayPanel.this.m_OpenGLView.getSurfaceHeight();
                ToolpathDisplayPanel.this.m_SurfaceWidth = ToolpathDisplayPanel.this.m_OpenGLView.getSurfaceWidth();
                ToolpathDisplayPanel.this.m_SurfaceChanged = true;
            }

            @Override
            public void onSurfaceCreate(GL gL) {
                gL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            }
        });
        layout2.add(UWKit.newToggleButton(this.m_TrackMode, "Track", (Object)true, (Object)false), "growx,gapbottom 8");
        Button button = UWKit.newButton("+");
        layout2.add(button, "growx");
        Button button2 = UWKit.newButton("-");
        layout2.add(button2, "growx,gap bottom 8");
        layout2.add(UWKit.newToggleButton(this.m_DisplayMode, "XY", (Object)DispMode.MODE_XY, (Object)DispMode.MODE_FREEROTATE), "growx");
        layout2.add(UWKit.newToggleButton(this.m_DisplayMode, "YZ", (Object)DispMode.MODE_YZ, (Object)DispMode.MODE_FREEROTATE), "growx");
        layout2.add(UWKit.newToggleButton(this.m_DisplayMode, "ZX", (Object)DispMode.MODE_ZX, (Object)DispMode.MODE_FREEROTATE), "growx, gapbottom 8");
        layout2.add(UWKit.newToggleButton((Variable)this.m_RotateMode, "[Rot]", (Object)true, (Object)false), "growx");
        layout2.add(UWKit.newToggleButton((Variable)this.m_RotateMode, "[Pan]", (Object)false, (Object)true), "growx, gapbottom 8");
        button.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                ToolpathDisplayPanel.this.m_Zoom /= ToolpathDisplayPanel.this.m_ZoomFactor;
                ToolpathDisplayPanel.this.m_OpenGLView.repaint();
            }
        });
        button2.addActionListener(new ActionListener(){

            @Override
            public void onAction() {
                ToolpathDisplayPanel.this.m_Zoom *= ToolpathDisplayPanel.this.m_ZoomFactor;
                ToolpathDisplayPanel.this.m_OpenGLView.repaint();
            }
        });
        this.m_OpenGLView.setGestureHandler(new OpenGLCanvas.GestureHandler(){
            int m_PrevX;
            int m_PrevY;

            @Override
            public void onSwipe(boolean bl, int n, int n2, boolean bl2) {
                if (bl) {
                    this.m_PrevX = n;
                    this.m_PrevY = n2;
                }
                if ((bl2 || ToolpathDisplayPanel.this.m_RotateMode.getValue().equals(true)) && (DispMode)((Object)ToolpathDisplayPanel.this.m_DisplayMode.getValue()) == DispMode.MODE_FREEROTATE) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    f = (float)n - (float)this.m_PrevX;
                    f2 = (float)n2 - (float)this.m_PrevY;
                    ToolpathDisplayPanel.this.m_Rotation -= (double)f / 200.0;
                    ToolpathDisplayPanel.this.m_Tilt -= (double)f2 / 100.0;
                    if (ToolpathDisplayPanel.this.m_Tilt > (double)((float)Math.toRadians(89.9))) {
                        ToolpathDisplayPanel.this.m_Tilt = (float)Math.toRadians(89.9);
                    }
                    if (ToolpathDisplayPanel.this.m_Tilt < (double)((float)Math.toRadians(-89.9))) {
                        ToolpathDisplayPanel.this.m_Tilt = (float)Math.toRadians(-89.9);
                    }
                } else {
                    float[] fArray = new float[4];
                    m_GLU.gluUnProject(this.m_PrevX, ToolpathDisplayPanel.this.m_ViewPort[3] - 1 - this.m_PrevY, -0.5f, ToolpathDisplayPanel.this.m_ViewMat, 0, ToolpathDisplayPanel.this.m_ProjectionMat, 0, ToolpathDisplayPanel.this.m_ViewPort, 0, fArray, 0);
                    Vector3f vector3f = new Vector3f(fArray);
                    m_GLU.gluUnProject(n, ToolpathDisplayPanel.this.m_ViewPort[3] - 1 - n2, -0.5f, ToolpathDisplayPanel.this.m_ViewMat, 0, ToolpathDisplayPanel.this.m_ProjectionMat, 0, ToolpathDisplayPanel.this.m_ViewPort, 0, fArray, 0);
                    vector3f.sub((Tuple3f)new Vector3f(fArray));
                    ToolpathDisplayPanel.this.m_LookAt.add((Tuple3f)vector3f);
                    ToolpathDisplayPanel.this.m_LookFrom.add((Tuple3f)vector3f);
                }
                this.m_PrevX = n;
                this.m_PrevY = n2;
                ToolpathDisplayPanel.this.m_OpenGLView.repaint();
            }

            @Override
            public void onPinch(int n) {
                float f = 0.1f;
                if (n > 0) {
                    ToolpathDisplayPanel.this.m_Zoom *= ToolpathDisplayPanel.this.m_ZoomFactor;
                }
                if (n < 0) {
                    ToolpathDisplayPanel.this.m_Zoom /= ToolpathDisplayPanel.this.m_ZoomFactor;
                }
                ToolpathDisplayPanel.this.m_OpenGLView.repaint();
            }
        });
        return layout;
    }

    public synchronized void clearAllToolpaths() {
        this.clearPlannedPath();
        this.clearMachinedPath();
    }

    public synchronized void clearPlannedPath() {
        this.m_PlannedToolPath.resetToolPath();
    }

    public synchronized void clearMachinedPath() {
        this.m_MachinedToolPath.resetToolPath();
        if (this.m_DebugPath != null) {
            this.m_DebugPath.resetToolPath();
        }
    }

    private boolean withInLimits(double[] dArray) {
        return false;
    }

    static enum DispMode {
        MODE_XY,
        MODE_YZ,
        MODE_ZX,
        MODE_FREEROTATE;

    }
}

