/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.UWKit;
import eazycnc.Main;
import eazycnc.gcode.MachState;
import eazycnc.planner.VecMath;

public class TouchPlate {
    static final String NOP = ";\n";
    private int m_NextStep;
    private double[] m_StartPos;
    private double dX;
    private double dY;
    private double dZ;
    private double dD;
    private double R;
    private int ix;
    private int iy;
    private String X;
    private String Y;
    private String Z;
    private double m_ProbedZ;
    private double[] m_ProbedP0;
    private double[] m_ProbedP1;
    private double[] m_ProbedP2;
    private double m_SavedRotation;
    private double m_SavedOffsetX;
    private double m_SavedOffsetY;
    private double m_SavedOffsetZ;
    private double m_NewRotation;
    private boolean m_ProbeZ = true;
    private boolean m_ProbeRot = true;
    private double m_EdgeH = 5.0;
    private double m_EdgeV = 5.0;
    private double m_ToolR = 3.0;
    private Capture m_Capture;

    public void startTouch(Main main, Corner corner) {
        this.m_NextStep = 0;
        if (ConnectionState.SIMULATION == main.m_MachController.getConnectionState()) {
            this.m_NextStep = -1;
        }
        this.saveWorkOffset(main.m_MachController.getMachState());
        main.m_MachController.syncMachStateWithMotorPositions();
        this.m_StartPos = main.m_MachController.m_MachState.getAxisPos();
        MachState machState = main.m_MachController.getMachState();
        double d = machState.getParamDouble(15213);
        double d2 = machState.getParamDouble(15213);
        this.dZ = machState.getParamDouble(15212);
        this.dD = machState.getParamDouble(15214);
        if (!machState.getParamBoolean(15206)) {
            this.R = machState.getParamDouble(15211);
        }
        d = 10.0;
        d2 = 10.0;
        this.dZ = 15.0;
        this.dD = 30.0;
        this.Z = "Z";
        switch (corner) {
            case BOTTOM_LEFT: {
                this.X = "X";
                this.Y = "Y";
                this.dX = d;
                this.dY = d2;
                this.ix = 0;
                this.iy = 1;
                break;
            }
            case BOTTOM_RIGHT: {
                this.X = "Y";
                this.Y = "X";
                this.dX = -d2;
                this.dY = d;
                this.ix = 1;
                this.iy = 0;
                break;
            }
            case TOP_LEFT: {
                this.X = "Y";
                this.Y = "X";
                this.dX = d2;
                this.dY = -d;
                this.ix = 1;
                this.iy = 0;
                break;
            }
            case TOP_RIGHT: {
                this.X = "X";
                this.Y = "Y";
                this.dX = -d;
                this.dY = -d2;
                this.ix = 0;
                this.iy = 1;
            }
        }
        this.m_EdgeH = machState.getParamDouble(15208);
        this.m_EdgeV = machState.getParamDouble(15207);
        this.m_ToolR = machState.getParamDouble(15211) / 2.0;
        UWKit.showConfirmDialog("Touch Plate Probing", "Confirm Touch Plate Probin?<br><br>Pressing 'Yes' will start the probing.", "Yes", null, "Cancel", dialogOptions2 -> {
            if (dialogOptions2 == DialogCallback.DialogOptions.YES) {
                this.executeNextStep(main);
                UWKit.showInformationDialog("Touch Plate Probing", "Probing in progress.<br><br>Press Cancel to STOP", null, null, "Cancel", dialogOptions -> {
                    this.m_NextStep = 99;
                    main.m_MachController.stopCycle();
                });
            }
        });
    }

    private void saveWorkOffset(MachState machState) {
        int n = machState.getWorkOffsetBaseIndex();
        this.m_SavedRotation = machState.getParamDouble(n + 19);
        this.m_SavedOffsetX = machState.getParamDouble(n + 0);
        this.m_SavedOffsetY = machState.getParamDouble(n + 1);
        this.m_SavedOffsetZ = machState.getParamDouble(n + 2);
        machState.setParam(n + 19, 0);
        machState.setParam(n + 0, 0);
        machState.setParam(n + 1, 0);
        machState.setParam(n + 2, 0);
    }

    private void restoreWorkOffset(MachState machState) {
        int n = machState.getWorkOffsetBaseIndex();
        machState.setParam(n + 19, this.m_SavedRotation);
        machState.setParam(n + 0, this.m_SavedOffsetX);
        machState.setParam(n + 1, this.m_SavedOffsetY);
        machState.setParam(n + 2, this.m_SavedOffsetZ);
    }

    private void executeNextStep(Main main) {
        double d = 20.0;
        Object object2 = "";
        MachState machState = main.m_MachController.getMachState();
        double d2 = this.m_StartPos[this.ix];
        double d3 = this.m_StartPos[this.iy];
        double d4 = this.m_StartPos[2];
        switch (this.m_NextStep++) {
            case -1: {
                object2 = "G0 X25 Y15 Z15";
                break;
            }
            case 0: {
                main.m_MachController.syncMachStateWithMotorPositions();
                this.m_StartPos = main.m_MachController.m_MachState.getAxisPos();
                if (!this.m_ProbeZ) {
                    object2 = NOP;
                    break;
                }
                object2 = (String)object2 + "F60 G31" + this.Z + (d4 - this.dZ) + "\n";
                object2 = (String)object2 + "G0" + this.Z + d4 + "\n";
                this.m_Capture = Capture.PZ;
                break;
            }
            case 1: {
                object2 = (String)object2 + "G0" + this.X + (d2 - this.dX) + "\n";
                object2 = (String)object2 + "G0" + this.Z + (d4 - this.dZ) + "\n";
                object2 = (String)object2 + "G31" + this.X + d2 + "\n";
                object2 = (String)object2 + "G0" + this.X + (d2 - this.dX) + "\n";
                object2 = (String)object2 + "G0" + this.Z + d4 + "\n";
                object2 = (String)object2 + "G0" + this.X + d2 + "\n";
                this.m_Capture = Capture.P0;
                break;
            }
            case 2: {
                object2 = (String)object2 + "G0" + this.Y + (d3 - this.dY) + "\n";
                object2 = (String)object2 + "G0" + this.Z + (d4 - this.dZ) + "\n";
                object2 = (String)object2 + "G31" + this.Y + d3 + "\n";
                object2 = (String)object2 + "G0" + this.Y + (d3 - this.dY) + "\n";
                object2 = (String)object2 + "G0" + this.Z + d4 + "\n";
                object2 = (String)object2 + "G0" + this.Y + d3 + "\n";
                this.m_Capture = Capture.P1;
                break;
            }
            case 3: {
                if (!this.m_ProbeRot) {
                    object2 = NOP;
                    break;
                }
                object2 = (String)object2 + "G0" + this.X + (d2 + this.dD) + "\n";
                object2 = (String)object2 + "G0" + this.Y + (d3 - this.dY) + "\n";
                object2 = (String)object2 + "G0" + this.Z + (d4 - this.dZ) + "\n";
                object2 = (String)object2 + "G31" + this.Y + (d3 + this.dY) + "\n";
                object2 = (String)object2 + "G0" + this.Z + d4 + "\n";
                object2 = (String)object2 + "G0" + this.Y + d3 + "\n";
                this.m_Capture = Capture.P2;
                break;
            }
            case 4: {
                double d5;
                double d6;
                object2 = (String)object2 + "G0 X" + d2 + "\n";
                if (this.m_ProbeRot) {
                    d6 = this.m_ProbedP2[this.ix] - this.m_ProbedP1[this.ix];
                    d5 = this.m_ProbedP2[this.iy] - this.m_ProbedP1[this.iy];
                } else {
                    d6 = Math.cos(this.m_SavedRotation);
                    d5 = Math.sin(this.m_SavedRotation);
                }
                this.m_NewRotation = Math.atan2(d5, d6);
                System.out.println("angle is " + Math.toDegrees(this.m_NewRotation));
                double d7 = 1.0 / Math.sqrt(d6 * d6 + d5 * d5);
                double d8 = this.m_EdgeH;
                double d9 = this.m_EdgeV;
                double[] dArray = new double[]{-(d5 *= d7), d6 *= d7};
                double[] dArray2 = new double[]{this.m_ProbedP1[this.ix] + (d8 + this.R) * dArray[0], this.m_ProbedP1[this.iy] + (d8 + this.R) * dArray[1]};
                double[] dArray3 = new double[]{d6, d5};
                double[] dArray4 = new double[]{this.m_ProbedP0[this.ix] + (d9 + this.R) * dArray3[0], this.m_ProbedP0[this.iy] + (d9 + this.R) * dArray3[1]};
                double[] dArray5 = new double[2];
                if (!VecMath.lineLineIntersection(dArray5, dArray2, dArray3, dArray4, dArray)) break;
                object2 = (String)object2 + "G0 X" + dArray5[this.ix] + " Y" + dArray5[this.iy] + "\n";
                break;
            }
            case 5: {
                int n = machState.getWorkOffsetBaseIndex();
                machState.setParam(n + 19, this.m_NewRotation);
                main.m_MachController.syncMachStateWithMotorPositions();
                machState.setWorkOffsetFromLocal(0, 0.0);
                machState.setWorkOffsetFromLocal(1, 0.0);
                machState.setWorkOffsetFromLocal(2, d4 - this.m_ProbedZ);
                UWKit.closeDialog();
                break;
            }
            case 99: {
                this.restoreWorkOffset(main.m_MachController.getMachState());
                UWKit.closeDialog();
            }
        }
        if (!((String)object2).isEmpty()) {
            object2 = (String)object2 + "M2 \n";
            System.out.println("script\n" + (String)object2);
            boolean bl = machState.getParamBoolean(15133);
            Main.m_MainWindow.execute((String)object2, object -> {
                main.m_MachController.getMachState().setParam(15133, bl);
                if (object == null) {
                    double[] dArray = main.m_MachController.getProbedPosition();
                    if (dArray == null && this.m_Capture != null) {
                        System.err.println("Probing script failed!");
                    }
                    if (this.m_Capture != null) {
                        if (dArray == null) {
                            System.err.println("Probing script failed!");
                        } else {
                            switch (this.m_Capture) {
                                case PZ: {
                                    this.m_ProbedZ = dArray[2];
                                    break;
                                }
                                case P0: {
                                    this.m_ProbedP0 = dArray;
                                    break;
                                }
                                case P1: {
                                    this.m_ProbedP1 = dArray;
                                    break;
                                }
                                case P2: {
                                    this.m_ProbedP2 = dArray;
                                }
                            }
                        }
                    }
                    this.m_Capture = null;
                } else {
                    this.m_NextStep = 99;
                }
                UWKit.scheduleInEDT(() -> this.executeNextStep(main));
            });
        }
    }

    static enum Corner {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        TOP_RIGHT;

    }

    public static enum Capture {
        PZ,
        P0,
        P1,
        P2;

    }
}

