/*
 * Decompiled with CFR 0.152.
 */
package eazycnc;

import com.eazycnc.plugin.ConnectionState;
import com.eazycnc.uwk.DialogCallback;
import com.eazycnc.uwk.NumericVariable;
import com.eazycnc.uwk.SimpleVariable;
import com.eazycnc.uwk.UWKit;
import com.eazycnc.uwk.widgets.ActionListener;
import eazycnc.Main;
import eazycnc.gcode.MachState;
import eazycnc.pendant.Pendant;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import motorcontrol.MachiningState;

public class UserActions {
    private Main m_Main;
    private Hashtable<String, Action> m_NameToActionMap;
    public Action m_Action_RUN;
    public Action m_Action_HOLD;
    public Action m_Action_RUN_HOLD_TOGGLE;
    public Action m_Action_STOP;
    public Action m_Action_REVERSE;
    public Action m_Action_STEP;
    public Action m_Action_COOLANT;
    public Action m_Action_COOLANT_ON;
    public Action m_Action_COOLANT_OFF;
    public Action m_Action_SPINDLE;
    public Action m_Action_SPINDLE_ON;
    public Action m_Action_SPINDLE_OFF;
    public Action m_Action_SPINDLE_MINUS;
    public Action m_Action_SPINDLE_PLUS;
    public Action m_Action_SPINDLE_REVERSE;
    public Action m_Action_SPINDLE_REVERSE_ON;
    public Action m_Action_SPINDLE_REVERSE_OFF;
    public Action m_Action_OVERRIDE;
    public Action m_Action_OVERRIDE_MINUS;
    public Action m_Action_OVERRIDE_PLUS;
    public Action m_Action_JOG_X_MINUS;
    public Action m_Action_JOG_X_STOP;
    public Action m_Action_JOG_X_PLUS;
    public Action m_Action_JOG_Y_MINUS;
    public Action m_Action_JOG_Y_STOP;
    public Action m_Action_JOG_Y_PLUS;
    public Action m_Action_JOG_Z_MINUS;
    public Action m_Action_JOG_Z_STOP;
    public Action m_Action_JOG_Z_PLUS;
    public Action m_Action_JOG_A_MINUS;
    public Action m_Action_JOG_A_STOP;
    public Action m_Action_JOG_A_PLUS;
    public Action m_Action_SHIFT_LOCK;
    public Action m_Action_AUTO_RUN;
    public Action m_Action_MPG_RUN_HOLD_TOGGLE;
    public Action m_Action_MPG_STOP;
    public Action m_Action_MPG_SPINDLE_TOGGLE;
    public Action m_Action_MPG_GOTO_ORIGIN_XY;
    public Action m_Action_MPG_GOTO_SAFE_Z;
    public Action m_Action_MPG_PROBE_ORIGIN;
    public Action m_Action_MPG_PROBE_Z;
    public Action m_Action_MPG_HOME;
    public Action m_Action_MPG_ZERO;
    public Action m_Action_MPG_EDGE;
    public Action m_Action_MPG_STEP;
    public Action m_Action_MPG_NEXT_TOOL;

    public UserActions(Main main) {
        this.m_Main = main;
        MachState machState = this.m_Main.m_MachController.getMachState();
        this.m_NameToActionMap = new Hashtable();
        this.createAllActions();
    }

    public String[] getActionNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.m_NameToActionMap.keySet());
        Collections.sort(linkedList);
        return linkedList.toArray(new String[0]);
    }

    public Action getActionByName(String string) {
        return this.m_NameToActionMap.get(string);
    }

    private Action add(String string, Action action) {
        if (this.m_NameToActionMap.contains(string)) {
            throw new IllegalArgumentException("duplicate action name");
        }
        this.m_NameToActionMap.put(string, action);
        return action;
    }

    private void createAllActions() {
        this.m_Action_RUN = this.add("RUN", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.startCycle(true);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_HOLD = this.add("HOLD", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.pauseCycle();
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_STOP = this.add("STOP", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.stopAutoRun();
                UserActions.this.m_Main.m_MachController.stopCycle();
                UserActions.this.m_Main.m_MachController.stopEverything();
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_REVERSE = this.add("REVERSE", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.setRunReverse(!UserActions.this.m_Main.m_MachController.getRunReverse());
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_STEP = this.add("STEP", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.setSingleStepMode(!UserActions.this.m_Main.m_MachController.getSingleStepMode());
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_RUN_HOLD_TOGGLE = this.add("RUN_HOLD_TOGGLE", new Action(){

            @Override
            public void onPressed() {
                MachiningState machiningState = UserActions.this.m_Main.m_MachController.getMachiningState();
                if (machiningState == MachiningState.PAUSED || machiningState == MachiningState.STOPPED) {
                    UserActions.this.m_Main.m_MachController.startCycle(true);
                } else if (machiningState == MachiningState.RUNNING) {
                    UserActions.this.m_Main.m_MachController.pauseCycle();
                } else {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.setButtonErrorAndBeep("Can't toggle RUN and HOLD as the machine state is neither");
                }
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_COOLANT_OFF = this.add("COOLANT_OFF", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15124);
                simpleVariable.setValue(false);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_COOLANT_ON = this.add("COOLANT_ON", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15124);
                simpleVariable.setValue(true);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_COOLANT = this.add("COOLANT_TOGGLE", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15124);
                simpleVariable.setValue(Boolean.FALSE.equals(simpleVariable.getValue()));
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE = this.add("SPINDLE_TOGGLE", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15126);
                simpleVariable.setValue(Boolean.FALSE.equals(simpleVariable.getValue()));
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_ON = this.add("SPINDLE_ON", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15126);
                simpleVariable.setValue(true);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_OFF = this.add("SPINDLE_OFF", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15126);
                simpleVariable.setValue(false);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_REVERSE_ON = this.add("SPINDLE_REVERSE_ON", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15128);
                simpleVariable.setValue(2);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_REVERSE_OFF = this.add("SPINDLE_REVERSE_OFF", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15128);
                simpleVariable.setValue(1);
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_REVERSE = this.add("SPINDLE_REVERSE", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15128);
                simpleVariable.setValue(Boolean.FALSE.equals(simpleVariable.getValue()));
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_PLUS = this.add("SPINDLE_OVERRIDE_PLUS", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.getMachState().setParam(15162, true);
                NumericVariable numericVariable = (NumericVariable)UserActions.this.m_Main.m_MachController.getMachState().getVariable(15161);
                double d = numericVariable.doubleValue();
                double d2 = UserActions.this.m_Main.m_MachController.getMachState().getParamDouble(15157);
                double d3 = UserActions.this.m_Main.m_MachController.getMachState().getParamDouble(15158);
                if (d < d2) {
                    if ((d += d3) > d2) {
                        d = d2;
                    }
                    numericVariable.setValue(d);
                } else {
                    UWKit.beep();
                }
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_SPINDLE_MINUS = this.add("SPINDLE_OVERRIDE_MINUS", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.getMachState().setParam(15162, true);
                NumericVariable numericVariable = (NumericVariable)UserActions.this.m_Main.m_MachController.getMachState().getVariable(15161);
                double d = numericVariable.doubleValue();
                double d2 = UserActions.this.m_Main.m_MachController.getMachState().getParamDouble(15156);
                double d3 = UserActions.this.m_Main.m_MachController.getMachState().getParamDouble(15158);
                if (d > d2) {
                    if ((d -= d3) < d2) {
                        d = d2;
                    }
                    numericVariable.setValue(d);
                } else {
                    UWKit.beep();
                }
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_OVERRIDE = this.add("FEED_OVERRIDE", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15131);
                simpleVariable.setValue(Boolean.FALSE.equals(simpleVariable.getValue()));
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_OVERRIDE_PLUS = this.add("FEED_OVERRIDE_PLUS", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.getMachState().setParam(15131, true);
                NumericVariable numericVariable = (NumericVariable)UserActions.this.m_Main.m_MachController.getMachState().getVariable(15132);
                double d = numericVariable.doubleValue();
                if (d < 3.0) {
                    if ((d += 0.1) >= 3.0) {
                        d = 3.0;
                    }
                    numericVariable.setValue(d);
                } else {
                    UWKit.beep();
                }
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_OVERRIDE_MINUS = this.add("FEED_OVERRIDE_MINUS", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.m_MachController.getMachState().setParam(15131, true);
                NumericVariable numericVariable = (NumericVariable)UserActions.this.m_Main.m_MachController.getMachState().getVariable(15132);
                double d = numericVariable.doubleValue();
                if (d > 0.1) {
                    if ((d -= 0.1) <= 0.1) {
                        d = 0.1;
                    }
                    numericVariable.setValue(d);
                } else {
                    UWKit.beep();
                }
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_JOG_X_MINUS = this.add("JOG_X_MINUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(0, false);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonXMinus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonXMinus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(0);
                }
            }
        });
        this.m_Action_JOG_X_PLUS = this.add("JOG_X_PLUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(0, true);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonXPlus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonXPlus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(0);
                }
            }
        });
        this.m_Action_JOG_Y_MINUS = this.add("JOG_Y_MINUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(1, false);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonYMinus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonYMinus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(1);
                }
            }
        });
        this.m_Action_JOG_Y_PLUS = this.add("JOG_Y_PLUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(1, true);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonYPlus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonYPlus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(1);
                }
            }
        });
        this.m_Action_JOG_Z_MINUS = this.add("JOG_Z_MINUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(2, false);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonZMinus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonZMinus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(2);
                }
            }
        });
        this.m_Action_JOG_Z_PLUS = this.add("JOG_Z_PLUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(2, true);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonZPlus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonZPlus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(2);
                }
            }
        });
        this.m_Action_JOG_A_MINUS = this.add("JOG_A_MINUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                if (UserActions.this.m_Main.m_MachController.isPairXA()) {
                    throw new Exception("A-axis jogging not available because the motor is paired with X-axis");
                }
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(3, false);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonAMinus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonAMinus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(3);
                }
            }
        });
        this.m_Action_JOG_A_PLUS = this.add("JOG_A_PLUS", new Action(){
            boolean m_JogOn;

            @Override
            public void onPressed() throws Exception {
                if (UserActions.this.m_Main.m_MachController.isPairXA()) {
                    throw new Exception("A-axis jogging not available because the motor is paired with X-axis");
                }
                this.m_JogOn = UserActions.this.m_Main.m_MachController.startJog(3, true);
                if (this.m_JogOn) {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonAPlus.setSelected(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
                if (this.m_JogOn) {
                    this.m_JogOn = false;
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.m_JogButtonAPlus.setSelected(false);
                    UserActions.this.m_Main.m_MachController.stopJog(3);
                }
            }
        });
        this.m_Action_SHIFT_LOCK = this.add("SHIFT_LOCK", new Action(){

            @Override
            public void onPressed() throws Exception {
                Main cfr_ignored_0 = UserActions.this.m_Main;
                Main cfr_ignored_1 = UserActions.this.m_Main;
                Main.m_Joystick.setShiftLock(!Main.m_Joystick.getShiftLock());
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_AUTO_RUN = new Action(){

            @Override
            public void onPressed() throws Exception {
                UserActions.this.m_Main.m_MachController.checkStartCyclePrerequisites();
                UWKit.showConfirmDialog("Confirm Test Run", "Are you sure you want to RUN the G-code ad infinitum?", "Yes", null, "Cancel", new DialogCallback(){

                    @Override
                    public void onClose(DialogCallback.DialogOptions dialogOptions) {
                        if (dialogOptions == DialogCallback.DialogOptions.YES && (UserActions.this.m_Main.m_MachController.getConnectionState() == ConnectionState.CONNECTED || UserActions.this.m_Main.m_MachController.getConnectionState() == ConnectionState.SIMULATION) && UserActions.this.m_Main.m_MachController.getMachiningState() == MachiningState.STOPPED) {
                            UWKit.scheduleInEDT(() -> UserActions.this.m_Main.startAutoRun());
                        }
                    }
                });
            }

            @Override
            void onReleased() throws Exception {
            }
        };
        this.m_Action_MPG_GOTO_ORIGIN_XY = this.add("MPG_GOTO_ORIGIN_XY", new Action(){

            @Override
            public void onPressed() throws Exception {
                Main cfr_ignored_0 = UserActions.this.m_Main;
                Main.m_MainWindow.gotoXYOrigin();
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_GOTO_SAFE_Z = this.add("MPG_GOTO_SAFE_Z", new Action(){

            @Override
            public void onPressed() throws Exception {
                Main cfr_ignored_0 = UserActions.this.m_Main;
                Main.m_MainWindow.gotoSafeZ();
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_PROBE_ORIGIN = this.add("MPG_PROBE_ORIGIN", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgProbeOrigin();
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_PROBE_Z = this.add("MPG_PROBE_Z", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgProbeZ(false);
                }
            }

            public void pressedLong(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgProbeZ(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_HOME = this.add("MPG_HOME", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgHome(false);
                }
            }

            @Override
            public void onPressedLong(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgHome(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_ZERO = this.add("MPG_ZERO", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgZERO();
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_EDGE = this.add("MPG_EDGE", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgEdge();
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_STEP = this.add("MPG_STEP", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgNextStepMultiplier();
                }
            }

            @Override
            public void onPressedLong(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgResetStepMultiplier();
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_NEXT_TOOL = this.add("MPG_NEXT_TOOL", new Action(){

            @Override
            public void onPressed(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgNextTool(false);
                }
            }

            @Override
            public void onPressedLong(Object object) throws Exception {
                if (object instanceof Pendant) {
                    ((Pendant)object).onMpgNextTool(true);
                }
            }

            @Override
            public void onReleased() throws Exception {
            }
        });
        this.m_Action_MPG_RUN_HOLD_TOGGLE = this.add("MPG_RUN_HOLD_TOGGLE", new Action(){

            @Override
            public void onPressed() {
                MachiningState machiningState = UserActions.this.m_Main.m_MachController.getMachiningState();
                if (machiningState == MachiningState.PAUSED || machiningState == MachiningState.STOPPED) {
                    UserActions.this.m_Main.m_MachController.startCycle(true);
                } else if (machiningState == MachiningState.RUNNING) {
                    UserActions.this.m_Main.m_MachController.pauseCycle();
                } else {
                    Main cfr_ignored_0 = UserActions.this.m_Main;
                    Main.m_MainWindow.setButtonErrorAndBeep("Can't toggle RUN and HOLD as the machine state is neither");
                }
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_MPG_STOP = this.add("MPG_STOP", new Action(){

            @Override
            public void onPressed() {
                UserActions.this.m_Main.stopAutoRun();
                UserActions.this.m_Main.m_MachController.stopCycle();
                UserActions.this.m_Main.m_MachController.stopEverything();
            }

            @Override
            public void onReleased() {
            }
        });
        this.m_Action_MPG_SPINDLE_TOGGLE = this.add("MPG_SPINDLE_TOGGLE", new Action(){

            @Override
            public void onPressed() {
                SimpleVariable simpleVariable = UserActions.this.m_Main.m_MachController.getMachState().getVariable(15126);
                simpleVariable.setValue(Boolean.FALSE.equals(simpleVariable.getValue()));
            }

            @Override
            public void onReleased() {
            }
        });
    }

    public abstract class Action
    implements ActionListener {
        void onPressed(Object object) throws Exception {
            this.onPressed();
        }

        void onReleased(Object object) throws Exception {
            this.onReleased();
        }

        void onPressedLong(Object object) throws Exception {
            this.onPressedLong();
        }

        void onPressed() throws Exception {
        }

        void onReleased() throws Exception {
        }

        void onPressedLong() throws Exception {
        }

        @Override
        public void onAction() {
            this.callOnPressed(null);
        }

        public void callOnPressed(Object object) {
            try {
                this.onPressed(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main cfr_ignored_0 = UserActions.this.m_Main;
                Main.m_MainWindow.setButtonErrorAndBeep(illegalArgumentException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Main cfr_ignored_1 = UserActions.this.m_Main;
                Main.m_MainWindow.setButtonErrorAndBeep("EXCEPTION " + exception.getClass().getSimpleName() + " press F12 for console");
            }
        }

        public void callOnReleased(Object object) {
            try {
                this.onReleased(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main cfr_ignored_0 = UserActions.this.m_Main;
                Main.m_MainWindow.setButtonErrorAndBeep(illegalArgumentException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Main cfr_ignored_1 = UserActions.this.m_Main;
                Main.m_MainWindow.setButtonErrorAndBeep("EXCEPTION " + exception.getClass().getSimpleName() + " press F12 for console");
            }
        }

        public void callOnPressedLong(Object object) {
            try {
                this.onPressedLong(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main cfr_ignored_0 = UserActions.this.m_Main;
                Main.m_MainWindow.setButtonErrorAndBeep(illegalArgumentException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Main cfr_ignored_1 = UserActions.this.m_Main;
                Main.m_MainWindow.setButtonErrorAndBeep("EXCEPTION " + exception.getClass().getSimpleName() + " press F12 for console");
            }
        }
    }
}

